package Spidy::GraphicsBuilder::imager;

use Spidy::GraphicsBuilder;
use Imager;
@ISA = qw( Spidy::GraphicsBuilder );

use strict;

sub resize_image {
  my $self = shift;
  my %args = @_;

  my $img = Imager->new();
  $img->open(file=>$args{input_image})
    or die $img->errstr();
  my $resized = $img->scale(
    xpixels => $args{'width'} || $args{size}->{'max_width'},
    ypixels => $args{size}->{'height'} || $args{size}->{'max_height'},
    type => 'min',
  );
  $resized->write(
    file => $args{output_image}
  ) or die $resized->errstr();

  print "resize_image\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
}

sub resize_padded_image {
  my $self = shift;
  my %args = @_;
  
  my $bg = Imager->new(
    xpixels => $args{size}->{'width'} || $args{size}->{'max_width'},
    ypixels => $args{size}->{'height'} || $args{size}->{'max_height'},
  );

  $bg->flood_fill(
    x => 0,
    y => 0,
    color => "#$args{color}",
  ) or die $bg->errstr();
  
  my $img = Imager->new();
  $img->open(file=>$args{input_image})
    or die $img->errstr();

  my $thumb = $img->scale(
    xpixels => $args{size}->{'width'} || $args{size}->{'max_width'},
    ypixels => $args{size}->{'height'} || $args{size}->{'max_height'},
    type => "min",
  );
  
  my $x = $args{size}->{'width'} || $args{size}->{'max_width'};
  my $y = $args{size}->{'height'} || $args{size}->{'max_height'};
  my $dx = int(($x - $thumb->getwidth()) / 2);
  my $dy = int(($y - $thumb->getheight()) / 2);
  
  $bg->paste(
    left => $dx,
    top  => $dy,
    img  => $thumb,
  ) or die $bg->errstr();
  
  $bg->write(
    file => $args{output_image},
  ) or die $bg->errstr();

  print "resize_padded_image\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
  return;
}        

sub watermark {
  my $self = shift;
  my %args = shift;
  
  if( defined($args{size}->{'watermark'}) 
      && $args{size}->{'watermark'} =~ /$Spidy::GraphicsBuilder::rxTrue/
      && $self->{'watermark'} ) {
      
      my $img = Imager->new();
      $img->read(
        file => $args{output_image},
      ) or die $img->errstr();
      
      my $watermark = Imager->new();
      $watermark->read(
        file => $self->{'watermark'},
      ) or die $watermark->errstr();
      
      my( $top, $left ) = $self->gravity_map(
        $self->{gravity},
        $img,
        $watermark,
      );
      
      $img->paste(
        img => $watermark,
        top => $top,
        left => $left,
      );
      
      $img->write(
        file => $args{output_image},
      ) or die $img->errstr();
      
      print "watermark image\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
  }
  return;
}

sub gravity_map {
  my $self = shift;
  my $gravity = lc shift;
  my $image = shift;
  my $watermark = shift;

  my $iw = $image->getwidth();
  my $ih = $image->getheight(); 
  
  my $ww = $watermark->getwidth();
  my $wh = $watermark->getheight();
  
  if( $gravity eq 'north' ) {
    my $left = int(($iw - $ww)/2);
    return (0, $left);
  } elsif( $gravity eq 'northeast' ) {
    my $left = $iw - $ww;
    return (0, $left);
  } elsif( $gravity eq 'east' ) {
    my $left = $iw - $ww;
    my $top = int(($ih - $wh)/2);
    return ($top, $left);
  } elsif( $gravity eq 'southeast' ) {
    my $left = $iw - $ww;
    my $top = $ih - $wh;
    return ($top, $left);
  } elsif( $gravity eq 'south' ) {
    my $left = int(($iw - $ww)/2);
    my $top = $ih - $wh;
    return ($top, $left);
  } elsif( $gravity eq 'southwest' ) {
    my $top = $ih - $wh;
    return ($top, 0);
  } elsif( $gravity eq 'west' ) {
    my $top = int(($ih - $wh)/2);
    return ($top, 0);
  } elsif( $gravity eq 'northwest' ) {
    return (0,0);
  } elsif( $gravity eq 'center' ) {
    my $top = int(($ih - $wh)/2);
    my $left = int(($iw - $ww)/2);
    return ($top, $left);
  } else {
    die( <<EOF);
gravity "$gravity" not understood.  Must be one of:
north northeast east southeast south southwest west northwest center
EOF
  }
  return;
}


1;
