package Spidy::Database::Image;

use Spidy::Image;
use Spidy::Database::Group;
@ISA = qw( Spidy::Image Spidy::Database::Group );

use strict;
use Image::Size;

sub autoload_members {
    my $self = shift;
    return {
        %{$self->SUPER::autoload_members()},
    };
}

*new = \&Spidy::Database::Group::new;

sub set_param_data {
  my $self = shift;
  my $p = shift;
  my $size = shift;
  my $caller = shift || $self;
  if( $p eq 'href' ) {
    my $path = $self->set_param_data('path', $size, $caller);
    $path = $path ? "$path/$self->{'name'}" : $self->{'name'};
    return $self->cgi()->script_name()."?size=$size->{'name'}&path=$path&type=image";
  } elsif( $p eq 'left_group_href' ) {
    my $prev = $self->previous_group();
    return unless $prev;
    my $path = $prev->set_param_data('path', $size, $caller);
    $path = $path ? "$path/$prev->{'input_image'}" : $prev->{'input_image'};
    return $self->cgi()->script_name()."?size=$size->{'name'}&path=$path&type=image";
    return;
  } elsif( $p eq 'right_group_href' ) {
    my $next = $self->next_group();
    return unless $next;
    my $path = $next->set_param_data('path', $size, $caller);
    $path = $path ? "$path/$next->{'input_image'}" : $next->{'input_image'};
    return $self->cgi()->script_name()."?size=$size->{'name'}&path=$path&type=image";
    return;
 } elsif( $p eq 'path' ) {
    return $self->{'path'} if defined $self->{'path'};
    return $self->clean_path( "$caller->{'top_html_path'}/$self->{'html_path'}" );
  } elsif( $p eq 'image' ) {
    return $self->{'name'};
  } elsif( $p eq 'xml_id' ) {
    return $self->{'id'};
  } elsif( $p eq 'src' ) {
    return $self->{'src'} if defined $self->{'src'};
  } elsif( $p eq 'width' || 
           $p eq 'height' ||
           $p eq 'column_count' ||
           $p eq 'count' ) {
    return $self->{$p} if defined $self->{$p};
  } elsif( $p eq 'compressed_href' ) {
    return $self->{'bundle_href'}  
  } elsif( $p eq 'type' ) {
    return $self->{'type'} if defined $self->{'type'};
    return "image";
  } elsif( $p eq 'top_html_path' ) {
    return '.';
  } elsif( $p eq 'left_group_src' ) {
    my $prev = $self->previous_group();
    return $prev->set_param_data( 'src', $size->first(), $caller )
      if $prev;
    return;
  } elsif( $p eq 'right_group_src' ) {
    my $next = $self->next_group();
    return $next->set_param_data( 'src', $size->first(), $caller )
      if $next;
    return;
  }


  return $self->SUPER::set_param_data( $p, $size, $caller );
}


1;


