/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_30 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 6329, "epsg", 6329,
        "NAD83(2011) / UTM zone 60N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 60N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",177],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6329\"]]");
    p = add_epsg_def_ex (filter, first, last, 6330, "epsg", 6330,
        "NAD83(2011) / UTM zone 1N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 1N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-177],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6330\"]]");
    p = add_epsg_def_ex (filter, first, last, 6331, "epsg", 6331,
        "NAD83(2011) / UTM zone 2N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 2N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-171],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6331\"]]");
    p = add_epsg_def_ex (filter, first, last, 6332, "epsg", 6332,
        "NAD83(2011) / UTM zone 3N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 3N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-165],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6332\"]]");
    p = add_epsg_def_ex (filter, first, last, 6333, "epsg", 6333,
        "NAD83(2011) / UTM zone 4N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 4N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-159],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6333\"]]");
    p = add_epsg_def_ex (filter, first, last, 6334, "epsg", 6334,
        "NAD83(2011) / UTM zone 5N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 5N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-153],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6334\"]]");
    p = add_epsg_def_ex (filter, first, last, 6335, "epsg", 6335,
        "NAD83(2011) / UTM zone 6N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 6N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-147],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6335\"]]");
    p = add_epsg_def_ex (filter, first, last, 6336, "epsg", 6336,
        "NAD83(2011) / UTM zone 7N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 7N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-141],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6336\"]]");
    p = add_epsg_def_ex (filter, first, last, 6337, "epsg", 6337,
        "NAD83(2011) / UTM zone 8N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 8N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-135],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6337\"]]");
    p = add_epsg_def_ex (filter, first, last, 6338, "epsg", 6338,
        "NAD83(2011) / UTM zone 9N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 9N\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 8,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",-129],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6338\"]]");
    p = add_epsg_def_ex (filter, first, last, 6339, "epsg", 6339,
        "NAD83(2011) / UTM zone 10N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 10N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-123],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6339\"]]");
    p = add_epsg_def_ex (filter, first, last, 6340, "epsg", 6340,
        "NAD83(2011) / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 11N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-117],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6340\"]]");
    p = add_epsg_def_ex (filter, first, last, 6341, "epsg", 6341,
        "NAD83(2011) / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 12N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-111],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6341\"]]");
    p = add_epsg_def_ex (filter, first, last, 6342, "epsg", 6342,
        "NAD83(2011) / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 13N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-105],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6342\"]]");
    p = add_epsg_def_ex (filter, first, last, 6343, "epsg", 6343,
        "NAD83(2011) / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 14N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-99],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6343\"]]");
    p = add_epsg_def_ex (filter, first, last, 6344, "epsg", 6344,
        "NAD83(2011) / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 15N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-93],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6344\"]]");
    p = add_epsg_def_ex (filter, first, last, 6345, "epsg", 6345,
        "NAD83(2011) / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 16N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-87],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6345\"]]");
    p = add_epsg_def_ex (filter, first, last, 6346, "epsg", 6346,
        "NAD83(2011) / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 17N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6346\"]]");
    p = add_epsg_def_ex (filter, first, last, 6347, "epsg", 6347,
        "NAD83(2011) / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 18N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6347\"]]");
    p = add_epsg_def_ex (filter, first, last, 6348, "epsg", 6348,
        "NAD83(2011) / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / UTM zone 19N\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6348\"]]");
    p = add_epsg_def_ex (filter, first, last, 6349, "epsg", 6349,
        "NAD83(2011)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +geoidgrids=g2012a_conus.gtx,");
    add_proj4text (p, 1,
        "g2012a_alaska.gtx,g2012a_guam.gtx,g2012a_hawaii.gtx,g201");
    add_proj4text (p, 2,
        "2a_puertorico.gtx,g2012a_samoa.gtx +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(2011) + NAVD88 height\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],VERT_CS[\"NAVD88 height\",V");
    add_srs_wkt (p, 8,
        "ERT_DATUM[\"North American Vertical Datum 1988\",2005,EX");
    add_srs_wkt (p, 9,
        "TENSION[\"PROJ4_GRIDS\",\"g2012a_conus.gtx,g2012a_alaska");
    add_srs_wkt (p, 10,
        ".gtx,g2012a_guam.gtx,g2012a_hawaii.gtx,g2012a_puertorico");
    add_srs_wkt (p, 11,
        ".gtx,g2012a_samoa.gtx\"],AUTHORITY[\"EPSG\",\"5103\"]],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\"");
    add_srs_wkt (p, 13,
        ",UP],AUTHORITY[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6349\"]]");
    p = add_epsg_def_ex (filter, first, last, 6350, "epsg", 6350,
        "NAD83(2011) / Conus Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Albers_Conic_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +");
    add_proj4text (p, 1,
        "x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Conus Albers\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Albers_Conic_Equa");
    add_srs_wkt (p, 8,
        "l_Area\"],PARAMETER[\"standard_parallel_1\",29.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",45.5],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 10,
        "f_center\",23],PARAMETER[\"longitude_of_center\",-96],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6350\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6351, "epsg", 6351,
        "NAD83(2011) / EPSG Arctic zone 5-29", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-163 +x_0=29500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / EPSG Arctic zone 5-29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",73.66666666666667],PARAMETER[\"standard_parallel_2\",70");
    add_srs_wkt (p, 10,
        ".33333333333333],PARAMETER[\"latitude_of_origin\",72.025");
    add_srs_wkt (p, 11,
        "00919444445],PARAMETER[\"central_meridian\",-163],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_easting\",29500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 13,
        "ng\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"6351\"]]");
    p = add_epsg_def_ex (filter, first, last, 6352, "epsg", 6352,
        "NAD83(2011) / EPSG Arctic zone 5-31", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-147 +x_0=31500000 +");
    add_proj4text (p, 2,
        "y_0=5500000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / EPSG Arctic zone 5-31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",73.66666666666667],PARAMETER[\"standard_parallel_2\",70");
    add_srs_wkt (p, 10,
        ".33333333333333],PARAMETER[\"latitude_of_origin\",72.025");
    add_srs_wkt (p, 11,
        "00919444445],PARAMETER[\"central_meridian\",-147],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_easting\",31500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 13,
        "ng\",5500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"6352\"]]");
    p = add_epsg_def_ex (filter, first, last, 6353, "epsg", 6353,
        "NAD83(2011) / EPSG Arctic zone 6-14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-165 +x_0=14500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / EPSG Arctic zone 6-14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",70.33333333333333],PARAMETER[\"standard_parallel_2\",67");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",68.68747555555557],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-165],PARAMETER[\"false_eas");
    add_srs_wkt (p, 12,
        "ting\",14500000],PARAMETER[\"false_northing\",6500000],U");
    add_srs_wkt (p, 13,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 14,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"6353\"]]");
    p = add_epsg_def_ex (filter, first, last, 6354, "epsg", 6354,
        "NAD83(2011) / EPSG Arctic zone 6-16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-147 +x_0=16500000 +y_0=6500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / EPSG Arctic zone 6-16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",70.33333333333333],PARAMETER[\"standard_parallel_2\",67");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",68.68747555555557],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",-147],PARAMETER[\"false_eas");
    add_srs_wkt (p, 12,
        "ting\",16500000],PARAMETER[\"false_northing\",6500000],U");
    add_srs_wkt (p, 13,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 14,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"6354\"]]");
    p = add_epsg_def_ex (filter, first, last, 6355, "epsg", 6355,
        "NAD83(2011) / Alabama East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9996 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alabama East\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",30.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-85.83333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.99996],PARAMETER[\"false_easting\",200000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6355\"]]");
    p = add_epsg_def_ex (filter, first, last, 6356, "epsg", 6356,
        "NAD83(2011) / Alabama West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=6");
    add_proj4text (p, 1,
        "00000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alabama West\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-87.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "9933333],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"6356\"]]");
    p = add_epsg_def_ex (filter, first, last, 6362, "epsg", 6362,
        "Mexico ITRF92 / LCC", 0, 1,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF92", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=17.5 +lat_2=29.5 +lat_0=12 +lon_0=-102 ");
    add_proj4text (p, 1,
        "+x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF92 / LCC\",GEOGCS[\"Mexico ITRF92\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Mexico_ITRF92\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"1042\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4483\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",17.5],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_2\",29.5],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",12],PARAMETER[\"central_meridian\",-102],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",2500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6362\"]]");
    p = add_epsg_def_ex (filter, first, last, 6365, "epsg", 6365,
        "Mexico ITRF2008", 1, 1,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF2008", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mexico ITRF2008\",DATUM[\"Mexico_ITRF2008\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1120\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6365\"]]");
    p = add_epsg_def_ex (filter, first, last, 6366, "epsg", 6366,
        "Mexico ITRF2008 / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF2008 / UTM zone 11N\",GEOGCS[\"Mexic");
    add_srs_wkt (p, 1,
        "o ITRF2008\",DATUM[\"Mexico_ITRF2008\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1120\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6365\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-117],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"6366\"]]");
    p = add_epsg_def_ex (filter, first, last, 6367, "epsg", 6367,
        "Mexico ITRF2008 / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF2008 / UTM zone 12N\",GEOGCS[\"Mexic");
    add_srs_wkt (p, 1,
        "o ITRF2008\",DATUM[\"Mexico_ITRF2008\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1120\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6365\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-111],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"6367\"]]");
    p = add_epsg_def_ex (filter, first, last, 6368, "epsg", 6368,
        "Mexico ITRF2008 / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF2008 / UTM zone 13N\",GEOGCS[\"Mexic");
    add_srs_wkt (p, 1,
        "o ITRF2008\",DATUM[\"Mexico_ITRF2008\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1120\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6365\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-105],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"6368\"]]");
    p = add_epsg_def_ex (filter, first, last, 6369, "epsg", 6369,
        "Mexico ITRF2008 / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF2008 / UTM zone 14N\",GEOGCS[\"Mexic");
    add_srs_wkt (p, 1,
        "o ITRF2008\",DATUM[\"Mexico_ITRF2008\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1120\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6365\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-99],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6369\"]]");
    p = add_epsg_def_ex (filter, first, last, 6370, "epsg", 6370,
        "Mexico ITRF2008 / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF2008 / UTM zone 15N\",GEOGCS[\"Mexic");
    add_srs_wkt (p, 1,
        "o ITRF2008\",DATUM[\"Mexico_ITRF2008\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1120\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6365\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-93],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6370\"]]");
    p = add_epsg_def_ex (filter, first, last, 6371, "epsg", 6371,
        "Mexico ITRF2008 / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF2008", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF2008 / UTM zone 16N\",GEOGCS[\"Mexic");
    add_srs_wkt (p, 1,
        "o ITRF2008\",DATUM[\"Mexico_ITRF2008\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1120\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6365\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-87],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6371\"]]");
    p = add_epsg_def_ex (filter, first, last, 6372, "epsg", 6372,
        "Mexico ITRF2008 / LCC", 0, 1,
        "GRS 1980", "Greenwich",
        "Mexico_ITRF2008", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=17.5 +lat_2=29.5 +lat_0=12 +lon_0=-102 ");
    add_proj4text (p, 1,
        "+x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mexico ITRF2008 / LCC\",GEOGCS[\"Mexico ITRF200");
    add_srs_wkt (p, 1,
        "8\",DATUM[\"Mexico_ITRF2008\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1120\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6365\"]],PROJECTION[\"Lambert_Conformal_Conic_2S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"standard_parallel_1\",17.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",29.5],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 10,
        "in\",12],PARAMETER[\"central_meridian\",-102],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",2500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"6372\"]]");
    p = add_epsg_def_ex (filter, first, last, 6381, "epsg", 6381,
        "UCS-2000 / Ukraine TM zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 7\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,-");
    add_srs_wkt (p, 3,
        "141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",21],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",300000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"6381\"]]");
    p = add_epsg_def_ex (filter, first, last, 6382, "epsg", 6382,
        "UCS-2000 / Ukraine TM zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 8\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,-");
    add_srs_wkt (p, 3,
        "141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",24],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",300000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"6382\"]]");
    p = add_epsg_def_ex (filter, first, last, 6383, "epsg", 6383,
        "UCS-2000 / Ukraine TM zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 9\",GEOGCS[\"UCS-200");
    add_srs_wkt (p, 1,
        "0\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\",");
    add_srs_wkt (p, 2,
        "6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,-");
    add_srs_wkt (p, 3,
        "141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",27],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",300000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"6383\"]]");
    p = add_epsg_def_ex (filter, first, last, 6384, "epsg", 6384,
        "UCS-2000 / Ukraine TM zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 10\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",30],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",300000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6384\"]]");
    p = add_epsg_def_ex (filter, first, last, 6385, "epsg", 6385,
        "UCS-2000 / Ukraine TM zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 11\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",33],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",300000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6385\"]]");
    p = add_epsg_def_ex (filter, first, last, 6386, "epsg", 6386,
        "UCS-2000 / Ukraine TM zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 12\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",36],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",300000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6386\"]]");
    p = add_epsg_def_ex (filter, first, last, 6387, "epsg", 6387,
        "UCS-2000 / Ukraine TM zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Ukraine_2000", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=300000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=25,-141,-78.5,0,0.35,0.736,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"UCS-2000 / Ukraine TM zone 13\",GEOGCS[\"UCS-20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Ukraine_2000\",SPHEROID[\"Krassowsky 1940\"");
    add_srs_wkt (p, 2,
        ",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[25,");
    add_srs_wkt (p, 3,
        "-141,-78.5,0,0.35,0.736,0],AUTHORITY[\"EPSG\",\"1077\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"5561\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",39],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",300000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6387\"]]");
    p = add_epsg_def_ex (filter, first, last, 6391, "epsg", 6391,
        "Cayman Islands National Grid 2011", 0, 0,
        "GRS 1980", "Greenwich",
        "Cayman_Islands_Geodetic_Datum_2011", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19.33333333333333 +lat_2=19.7 +lat_0=19");
    add_proj4text (p, 1,
        ".33333333333333 +lon_0=-80.56666666666666 +x_0=899160 +y");
    add_proj4text (p, 2,
        "_0=579120 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cayman Islands National Grid 2011\",GEOGCS[\"CI");
    add_srs_wkt (p, 1,
        "GD11\",DATUM[\"Cayman_Islands_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1100\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"6135\"]],PROJECTION[\"La");
    add_srs_wkt (p, 8,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",19.33333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",19.7],PARAMETER[\"latitude_of_origin\",19.3333333333");
    add_srs_wkt (p, 11,
        "3333],PARAMETER[\"central_meridian\",-80.56666666666666]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_easting\",2950000],PARAMETER[\"false_");
    add_srs_wkt (p, 13,
        "northing\",1900000],UNIT[\"foot\",0.3048,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 15,
        "NORTH],AUTHORITY[\"EPSG\",\"6391\"]]");
    p = add_epsg_def_ex (filter, first, last, 6393, "epsg", 6393,
        "NAD83(2011) / Alaska Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Albers_Conic_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska Albers\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Albers_Conic_Equa");
    add_srs_wkt (p, 8,
        "l_Area\"],PARAMETER[\"standard_parallel_1\",55],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",65],PARAMETER[\"latitude_of_ce");
    add_srs_wkt (p, 10,
        "nter\",50],PARAMETER[\"longitude_of_center\",-154],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",0],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6393\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6394, "epsg", 6394,
        "NAD83(2011) / Alaska zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=32");
    add_proj4text (p, 1,
        "3.1301023611111 +k=0.9999 +x_0=5000000 +y_0=-5000000 +no");
    add_proj4text (p, 2,
        "_uoff +gamma=323.1301023611111 +ellps=GRS80 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 1\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Hotine_Oblique_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_center\",57],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"longitude_of_center\",-133.6666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "azimuth\",323.1301023611111],PARAMETER[\"rectified_grid_");
    add_srs_wkt (p, 11,
        "angle\",323.1301023611111],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 12,
        "9999],PARAMETER[\"false_easting\",5000000],PARAMETER[\"f");
    add_srs_wkt (p, 13,
        "alse_northing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"6394\"]]");
    p = add_epsg_def_ex (filter, first, last, 6395, "epsg", 6395,
        "NAD83(2011) / Alaska zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 2\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-142],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6395\"]]");
    p = add_epsg_def_ex (filter, first, last, 6396, "epsg", 6396,
        "NAD83(2011) / Alaska zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 3\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-146],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6396\"]]");
    p = add_epsg_def_ex (filter, first, last, 6397, "epsg", 6397,
        "NAD83(2011) / Alaska zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 4\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-150],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6397\"]]");
    p = add_epsg_def_ex (filter, first, last, 6398, "epsg", 6398,
        "NAD83(2011) / Alaska zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 5\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-154],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6398\"]]");
    p = add_epsg_def_ex (filter, first, last, 6399, "epsg", 6399,
        "NAD83(2011) / Alaska zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 6\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-158],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6399\"]]");
    p = add_epsg_def_ex (filter, first, last, 6400, "epsg", 6400,
        "NAD83(2011) / Alaska zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 7\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-162],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6400\"]]");
    p = add_epsg_def_ex (filter, first, last, 6401, "epsg", 6401,
        "NAD83(2011) / Alaska zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 8\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-166],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6401\"]]");
    p = add_epsg_def_ex (filter, first, last, 6402, "epsg", 6402,
        "NAD83(2011) / Alaska zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 9\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",54],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-170],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "9],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6402\"]]");
    p = add_epsg_def_ex (filter, first, last, 6403, "epsg", 6403,
        "NAD83(2011) / Alaska zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Alaska zone 10\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",53.8333");
    add_srs_wkt (p, 9,
        "3333333334],PARAMETER[\"standard_parallel_2\",51.8333333");
    add_srs_wkt (p, 10,
        "3333334],PARAMETER[\"latitude_of_origin\",51],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"central_meridian\",-176],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 12,
        "000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6403\"]]");
    p = add_epsg_def_ex (filter, first, last, 6404, "epsg", 6404,
        "NAD83(2011) / Arizona Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arizona Central\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-111.9166666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",213360],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"6404\"]]");
    p = add_epsg_def_ex (filter, first, last, 6405, "epsg", 6405,
        "NAD83(2011) / Arizona Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arizona Central (ft)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",31],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",-111.9166666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",70000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6405\"]]");
    p = add_epsg_def_ex (filter, first, last, 6406, "epsg", 6406,
        "NAD83(2011) / Arizona East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arizona East\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-110.1666666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",213360],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"6406\"]]");
    p = add_epsg_def_ex (filter, first, last, 6407, "epsg", 6407,
        "NAD83(2011) / Arizona East (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arizona East (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-110.1666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",700000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6407\"]]");
    p = add_epsg_def_ex (filter, first, last, 6408, "epsg", 6408,
        "NAD83(2011) / Arizona West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arizona West\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-113.75],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999933333],PARAMETER[\"false_easting\",213360],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"6408\"]]");
    p = add_epsg_def_ex (filter, first, last, 6409, "epsg", 6409,
        "NAD83(2011) / Arizona West (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arizona West (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-113.75],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.999933333],PARAMETER[\"false_easting\",700000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"6409\"]]");
    p = add_epsg_def_ex (filter, first, last, 6410, "epsg", 6410,
        "NAD83(2011) / Arkansas North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arkansas North\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",36.2333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",34.9333333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"latitude_of_origin\",34.33333333333");
    add_srs_wkt (p, 11,
        "334],PARAMETER[\"central_meridian\",-92],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_easting\",400000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 13,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6410\"]]");
    p = add_epsg_def_ex (filter, first, last, 6411, "epsg", 6411,
        "NAD83(2011) / Arkansas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.9999");
    add_proj4text (p, 2,
        "8984 +y_0=0 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arkansas North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",36.23333333333333],PARAMETER[\"standard_parallel_2\",34");
    add_srs_wkt (p, 10,
        ".93333333333333],PARAMETER[\"latitude_of_origin\",34.333");
    add_srs_wkt (p, 11,
        "33333333334],PARAMETER[\"central_meridian\",-92],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_easting\",1312333.3333],PARAMETER[\"false_nor");
    add_srs_wkt (p, 13,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 15,
        "NORTH],AUTHORITY[\"EPSG\",\"6411\"]]");
    p = add_epsg_def_ex (filter, first, last, 6412, "epsg", 6412,
        "NAD83(2011) / Arkansas South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arkansas South\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",34.7666");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",33.3],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",32.66666666666666],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-92],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "400000],PARAMETER[\"false_northing\",400000],UNIT[\"metr");
    add_srs_wkt (p, 13,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 14,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6412\"]]");
    p = add_epsg_def_ex (filter, first, last, 6413, "epsg", 6413,
        "NAD83(2011) / Arkansas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399");
    add_proj4text (p, 2,
        "999.99998984 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Arkansas South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",34.76666666666667],PARAMETER[\"standard_parallel_2\",33");
    add_srs_wkt (p, 10,
        ".3],PARAMETER[\"latitude_of_origin\",32.66666666666666],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"central_meridian\",-92],PARAMETER[\"false_ea");
    add_srs_wkt (p, 12,
        "sting\",1312333.3333],PARAMETER[\"false_northing\",13123");
    add_srs_wkt (p, 13,
        "33.3333],UNIT[\"US survey foot\",0.3048006096012192,AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 15,
        "RTH],AUTHORITY[\"EPSG\",\"6413\"]]");
    p = add_epsg_def_ex (filter, first, last, 6414, "epsg", 6414,
        "NAD83(2011) / California Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Albers_Conic_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=-4000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California Albers\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Albers_Conic");
    add_srs_wkt (p, 8,
        "_Equal_Area\"],PARAMETER[\"standard_parallel_1\",34],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",40.5],PARAMETER[\"latitud");
    add_srs_wkt (p, 10,
        "e_of_center\",0],PARAMETER[\"longitude_of_center\",-120]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",0],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",-4000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"6414\"]]");
    p = add_epsg_def_ex (filter, first, last, 6415, "epsg", 6415,
        "NAD83(2011) / California zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 1\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.");
    add_srs_wkt (p, 9,
        "66666666666666],PARAMETER[\"standard_parallel_2\",40],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"latitude_of_origin\",39.33333333333334],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",-122],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",2000000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6415\"]]");
    p = add_epsg_def_ex (filter, first, last, 6416, "epsg", 6416,
        "NAD83(2011) / California zone 1 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=5000");
    add_proj4text (p, 2,
        "00.0001016001 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 1 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 8,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",41.66666666666666],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "40],PARAMETER[\"latitude_of_origin\",39.33333333333334],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"central_meridian\",-122],PARAMETER[\"false_e");
    add_srs_wkt (p, 12,
        "asting\",6561666.667],PARAMETER[\"false_northing\",16404");
    add_srs_wkt (p, 13,
        "16.667],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 15,
        "TH],AUTHORITY[\"EPSG\",\"6416\"]]");
    p = add_epsg_def_ex (filter, first, last, 6417, "epsg", 6417,
        "NAD83(2011) / California zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y");
    add_proj4text (p, 2,
        "_0=500000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 2\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39.");
    add_srs_wkt (p, 9,
        "83333333333334],PARAMETER[\"standard_parallel_2\",38.333");
    add_srs_wkt (p, 10,
        "33333333334],PARAMETER[\"latitude_of_origin\",37.6666666");
    add_srs_wkt (p, 11,
        "6666666],PARAMETER[\"central_meridian\",-122],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_easting\",2000000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 13,
        "500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 14,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 15,
        "417\"]]");
    p = add_epsg_def_ex (filter, first, last, 6418, "epsg", 6418,
        "NAD83(2011) / California zone 2 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.00");
    add_proj4text (p, 2,
        "01016 +y_0=500000.0001016001 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 2 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 8,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",39.83333333333334],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "38.33333333333334],PARAMETER[\"latitude_of_origin\",37.6");
    add_srs_wkt (p, 11,
        "6666666666666],PARAMETER[\"central_meridian\",-122],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",6561666.667],PARAMETER[\"false_n");
    add_srs_wkt (p, 13,
        "orthing\",1640416.667],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 14,
        "096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 15,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6418\"]]");
    p = add_epsg_def_ex (filter, first, last, 6419, "epsg", 6419,
        "NAD83(2011) / California zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 3\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38.");
    add_srs_wkt (p, 9,
        "43333333333333],PARAMETER[\"standard_parallel_2\",37.066");
    add_srs_wkt (p, 10,
        "66666666667],PARAMETER[\"latitude_of_origin\",36.5],PARA");
    add_srs_wkt (p, 11,
        "METER[\"central_meridian\",-120.5],PARAMETER[\"false_eas");
    add_srs_wkt (p, 12,
        "ting\",2000000],PARAMETER[\"false_northing\",500000],UNI");
    add_srs_wkt (p, 13,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6419\"]]");
    p = add_epsg_def_ex (filter, first, last, 6420, "epsg", 6420,
        "NAD83(2011) / California zone 3 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=");
    add_proj4text (p, 2,
        "500000.0001016001 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 3 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 8,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",38.43333333333333],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "37.06666666666667],PARAMETER[\"latitude_of_origin\",36.5");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"central_meridian\",-120.5],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_easting\",6561666.667],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 13,
        "640416.667],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"6420\"]]");
    p = add_epsg_def_ex (filter, first, last, 6421, "epsg", 6421,
        "NAD83(2011) / California zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 4\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",37.");
    add_srs_wkt (p, 9,
        "25],PARAMETER[\"standard_parallel_2\",36],PARAMETER[\"la");
    add_srs_wkt (p, 10,
        "titude_of_origin\",35.33333333333334],PARAMETER[\"centra");
    add_srs_wkt (p, 11,
        "l_meridian\",-119],PARAMETER[\"false_easting\",2000000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"6421\"]]");
    p = add_epsg_def_ex (filter, first, last, 6422, "epsg", 6422,
        "NAD83(2011) / California zone 4 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.000101600");
    add_proj4text (p, 2,
        "1 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 4 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 8,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",37.25],PARAMETER[\"standard_parallel_2\",36],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"latitude_of_origin\",35.33333333333334],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "central_meridian\",-119],PARAMETER[\"false_easting\",656");
    add_srs_wkt (p, 12,
        "1666.667],PARAMETER[\"false_northing\",1640416.667],UNIT");
    add_srs_wkt (p, 13,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"6422\"]]");
    p = add_epsg_def_ex (filter, first, last, 6423, "epsg", 6423,
        "NAD83(2011) / California zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 5\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",35.");
    add_srs_wkt (p, 9,
        "46666666666667],PARAMETER[\"standard_parallel_2\",34.033");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"latitude_of_origin\",33.5],PARA");
    add_srs_wkt (p, 11,
        "METER[\"central_meridian\",-118],PARAMETER[\"false_easti");
    add_srs_wkt (p, 12,
        "ng\",2000000],PARAMETER[\"false_northing\",500000],UNIT[");
    add_srs_wkt (p, 13,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6423\"]]");
    p = add_epsg_def_ex (filter, first, last, 6424, "epsg", 6424,
        "NAD83(2011) / California zone 5 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=50");
    add_proj4text (p, 2,
        "0000.0001016001 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 5 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 8,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",35.46666666666667],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "34.03333333333333],PARAMETER[\"latitude_of_origin\",33.5");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"central_meridian\",-118],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_easting\",6561666.667],PARAMETER[\"false_northing\",164");
    add_srs_wkt (p, 13,
        "0416.667],UNIT[\"US survey foot\",0.3048006096012192,AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 15,
        "ORTH],AUTHORITY[\"EPSG\",\"6424\"]]");
    p = add_epsg_def_ex (filter, first, last, 6425, "epsg", 6425,
        "NAD83(2011) / California zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        " +y_0=500000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 6\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",33.");
    add_srs_wkt (p, 9,
        "88333333333333],PARAMETER[\"standard_parallel_2\",32.783");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"latitude_of_origin\",32.1666666");
    add_srs_wkt (p, 11,
        "6666666],PARAMETER[\"central_meridian\",-116.25],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_easting\",2000000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 13,
        "\",500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 14,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 15,
        "\"6425\"]]");
    p = add_epsg_def_ex (filter, first, last, 6426, "epsg", 6426,
        "NAD83(2011) / California zone 6 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        ".0001016 +y_0=500000.0001016001 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / California zone 6 (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 8,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",33.88333333333333],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "32.78333333333333],PARAMETER[\"latitude_of_origin\",32.1");
    add_srs_wkt (p, 11,
        "6666666666666],PARAMETER[\"central_meridian\",-116.25],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_easting\",6561666.667],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",1640416.667],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 14,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 15,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6426\"]]");
    p = add_epsg_def_ex (filter, first, last, 6427, "epsg", 6427,
        "NAD83(2011) / Colorado Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Colorado Central\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39.7");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_2\",38.45],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",37.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-105.5],PARAMETER[\"false_easting\",91440");
    add_srs_wkt (p, 12,
        "1.8289],PARAMETER[\"false_northing\",304800.6096],UNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6427\"]]");
    p = add_epsg_def_ex (filter, first, last, 6428, "epsg", 6428,
        "NAD83(2011) / Colorado Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.60");
    add_proj4text (p, 2,
        "96012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Colorado Central (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 8,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",39.75],PARAMETER[\"standard_parallel_2\",38.45],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"latitude_of_origin\",37.83333333333334],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "central_meridian\",-105.5],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 12,
        "000000],PARAMETER[\"false_northing\",1000000],UNIT[\"US ");
    add_srs_wkt (p, 13,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 15,
        "SG\",\"6428\"]]");
    p = add_epsg_def_ex (filter, first, last, 6429, "epsg", 6429,
        "NAD83(2011) / Colorado North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Colorado North\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",40.7833");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",39.7166666");
    add_srs_wkt (p, 10,
        "6666667],PARAMETER[\"latitude_of_origin\",39.33333333333");
    add_srs_wkt (p, 11,
        "334],PARAMETER[\"central_meridian\",-105.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",914401.8289],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",304800.6096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"6429\"]]");
    p = add_epsg_def_ex (filter, first, last, 6430, "epsg", 6430,
        "NAD83(2011) / Colorado North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "288036576 +y_0=304800.6096012192 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Colorado North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",40.78333333333333],PARAMETER[\"standard_parallel_2\",39");
    add_srs_wkt (p, 10,
        ".71666666666667],PARAMETER[\"latitude_of_origin\",39.333");
    add_srs_wkt (p, 11,
        "33333333334],PARAMETER[\"central_meridian\",-105.5],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",3000000],PARAMETER[\"false_north");
    add_srs_wkt (p, 13,
        "ing\",1000000],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 14,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6430\"]]");
    p = add_epsg_def_ex (filter, first, last, 6431, "epsg", 6431,
        "NAD83(2011) / Colorado South", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "289 +y_0=304800.6096 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Colorado South\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38.4333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",37.2333333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"latitude_of_origin\",36.66666666666");
    add_srs_wkt (p, 11,
        "666],PARAMETER[\"central_meridian\",-105.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",914401.8289],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",304800.6096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"6431\"]]");
    p = add_epsg_def_ex (filter, first, last, 6432, "epsg", 6432,
        "NAD83(2011) / Colorado South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "288036576 +y_0=304800.6096012192 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Colorado South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",38.43333333333333],PARAMETER[\"standard_parallel_2\",37");
    add_srs_wkt (p, 10,
        ".23333333333333],PARAMETER[\"latitude_of_origin\",36.666");
    add_srs_wkt (p, 11,
        "66666666666],PARAMETER[\"central_meridian\",-105.5],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_easting\",3000000],PARAMETER[\"false_north");
    add_srs_wkt (p, 13,
        "ing\",1000000],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 14,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6432\"]]");
    p = add_epsg_def_ex (filter, first, last, 6433, "epsg", 6433,
        "NAD83(2011) / Connecticut", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=1524");
    add_proj4text (p, 2,
        "00.3048 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Connecticut\",GEOGCS[\"NAD83(2011");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_2011");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal_");
    add_srs_wkt (p, 8,
        "Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.866666");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"standard_parallel_2\",41.2],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",40.83333333333334],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"central_meridian\",-72.75],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",304800.6096],PARAMETER[\"false_northing\",152400.3048],");
    add_srs_wkt (p, 13,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6433\"]]");
    p = add_epsg_def_ex (filter, first, last, 6434, "epsg", 6434,
        "NAD83(2011) / Connecticut (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_");
    add_proj4text (p, 2,
        "0=152400.3048006096 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Connecticut (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41");
    add_srs_wkt (p, 9,
        ".86666666666667],PARAMETER[\"standard_parallel_2\",41.2]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"latitude_of_origin\",40.83333333333334],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"central_meridian\",-72.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 12,
        "sting\",1000000],PARAMETER[\"false_northing\",500000],UN");
    add_srs_wkt (p, 13,
        "IT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"6434\"]]");
    p = add_epsg_def_ex (filter, first, last, 6435, "epsg", 6435,
        "NAD83(2011) / Delaware", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Delaware\",GEOGCS[\"NAD83(2011)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"NAD83_National_Spatial_Reference_System_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",38],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",-75.41666666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999995],PARAMETER[\"false_easting\",200000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"6435\"]]");
    p = add_epsg_def_ex (filter, first, last, 6436, "epsg", 6436,
        "NAD83(2011) / Delaware (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Delaware (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",38],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",-75.41666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.999995],PARAMETER[\"false_easting\",656166");
    add_srs_wkt (p, 11,
        ".667],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "436\"]]");
    p = add_epsg_def_ex (filter, first, last, 6437, "epsg", 6437,
        "NAD83(2011) / Florida East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Florida East\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",24.33333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.999941177],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6437\"]]");
    p = add_epsg_def_ex (filter, first, last, 6438, "epsg", 6438,
        "NAD83(2011) / Florida East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Florida East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",24.3333333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.999941177],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "656166.667],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"6438\"]]");
    p = add_epsg_def_ex (filter, first, last, 6439, "epsg", 6439,
        "NAD83(2011) / Florida GDL Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Albers_Conic_Equal_Area", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_");
    add_proj4text (p, 1,
        "0=400000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Florida GDL Albers\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Albers_Coni");
    add_srs_wkt (p, 8,
        "c_Equal_Area\"],PARAMETER[\"standard_parallel_1\",24],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_2\",31.5],PARAMETER[\"latitu");
    add_srs_wkt (p, 10,
        "de_of_center\",24],PARAMETER[\"longitude_of_center\",-84");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",400000],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"6439\"]]");
    p = add_epsg_def_ex (filter, first, last, 6440, "epsg", 6440,
        "NAD83(2011) / Florida North", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Florida North\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",30.75],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",29.58333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"latitude_of_origin\",29],PARAMETER[\"central_mer");
    add_srs_wkt (p, 11,
        "idian\",-84.5],PARAMETER[\"false_easting\",600000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"6440\"]]");
    p = add_epsg_def_ex (filter, first, last, 6441, "epsg", 6441,
        "NAD83(2011) / Florida North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Florida North (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 9,
        "0.75],PARAMETER[\"standard_parallel_2\",29.5833333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"latitude_of_origin\",29],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-84.5],PARAMETER[\"false_easting\",196850");
    add_srs_wkt (p, 12,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 13,
        "\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 14,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6441");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6442, "epsg", 6442,
        "NAD83(2011) / Florida West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Florida West\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",24.33333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-82],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.999941177],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6442\"]]");
    p = add_epsg_def_ex (filter, first, last, 6443, "epsg", 6443,
        "NAD83(2011) / Florida West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Florida West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",24.3333333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"central_meridian\",-82],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.999941177],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "656166.667],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"6443\"]]");
    p = add_epsg_def_ex (filter, first, last, 6444, "epsg", 6444,
        "NAD83(2011) / Georgia East", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Georgia East\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-82.16666666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",200000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"6444\"]]");
    p = add_epsg_def_ex (filter, first, last, 6445, "epsg", 6445,
        "NAD83(2011) / Georgia East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Georgia East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",30],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",-82.16666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",65616");
    add_srs_wkt (p, 11,
        "6.667],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6445\"]]");
    p = add_epsg_def_ex (filter, first, last, 6446, "epsg", 6446,
        "NAD83(2011) / Georgia West", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=700000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Georgia West\",GEOGCS[\"NAD83(201");
    add_srs_wkt (p, 1,
        "1)\",DATUM[\"NAD83_National_Spatial_Reference_System_201");
    add_srs_wkt (p, 2,
        "1\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-84.16666666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",700000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"6446\"]]");
    p = add_epsg_def_ex (filter, first, last, 6447, "epsg", 6447,
        "NAD83(2011) / Georgia West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Georgia West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",30],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",-84.16666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",22965");
    add_srs_wkt (p, 11,
        "83.333],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6447\"]]");
    p = add_epsg_def_ex (filter, first, last, 6448, "epsg", 6448,
        "NAD83(2011) / Idaho Central", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Idaho Central\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",41.66666666666666");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-114],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.999947368],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"6448\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

