/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_57 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 32510, "epsg", 32510,
        "WGS 72BE / UTM zone 10S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 10S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-123],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"32510\"]]");
    p = add_epsg_def_ex (filter, first, last, 32511, "epsg", 32511,
        "WGS 72BE / UTM zone 11S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 11S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-117],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"32511\"]]");
    p = add_epsg_def_ex (filter, first, last, 32512, "epsg", 32512,
        "WGS 72BE / UTM zone 12S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 12S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-111],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"32512\"]]");
    p = add_epsg_def_ex (filter, first, last, 32513, "epsg", 32513,
        "WGS 72BE / UTM zone 13S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 13S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-105],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"32513\"]]");
    p = add_epsg_def_ex (filter, first, last, 32514, "epsg", 32514,
        "WGS 72BE / UTM zone 14S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 14S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-99],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32514\"]]");
    p = add_epsg_def_ex (filter, first, last, 32515, "epsg", 32515,
        "WGS 72BE / UTM zone 15S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 15S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-93],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32515\"]]");
    p = add_epsg_def_ex (filter, first, last, 32516, "epsg", 32516,
        "WGS 72BE / UTM zone 16S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 16S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-87],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32516\"]]");
    p = add_epsg_def_ex (filter, first, last, 32517, "epsg", 32517,
        "WGS 72BE / UTM zone 17S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 17S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32517\"]]");
    p = add_epsg_def_ex (filter, first, last, 32518, "epsg", 32518,
        "WGS 72BE / UTM zone 18S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 18S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32518\"]]");
    p = add_epsg_def_ex (filter, first, last, 32519, "epsg", 32519,
        "WGS 72BE / UTM zone 19S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 19S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32519\"]]");
    p = add_epsg_def_ex (filter, first, last, 32520, "epsg", 32520,
        "WGS 72BE / UTM zone 20S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 20S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32520\"]]");
    p = add_epsg_def_ex (filter, first, last, 32521, "epsg", 32521,
        "WGS 72BE / UTM zone 21S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 21S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32521\"]]");
    p = add_epsg_def_ex (filter, first, last, 32522, "epsg", 32522,
        "WGS 72BE / UTM zone 22S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 22S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-51],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32522\"]]");
    p = add_epsg_def_ex (filter, first, last, 32523, "epsg", 32523,
        "WGS 72BE / UTM zone 23S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 23S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-45],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32523\"]]");
    p = add_epsg_def_ex (filter, first, last, 32524, "epsg", 32524,
        "WGS 72BE / UTM zone 24S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 24S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-39],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32524\"]]");
    p = add_epsg_def_ex (filter, first, last, 32525, "epsg", 32525,
        "WGS 72BE / UTM zone 25S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 25S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-33],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32525\"]]");
    p = add_epsg_def_ex (filter, first, last, 32526, "epsg", 32526,
        "WGS 72BE / UTM zone 26S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 26S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-27],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32526\"]]");
    p = add_epsg_def_ex (filter, first, last, 32527, "epsg", 32527,
        "WGS 72BE / UTM zone 27S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 27S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-21],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32527\"]]");
    p = add_epsg_def_ex (filter, first, last, 32528, "epsg", 32528,
        "WGS 72BE / UTM zone 28S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 28S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-15],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32528\"]]");
    p = add_epsg_def_ex (filter, first, last, 32529, "epsg", 32529,
        "WGS 72BE / UTM zone 29S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 29S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-9],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32529\"]]");
    p = add_epsg_def_ex (filter, first, last, 32530, "epsg", 32530,
        "WGS 72BE / UTM zone 30S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 30S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-3],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32530\"]]");
    p = add_epsg_def_ex (filter, first, last, 32531, "epsg", 32531,
        "WGS 72BE / UTM zone 31S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 31S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",3],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"32531\"]]");
    p = add_epsg_def_ex (filter, first, last, 32532, "epsg", 32532,
        "WGS 72BE / UTM zone 32S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 32S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"32532\"]]");
    p = add_epsg_def_ex (filter, first, last, 32533, "epsg", 32533,
        "WGS 72BE / UTM zone 33S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 33S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",15],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32533\"]]");
    p = add_epsg_def_ex (filter, first, last, 32534, "epsg", 32534,
        "WGS 72BE / UTM zone 34S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 34S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",21],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32534\"]]");
    p = add_epsg_def_ex (filter, first, last, 32535, "epsg", 32535,
        "WGS 72BE / UTM zone 35S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 35S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",27],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32535\"]]");
    p = add_epsg_def_ex (filter, first, last, 32536, "epsg", 32536,
        "WGS 72BE / UTM zone 36S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 36S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",33],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32536\"]]");
    p = add_epsg_def_ex (filter, first, last, 32537, "epsg", 32537,
        "WGS 72BE / UTM zone 37S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 37S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",39],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32537\"]]");
    p = add_epsg_def_ex (filter, first, last, 32538, "epsg", 32538,
        "WGS 72BE / UTM zone 38S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 38S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",45],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32538\"]]");
    p = add_epsg_def_ex (filter, first, last, 32539, "epsg", 32539,
        "WGS 72BE / UTM zone 39S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 39S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",51],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32539\"]]");
    p = add_epsg_def_ex (filter, first, last, 32540, "epsg", 32540,
        "WGS 72BE / UTM zone 40S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 40S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",57],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32540\"]]");
    p = add_epsg_def_ex (filter, first, last, 32541, "epsg", 32541,
        "WGS 72BE / UTM zone 41S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 41S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",63],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32541\"]]");
    p = add_epsg_def_ex (filter, first, last, 32542, "epsg", 32542,
        "WGS 72BE / UTM zone 42S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 42S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",69],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32542\"]]");
    p = add_epsg_def_ex (filter, first, last, 32543, "epsg", 32543,
        "WGS 72BE / UTM zone 43S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 43S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",75],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32543\"]]");
    p = add_epsg_def_ex (filter, first, last, 32544, "epsg", 32544,
        "WGS 72BE / UTM zone 44S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 44S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",81],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32544\"]]");
    p = add_epsg_def_ex (filter, first, last, 32545, "epsg", 32545,
        "WGS 72BE / UTM zone 45S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 45S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",87],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32545\"]]");
    p = add_epsg_def_ex (filter, first, last, 32546, "epsg", 32546,
        "WGS 72BE / UTM zone 46S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 46S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",93],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32546\"]]");
    p = add_epsg_def_ex (filter, first, last, 32547, "epsg", 32547,
        "WGS 72BE / UTM zone 47S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 47S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",99],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32547\"]]");
    p = add_epsg_def_ex (filter, first, last, 32548, "epsg", 32548,
        "WGS 72BE / UTM zone 48S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 48S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",105],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32548\"]]");
    p = add_epsg_def_ex (filter, first, last, 32549, "epsg", 32549,
        "WGS 72BE / UTM zone 49S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 49S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",111],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32549\"]]");
    p = add_epsg_def_ex (filter, first, last, 32550, "epsg", 32550,
        "WGS 72BE / UTM zone 50S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 50S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",117],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32550\"]]");
    p = add_epsg_def_ex (filter, first, last, 32551, "epsg", 32551,
        "WGS 72BE / UTM zone 51S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 51S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",123],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32551\"]]");
    p = add_epsg_def_ex (filter, first, last, 32552, "epsg", 32552,
        "WGS 72BE / UTM zone 52S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 52S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",129],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32552\"]]");
    p = add_epsg_def_ex (filter, first, last, 32553, "epsg", 32553,
        "WGS 72BE / UTM zone 53S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 53S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",135],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32553\"]]");
    p = add_epsg_def_ex (filter, first, last, 32554, "epsg", 32554,
        "WGS 72BE / UTM zone 54S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 54S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",141],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32554\"]]");
    p = add_epsg_def_ex (filter, first, last, 32555, "epsg", 32555,
        "WGS 72BE / UTM zone 55S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 55S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",147],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32555\"]]");
    p = add_epsg_def_ex (filter, first, last, 32556, "epsg", 32556,
        "WGS 72BE / UTM zone 56S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 56S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",153],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32556\"]]");
    p = add_epsg_def_ex (filter, first, last, 32557, "epsg", 32557,
        "WGS 72BE / UTM zone 57S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 57S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",159],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32557\"]]");
    p = add_epsg_def_ex (filter, first, last, 32558, "epsg", 32558,
        "WGS 72BE / UTM zone 58S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 58S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",165],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32558\"]]");
    p = add_epsg_def_ex (filter, first, last, 32559, "epsg", 32559,
        "WGS 72BE / UTM zone 59S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 59S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",171],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32559\"]]");
    p = add_epsg_def_ex (filter, first, last, 32560, "epsg", 32560,
        "WGS 72BE / UTM zone 60S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 60S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,1.9,0,0,0.814,-0.38],AUTHORITY[\"EPSG\",\"6324\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4324\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",177],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"32560\"]]");
    p = add_epsg_def_ex (filter, first, last, 900913, "epsg", 900913,
        "Google Maps Global Mercator (deprecated)", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +a=6378137 +b=6378137 +lat_ts=0 +lon_0=0 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +k=1 +units=m +nadgrids=@null +wktext +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Google Maps Global Mercator (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"central_meri");
    add_srs_wkt (p, 7,
        "dian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 8,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 9,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 10,
        "AST],AXIS[\"Northing\",NORTH],EXTENSION[\"PROJ4\",\"+pro");
    add_srs_wkt (p, 11,
        "j=merc +a=6378137 +b=6378137 +lat_ts=0 +lon_0=0 +x_0=0 +");
    add_srs_wkt (p, 12,
        "y_0=0 +k=1 +units=m +nadgrids=@null +wktext +no_defs\"],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"900913\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

