/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_52 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 29185, "epsg", 29185,
        "SAD69 / UTM zone 25S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 25S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-33],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"29195\"]]");
    p = add_epsg_def_ex (filter, first, last, 29187, "epsg", 29187,
        "SAD69 / UTM zone 17S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 17S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-81],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29187\"]]");
    p = add_epsg_def_ex (filter, first, last, 29188, "epsg", 29188,
        "SAD69 / UTM zone 18S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-75],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29188\"]]");
    p = add_epsg_def_ex (filter, first, last, 29189, "epsg", 29189,
        "SAD69 / UTM zone 19S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-69],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29189\"]]");
    p = add_epsg_def_ex (filter, first, last, 29190, "epsg", 29190,
        "SAD69 / UTM zone 20S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-63],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29190\"]]");
    p = add_epsg_def_ex (filter, first, last, 29191, "epsg", 29191,
        "SAD69 / UTM zone 21S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-57],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29191\"]]");
    p = add_epsg_def_ex (filter, first, last, 29192, "epsg", 29192,
        "SAD69 / UTM zone 22S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-51],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"29192\"]]");
    p = add_epsg_def_ex (filter, first, last, 29193, "epsg", 29193,
        "SAD69 / UTM zone 23S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 23S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-45],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"29193\"]]");
    p = add_epsg_def_ex (filter, first, last, 29194, "epsg", 29194,
        "SAD69 / UTM zone 24S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 24S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-39],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"29194\"]]");
    p = add_epsg_def_ex (filter, first, last, 29195, "epsg", 29195,
        "SAD69 / UTM zone 25S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 25S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-66.87,4.37,-38.52,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-33],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"29195\"]]");
    p = add_epsg_def_ex (filter, first, last, 29220, "epsg", 29220,
        "Sapper Hill 1943 / UTM zone 20S", 0, 0,
        "International 1924", "Greenwich",
        "Sapper_Hill_1943", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=intl +towgs84=-355,21,7");
    add_proj4text (p, 1,
        "2,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sapper Hill 1943 / UTM zone 20S\",GEOGCS[\"Sapp");
    add_srs_wkt (p, 1,
        "er Hill 1943\",DATUM[\"Sapper_Hill_1943\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6292\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4292\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"29220\"]]");
    p = add_epsg_def_ex (filter, first, last, 29221, "epsg", 29221,
        "Sapper Hill 1943 / UTM zone 21S", 0, 0,
        "International 1924", "Greenwich",
        "Sapper_Hill_1943", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-355,21,7");
    add_proj4text (p, 1,
        "2,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sapper Hill 1943 / UTM zone 21S\",GEOGCS[\"Sapp");
    add_srs_wkt (p, 1,
        "er Hill 1943\",DATUM[\"Sapper_Hill_1943\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6292\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4292\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"29221\"]]");
    p = add_epsg_def_ex (filter, first, last, 29333, "epsg", 29333,
        "Schwarzeck / UTM zone 33S", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=bess_nam +towgs84=616,9");
    add_proj4text (p, 1,
        "7,-251,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / UTM zone 33S\",GEOGCS[\"Schwarzeck");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\"");
    add_srs_wkt (p, 2,
        ",6377483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"629");
    add_srs_wkt (p, 4,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"29333\"]]");
    p = add_epsg_def_ex (filter, first, last, 29371, "epsg", 29371,
        "Schwarzeck / Lo22/11", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=11 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/11\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",11],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29371\"]]");
    p = add_epsg_def_ex (filter, first, last, 29373, "epsg", 29373,
        "Schwarzeck / Lo22/13", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=13 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/13\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",13],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29373\"]]");
    p = add_epsg_def_ex (filter, first, last, 29375, "epsg", 29375,
        "Schwarzeck / Lo22/15", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/15\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",15],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29375\"]]");
    p = add_epsg_def_ex (filter, first, last, 29377, "epsg", 29377,
        "Schwarzeck / Lo22/17", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/17\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",17],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29377\"]]");
    p = add_epsg_def_ex (filter, first, last, 29379, "epsg", 29379,
        "Schwarzeck / Lo22/19", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/19\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",19],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29379\"]]");
    p = add_epsg_def_ex (filter, first, last, 29381, "epsg", 29381,
        "Schwarzeck / Lo22/21", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/21\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",21],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29381\"]]");
    p = add_epsg_def_ex (filter, first, last, 29383, "epsg", 29383,
        "Schwarzeck / Lo22/23", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/23\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",23],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29383\"]]");
    p = add_epsg_def_ex (filter, first, last, 29385, "epsg", 29385,
        "Schwarzeck / Lo22/25", 0, 0,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "Transverse_Mercator_South_Orientated", "German legal metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/25\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.86528042,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29385\"]]");
    p = add_epsg_def_ex (filter, first, last, 29635, "epsg", 29635,
        "Adindan / UTM zone 35N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 35N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-161,-14");
    add_srs_wkt (p, 3,
        ",205,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",27],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20135\"]]");
    p = add_epsg_def_ex (filter, first, last, 29636, "epsg", 29636,
        "Adindan / UTM zone 36N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 36N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-161,-14");
    add_srs_wkt (p, 3,
        ",205,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",33],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"20136\"]]");
    p = add_epsg_def_ex (filter, first, last, 29700, "epsg", 29700,
        "Tananarive (Paris) / Laborde Grid (deprecated)", 0, 0,
        "International 1924", "Paris",
        "Tananarive_1925_Paris", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=-18.9 +lonc=44.10000000000001 +alpha=");
    add_proj4text (p, 1,
        "18.9 +k=0.9995000000000001 +x_0=400000 +y_0=800000 +gamm");
    add_proj4text (p, 2,
        "a=18.9 +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=pa");
    add_proj4text (p, 3,
        "ris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive (Paris) / Laborde Grid (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7022\"]],TOWGS84[-198.383,-240.517,-107.");
    add_srs_wkt (p, 4,
        "909,0,0,0,0],AUTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Pari");
    add_srs_wkt (p, 5,
        "s\",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4810\"]],PROJECTION[\"Hotine_Obli");
    add_srs_wkt (p, 8,
        "que_Mercator_Azimuth_Center\"],PARAMETER[\"latitude_of_c");
    add_srs_wkt (p, 9,
        "enter\",-21],PARAMETER[\"longitude_of_center\",49],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"azimuth\",21],PARAMETER[\"rectified_grid_angle\",");
    add_srs_wkt (p, 11,
        "21],PARAMETER[\"scale_factor\",0.9995],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_easting\",400000],PARAMETER[\"false_northing\",800000],");
    add_srs_wkt (p, 13,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 14,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"29700\"]]");
    p = add_epsg_def_ex (filter, first, last, 29701, "epsg", 29701,
        "Tananarive (Paris) / Laborde Grid", 0, 1,
        "International 1924", "Paris",
        "Tananarive_1925_Paris", "Laborde_Oblique_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=labrd +lat_0=-18.9 +lon_0=44.1 +azi=18.9 +k=0.9995");
    add_proj4text (p, 1,
        " +x_0=400000 +y_0=800000 +ellps=intl +pm=paris +towgs84=");
    add_proj4text (p, 2,
        "-198.383,-240.517,-107.909,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive (Paris) / Laborde Grid\",GEOGCS[\"Ta");
    add_srs_wkt (p, 1,
        "nanarive (Paris)\",DATUM[\"Tananarive_1925_Paris\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],TOWGS84[-198.383,-240.517,-107.909,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Paris\",2.3372291");
    add_srs_wkt (p, 5,
        "6999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.01");
    add_srs_wkt (p, 6,
        "57079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4810\"]],PROJECTION[\"Laborde_Oblique_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_center\",-21],PARAMETER[\"long");
    add_srs_wkt (p, 9,
        "itude_of_center\",49],PARAMETER[\"azimuth\",21],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"scale_factor\",0.9995],PARAMETER[\"false_easting\",4");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",800000],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"29701\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 29702, "epsg", 29702,
        "Tananarive (Paris) / Laborde Grid approximation", 0, 1,
        "International 1924", "Paris",
        "Tananarive_1925_Paris", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=-18.9 +lonc=44.10000000000001 +alpha=");
    add_proj4text (p, 1,
        "18.9 +k=0.9995000000000001 +x_0=400000 +y_0=800000 +gamm");
    add_proj4text (p, 2,
        "a=18.9 +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=pa");
    add_proj4text (p, 3,
        "ris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive (Paris) / Laborde Grid approximation");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"International 1924\",6378388,297,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7022\"]],TOWGS84[-198.383,-240.517,-10");
    add_srs_wkt (p, 4,
        "7.909,0,0,0,0],AUTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Pa");
    add_srs_wkt (p, 5,
        "ris\",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4810\"]],PROJECTION[\"Hotine_Obl");
    add_srs_wkt (p, 8,
        "ique_Mercator_Azimuth_Center\"],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 9,
        "center\",-21],PARAMETER[\"longitude_of_center\",49],PARA");
    add_srs_wkt (p, 10,
        "METER[\"azimuth\",21],PARAMETER[\"rectified_grid_angle\"");
    add_srs_wkt (p, 11,
        ",21],PARAMETER[\"scale_factor\",0.9995],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",400000],PARAMETER[\"false_northing\",800000]");
    add_srs_wkt (p, 13,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"29702\"]]");
    p = add_epsg_def_ex (filter, first, last, 29738, "epsg", 29738,
        "Tananarive / UTM zone 38S", 0, 0,
        "International 1924", "Greenwich",
        "Tananarive_1925", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=intl +towgs84=-189,-242");
    add_proj4text (p, 1,
        ",-91,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive / UTM zone 38S\",GEOGCS[\"Tananarive");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Tananarive_1925\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "198.383,-240.517,-107.909,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6297\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4297\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29738\"]]");
    p = add_epsg_def_ex (filter, first, last, 29739, "epsg", 29739,
        "Tananarive / UTM zone 39S", 0, 0,
        "International 1924", "Greenwich",
        "Tananarive_1925", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=intl +towgs84=-189,-242");
    add_proj4text (p, 1,
        ",-91,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive / UTM zone 39S\",GEOGCS[\"Tananarive");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Tananarive_1925\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "198.383,-240.517,-107.909,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6297\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4297\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",51],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29739\"]]");
    p = add_epsg_def_ex (filter, first, last, 29849, "epsg", 29849,
        "Timbalai 1948 / UTM zone 49N", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=evrstSS +towgs84=-679,669,-48,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / UTM zone 49N\",GEOGCS[\"Timbala");
    add_srs_wkt (p, 1,
        "i 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1830");
    add_srs_wkt (p, 2,
        " (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4298\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",111],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29849\"]]");
    p = add_epsg_def_ex (filter, first, last, 29850, "epsg", 29850,
        "Timbalai 1948 / UTM zone 50N", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=evrstSS +towgs84=-679,669,-48,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / UTM zone 50N\",GEOGCS[\"Timbala");
    add_srs_wkt (p, 1,
        "i 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1830");
    add_srs_wkt (p, 2,
        " (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4298\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",117],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29850\"]]");
    p = add_epsg_def_ex (filter, first, last, 29871, "epsg", 29871,
        "Timbalai 1948 / RSO Borneo (ch)", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Hotine_Oblique_Mercator_Azimuth_Center", "British chain (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.8714630401 +y_0=442857.653094361 ");
    add_proj4text (p, 2,
        "+gamma=53.13010236111111 +ellps=evrstSS +towgs84=-679,66");
    add_proj4text (p, 3,
        "9,-48,0,0,0,0 +to_meter=20.11676512155263 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (ch)\",GEOGCS[\"Timb");
    add_srs_wkt (p, 1,
        "alai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4298\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Center\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_center\",4],PARAMETER[\"longitud");
    add_srs_wkt (p, 9,
        "e_of_center\",115],PARAMETER[\"azimuth\",53.315820472222");
    add_srs_wkt (p, 10,
        "2],PARAMETER[\"rectified_grid_angle\",53.1301023611111],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_ea");
    add_srs_wkt (p, 12,
        "sting\",29352.4763],PARAMETER[\"false_northing\",22014.3");
    add_srs_wkt (p, 13,
        "572],UNIT[\"British chain (Sears 1922)\",20.116765121552");
    add_srs_wkt (p, 14,
        "6,AUTHORITY[\"EPSG\",\"9042\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 15,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29871\"]]");
    p = add_epsg_def_ex (filter, first, last, 29872, "epsg", 29872,
        "Timbalai 1948 / RSO Borneo (ftSe)", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Hotine_Oblique_Mercator_Azimuth_Center", "British foot (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.8727431979 +y_0=442857.6545573985");
    add_proj4text (p, 2,
        " +gamma=53.13010236111111 +ellps=evrstSS +towgs84=-679,6");
    add_proj4text (p, 3,
        "69,-48,0,0,0,0 +to_meter=0.3047994715386762 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (ftSe)\",GEOGCS[\"Ti");
    add_srs_wkt (p, 1,
        "mbalai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1967 Definition)\",6377298.556,300.8017,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4298");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Center");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_center\",4],PARAMETER[\"long");
    add_srs_wkt (p, 9,
        "itude_of_center\",115],PARAMETER[\"azimuth\",53.31582047");
    add_srs_wkt (p, 10,
        "22222],PARAMETER[\"rectified_grid_angle\",53.13010236111");
    add_srs_wkt (p, 11,
        "11],PARAMETER[\"scale_factor\",0.99984],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",1937263.44],PARAMETER[\"false_northing\",145");
    add_srs_wkt (p, 13,
        "2947.58],UNIT[\"British foot (Sears 1922)\",0.3047994715");
    add_srs_wkt (p, 14,
        "38676,AUTHORITY[\"EPSG\",\"9041\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 15,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29872\"");
    add_srs_wkt (p, 16,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 29873, "epsg", 29873,
        "Timbalai 1948 / RSO Borneo (m)", 0, 0,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.87 +y_0=442857.65 +gamma=53.13010");
    add_proj4text (p, 2,
        "236111111 +ellps=evrstSS +towgs84=-679,669,-48,0,0,0,0 +");
    add_proj4text (p, 3,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (m)\",GEOGCS[\"Timba");
    add_srs_wkt (p, 1,
        "lai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 18");
    add_srs_wkt (p, 2,
        "30 (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7016\"]],TOWGS84[-679,669,-48,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4298\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Center\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_center\",4],PARAMETER[\"longitud");
    add_srs_wkt (p, 9,
        "e_of_center\",115],PARAMETER[\"azimuth\",53.315820472222");
    add_srs_wkt (p, 10,
        "2],PARAMETER[\"rectified_grid_angle\",53.1301023611111],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_ea");
    add_srs_wkt (p, 12,
        "sting\",590476.87],PARAMETER[\"false_northing\",442857.6");
    add_srs_wkt (p, 13,
        "5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 15,
        "G\",\"29873\"]]");
    p = add_epsg_def_ex (filter, first, last, 29900, "epsg", 29900,
        "TM65 / Irish Grid", 0, 0,
        "Airy Modified 1849", "Greenwich",
        "TM65", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM65 / Irish Grid\",GEOGCS[\"TM65\",DATUM[\"TM6");
    add_srs_wkt (p, 1,
        "5\",SPHEROID[\"Airy Modified 1849\",6377340.189,299.3249");
    add_srs_wkt (p, 2,
        "646,AUTHORITY[\"EPSG\",\"7002\"]],TOWGS84[482.5,-130.6,5");
    add_srs_wkt (p, 3,
        "64.6,-1.042,-0.214,-0.631,8.15],AUTHORITY[\"EPSG\",\"629");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4299\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "3.5],PARAMETER[\"central_meridian\",-8],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000035],PARAMETER[\"false_easting\",200000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",250000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29902\"]]");
    p = add_epsg_def_ex (filter, first, last, 29901, "epsg", 29901,
        "OSNI 1952 / Irish National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "OSNI_1952", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1 +x_0=200000 +y_0=");
    add_proj4text (p, 1,
        "250000 +ellps=airy +towgs84=482.5,-130.6,564.6,-1.042,-0");
    add_proj4text (p, 2,
        ".214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"OSNI 1952 / Irish National Grid\",GEOGCS[\"OSNI");
    add_srs_wkt (p, 1,
        " 1952\",DATUM[\"OSNI_1952\",SPHEROID[\"Airy 1830\",63775");
    add_srs_wkt (p, 2,
        "63.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6188\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4188\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",53.5],PARAMETER[\"central_meridian\",-8],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",250000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29901\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 29902, "epsg", 29902,
        "TM65 / Irish Grid", 0, 0,
        "Airy Modified 1849", "Greenwich",
        "TM65", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM65 / Irish Grid\",GEOGCS[\"TM65\",DATUM[\"TM6");
    add_srs_wkt (p, 1,
        "5\",SPHEROID[\"Airy Modified 1849\",6377340.189,299.3249");
    add_srs_wkt (p, 2,
        "646,AUTHORITY[\"EPSG\",\"7002\"]],TOWGS84[482.5,-130.6,5");
    add_srs_wkt (p, 3,
        "64.6,-1.042,-0.214,-0.631,8.15],AUTHORITY[\"EPSG\",\"629");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4299\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "3.5],PARAMETER[\"central_meridian\",-8],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000035],PARAMETER[\"false_easting\",200000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",250000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29902\"]]");
    p = add_epsg_def_ex (filter, first, last, 29903, "epsg", 29903,
        "TM75 / Irish Grid", 0, 0,
        "Airy Modified 1849", "Greenwich",
        "Geodetic_Datum_of_1965", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM75 / Irish Grid\",GEOGCS[\"TM75\",DATUM[\"Geo");
    add_srs_wkt (p, 1,
        "detic_Datum_of_1965\",SPHEROID[\"Airy Modified 1849\",63");
    add_srs_wkt (p, 2,
        "77340.189,299.3249646,AUTHORITY[\"EPSG\",\"7002\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6300\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4300\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",53.5],PARAMETER[\"central_meridian\",-8]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.000035],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",200000],PARAMETER[\"false_northing\",250000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"29903\"]]");
    p = add_epsg_def_ex (filter, first, last, 30161, "epsg", 30161,
        "Tokyo / Japan Plane Rectangular CS I", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS I\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"central_meridian\",129.5],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"30161\"]]");
    p = add_epsg_def_ex (filter, first, last, 30162, "epsg", 30162,
        "Tokyo / Japan Plane Rectangular CS II", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS II\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",33],PARAMETER[\"central_meridian\",131],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"30162\"]]");
    p = add_epsg_def_ex (filter, first, last, 30163, "epsg", 30163,
        "Tokyo / Japan Plane Rectangular CS III", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS III\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",132.166666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30163\"]]");
    p = add_epsg_def_ex (filter, first, last, 30164, "epsg", 30164,
        "Tokyo / Japan Plane Rectangular CS IV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS IV\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",33],PARAMETER[\"central_meridian\",133.5],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"30164\"]]");
    p = add_epsg_def_ex (filter, first, last, 30165, "epsg", 30165,
        "Tokyo / Japan Plane Rectangular CS V", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS V\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "6],PARAMETER[\"central_meridian\",134.333333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9999],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30165\"]]");
    p = add_epsg_def_ex (filter, first, last, 30166, "epsg", 30166,
        "Tokyo / Japan Plane Rectangular CS VI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VI\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",136],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"30166\"]]");
    p = add_epsg_def_ex (filter, first, last, 30167, "epsg", 30167,
        "Tokyo / Japan Plane Rectangular CS VII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VII\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",137.166666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30167\"]]");
    p = add_epsg_def_ex (filter, first, last, 30168, "epsg", 30168,
        "Tokyo / Japan Plane Rectangular CS VIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VIII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",36],PARAMETER[\"central_meridian\",138.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"30168\"]]");
    p = add_epsg_def_ex (filter, first, last, 30169, "epsg", 30169,
        "Tokyo / Japan Plane Rectangular CS IX", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS IX\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",139.833333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30169\"]]");
    p = add_epsg_def_ex (filter, first, last, 30170, "epsg", 30170,
        "Tokyo / Japan Plane Rectangular CS X", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS X\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",140.833333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.9999],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30170\"]]");
    p = add_epsg_def_ex (filter, first, last, 30171, "epsg", 30171,
        "Tokyo / Japan Plane Rectangular CS XI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XI\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",44],PARAMETER[\"central_meridian\",140.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"30171\"]]");
    p = add_epsg_def_ex (filter, first, last, 30172, "epsg", 30172,
        "Tokyo / Japan Plane Rectangular CS XII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XII\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",44],PARAMETER[\"central_meridian\",142.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"30172\"]]");
    p = add_epsg_def_ex (filter, first, last, 30173, "epsg", 30173,
        "Tokyo / Japan Plane Rectangular CS XIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",44],PARAMETER[\"central_meridian\",144.25],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"30173\"]]");
    p = add_epsg_def_ex (filter, first, last, 30174, "epsg", 30174,
        "Tokyo / Japan Plane Rectangular CS XIV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIV\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",26],PARAMETER[\"central_meridian\",142],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"30174\"]]");
    p = add_epsg_def_ex (filter, first, last, 30175, "epsg", 30175,
        "Tokyo / Japan Plane Rectangular CS XV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XV\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",26],PARAMETER[\"central_meridian\",127.5],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"30175\"]]");
    p = add_epsg_def_ex (filter, first, last, 30176, "epsg", 30176,
        "Tokyo / Japan Plane Rectangular CS XVI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVI\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",26],PARAMETER[\"central_meridian\",124],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"30176\"]]");
    p = add_epsg_def_ex (filter, first, last, 30177, "epsg", 30177,
        "Tokyo / Japan Plane Rectangular CS XVII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",26],PARAMETER[\"central_meridian\",131],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"30177\"]]");
    p = add_epsg_def_ex (filter, first, last, 30178, "epsg", 30178,
        "Tokyo / Japan Plane Rectangular CS XVIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVIII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",20],PARAMETER[\"central_meridian\",136],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"30178\"]]");
    p = add_epsg_def_ex (filter, first, last, 30179, "epsg", 30179,
        "Tokyo / Japan Plane Rectangular CS XIX", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIX\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",26],PARAMETER[\"central_meridian\",154],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"30179\"]]");
    p = add_epsg_def_ex (filter, first, last, 30200, "epsg", 30200,
        "Trinidad 1903 / Trinidad Grid", 0, 0,
        "Clarke 1858", "Greenwich",
        "Trinidad_1903", "Cassini_Soldner", "Clarke's link",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=10.44166666666667 +lon_0=-61.333333333");
    add_proj4text (p, 1,
        "33334 +x_0=86501.46392051999 +y_0=65379.0134283 +a=63782");
    add_proj4text (p, 2,
        "93.645208759 +b=6356617.987679838 +towgs84=-61.702,284.4");
    add_proj4text (p, 3,
        "88,472.052,0,0,0,0 +to_meter=0.201166195164 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Trinidad 1903 / Trinidad Grid\",GEOGCS[\"Trinid");
    add_srs_wkt (p, 1,
        "ad 1903\",DATUM[\"Trinidad_1903\",SPHEROID[\"Clarke 1858");
    add_srs_wkt (p, 2,
        "\",6378293.64520876,294.260676369261,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7007\"]],TOWGS84[-61.702,284.488,472.052,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6302\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"430");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",10.4416666666667],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-61.3333333333333],PARAMETER[\"false_easting\",4");
    add_srs_wkt (p, 10,
        "30000],PARAMETER[\"false_northing\",325000],UNIT[\"Clark");
    add_srs_wkt (p, 11,
        "e's link\",0.201166195164,AUTHORITY[\"EPSG\",\"9039\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"30200\"]]");
    p = add_epsg_def_ex (filter, first, last, 30339, "epsg", 30339,
        "TC(1948) / UTM zone 39N", 0, 0,
        "Helmert 1906", "Greenwich",
        "Trucial_Coast_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=helmert +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TC(1948) / UTM zone 39N\",GEOGCS[\"TC(1948)\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Trucial_Coast_1948\",SPHEROID[\"Helmert 1906\",63");
    add_srs_wkt (p, 2,
        "78200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6303\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4303\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",51],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"30339\"]]");
    p = add_epsg_def_ex (filter, first, last, 30340, "epsg", 30340,
        "TC(1948) / UTM zone 40N", 0, 0,
        "Helmert 1906", "Greenwich",
        "Trucial_Coast_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=helmert +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TC(1948) / UTM zone 40N\",GEOGCS[\"TC(1948)\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Trucial_Coast_1948\",SPHEROID[\"Helmert 1906\",63");
    add_srs_wkt (p, 2,
        "78200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6303\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4303\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",57],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"30340\"]]");
    p = add_epsg_def_ex (filter, first, last, 30491, "epsg", 30491,
        "Voirol 1875 / Nord Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1875", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 2,
        "84=-73,-247,227,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1875 / Nord Algerie (ancienne)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7011\"]],TOWGS84[-73,-247,227,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6304\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4304\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",36],PARAMETER[\"central_meridian\",2.");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",0.999625544],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",500000],PARAMETER[\"false_northing\",3000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"30491\"]]");
    p = add_epsg_def_ex (filter, first, last, 30492, "epsg", 30492,
        "Voirol 1875 / Sud Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1875", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +t");
    add_proj4text (p, 2,
        "owgs84=-73,-247,227,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1875 / Sud Algerie (ancienne)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7011\"]],TOWGS84[-73,-247,227,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6304\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4304\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",33.3],PARAMETER[\"central_meridian\",2.7");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",0.999625769],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",30000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"30492\"]]");
    p = add_epsg_def_ex (filter, first, last, 30493, "epsg", 30493,
        "Voirol 1879 / Nord Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1879", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1879 / Nord Algerie (ancienne)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Voirol 1879\",DATUM[\"Voirol_1879\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7011\"]],AUTHORITY[\"EPSG\",\"6671\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4671\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",36],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",2.7],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.999625544],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",300000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"30493\"]]");
    p = add_epsg_def_ex (filter, first, last, 30494, "epsg", 30494,
        "Voirol 1879 / Sud Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1879", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1879 / Sud Algerie (ancienne)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Voirol 1879\",DATUM[\"Voirol_1879\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7011\"]],AUTHORITY[\"EPSG\",\"6671\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4671\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",33.3],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",2.7],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.999625769],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",300000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"30494\"]]");
    p = add_epsg_def_ex (filter, first, last, 30729, "epsg", 30729,
        "Nord Sahara 1959 / UTM zone 29N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-209.3622,-87.");
    add_proj4text (p, 1,
        "8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / UTM zone 29N\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],TOWGS84[-209.3622,-87.8162,404.6198,0.0046,3.");
    add_srs_wkt (p, 4,
        "4784,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6307\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4307\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-9],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"30729\"]]");
    p = add_epsg_def_ex (filter, first, last, 30730, "epsg", 30730,
        "Nord Sahara 1959 / UTM zone 30N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=clrk80 +towgs84=-209.3622,-87.");
    add_proj4text (p, 1,
        "8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / UTM zone 30N\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],TOWGS84[-209.3622,-87.8162,404.6198,0.0046,3.");
    add_srs_wkt (p, 4,
        "4784,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6307\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4307\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-3],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"30730\"]]");
    p = add_epsg_def_ex (filter, first, last, 30731, "epsg", 30731,
        "Nord Sahara 1959 / UTM zone 31N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=clrk80 +towgs84=-209.3622,-87.");
    add_proj4text (p, 1,
        "8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / UTM zone 31N\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],TOWGS84[-209.3622,-87.8162,404.6198,0.0046,3.");
    add_srs_wkt (p, 4,
        "4784,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6307\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4307\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",3],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"30731\"]]");
    p = add_epsg_def_ex (filter, first, last, 30732, "epsg", 30732,
        "Nord Sahara 1959 / UTM zone 32N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=clrk80 +towgs84=-209.3622,-87.");
    add_proj4text (p, 1,
        "8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / UTM zone 32N\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],TOWGS84[-209.3622,-87.8162,404.6198,0.0046,3.");
    add_srs_wkt (p, 4,
        "4784,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6307\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4307\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",9],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"30732\"]]");
    p = add_epsg_def_ex (filter, first, last, 30791, "epsg", 30791,
        "Nord Sahara 1959 / Nord Algerie", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500135 +y_0=300090 +ellps=clrk80 +towgs84=-209.36");
    add_proj4text (p, 2,
        "22,-87.8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / Nord Algerie\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],TOWGS84[-209.3622,-87.8162,404.6198,0.0046,3.");
    add_srs_wkt (p, 4,
        "4784,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6307\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4307\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",36],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",2.7],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.999625544],PARAMETER[\"false_easting\",500135],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",300090],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"30791\"]]");
    p = add_epsg_def_ex (filter, first, last, 30792, "epsg", 30792,
        "Nord Sahara 1959 / Sud Algerie", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500135 +y_0=300090 +ellps=clrk80 +towgs84=-20");
    add_proj4text (p, 2,
        "9.3622,-87.8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +u");
    add_proj4text (p, 3,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / Sud Algerie\",GEOGCS[\"Nord ");
    add_srs_wkt (p, 1,
        "Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7012\"]],TOWGS84[-209.3622,-87.8162,404.6198,0.0046,3.47");
    add_srs_wkt (p, 4,
        "84,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6307\"]],PRIMEM[");
    add_srs_wkt (p, 5,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 6,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4307\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",33.3],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",2.7],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.999625769],PARAMETER[\"false_easting\",500135],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",300090],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"30792\"]]");
    p = add_epsg_def_ex (filter, first, last, 30800, "epsg", 30800,
        "RT38 2.5 gon V", 0, 1,
        "Bessel 1841", "Greenwich",
        "Stockholm_1938", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1500000 +y_0=0 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RT38 2.5 gon V\",GEOGCS[\"RT38\",DATUM[\"Stockh");
    add_srs_wkt (p, 1,
        "olm_1938\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528");
    add_srs_wkt (p, 2,
        "128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "308\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4308\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "0],PARAMETER[\"central_meridian\",15.8082777777778],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",15");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"3027\"]]");
    p = add_epsg_def_ex (filter, first, last, 31028, "epsg", 31028,
        "Yoff / UTM zone 28N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Yoff", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-30,");
    add_proj4text (p, 1,
        "190,89,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yoff / UTM zone 28N\",GEOGCS[\"Yoff\",DATUM[\"Y");
    add_srs_wkt (p, 1,
        "off\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602");
    add_srs_wkt (p, 2,
        "1293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-30,190,89");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6310\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4310\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-15],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"31028\"]]");
    p = add_epsg_def_ex (filter, first, last, 31121, "epsg", 31121,
        "Zanderij / UTM zone 21N", 0, 0,
        "International 1924", "Greenwich",
        "Zanderij", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=intl +towgs84=-265,120,-358,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Zanderij / UTM zone 21N\",GEOGCS[\"Zanderij\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Zanderij\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-265,120,-35");
    add_srs_wkt (p, 3,
        "8,0,0,0,0],AUTHORITY[\"EPSG\",\"6311\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4311\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-57],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"31121\"]]");
    p = add_epsg_def_ex (filter, first, last, 31154, "epsg", 31154,
        "Zanderij / TM 54 NW", 0, 0,
        "International 1924", "Greenwich",
        "Zanderij", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-54 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Zanderij / TM 54 NW\",GEOGCS[\"Zanderij\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Zanderij\",SPHEROID[\"International 1924\",6378388,29");
    add_srs_wkt (p, 2,
        "7,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-265,120,-358,0,");
    add_srs_wkt (p, 3,
        "0,0,0],AUTHORITY[\"EPSG\",\"6311\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4311\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-54],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31154\"]]");
    p = add_epsg_def_ex (filter, first, last, 31170, "epsg", 31170,
        "Zanderij / Suriname Old TM", 0, 0,
        "International 1924", "Greenwich",
        "Zanderij", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-55.68333333333333 +k=0.9996");
    add_proj4text (p, 1,
        " +x_0=500000 +y_0=0 +ellps=intl +towgs84=-265,120,-358,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Zanderij / Suriname Old TM\",GEOGCS[\"Zanderij\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Zanderij\",SPHEROID[\"International 1924\",6378");
    add_srs_wkt (p, 2,
        "388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-265,120,-");
    add_srs_wkt (p, 3,
        "358,0,0,0,0],AUTHORITY[\"EPSG\",\"6311\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4311\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-55.6833333333333],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"31170\"]]");
    p = add_epsg_def_ex (filter, first, last, 31171, "epsg", 31171,
        "Zanderij / Suriname TM", 0, 0,
        "International 1924", "Greenwich",
        "Zanderij", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-55.68333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=500000 +y_0=0 +ellps=intl +towgs84=-265,120,-358,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Zanderij / Suriname TM\",GEOGCS[\"Zanderij\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Zanderij\",SPHEROID[\"International 1924\",6378388");
    add_srs_wkt (p, 2,
        ",297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-265,120,-358");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6311\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4311\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-55.6833333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"31171\"]]");
    p = add_epsg_def_ex (filter, first, last, 31251, "epsg", 31251,
        "MGI (Ferro) / Austria GK West Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=-5000000");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.4");
    add_proj4text (p, 2,
        "74,5.297,2.4232 +pm=ferro +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria GK West Zone\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI (Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferr");
    add_srs_wkt (p, 2,
        "o\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.91");
    add_srs_wkt (p, 4,
        "9,5.137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",-5000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"31251\"]]");
    p = add_epsg_def_ex (filter, first, last, 31252, "epsg", 31252,
        "MGI (Ferro) / Austria GK Central Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=-5000000");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.4");
    add_proj4text (p, 2,
        "74,5.297,2.4232 +pm=ferro +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria GK Central Zone\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"MGI (Ferro)\",DATUM[\"Militar_Geographische_Institut_F");
    add_srs_wkt (p, 2,
        "erro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463");
    add_srs_wkt (p, 4,
        ".919,5.137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805");
    add_srs_wkt (p, 5,
        "\"]],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",0],PARAMETER[\"central_meridian\",31],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",-5000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"31252\"]]");
    p = add_epsg_def_ex (filter, first, last, 31253, "epsg", 31253,
        "MGI (Ferro) / Austria GK East Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=-5000000");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.4");
    add_proj4text (p, 2,
        "74,5.297,2.4232 +pm=ferro +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria GK East Zone\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI (Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferr");
    add_srs_wkt (p, 2,
        "o\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.91");
    add_srs_wkt (p, 4,
        "9,5.137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",34],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",-5000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"31253\"]]");
    p = add_epsg_def_ex (filter, first, last, 31254, "epsg", 31254,
        "MGI / Austria GK West", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,46");
    add_proj4text (p, 2,
        "3.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK West\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar_Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "0.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",0],PARAMETER[\"false_northing\",-5000");
    add_srs_wkt (p, 11,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"31254\"]]");
    p = add_epsg_def_ex (filter, first, last, 31255, "epsg", 31255,
        "MGI / Austria GK Central", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,46");
    add_proj4text (p, 2,
        "3.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK Central\",GEOGCS[\"MGI\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Militar_Geographische_Institut\",SPHEROID[\"Bessel 18");
    add_srs_wkt (p, 2,
        "41\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.42");
    add_srs_wkt (p, 4,
        "32],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",13.3333333333333],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"31255\"]]");
    p = add_epsg_def_ex (filter, first, last, 31256, "epsg", 31256,
        "MGI / Austria GK East", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,46");
    add_proj4text (p, 2,
        "3.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK East\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar_Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "6.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",0],PARAMETER[\"false_northing\",-5000");
    add_srs_wkt (p, 11,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"31256\"]]");
    p = add_epsg_def_ex (filter, first, last, 31257, "epsg", 31257,
        "MGI / Austria GK M28", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "150000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.1");
    add_proj4text (p, 2,
        "29,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK M28\",GEOGCS[\"MGI\",DATUM[\"M");
    add_srs_wkt (p, 1,
        "ilitar_Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "0.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",150000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"31257\"]]");
    p = add_epsg_def_ex (filter, first, last, 31258, "epsg", 31258,
        "MGI / Austria GK M31", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "450000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.1");
    add_proj4text (p, 2,
        "29,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK M31\",GEOGCS[\"MGI\",DATUM[\"M");
    add_srs_wkt (p, 1,
        "ilitar_Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "3.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",450000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"31258\"]]");
    p = add_epsg_def_ex (filter, first, last, 31259, "epsg", 31259,
        "MGI / Austria GK M34", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "750000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.1");
    add_proj4text (p, 2,
        "29,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK M34\",GEOGCS[\"MGI\",DATUM[\"M");
    add_srs_wkt (p, 1,
        "ilitar_Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "6.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",750000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"31259\"]]");
    p = add_epsg_def_ex (filter, first, last, 31265, "epsg", 31265,
        "MGI / Balkans zone 5 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.47");
    add_proj4text (p, 2,
        "4,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 5 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar_Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",15],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",5500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31275\"]]");
    p = add_epsg_def_ex (filter, first, last, 31266, "epsg", 31266,
        "MGI / Balkans zone 6 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.47");
    add_proj4text (p, 2,
        "4,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 6 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar_Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",18],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",6500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31276\"]]");
    p = add_epsg_def_ex (filter, first, last, 31267, "epsg", 31267,
        "MGI / Balkans zone 7 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.47");
    add_proj4text (p, 2,
        "4,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 7 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar_Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31277\"]]");
    p = add_epsg_def_ex (filter, first, last, 31268, "epsg", 31268,
        "MGI / Balkans zone 8 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.47");
    add_proj4text (p, 2,
        "4,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 8 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar_Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31278\"]]");
    p = add_epsg_def_ex (filter, first, last, 31275, "epsg", 31275,
        "MGI 1901 / Balkans zone 5 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=5500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 5 (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"MGI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",15],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",5500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"3907\"]]");
    p = add_epsg_def_ex (filter, first, last, 31276, "epsg", 31276,
        "MGI 1901 / Balkans zone 6 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=6500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 6 (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"MGI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",18],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",6500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"3908\"]]");
    p = add_epsg_def_ex (filter, first, last, 31277, "epsg", 31277,
        "MGI 1901 / Balkans zone 7 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 7 (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"MGI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",21],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",7500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"3909\"]]");
    p = add_epsg_def_ex (filter, first, last, 31278, "epsg", 31278,
        "MGI / Balkans zone 8 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 8 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar_Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",24],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",8500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31279\"]]");
    p = add_epsg_def_ex (filter, first, last, 31279, "epsg", 31279,
        "MGI 1901 / Balkans zone 8 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "MGI_1901", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=8500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI 1901 / Balkans zone 8 (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"MGI 1901\",DATUM[\"MGI_1901\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[682,-203,480,0,0,0,0],AUTHORITY[\"EPSG\",\"1031\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"3906\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",24],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",8500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"3910\"]]");
    p = add_epsg_def_ex (filter, first, last, 31281, "epsg", 31281,
        "MGI (Ferro) / Austria West Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria West Zone\",GEOGCS[\"MGI ");
    add_srs_wkt (p, 1,
        "(Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferro\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.919,5");
    add_srs_wkt (p, 4,
        ".137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805\"]],P");
    add_srs_wkt (p, 5,
        "RIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 6,
        "909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"31281\"]]");
    p = add_epsg_def_ex (filter, first, last, 31282, "epsg", 31282,
        "MGI (Ferro) / Austria Central Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria Central Zone\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI (Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferr");
    add_srs_wkt (p, 2,
        "o\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.91");
    add_srs_wkt (p, 4,
        "9,5.137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805\"]");
    add_srs_wkt (p, 5,
        "],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",0],PARAMETER[\"central_meridian\",31],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"31282\"]]");
    p = add_epsg_def_ex (filter, first, last, 31283, "epsg", 31283,
        "MGI (Ferro) / Austria East Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria East Zone\",GEOGCS[\"MGI ");
    add_srs_wkt (p, 1,
        "(Ferro)\",DATUM[\"Militar_Geographische_Institut_Ferro\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.919,5");
    add_srs_wkt (p, 4,
        ".137,1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6805\"]],P");
    add_srs_wkt (p, 5,
        "RIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 6,
        "909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",34],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"31283\"]]");
    p = add_epsg_def_ex (filter, first, last, 31284, "epsg", 31284,
        "MGI / Austria M28", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "150000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M28\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar_Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 7,
        "12\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",10");
    add_srs_wkt (p, 9,
        ".3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",150000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"31284\"]]");
    p = add_epsg_def_ex (filter, first, last, 31285, "epsg", 31285,
        "MGI / Austria M31", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "450000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M31\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar_Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 7,
        "12\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",13");
    add_srs_wkt (p, 9,
        ".3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",450000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"31285\"]]");
    p = add_epsg_def_ex (filter, first, last, 31286, "epsg", 31286,
        "MGI / Austria M34", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "750000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M34\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar_Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 7,
        "12\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",16");
    add_srs_wkt (p, 9,
        ".3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",750000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"31286\"]]");
    p = add_epsg_def_ex (filter, first, last, 31287, "epsg", 31287,
        "MGI / Austria Lambert", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institut", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.3333");
    add_proj4text (p, 1,
        "3333333333 +x_0=400000 +y_0=400000 +ellps=bessel +towgs8");
    add_proj4text (p, 2,
        "4=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria Lambert\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar_Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[577.326,90.129,463.919,5.137,1.474,5.297,2.4232],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4312\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",47.5],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",13.3333333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_1\",49],PARAMETER[\"standard_parallel_2\",46],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",400000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"31287\"]]");
    p = add_epsg_def_ex (filter, first, last, 31288, "epsg", 31288,
        "MGI (Ferro) / M28", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=150000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / M28\",GEOGCS[\"MGI (Ferro)\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Militar_Geographische_Institut_Ferro\",SPHEROID[\"Be");
    add_srs_wkt (p, 2,
        "ssel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],TOWGS84[577.326,90.129,463.919,5.137,1.474,5.29");
    add_srs_wkt (p, 4,
        "7,2.4232],AUTHORITY[\"EPSG\",\"6805\"]],PRIMEM[\"Ferro\"");
    add_srs_wkt (p, 5,
        ",-17.6666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",28],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",150000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"31288\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

