/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_50 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 26965, "epsg", 26965,
        "NAD83 / Hawaii zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 5\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "1,1,-1,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",21.6666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-160.166666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26965\"]]");
    p = add_epsg_def_ex (filter, first, last, 26966, "epsg", 26966,
        "NAD83 / Georgia East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Georgia East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-82.1666666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999],PARAMETER[\"false_easting\",200000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26966\"]]");
    p = add_epsg_def_ex (filter, first, last, 26967, "epsg", 26967,
        "NAD83 / Georgia West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Georgia West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",30],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-84.1666666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999],PARAMETER[\"false_easting\",700000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"26967\"]]");
    p = add_epsg_def_ex (filter, first, last, 26968, "epsg", 26968,
        "NAD83 / Idaho East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho East\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",41.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-112.166666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.999947368],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26968\"]]");
    p = add_epsg_def_ex (filter, first, last, 26969, "epsg", 26969,
        "NAD83 / Idaho Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho Central\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",41.6666666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-114],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.999947368],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"26969\"]]");
    p = add_epsg_def_ex (filter, first, last, 26970, "epsg", 26970,
        "NAD83 / Idaho West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 2,
        "0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho West\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",41.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-115.75],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999933333],PARAMETER[\"false_easting\",800000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"26970\"]]");
    p = add_epsg_def_ex (filter, first, last, 26971, "epsg", 26971,
        "NAD83 / Illinois East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois East\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36.6666666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-88.3333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.999975],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",300000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26971\"]]");
    p = add_epsg_def_ex (filter, first, last, 26972, "epsg", 26972,
        "NAD83 / Illinois West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Illinois West\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36.6666666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-90.1666666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.999941177],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",700000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26972\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26973, "epsg", 26973,
        "NAD83 / Indiana East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Indiana East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",37.5],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-85.6666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999966667],PARAMETER[\"false_easting\",100000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",250000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26973\"]]");
    p = add_epsg_def_ex (filter, first, last, 26974, "epsg", 26974,
        "NAD83 / Indiana West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Indiana West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",37.5],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-87.0833333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999966667],PARAMETER[\"false_easting\",900000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",250000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26974\"]]");
    p = add_epsg_def_ex (filter, first, last, 26975, "epsg", 26975,
        "NAD83 / Iowa North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa North\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",41.5],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-93.5],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_1\",43.2666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_2\",42.0666666666667],PARAMETER[\"false_easting\",15000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26975\"]]");
    p = add_epsg_def_ex (filter, first, last, 26976, "epsg", 26976,
        "NAD83 / Iowa South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Iowa South\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-93.5],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",41.7833333333333],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",40.6166666666667],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"26976\"]]");
    p = add_epsg_def_ex (filter, first, last, 26977, "epsg", 26977,
        "NAD83 / Kansas North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas North\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
        "nic_2SP\"],PARAMETER[\"latitude_of_origin\",38.333333333");
    add_srs_wkt (p, 8,
        "3333],PARAMETER[\"central_meridian\",-98],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",39.7833333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",38.7166666666667],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",400000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26977\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26978, "epsg", 26978,
        "NAD83 / Kansas South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y");
    add_proj4text (p, 2,
        "_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kansas South\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
        "nic_2SP\"],PARAMETER[\"latitude_of_origin\",36.666666666");
    add_srs_wkt (p, 8,
        "6667],PARAMETER[\"central_meridian\",-98.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",38.5666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",37.2666666666667],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",400000],PARAMETER[\"false_northing\",400000],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "26978\"]]");
    p = add_epsg_def_ex (filter, first, last, 26979, "epsg", 26979,
        "NAD83 / Kentucky North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=37.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37.5],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-84.25],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",37.9666666666667],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",38.9666666666667],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2205\"]]");
    p = add_epsg_def_ex (filter, first, last, 26980, "epsg", 26980,
        "NAD83 / Kentucky South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +");
    add_proj4text (p, 2,
        "y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.333333");
    add_srs_wkt (p, 8,
        "3333333],PARAMETER[\"central_meridian\",-85.75],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_1\",37.9333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",36.7333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",500000],PARAMETER[\"false_northing\",500000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"26980\"]]");
    p = add_epsg_def_ex (filter, first, last, 26981, "epsg", 26981,
        "NAD83 / Louisiana North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana North\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",30.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-92.5],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",32.6666666666667],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",31.1666666666667],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "1000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26981\"]]");
    p = add_epsg_def_ex (filter, first, last, 26982, "epsg", 26982,
        "NAD83 / Louisiana South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91");
    add_proj4text (p, 1,
        ".33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs8");
    add_proj4text (p, 2,
        "4=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Louisiana South\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",28.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-91.3333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_1\",30.7],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",29.3],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26982\"]]");
    p = add_epsg_def_ex (filter, first, last, 26983, "epsg", 26983,
        "NAD83 / Maine East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",43.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-68.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9999],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"26983\"]]");
    p = add_epsg_def_ex (filter, first, last, 26984, "epsg", 26984,
        "NAD83 / Maine West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",42.8333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-70.1666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.999966667],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",900000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26984\"]]");
    p = add_epsg_def_ex (filter, first, last, 26985, "epsg", 26985,
        "NAD83 / Maryland", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maryland\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",37.666666666666");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"central_meridian\",-77],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",39.45],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",38.3],PARAMETER[\"false_easting\",400000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26985\"]]");
    p = add_epsg_def_ex (filter, first, last, 26986, "epsg", 26986,
        "NAD83 / Massachusetts Mainland", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Massachusetts Mainland\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-71.5],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_1\",42.6833333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",41.7166666666667],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",200000],PARAMETER[\"false_northing\",750000],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 14,
        "86\"]]");
    p = add_epsg_def_ex (filter, first, last, 26987, "epsg", 26987,
        "NAD83 / Massachusetts Island", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Massachusetts Island\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-70.5],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",41.4833333333333],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",41.2833333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26987\"]]");
    p = add_epsg_def_ex (filter, first, last, 26988, "epsg", 26988,
        "NAD83 / Michigan North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan North\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",44.783333");
    add_srs_wkt (p, 8,
        "3333333],PARAMETER[\"central_meridian\",-87],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",47.0833333333333],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",45.4833333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",8000000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"269");
    add_srs_wkt (p, 14,
        "88\"]]");
    p = add_epsg_def_ex (filter, first, last, 26989, "epsg", 26989,
        "NAD83 / Michigan Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43");
    add_proj4text (p, 1,
        ".31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43.31666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-84.36666666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"standard_parallel_1\",45.7],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",44.1833333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",6000000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "26989\"]]");
    p = add_epsg_def_ex (filter, first, last, 26990, "epsg", 26990,
        "NAD83 / Michigan South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41");
    add_proj4text (p, 1,
        ".5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan South\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41.5],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-84.3666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",43.6666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",42.1],PARAMETER[\"false_easting\",4");
    add_srs_wkt (p, 11,
        "000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26990\"]]");
    p = add_epsg_def_ex (filter, first, last, 26991, "epsg", 26991,
        "NAD83 / Minnesota North", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y");
    add_proj4text (p, 2,
        "_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",46.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-93.1],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",48.6333333333333],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",47.0333333333333],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "800000],PARAMETER[\"false_northing\",100000],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26991\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26992, "epsg", 26992,
        "NAD83 / Minnesota Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",45],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-94.25],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",47.05],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "45.6166666666667],PARAMETER[\"false_easting\",800000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",100000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26992\"]]");
    p = add_epsg_def_ex (filter, first, last, 26993, "epsg", 26993,
        "NAD83 / Minnesota South", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-94],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_1\",45.2166666666667],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",43.7833333333333],PARAMETER[\"false_easting\",8000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",100000],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26993\"]]");
    p = add_epsg_def_ex (filter, first, last, 26994, "epsg", 26994,
        "NAD83 / Mississippi East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi East\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",29.5],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-88.8333333333333],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.99995],PARAMETER[\"false_easting\",300000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"26994\"]]");
    p = add_epsg_def_ex (filter, first, last, 26995, "epsg", 26995,
        "NAD83 / Mississippi West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi West\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",29.5],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-90.3333333333333],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.99995],PARAMETER[\"false_easting\",700000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"26995\"]]");
    p = add_epsg_def_ex (filter, first, last, 26996, "epsg", 26996,
        "NAD83 / Missouri East", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri East\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",35.8333333333333],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-90.5],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999933333],PARAMETER[\"false_easting\",250000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"26996\"]]");
    p = add_epsg_def_ex (filter, first, last, 26997, "epsg", 26997,
        "NAD83 / Missouri Central", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",35.8333333333333");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-92.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.999933333],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26997\"]]");
    p = add_epsg_def_ex (filter, first, last, 26998, "epsg", 26998,
        "NAD83 / Missouri West", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Missouri West\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36.1666666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-94.5],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.999941177],PARAMETER[\"false_easting\",850000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"26998\"]]");
    p = add_epsg_def_ex (filter, first, last, 27037, "epsg", 27037,
        "Nahrwan 1934 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 37N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6744\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4744\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"7005\"]]");
    p = add_epsg_def_ex (filter, first, last, 27038, "epsg", 27038,
        "Nahrwan 1934 / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1934", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1934 / UTM zone 38N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1934\",DATUM[\"Nahrwan_1934\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-242.2,-144.9,370.3,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6744\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4744\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"7006\"]]");
    p = add_epsg_def_ex (filter, first, last, 27039, "epsg", 27039,
        "Nahrwan 1967 / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 39N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6270\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4270\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"270");
    add_srs_wkt (p, 12,
        "39\"]]");
    p = add_epsg_def_ex (filter, first, last, 27040, "epsg", 27040,
        "Nahrwan 1967 / UTM zone 40N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-249,-156,381,");
    add_proj4text (p, 1,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nahrwan 1967 / UTM zone 40N\",GEOGCS[\"Nahrwan ");
    add_srs_wkt (p, 1,
        "1967\",DATUM[\"Nahrwan_1967\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-249,-156,381,0,0,0,0],AUTHORITY[\"EPSG\",\"6270\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4270\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",57],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"27040\"]]");
    p = add_epsg_def_ex (filter, first, last, 27120, "epsg", 27120,
        "Naparima 1972 / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "Naparima_1972", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-10,375,165,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Naparima 1972 / UTM zone 20N\",GEOGCS[\"Naparim");
    add_srs_wkt (p, 1,
        "a 1972\",DATUM[\"Naparima_1972\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-2,374,172,0,0,0,0],AUTHORITY[\"EPSG\",\"6271\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4271\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-63],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"27120\"]]");
    p = add_epsg_def_ex (filter, first, last, 27200, "epsg", 27200,
        "NZGD49 / New Zealand Map Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "New_Zealand_Map_Grid", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=nzmg +lat_0=-41 +lon_0=173 +x_0=2510000 +y_0=60231");
    add_proj4text (p, 1,
        "50 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.0");
    add_proj4text (p, 2,
        "24,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / New Zealand Map Grid\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4272\"]],PROJECTION[\"New_Zealand_Map_Grid\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_origin\",-41],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",173],PARAMETER[\"false_easting\",2510000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",6023150],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"27200\"]]");
    p = add_epsg_def_ex (filter, first, last, 27205, "epsg", 27205,
        "NZGD49 / Mount Eden Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-36.87986527777778 +lon_0=174.7643393");
    add_proj4text (p, 1,
        "611111 +k=0.9999 +x_0=300000 +y_0=700000 +ellps=intl +to");
    add_proj4text (p, 2,
        "wgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Eden Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-36.8798652777778],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",174.764339361111],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999],PARAMETER[\"false_easting\",300000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"27205\"]]");
    p = add_epsg_def_ex (filter, first, last, 27206, "epsg", 27206,
        "NZGD49 / Bay of Plenty Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-37.76124980555556 +lon_0=176.4661972");
    add_proj4text (p, 1,
        "5 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bay of Plenty Circuit\",GEOGCS[\"NZGD4");
    add_srs_wkt (p, 1,
        "9\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",-37.7612498055556],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",176.46619725],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27206\"]]");
    p = add_epsg_def_ex (filter, first, last, 27207, "epsg", 27207,
        "NZGD49 / Poverty Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-38.62470277777778 +lon_0=177.8856362");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Poverty Bay Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-38.6247027777778],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",177.885636277778],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27207\"]]");
    p = add_epsg_def_ex (filter, first, last, 27208, "epsg", 27208,
        "NZGD49 / Hawkes Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.65092930555556 +lon_0=176.6736805");
    add_proj4text (p, 1,
        "277778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hawkes Bay Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-39.6509293055556],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",176.673680527778],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27208\"]]");
    p = add_epsg_def_ex (filter, first, last, 27209, "epsg", 27209,
        "NZGD49 / Taranaki Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.13575830555556 +lon_0=174.2280117");
    add_proj4text (p, 1,
        "5 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Taranaki Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-39.1357583055556],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",174.22801175],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",300000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"27209\"]]");
    p = add_epsg_def_ex (filter, first, last, 27210, "epsg", 27210,
        "NZGD49 / Tuhirangi Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39.51247038888889 +lon_0=175.6400368");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Tuhirangi Circuit\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-39.5124703888889],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",175.640036805556],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27210\"]]");
    p = add_epsg_def_ex (filter, first, last, 27211, "epsg", 27211,
        "NZGD49 / Wanganui Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.24194713888889 +lon_0=175.4880996");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wanganui Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-40.2419471388889],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",175.488099611111],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27211\"]]");
    p = add_epsg_def_ex (filter, first, last, 27212, "epsg", 27212,
        "NZGD49 / Wairarapa Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.92553263888889 +lon_0=175.6473496");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wairarapa Circuit\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-40.9255326388889],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",175.647349666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27212\"]]");
    p = add_epsg_def_ex (filter, first, last, 27213, "epsg", 27213,
        "NZGD49 / Wellington Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.30131963888888 +lon_0=174.7766231");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wellington Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-41.3013196388889],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",174.776623111111],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27213\"]]");
    p = add_epsg_def_ex (filter, first, last, 27214, "epsg", 27214,
        "NZGD49 / Collingwood Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.71475905555556 +lon_0=172.6720465");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47");
    add_proj4text (p, 2,
        ",-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Collingwood Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-40.7147590555556],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",172.6720465],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"27214\"]]");
    p = add_epsg_def_ex (filter, first, last, 27215, "epsg", 27215,
        "NZGD49 / Nelson Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.27454472222222 +lon_0=173.2993168");
    add_proj4text (p, 1,
        "055555 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Nelson Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-41.2745447222222],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",173.299316805556],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"27215\"]]");
    p = add_epsg_def_ex (filter, first, last, 27216, "epsg", 27216,
        "NZGD49 / Karamea Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.28991152777778 +lon_0=172.1090281");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Karamea Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-41.2899115277778],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",172.109028194444],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27216\"]]");
    p = add_epsg_def_ex (filter, first, last, 27217, "epsg", 27217,
        "NZGD49 / Buller Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.81080286111111 +lon_0=171.5812600");
    add_proj4text (p, 1,
        "555556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Buller Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-41.8108028611111],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",171.581260055556],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"27217\"]]");
    p = add_epsg_def_ex (filter, first, last, 27218, "epsg", 27218,
        "NZGD49 / Grey Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.33369427777778 +lon_0=171.5497713");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Grey Circuit\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",-42.3336942777778],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",171.549771305556],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"27218\"]]");
    p = add_epsg_def_ex (filter, first, last, 27219, "epsg", 27219,
        "NZGD49 / Amuri Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.68911658333333 +lon_0=173.0101333");
    add_proj4text (p, 1,
        "888889 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Amuri Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"427");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",-42.6891165833333],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",173.010133388889],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"27219\"]]");
    p = add_epsg_def_ex (filter, first, last, 27220, "epsg", 27220,
        "NZGD49 / Marlborough Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.54448666666666 +lon_0=173.8020741");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Marlborough Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-41.5444866666667],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",173.802074111111],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27220\"]]");
    p = add_epsg_def_ex (filter, first, last, 27221, "epsg", 27221,
        "NZGD49 / Hokitika Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.88632236111111 +lon_0=170.9799935");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47");
    add_proj4text (p, 2,
        ",-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hokitika Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-42.8863223611111],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",170.9799935],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",300000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"27221\"]]");
    p = add_epsg_def_ex (filter, first, last, 27222, "epsg", 27222,
        "NZGD49 / Okarito Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.11012813888889 +lon_0=170.2609258");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Okarito Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-43.1101281388889],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",170.260925833333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27222\"]]");
    p = add_epsg_def_ex (filter, first, last, 27223, "epsg", 27223,
        "NZGD49 / Jacksons Bay Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.97780288888889 +lon_0=168.606267 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,");
    add_proj4text (p, 2,
        "-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Jacksons Bay Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",-43.9778028888889],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",168.606267],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"27223\"]]");
    p = add_epsg_def_ex (filter, first, last, 27224, "epsg", 27224,
        "NZGD49 / Mount Pleasant Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.59063758333333 +lon_0=172.7271935");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Pleasant Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5");
    add_srs_wkt (p, 4,
        "993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",-43.5906375833333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",172.727193583333],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27224\"]]");
    p = add_epsg_def_ex (filter, first, last, 27225, "epsg", 27225,
        "NZGD49 / Gawler Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.74871155555556 +lon_0=171.3607484");
    add_proj4text (p, 1,
        "722222 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Gawler Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-43.7487115555556],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",171.360748472222],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"27225\"]]");
    p = add_epsg_def_ex (filter, first, last, 27226, "epsg", 27226,
        "NZGD49 / Timaru Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.40222036111111 +lon_0=171.0572508");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Timaru Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-44.4022203611111],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",171.057250833333],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"27226\"]]");
    p = add_epsg_def_ex (filter, first, last, 27227, "epsg", 27227,
        "NZGD49 / Lindis Peak Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.73526797222222 +lon_0=169.4677550");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Lindis Peak Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-44.7352679722222],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",169.467755083333],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27227\"]]");
    p = add_epsg_def_ex (filter, first, last, 27228, "epsg", 27228,
        "NZGD49 / Mount Nicholas Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.13290258333333 +lon_0=168.3986411");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Nicholas Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5");
    add_srs_wkt (p, 4,
        "993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",-45.1329025833333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",168.398641194444],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"27228\"]]");
    p = add_epsg_def_ex (filter, first, last, 27229, "epsg", 27229,
        "NZGD49 / Mount York Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.56372616666666 +lon_0=167.7388617");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount York Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-45.5637261666667],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",167.738861777778],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AUTHORITY[\"EPSG\",\"27229\"]]");
    p = add_epsg_def_ex (filter, first, last, 27230, "epsg", 27230,
        "NZGD49 / Observation Point Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.81619661111111 +lon_0=170.6285951");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84");
    add_proj4text (p, 2,
        "=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Observation Point Circuit\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ZGD49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-");
    add_srs_wkt (p, 4,
        "4.5993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",-45.8161966111111],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",170.628595166667],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"27230\"]]");
    p = add_epsg_def_ex (filter, first, last, 27231, "epsg", 27231,
        "NZGD49 / North Taieri Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.86151336111111 +lon_0=170.2825891");
    add_proj4text (p, 1,
        "111111 +k=0.99996 +x_0=300000 +y_0=700000 +ellps=intl +t");
    add_proj4text (p, 2,
        "owgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Taieri Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",-45.8615133611111],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",170.282589111111],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.99996],PARAMETER[\"false_easting\",300000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"27231\"]]");
    p = add_epsg_def_ex (filter, first, last, 27232, "epsg", 27232,
        "NZGD49 / Bluff Circuit", 0, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-46.60000961111111 +lon_0=168.342872 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300002.66 +y_0=699999.58 +ellps=intl +towgs84=");
    add_proj4text (p, 2,
        "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bluff Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"427");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",-46.6000096111111],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",168.342872],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",300002.66],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",699999.58],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"27232\"]]");
    p = add_epsg_def_ex (filter, first, last, 27258, "epsg", 27258,
        "NZGD49 / UTM zone 58S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 58S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",165]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"27258\"]]");
    p = add_epsg_def_ex (filter, first, last, 27259, "epsg", 27259,
        "NZGD49 / UTM zone 59S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 59S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",171]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"27259\"]]");
    p = add_epsg_def_ex (filter, first, last, 27260, "epsg", 27260,
        "NZGD49 / UTM zone 60S", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=intl +towgs84=59.47,-5.");
    add_proj4text (p, 1,
        "04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 60S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",177]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"27260\"]]");
    p = add_epsg_def_ex (filter, first, last, 27291, "epsg", 27291,
        "NZGD49 / North Island Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "British yard (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39 +lon_0=175.5 +k=1 +x_0=274319.524");
    add_proj4text (p, 1,
        "3848086 +y_0=365759.3658464114 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.91439");
    add_proj4text (p, 3,
        "84146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-39],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",175.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",300000],PARAMETER[\"false_northing\",400000],U");
    add_srs_wkt (p, 11,
        "NIT[\"British yard (Sears 1922)\",0.914398414616029,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"27291\"]]");
    p = add_epsg_def_ex (filter, first, last, 27292, "epsg", 27292,
        "NZGD49 / South Island Grid", 0, 0,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "Transverse_Mercator", "British yard (Sears 1922)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=171.5 +k=1 +x_0=457199.207");
    add_proj4text (p, 1,
        "3080143 +y_0=457199.2073080143 +ellps=intl +towgs84=59.4");
    add_proj4text (p, 2,
        "7,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.91439");
    add_proj4text (p, 3,
        "84146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / South Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-44],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",171.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",500000],U");
    add_srs_wkt (p, 11,
        "NIT[\"British yard (Sears 1922)\",0.914398414616029,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"27292\"]]");
    p = add_epsg_def_ex (filter, first, last, 27391, "epsg", 27391,
        "NGO 1948 (Oslo) / NGO zone I", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-4.666666666666667 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone I\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666666");
    add_srs_wkt (p, 5,
        "67,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-4.66666666666667],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",0],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"27391\"]]");
    p = add_epsg_def_ex (filter, first, last, 27392, "epsg", 27392,
        "NGO 1948 (Oslo) / NGO zone II", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-2.333333333333333 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone II\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 6,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",58],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-2.33333333333333],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"27392\"]]");
    p = add_epsg_def_ex (filter, first, last, 27393, "epsg", 27393,
        "NGO 1948 (Oslo) / NGO zone III", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=637");
    add_proj4text (p, 1,
        "7492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.");
    add_proj4text (p, 2,
        "889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone III\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.722916666");
    add_srs_wkt (p, 5,
        "6667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2739");
    add_srs_wkt (p, 13,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 27394, "epsg", 27394,
        "NGO 1948 (Oslo) / NGO zone IV", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=2.5 +k=1 +x_0=0 +y_0=0 +a=6");
    add_proj4text (p, 1,
        "377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,");
    add_proj4text (p, 2,
        "7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone IV\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 6,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",58],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",2.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northin");
    add_srs_wkt (p, 12,
        "g\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "7394\"]]");
    p = add_epsg_def_ex (filter, first, last, 27395, "epsg", 27395,
        "NGO 1948 (Oslo) / NGO zone V", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.166666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone V\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666666");
    add_srs_wkt (p, 5,
        "67,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",58],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",6.16666666666667],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"27395\"]]");
    p = add_epsg_def_ex (filter, first, last, 27396, "epsg", 27396,
        "NGO 1948 (Oslo) / NGO zone VI", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VI\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 6,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",58],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",10.1666666666667],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",0],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"27396\"]]");
    p = add_epsg_def_ex (filter, first, last, 27397, "epsg", 27397,
        "NGO 1948 (Oslo) / NGO zone VII", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VII\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.722916666");
    add_srs_wkt (p, 5,
        "6667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",14.1666666666667],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"27397\"]]");
    p = add_epsg_def_ex (filter, first, last, 27398, "epsg", 27398,
        "NGO 1948 (Oslo) / NGO zone VIII", 0, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.33333333333333 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VIII\",GEOGCS[\"NGO ");
    add_srs_wkt (p, 1,
        "1948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel ");
    add_srs_wkt (p, 2,
        "Modified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666");
    add_srs_wkt (p, 5,
        "66667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",18.3333333333333],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"27398\"]]");
    p = add_epsg_def_ex (filter, first, last, 27429, "epsg", 27429,
        "Datum 73 / UTM zone 29N", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +towgs84=-223.237,110.193");
    add_proj4text (p, 1,
        ",36.649,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / UTM zone 29N\",GEOGCS[\"Datum 73\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Datum_73\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-239.749,88.");
    add_srs_wkt (p, 3,
        "181,30.488,0.263,0.082,1.211,2.229],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"27429\"]]");
    p = add_epsg_def_ex (filter, first, last, 27492, "epsg", 27492,
        "Datum 73 / Modified Portuguese Grid", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-239.749,88.181,30.488,0.263,0.082,1.211,2.229],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",39.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-8.13190611111111],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",180.598],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",-86.99],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"27493\"]]");
    p = add_epsg_def_ex (filter, first, last, 27493, "epsg", 27493,
        "Datum 73 / Modified Portuguese Grid", 0, 0,
        "International 1924", "Greenwich",
        "Datum_73", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-239.749,88.181,30.488,0.263,0.082,1.211,2.229],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",39.6666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-8.13190611111111],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",180.598],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",-86.99],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"27493\"]]");
    p = add_epsg_def_ex (filter, first, last, 27500, "epsg", 27500,
        "ATF (Paris) / Nord de Guerre", 0, 0,
        "Plessis 1817", "Paris RGS",
        "Ancienne_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=5.399999999999999 +k_0=0.99950908 +x_0=500000");
    add_proj4text (p, 2,
        " +y_0=300000 +a=6376523 +b=6355862.933255573 +pm=2.33720");
    add_proj4text (p, 3,
        "8333333333 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATF (Paris) / Nord de Guerre\",GEOGCS[\"ATF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Ancienne_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Plessis 1817\",6376523,308.64,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901\"]],PRIMEM[\"Pa");
    add_srs_wkt (p, 4,
        "ris RGS\",2.33720833333333,AUTHORITY[\"EPSG\",\"8914\"]]");
    add_srs_wkt (p, 5,
        ",UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "105\"]],AUTHORITY[\"EPSG\",\"4901\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",55],PARAMETER[\"central_meridian\",6],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.99950908],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27500\"]]");
    p = add_epsg_def_ex (filter, first, last, 27561, "epsg", 27561,
        "NTF (Paris) / Lambert Nord France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Nord France\",GEOGCS[\"NT");
    add_srs_wkt (p, 1,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 2,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 3,
        "293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 6,
        "rad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.999877341],PARAMETER[\"false_easting\",600000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",200000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"27561\"]]");
    p = add_epsg_def_ex (filter, first, last, 27562, "epsg", 27562,
        "NTF (Paris) / Lambert Centre France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Centre France\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,");
    add_srs_wkt (p, 4,
        "320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Pari");
    add_srs_wkt (p, 5,
        "s\",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.99987742],PARAMETER[\"false_easting\",600000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",200000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"27562\"]]");
    p = add_epsg_def_ex (filter, first, last, 27563, "epsg", 27563,
        "NTF (Paris) / Lambert Sud France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Sud France\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "93627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 6,
        "rad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.999877499],PARAMETER[\"false_easting\",600000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",200000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"27563\"]]");
    p = add_epsg_def_ex (filter, first, last, 27564, "epsg", 27564,
        "NTF (Paris) / Lambert Corse", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Corse\",GEOGCS[\"NTF (Par");
    add_srs_wkt (p, 1,
        "is)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293627");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.33");
    add_srs_wkt (p, 5,
        "722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 6,
        ",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",0],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.99994471],PARAMETER[\"false_easting\",234.358],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",185861.369],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"27564\"]]");
    p = add_epsg_def_ex (filter, first, last, 27571, "epsg", 27571,
        "NTF (Paris) / Lambert zone I", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 3,
        "7,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.3");
    add_srs_wkt (p, 5,
        "3722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 6,
        ",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999877341],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",1200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"27571\"]]");
    p = add_epsg_def_ex (filter, first, last, 27572, "epsg", 27572,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 5,
        "33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad");
    add_srs_wkt (p, 6,
        "\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.99987742],PARAMETER[\"false_easting\",600000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",2200000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"27572\"]]");
    p = add_epsg_def_ex (filter, first, last, 27573, "epsg", 27573,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 1,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 5,
        "33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad");
    add_srs_wkt (p, 6,
        "\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999877499],PARAMETER[\"false_easting\",600000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",3200000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"27573\"]]");
    p = add_epsg_def_ex (filter, first, last, 27574, "epsg", 27574,
        "NTF (Paris) / Lambert zone IV", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 5,
        "33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad");
    add_srs_wkt (p, 6,
        "\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.99994471],PARAMETER[\"false_easting\",234.358],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",4185861.369],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27574\"]]");
    p = add_epsg_def_ex (filter, first, last, 27581, "epsg", 27581,
        "NTF (Paris) / Lambert zone I", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 3,
        "7,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.3");
    add_srs_wkt (p, 5,
        "3722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 6,
        ",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999877341],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",1200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"27571\"]]");
    p = add_epsg_def_ex (filter, first, last, 27582, "epsg", 27582,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 5,
        "33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad");
    add_srs_wkt (p, 6,
        "\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.99987742],PARAMETER[\"false_easting\",600000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",2200000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"27572\"]]");
    p = add_epsg_def_ex (filter, first, last, 27583, "epsg", 27583,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 1,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 5,
        "33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad");
    add_srs_wkt (p, 6,
        "\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999877499],PARAMETER[\"false_easting\",600000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",3200000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"27573\"]]");
    p = add_epsg_def_ex (filter, first, last, 27584, "epsg", 27584,
        "NTF (Paris) / Lambert zone IV", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 5,
        "33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad");
    add_srs_wkt (p, 6,
        "\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.99994471],PARAMETER[\"false_easting\",234.358],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",4185861.369],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"27574\"]]");
    p = add_epsg_def_ex (filter, first, last, 27591, "epsg", 27591,
        "NTF (Paris) / Lambert Nord France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Nord France\",GEOGCS[\"NT");
    add_srs_wkt (p, 1,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 2,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 3,
        "293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 6,
        "rad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.999877341],PARAMETER[\"false_easting\",600000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",200000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"27561\"]]");
    p = add_epsg_def_ex (filter, first, last, 27592, "epsg", 27592,
        "NTF (Paris) / Lambert Centre France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Centre France\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,");
    add_srs_wkt (p, 4,
        "320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Pari");
    add_srs_wkt (p, 5,
        "s\",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.99987742],PARAMETER[\"false_easting\",600000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",200000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"27562\"]]");
    p = add_epsg_def_ex (filter, first, last, 27593, "epsg", 27593,
        "NTF (Paris) / Lambert Sud France", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Sud France\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "93627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320");
    add_srs_wkt (p, 4,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 6,
        "rad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.999877499],PARAMETER[\"false_easting\",600000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",200000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"27563\"]]");
    p = add_epsg_def_ex (filter, first, last, 27594, "epsg", 27594,
        "NTF (Paris) / Lambert Corse", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Corse\",GEOGCS[\"NTF (Par");
    add_srs_wkt (p, 1,
        "is)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293627");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.33");
    add_srs_wkt (p, 5,
        "722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 6,
        ",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",0],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.99994471],PARAMETER[\"false_easting\",234.358],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",185861.369],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"27564\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

