/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_46 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 22176, "epsg", 22176,
        "POSGAR 98 / Argentina 6", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 6\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",6500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"22176\"]]");
    p = add_epsg_def_ex (filter, first, last, 22177, "epsg", 22177,
        "POSGAR 98 / Argentina 7", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 7\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"619");
    add_srs_wkt (p, 4,
        "0\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4190\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 8,
        "90],PARAMETER[\"central_meridian\",-54],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",7500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"22177\"]]");
    p = add_epsg_def_ex (filter, first, last, 22181, "epsg", 22181,
        "POSGAR 94 / Argentina 1", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 1\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-72],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",1500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"22181\"]]");
    p = add_epsg_def_ex (filter, first, last, 22182, "epsg", 22182,
        "POSGAR 94 / Argentina 2", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 2\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",2500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"22182\"]]");
    p = add_epsg_def_ex (filter, first, last, 22183, "epsg", 22183,
        "POSGAR 94 / Argentina 3", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 3\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-66],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",3500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"22183\"]]");
    p = add_epsg_def_ex (filter, first, last, 22184, "epsg", 22184,
        "POSGAR 94 / Argentina 4", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 4\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",4500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"22184\"]]");
    p = add_epsg_def_ex (filter, first, last, 22185, "epsg", 22185,
        "POSGAR 94 / Argentina 5", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 5\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-60],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",5500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"22185\"]]");
    p = add_epsg_def_ex (filter, first, last, 22186, "epsg", 22186,
        "POSGAR 94 / Argentina 6", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 6\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",6500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"22186\"]]");
    p = add_epsg_def_ex (filter, first, last, 22187, "epsg", 22187,
        "POSGAR 94 / Argentina 7", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 7\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6694");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4694\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-9");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-54],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",7500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"22187\"]]");
    p = add_epsg_def_ex (filter, first, last, 22191, "epsg", 22191,
        "Campo Inchauspe / Argentina 1", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 1\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-72],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",1500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"22191\"]]");
    p = add_epsg_def_ex (filter, first, last, 22192, "epsg", 22192,
        "Campo Inchauspe / Argentina 2", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 2\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",2500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"22192\"]]");
    p = add_epsg_def_ex (filter, first, last, 22193, "epsg", 22193,
        "Campo Inchauspe / Argentina 3", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 3\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4221\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-66],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2219");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 22194, "epsg", 22194,
        "Campo Inchauspe / Argentina 4", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 4\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",4500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"22194\"]]");
    p = add_epsg_def_ex (filter, first, last, 22195, "epsg", 22195,
        "Campo Inchauspe / Argentina 5", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 5\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-60],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",5500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"22195\"]]");
    p = add_epsg_def_ex (filter, first, last, 22196, "epsg", 22196,
        "Campo Inchauspe / Argentina 6", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 6\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",6500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"22196\"]]");
    p = add_epsg_def_ex (filter, first, last, 22197, "epsg", 22197,
        "Campo Inchauspe / Argentina 7", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 7\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-90]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-54],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",7500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"22197\"]]");
    p = add_epsg_def_ex (filter, first, last, 22234, "epsg", 22234,
        "Cape / UTM zone 34S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 34S\",GEOGCS[\"Cape\",DATUM[\"C");
    add_srs_wkt (p, 1,
        "ape\",SPHEROID[\"Clarke 1880 (Arc)\",6378249.145,293.466");
    add_srs_wkt (p, 2,
        "3077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6222\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22234\"]]");
    p = add_epsg_def_ex (filter, first, last, 22235, "epsg", 22235,
        "Cape / UTM zone 35S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 35S\",GEOGCS[\"Cape\",DATUM[\"C");
    add_srs_wkt (p, 1,
        "ape\",SPHEROID[\"Clarke 1880 (Arc)\",6378249.145,293.466");
    add_srs_wkt (p, 2,
        "3077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6222\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22235\"]]");
    p = add_epsg_def_ex (filter, first, last, 22236, "epsg", 22236,
        "Cape / UTM zone 36S (deprecated)", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 36S (deprecated)\",GEOGCS[\"Cap");
    add_srs_wkt (p, 1,
        "e\",DATUM[\"Cape\",SPHEROID[\"Clarke 1880 (Arc)\",637824");
    add_srs_wkt (p, 2,
        "9.145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4222\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",33],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"222");
    add_srs_wkt (p, 12,
        "36\"]]");
    p = add_epsg_def_ex (filter, first, last, 22275, "epsg", 22275,
        "Cape / Lo15", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo15\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",15],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22275\"]]");
    p = add_epsg_def_ex (filter, first, last, 22277, "epsg", 22277,
        "Cape / Lo17", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo17\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",17],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22277\"]]");
    p = add_epsg_def_ex (filter, first, last, 22279, "epsg", 22279,
        "Cape / Lo19", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo19\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",19],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22279\"]]");
    p = add_epsg_def_ex (filter, first, last, 22281, "epsg", 22281,
        "Cape / Lo21", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo21\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",21],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22281\"]]");
    p = add_epsg_def_ex (filter, first, last, 22283, "epsg", 22283,
        "Cape / Lo23", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo23\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",23],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22283\"]]");
    p = add_epsg_def_ex (filter, first, last, 22285, "epsg", 22285,
        "Cape / Lo25", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo25\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",25],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22285\"]]");
    p = add_epsg_def_ex (filter, first, last, 22287, "epsg", 22287,
        "Cape / Lo27", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo27\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",27],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22287\"]]");
    p = add_epsg_def_ex (filter, first, last, 22289, "epsg", 22289,
        "Cape / Lo29", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo29\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",29],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22289\"]]");
    p = add_epsg_def_ex (filter, first, last, 22291, "epsg", 22291,
        "Cape / Lo31", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo31\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",31],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22291\"]]");
    p = add_epsg_def_ex (filter, first, last, 22293, "epsg", 22293,
        "Cape / Lo33", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo33\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],TOWGS84[-136,-108,-292,0,0,0,");
    add_srs_wkt (p, 3,
        "0],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4222\"]],PROJECTION[\"Transverse_Mercator_South_Orien");
    add_srs_wkt (p, 7,
        "tated\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",33],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Westing\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22293\"]]");
    p = add_epsg_def_ex (filter, first, last, 22332, "epsg", 22332,
        "Carthage / UTM zone 32N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Carthage", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-263");
    add_proj4text (p, 1,
        ",6,431,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / UTM zone 32N\",GEOGCS[\"Carthage\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249");
    add_srs_wkt (p, 2,
        ".2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-260.1,5.5,432.2,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",9],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"22332\"]]");
    p = add_epsg_def_ex (filter, first, last, 22391, "epsg", 22391,
        "Carthage / Nord Tunisie", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Carthage", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=9.9 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 2,
        "84=-263,6,431,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / Nord Tunisie\",GEOGCS[\"Carthage\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249");
    add_srs_wkt (p, 2,
        ".2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-260.1,5.5,432.2,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",36],PARAMETER[\"central_meridian\",9.9],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.999625544],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",300000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22391\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 22392, "epsg", 22392,
        "Carthage / Sud Tunisie", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Carthage", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=9.9 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +t");
    add_proj4text (p, 2,
        "owgs84=-263,6,431,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / Sud Tunisie\",GEOGCS[\"Carthage\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.");
    add_srs_wkt (p, 2,
        "2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-263,6,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6223\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4223\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",33.3");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",9.9],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999625769],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",300000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22392\"]]");
    p = add_epsg_def_ex (filter, first, last, 22521, "epsg", 22521,
        "Corrego Alegre 1970-72 / UTM zone 21S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1970_72", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-205.57,1");
    add_proj4text (p, 1,
        "68.77,-4.12,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 21S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-205.57,168.77,-4.12,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4225\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"22521\"]]");
    p = add_epsg_def_ex (filter, first, last, 22522, "epsg", 22522,
        "Corrego Alegre 1970-72 / UTM zone 22S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1970_72", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-205.57,1");
    add_proj4text (p, 1,
        "68.77,-4.12,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 22S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-205.57,168.77,-4.12,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4225\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"22522\"]]");
    p = add_epsg_def_ex (filter, first, last, 22523, "epsg", 22523,
        "Corrego Alegre 1970-72 / UTM zone 23S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1970_72", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +towgs84=-205.57,1");
    add_proj4text (p, 1,
        "68.77,-4.12,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 23S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-205.57,168.77,-4.12,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4225\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"22523\"]]");
    p = add_epsg_def_ex (filter, first, last, 22524, "epsg", 22524,
        "Corrego Alegre 1970-72 / UTM zone 24S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1970_72", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=intl +towgs84=-205.57,1");
    add_proj4text (p, 1,
        "68.77,-4.12,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 24S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-205.57,168.77,-4.12,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4225\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"22524\"]]");
    p = add_epsg_def_ex (filter, first, last, 22525, "epsg", 22525,
        "Corrego Alegre 1970-72 / UTM zone 25S", 0, 0,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1970_72", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=intl +towgs84=-205.57,1");
    add_proj4text (p, 1,
        "68.77,-4.12,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Corrego Alegre 1970-72 / UTM zone 25S\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre_1970_7");
    add_srs_wkt (p, 2,
        "2\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7022\"]],TOWGS84[-205.57,168.77,-4.12,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6225\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4225\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"22525\"]]");
    p = add_epsg_def_ex (filter, first, last, 22700, "epsg", 22700,
        "Deir ez Zor / Levant Zone", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Deir_ez_Zor", "Lambert_Conic_Near-Conformal", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.");
    add_proj4text (p, 1,
        "9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Levant Zone\",GEOGCS[\"Deir ez Zo");
    add_srs_wkt (p, 1,
        "r\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 1880 (IGN)\"");
    add_srs_wkt (p, 2,
        ",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6227\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4227\"]],PROJECTION[\"Lambert_Conic_Near-Conformal\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"Latitude of natural origin\",34.65],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"Longitude of natural origin\",37.35],PARAMETER[\"Sc");
    add_srs_wkt (p, 9,
        "ale factor at natural origin\",0.9996256],PARAMETER[\"Fa");
    add_srs_wkt (p, 10,
        "lse easting\",300000],PARAMETER[\"False northing\",30000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"22700\"]]");
    p = add_epsg_def_ex (filter, first, last, 22770, "epsg", 22770,
        "Deir ez Zor / Syria Lambert", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Deir_ez_Zor", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.");
    add_proj4text (p, 1,
        "9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 ");
    add_proj4text (p, 2,
        "+towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Syria Lambert\",GEOGCS[\"Deir ez ");
    add_srs_wkt (p, 1,
        "Zor\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 1880 (IGN)");
    add_srs_wkt (p, 2,
        "\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6227\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4227\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",34.65],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",37.35],PARAMETER[\"scale_factor\",0.99962");
    add_srs_wkt (p, 9,
        "56],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"22770\"]]");
    p = add_epsg_def_ex (filter, first, last, 22780, "epsg", 22780,
        "Deir ez Zor / Levant Stereographic", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Deir_ez_Zor", "Oblique_Stereographic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=34.2 +lon_0=39.15 +k=0.9995341 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-190.421,8.532");
    add_proj4text (p, 2,
        ",238.69,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Deir ez Zor / Levant Stereographic\",GEOGCS[\"D");
    add_srs_wkt (p, 1,
        "eir ez Zor\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 2,
        "0 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7011\"]],AUTHORITY[\"EPSG\",\"6227\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4227\"]],PROJECTION[\"Oblique_Stereographic\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",34.2],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",39.15],PARAMETER[\"scale_factor\",0.9995");
    add_srs_wkt (p, 9,
        "341],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"22780\"]]");
    p = add_epsg_def_ex (filter, first, last, 22832, "epsg", 22832,
        "Douala 1948 / AOF west (deprecated)", 0, 0,
        "International 1924", "Greenwich",
        "Douala_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Douala 1948 / AOF west (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Douala 1948\",DATUM[\"Douala_1948\",SPHEROID[\"Internati");
    add_srs_wkt (p, 2,
        "onal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[-206.1,-174.7,-87.7,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6192\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4192\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",10.5],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.999],PARAMETER[\"false_easting\",1000000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2214\"]]");
    p = add_epsg_def_ex (filter, first, last, 22991, "epsg", 22991,
        "Egypt 1907 / Blue Belt", 0, 0,
        "Helmert 1906", "Greenwich",
        "Egypt_1907", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=35 +k=1 +x_0=300000 +y_0=11");
    add_proj4text (p, 1,
        "00000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Blue Belt\",GEOGCS[\"Egypt 1907\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,2");
    add_srs_wkt (p, 2,
        "98.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6229\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4229\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",30],PARAMETER[\"central_meridian\",35],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",1],PARAMETER[\"false_easting\",300000],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_northing\",1100000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 10,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"22991\"]]");
    p = add_epsg_def_ex (filter, first, last, 22992, "epsg", 22992,
        "Egypt 1907 / Red Belt", 0, 0,
        "Helmert 1906", "Greenwich",
        "Egypt_1907", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=81");
    add_proj4text (p, 1,
        "0000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Red Belt\",GEOGCS[\"Egypt 1907\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,29");
    add_srs_wkt (p, 2,
        "8.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "229\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4229\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "30],PARAMETER[\"central_meridian\",31],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",1],PARAMETER[\"false_easting\",615000],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_northing\",810000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"22992\"]]");
    p = add_epsg_def_ex (filter, first, last, 22993, "epsg", 22993,
        "Egypt 1907 / Purple Belt", 0, 0,
        "Helmert 1906", "Greenwich",
        "Egypt_1907", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=20");
    add_proj4text (p, 1,
        "0000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Purple Belt\",GEOGCS[\"Egypt 1907\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\",6378200,");
    add_srs_wkt (p, 2,
        "298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6229\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4229\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",30],PARAMETER[\"central_meridian\",27],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",1],PARAMETER[\"false_easting\",700000],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_northing\",200000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"22993\"]]");
    p = add_epsg_def_ex (filter, first, last, 22994, "epsg", 22994,
        "Egypt 1907 / Extended Purple Belt", 0, 0,
        "Helmert 1906", "Greenwich",
        "Egypt_1907", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=12");
    add_proj4text (p, 1,
        "00000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Egypt 1907 / Extended Purple Belt\",GEOGCS[\"Eg");
    add_srs_wkt (p, 1,
        "ypt 1907\",DATUM[\"Egypt_1907\",SPHEROID[\"Helmert 1906\"");
    add_srs_wkt (p, 2,
        ",6378200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6229\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4229\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",30],PARAMETER[\"central_meridian\",27],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",7000");
    add_srs_wkt (p, 9,
        "00],PARAMETER[\"false_northing\",1200000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22994\"]]");
    p = add_epsg_def_ex (filter, first, last, 23028, "epsg", 23028,
        "ED50 / UTM zone 28N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 28N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-89.5,-93");
    add_srs_wkt (p, 3,
        ".8,-123.1,0,0,-0.156,1.2],AUTHORITY[\"EPSG\",\"6230\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-15],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23028\"]]");
    p = add_epsg_def_ex (filter, first, last, 23029, "epsg", 23029,
        "ED50 / UTM zone 29N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 29N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",-9],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23029\"]]");
    p = add_epsg_def_ex (filter, first, last, 23030, "epsg", 23030,
        "ED50 / UTM zone 30N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 30N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",-3],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23030\"]]");
    p = add_epsg_def_ex (filter, first, last, 23031, "epsg", 23031,
        "ED50 / UTM zone 31N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 31N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",3],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"23031\"]]");
    p = add_epsg_def_ex (filter, first, last, 23032, "epsg", 23032,
        "ED50 / UTM zone 32N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 32N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"23032\"]]");
    p = add_epsg_def_ex (filter, first, last, 23033, "epsg", 23033,
        "ED50 / UTM zone 33N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 33N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23033\"]]");
    p = add_epsg_def_ex (filter, first, last, 23034, "epsg", 23034,
        "ED50 / UTM zone 34N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 34N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23034\"]]");
    p = add_epsg_def_ex (filter, first, last, 23035, "epsg", 23035,
        "ED50 / UTM zone 35N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 35N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23035\"]]");
    p = add_epsg_def_ex (filter, first, last, 23036, "epsg", 23036,
        "ED50 / UTM zone 36N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 36N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",33],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23036\"]]");
    p = add_epsg_def_ex (filter, first, last, 23037, "epsg", 23037,
        "ED50 / UTM zone 37N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 37N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 11,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"23037\"]]");
    p = add_epsg_def_ex (filter, first, last, 23038, "epsg", 23038,
        "ED50 / UTM zone 38N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=intl +towgs84=-87,-98,-121,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / UTM zone 38N\",GEOGCS[\"ED50\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Datum_1950\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-84.1,-10");
    add_srs_wkt (p, 3,
        "1.8,-129.7,0,0,0.468,1.05],AUTHORITY[\"EPSG\",\"6230\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",45],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"23038\"]]");
    p = add_epsg_def_ex (filter, first, last, 23090, "epsg", 23090,
        "ED50 / TM 0 N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 0 N\",GEOGCS[\"ED50\",DATUM[\"Europea");
    add_srs_wkt (p, 1,
        "n_Datum_1950\",SPHEROID[\"International 1924\",6378388,2");
    add_srs_wkt (p, 2,
        "97,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-89.5,-93.8,-12");
    add_srs_wkt (p, 3,
        "3.1,0,0,-0.156,1.2],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",0],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"23090\"]]");
    p = add_epsg_def_ex (filter, first, last, 23095, "epsg", 23095,
        "ED50 / TM 5 NE", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=5 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM 5 NE\",GEOGCS[\"ED50\",DATUM[\"Europe");
    add_srs_wkt (p, 1,
        "an_Datum_1950\",SPHEROID[\"International 1924\",6378388,");
    add_srs_wkt (p, 2,
        "297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-89.5,-93.8,-1");
    add_srs_wkt (p, 3,
        "23.1,0,0,-0.156,1.2],AUTHORITY[\"EPSG\",\"6230\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23095\"]]");
    p = add_epsg_def_ex (filter, first, last, 23239, "epsg", 23239,
        "Fahud / UTM zone 39N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Fahud", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=clrk80 +towgs84=-333.102,-11.0");
    add_proj4text (p, 1,
        "2,230.69,0,0,0.554,0.219 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fahud / UTM zone 39N\",GEOGCS[\"Fahud\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Fahud\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-345,3,223,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6232\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4232\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"23239\"]]");
    p = add_epsg_def_ex (filter, first, last, 23240, "epsg", 23240,
        "Fahud / UTM zone 40N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Fahud", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=clrk80 +towgs84=-333.102,-11.0");
    add_proj4text (p, 1,
        "2,230.69,0,0,0.554,0.219 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fahud / UTM zone 40N\",GEOGCS[\"Fahud\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Fahud\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.4");
    add_srs_wkt (p, 2,
        "65,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-345,3,223,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6232\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4232\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"23240\"]]");
    p = add_epsg_def_ex (filter, first, last, 23433, "epsg", 23433,
        "Garoua / UTM zone 33N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Garoua", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Garoua / UTM zone 33N\",GEOGCS[\"Garoua\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Garoua\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,2");
    add_srs_wkt (p, 2,
        "93.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6197\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4197\"]],PROJECTIO");
    add_srs_wkt (p, 6,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
        "n\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2312\"]]");
    p = add_epsg_def_ex (filter, first, last, 23700, "epsg", 23700,
        "HD72 / EOV", 0, 0,
        "GRS 1967", "Greenwich",
        "Hungarian_Datum_1972", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=47.14439372222222 +lon_0=19.04857177");
    add_proj4text (p, 1,
        "777778 +k_0=0.99993 +x_0=650000 +y_0=200000 +ellps=GRS67");
    add_proj4text (p, 2,
        " +towgs84=52.17,-71.82,-14.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"HD72 / EOV\",GEOGCS[\"HD72\",DATUM[\"Hungarian_");
    add_srs_wkt (p, 1,
        "Datum_1972\",SPHEROID[\"GRS 1967\",6378160,298.247167427");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7036\"]],TOWGS84[52.684,-71.194,-1");
    add_srs_wkt (p, 3,
        "3.975,-0.312,-0.1063,-0.3729,1.0191],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6237\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4237\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Hotine_Oblique_Mercator_Azimuth_Center\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"latitude_of_center\",47.1443937222222],PARAMETER[\"lon");
    add_srs_wkt (p, 9,
        "gitude_of_center\",19.0485717777778],PARAMETER[\"azimuth");
    add_srs_wkt (p, 10,
        "\",90],PARAMETER[\"rectified_grid_angle\",90],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"scale_factor\",0.99993],PARAMETER[\"false_easting\",65");
    add_srs_wkt (p, 12,
        "0000],PARAMETER[\"false_northing\",200000],UNIT[\"metre\"");
    add_srs_wkt (p, 13,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"23700\"]]");
    p = add_epsg_def_ex (filter, first, last, 23830, "epsg", 23830,
        "DGN95 / Indonesia TM-3 zone 46.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=94.5 +k=0.9999 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 46.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",94.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999],PARAMETER[\"false_easting\",200000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23830\"]]");
    p = add_epsg_def_ex (filter, first, last, 23831, "epsg", 23831,
        "DGN95 / Indonesia TM-3 zone 47.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=97.5 +k=0.9999 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 47.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",97.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.9999],PARAMETER[\"false_easting\",200000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"23831\"]]");
    p = add_epsg_def_ex (filter, first, last, 23832, "epsg", 23832,
        "DGN95 / Indonesia TM-3 zone 47.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=100.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 47.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",100.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23832\"]]");
    p = add_epsg_def_ex (filter, first, last, 23833, "epsg", 23833,
        "DGN95 / Indonesia TM-3 zone 48.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=103.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 48.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",103.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23833\"]]");
    p = add_epsg_def_ex (filter, first, last, 23834, "epsg", 23834,
        "DGN95 / Indonesia TM-3 zone 48.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 48.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",106.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23834\"]]");
    p = add_epsg_def_ex (filter, first, last, 23835, "epsg", 23835,
        "DGN95 / Indonesia TM-3 zone 49.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=109.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 49.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",109.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23835\"]]");
    p = add_epsg_def_ex (filter, first, last, 23836, "epsg", 23836,
        "DGN95 / Indonesia TM-3 zone 49.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=112.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 49.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",112.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23836\"]]");
    p = add_epsg_def_ex (filter, first, last, 23837, "epsg", 23837,
        "DGN95 / Indonesia TM-3 zone 50.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 50.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",115.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23837\"]]");
    p = add_epsg_def_ex (filter, first, last, 23838, "epsg", 23838,
        "DGN95 / Indonesia TM-3 zone 50.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=118.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 50.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",118.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23838\"]]");
    p = add_epsg_def_ex (filter, first, last, 23839, "epsg", 23839,
        "DGN95 / Indonesia TM-3 zone 51.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 51.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",121.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23839\"]]");
    p = add_epsg_def_ex (filter, first, last, 23840, "epsg", 23840,
        "DGN95 / Indonesia TM-3 zone 51.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=124.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 51.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",124.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23840\"]]");
    p = add_epsg_def_ex (filter, first, last, 23841, "epsg", 23841,
        "DGN95 / Indonesia TM-3 zone 52.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=127.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 52.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",127.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23841\"]]");
    p = add_epsg_def_ex (filter, first, last, 23842, "epsg", 23842,
        "DGN95 / Indonesia TM-3 zone 52.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=130.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 52.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",130.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23842\"]]");
    p = add_epsg_def_ex (filter, first, last, 23843, "epsg", 23843,
        "DGN95 / Indonesia TM-3 zone 53.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=133.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",133.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23843\"]]");
    p = add_epsg_def_ex (filter, first, last, 23844, "epsg", 23844,
        "DGN95 / Indonesia TM-3 zone 53.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=136.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",136.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23844\"]]");
    p = add_epsg_def_ex (filter, first, last, 23845, "epsg", 23845,
        "DGN95 / Indonesia TM-3 zone 54.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=139.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 54.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",139.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",1500000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"23845\"]]");
    p = add_epsg_def_ex (filter, first, last, 23846, "epsg", 23846,
        "ID74 / UTM zone 46N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 13,
        "46\"]]");
    p = add_epsg_def_ex (filter, first, last, 23847, "epsg", 23847,
        "ID74 / UTM zone 47N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"238");
    add_srs_wkt (p, 13,
        "47\"]]");
    p = add_epsg_def_ex (filter, first, last, 23848, "epsg", 23848,
        "ID74 / UTM zone 48N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "05],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "3848\"]]");
    p = add_epsg_def_ex (filter, first, last, 23849, "epsg", 23849,
        "ID74 / UTM zone 49N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "3849\"]]");
    p = add_epsg_def_ex (filter, first, last, 23850, "epsg", 23850,
        "ID74 / UTM zone 50N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "17],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "3850\"]]");
    p = add_epsg_def_ex (filter, first, last, 23851, "epsg", 23851,
        "ID74 / UTM zone 51N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "23],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "3851\"]]");
    p = add_epsg_def_ex (filter, first, last, 23852, "epsg", 23852,
        "ID74 / UTM zone 52N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-1.977,-13.06,-9.993,0.364,0.254,0.689,-1.037],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "238\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "29],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "3852\"]]");
    p = add_epsg_def_ex (filter, first, last, 23853, "epsg", 23853,
        "ID74 / UTM zone 53N (deprecated)", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53N (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],TOWGS84[-1.977,-13.06,-9.993,0.364,0.254,0.6");
    add_srs_wkt (p, 4,
        "89,-1.037],AUTHORITY[\"EPSG\",\"6238\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",135],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"23853\"]]");
    p = add_epsg_def_ex (filter, first, last, 23866, "epsg", 23866,
        "DGN95 / UTM zone 46N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 46N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",93],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23866\"]]");
    p = add_epsg_def_ex (filter, first, last, 23867, "epsg", 23867,
        "DGN95 / UTM zone 47N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"23867\"]]");
    p = add_epsg_def_ex (filter, first, last, 23868, "epsg", 23868,
        "DGN95 / UTM zone 48N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23868\"]]");
    p = add_epsg_def_ex (filter, first, last, 23869, "epsg", 23869,
        "DGN95 / UTM zone 49N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23869\"]]");
    p = add_epsg_def_ex (filter, first, last, 23870, "epsg", 23870,
        "DGN95 / UTM zone 50N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23870\"]]");
    p = add_epsg_def_ex (filter, first, last, 23871, "epsg", 23871,
        "DGN95 / UTM zone 51N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23871\"]]");
    p = add_epsg_def_ex (filter, first, last, 23872, "epsg", 23872,
        "DGN95 / UTM zone 52N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"23872\"]]");
    p = add_epsg_def_ex (filter, first, last, 23877, "epsg", 23877,
        "DGN95 / UTM zone 47S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"23877\"]]");
    p = add_epsg_def_ex (filter, first, last, 23878, "epsg", 23878,
        "DGN95 / UTM zone 48S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23878\"]]");
    p = add_epsg_def_ex (filter, first, last, 23879, "epsg", 23879,
        "DGN95 / UTM zone 49S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23879\"]]");
    p = add_epsg_def_ex (filter, first, last, 23880, "epsg", 23880,
        "DGN95 / UTM zone 50S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23880\"]]");
    p = add_epsg_def_ex (filter, first, last, 23881, "epsg", 23881,
        "DGN95 / UTM zone 51S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23881\"]]");
    p = add_epsg_def_ex (filter, first, last, 23882, "epsg", 23882,
        "DGN95 / UTM zone 52S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23882\"]]");
    p = add_epsg_def_ex (filter, first, last, 23883, "epsg", 23883,
        "DGN95 / UTM zone 53S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 53S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",135],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23883\"]]");
    p = add_epsg_def_ex (filter, first, last, 23884, "epsg", 23884,
        "DGN95 / UTM zone 54S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 54S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",141],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"23884\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

