/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_29 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 5833, "epsg", 5833,
        "DB_REF / 3-degree Gauss-Kruger zone 3 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF / 3-degree Gauss-Kruger zone 3 (E-N) +");
    add_srs_wkt (p, 1,
        " DHHN92 height\",PROJCS[\"DB_REF / 3-degree Gauss-Kruger");
    add_srs_wkt (p, 2,
        " zone 3 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_");
    add_srs_wkt (p, 3,
        "Reference_System\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 4,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5681\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",3500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"5683\"]],VERT_CS[\"DH");
    add_srs_wkt (p, 14,
        "HN92 height\",VERT_DATUM[\"Deutsches Haupthoehennetz 199");
    add_srs_wkt (p, 15,
        "2\",2005,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",1,");
    add_srs_wkt (p, 16,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related hei");
    add_srs_wkt (p, 17,
        "ght\",UP],AUTHORITY[\"EPSG\",\"5783\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 18,
        "\",\"5833\"]]");
    p = add_epsg_def_ex (filter, first, last, 5834, "epsg", 5834,
        "DB_REF / 3-degree Gauss-Kruger zone 4 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF / 3-degree Gauss-Kruger zone 4 (E-N) +");
    add_srs_wkt (p, 1,
        " DHHN92 height\",PROJCS[\"DB_REF / 3-degree Gauss-Kruger");
    add_srs_wkt (p, 2,
        " zone 4 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_");
    add_srs_wkt (p, 3,
        "Reference_System\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 4,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5681\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",12],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",4500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"5684\"]],VERT_CS[\"");
    add_srs_wkt (p, 14,
        "DHHN92 height\",VERT_DATUM[\"Deutsches Haupthoehennetz 1");
    add_srs_wkt (p, 15,
        "992\",2005,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",");
    add_srs_wkt (p, 16,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related h");
    add_srs_wkt (p, 17,
        "eight\",UP],AUTHORITY[\"EPSG\",\"5783\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 18,
        "SG\",\"5834\"]]");
    p = add_epsg_def_ex (filter, first, last, 5835, "epsg", 5835,
        "DB_REF / 3-degree Gauss-Kruger zone 5 (E-N)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsche_Bahn_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"DB_REF / 3-degree Gauss-Kruger zone 5 (E-N) +");
    add_srs_wkt (p, 1,
        " DHHN92 height\",PROJCS[\"DB_REF / 3-degree Gauss-Kruger");
    add_srs_wkt (p, 2,
        " zone 5 (E-N)\",GEOGCS[\"DB_REF\",DATUM[\"Deutsche_Bahn_");
    add_srs_wkt (p, 3,
        "Reference_System\",SPHEROID[\"Bessel 1841\",6377397.155,");
    add_srs_wkt (p, 4,
        "299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 5,
        "SG\",\"1081\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5681\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",15],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",5500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"5685\"]],VERT_CS[\"");
    add_srs_wkt (p, 14,
        "DHHN92 height\",VERT_DATUM[\"Deutsches Haupthoehennetz 1");
    add_srs_wkt (p, 15,
        "992\",2005,AUTHORITY[\"EPSG\",\"5181\"]],UNIT[\"metre\",");
    add_srs_wkt (p, 16,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related h");
    add_srs_wkt (p, 17,
        "eight\",UP],AUTHORITY[\"EPSG\",\"5783\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 18,
        "SG\",\"5835\"]]");
    p = add_epsg_def_ex (filter, first, last, 5836, "epsg", 5836,
        "Yemen NGN96 / UTM zone 37N", 0, 0,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yemen NGN96 / UTM zone 37N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
        "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6163\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4163\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",39],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5836\"]]");
    p = add_epsg_def_ex (filter, first, last, 5837, "epsg", 5837,
        "Yemen NGN96 / UTM zone 40N", 0, 0,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yemen NGN96 / UTM zone 40N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
        "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6163\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4163\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",57],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5837\"]]");
    p = add_epsg_def_ex (filter, first, last, 5839, "epsg", 5839,
        "Peru96 / UTM zone 17S", 0, 0,
        "GRS 1980", "Greenwich",
        "Peru96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 17S\",GEOGCS[\"Peru96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"53");
    add_srs_wkt (p, 6,
        "73\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5839\"]]");
    p = add_epsg_def_ex (filter, first, last, 5842, "epsg", 5842,
        "WGS 84 / TM 12 SE", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 12 SE\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",12],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 8,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11,
        "\",NORTH],AUTHORITY[\"EPSG\",\"5842\"]]");
    p = add_epsg_def_ex (filter, first, last, 5844, "epsg", 5844,
        "RGRDC 2005 / Congo TM zone 30", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_RDC_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGRDC 2005 / Congo TM zone 30\",GEOGCS[\"RGRDC ");
    add_srs_wkt (p, 1,
        "2005\",DATUM[\"Reseau_Geodesique_de_la_RDC_2005\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1033\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4046\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",30],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5844\"]]");
    p = add_epsg_def_ex (filter, first, last, 5845, "epsg", 5845,
        "SWEREF99 TM", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 TM + RH2000 height\",PROJCS[\"SWEREF");
    add_srs_wkt (p, 1,
        "99 TM\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"661");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"3006\"]],VERT_CS[\"RH2000");
    add_srs_wkt (p, 13,
        " height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 16,
        "THORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"5845\"]");
    add_srs_wkt (p, 17,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5846, "epsg", 5846,
        "SWEREF99 12 00", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=150000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 12 00 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 12 00\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",12],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",150000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"3007\"]],VERT_CS[\"RH20");
    add_srs_wkt (p, 13,
        "00 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],");
    add_srs_wkt (p, 16,
        "AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"5846\"");
    add_srs_wkt (p, 17,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5847, "epsg", 5847,
        "SWEREF99 13 30", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=150000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 13 30 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 13 30\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",13.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",150000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"3008\"]],VERT_CS[\"RH2");
    add_srs_wkt (p, 13,
        "000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP]");
    add_srs_wkt (p, 16,
        ",AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"5847");
    add_srs_wkt (p, 17,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 5848, "epsg", 5848,
        "SWEREF99 15 00", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=150000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 15 00 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 15 00\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",150000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"3009\"]],VERT_CS[\"RH20");
    add_srs_wkt (p, 13,
        "00 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],");
    add_srs_wkt (p, 16,
        "AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"5848\"");
    add_srs_wkt (p, 17,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5849, "epsg", 5849,
        "SWEREF99 16 30", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=150000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 16 30 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 16 30\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",16.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",150000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"3010\"]],VERT_CS[\"RH2");
    add_srs_wkt (p, 13,
        "000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP]");
    add_srs_wkt (p, 16,
        ",AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"5849");
    add_srs_wkt (p, 17,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 5850, "epsg", 5850,
        "SWEREF99 18 00", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=150000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 18 00 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 18 00\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",18],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",150000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"3011\"]],VERT_CS[\"RH20");
    add_srs_wkt (p, 13,
        "00 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",2005,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],");
    add_srs_wkt (p, 16,
        "AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"5850\"");
    add_srs_wkt (p, 17,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5851, "epsg", 5851,
        "SWEREF99 14 15", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14.25 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 14 15 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 14 15\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",14.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",150000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3012\"]],VERT_CS[\"R");
    add_srs_wkt (p, 13,
        "H2000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 17,
        "51\"]]");
    p = add_epsg_def_ex (filter, first, last, 5852, "epsg", 5852,
        "SWEREF99 15 45", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.75 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 15 45 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 15 45\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",15.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",150000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3013\"]],VERT_CS[\"R");
    add_srs_wkt (p, 13,
        "H2000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 17,
        "52\"]]");
    p = add_epsg_def_ex (filter, first, last, 5853, "epsg", 5853,
        "SWEREF99 17 15", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17.25 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 17 15 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 17 15\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",17.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",150000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3014\"]],VERT_CS[\"R");
    add_srs_wkt (p, 13,
        "H2000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 17,
        "53\"]]");
    p = add_epsg_def_ex (filter, first, last, 5854, "epsg", 5854,
        "SWEREF99 18 45", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.75 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 18 45 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 18 45\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",18.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",150000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3015\"]],VERT_CS[\"R");
    add_srs_wkt (p, 13,
        "H2000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 17,
        "54\"]]");
    p = add_epsg_def_ex (filter, first, last, 5855, "epsg", 5855,
        "SWEREF99 20 15", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20.25 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 20 15 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 20 15\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",20.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",150000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3016\"]],VERT_CS[\"R");
    add_srs_wkt (p, 13,
        "H2000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 17,
        "55\"]]");
    p = add_epsg_def_ex (filter, first, last, 5856, "epsg", 5856,
        "SWEREF99 21 45", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21.75 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 21 45 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 21 45\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",21.75],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",150000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3017\"]],VERT_CS[\"R");
    add_srs_wkt (p, 13,
        "H2000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 17,
        "56\"]]");
    p = add_epsg_def_ex (filter, first, last, 5857, "epsg", 5857,
        "SWEREF99 23 15", 0, 0,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23.25 +k=1 +x_0=150000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SWEREF99 23 15 + RH2000 height\",PROJCS[\"SWE");
    add_srs_wkt (p, 1,
        "REF99 23 15\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",23.25],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",150000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3018\"]],VERT_CS[\"R");
    add_srs_wkt (p, 13,
        "H2000 height\",VERT_DATUM[\"Rikets hojdsystem 2000\",200");
    add_srs_wkt (p, 14,
        "5,AUTHORITY[\"EPSG\",\"5208\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 16,
        "P],AUTHORITY[\"EPSG\",\"5613\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 17,
        "57\"]]");
    p = add_epsg_def_ex (filter, first, last, 5858, "epsg", 5858,
        "SAD69(96) / UTM zone 22S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 22S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5858\"]]");
    p = add_epsg_def_ex (filter, first, last, 5875, "epsg", 5875,
        "SAD69(96) / UTM zone 18S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 18S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5875\"]]");
    p = add_epsg_def_ex (filter, first, last, 5876, "epsg", 5876,
        "SAD69(96) / UTM zone 19S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 19S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5876\"]]");
    p = add_epsg_def_ex (filter, first, last, 5877, "epsg", 5877,
        "SAD69(96) / UTM zone 20S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 20S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5877\"]]");
    p = add_epsg_def_ex (filter, first, last, 5879, "epsg", 5879,
        "Cadastre 1997 / UTM zone 38S", 0, 0,
        "International 1924", "Greenwich",
        "Cadastre_1997", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=intl +towgs84=-381.788,");
    add_proj4text (p, 1,
        "-57.501,-256.673,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cadastre 1997 / UTM zone 38S\",GEOGCS[\"Cadastr");
    add_srs_wkt (p, 1,
        "e 1997\",DATUM[\"Cadastre_1997\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-381.788,-57.501,-256.673,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1037\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4475\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",45],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5879\"]]");
    p = add_epsg_def_ex (filter, first, last, 5880, "epsg", 5880,
        "SIRGAS 2000 / Brazil Polyconic", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Polyconic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / Brazil Polyconic\",GEOGCS[\"SIRGA");
    add_srs_wkt (p, 1,
        "S 2000\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_");
    add_srs_wkt (p, 2,
        "las_AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4674\"]],PROJECTION[\"Polyconic\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-54]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",5000000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"5880\"]]");
    p = add_epsg_def_ex (filter, first, last, 5885, "epsg", 5885,
        "TGD2005", 1, 1,
        "GRS 1980", "Greenwich",
        "Tonga_Geodetic_Datum_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"TGD2005\",DATUM[\"Tonga Geodetic Datum 2005\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[");
    add_srs_wkt (p, 2,
        "\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree");
    add_srs_wkt (p, 3,
        "\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodeti");
    add_srs_wkt (p, 4,
        "c latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433]],AXIS[\"geodetic longitude (Lon)\",ea");
    add_srs_wkt (p, 6,
        "st,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 7,
        "IS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"m");
    add_srs_wkt (p, 8,
        "etre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Tonga\"],BBOX");
    add_srs_wkt (p, 9,
        "[-25.68,-179.08,-14.14,-171.28]],ID[\"EPSG\",5885]]");
    p = add_epsg_def_ex (filter, first, last, 5886, "epsg", 5886,
        "TGD2005", 1, 1,
        "GRS 1980", "Greenwich",
        "Tonga_Geodetic_Datum_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TGD2005\",DATUM[\"Tonga_Geodetic_Datum_2005\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1095\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"5886\"]]");
    p = add_epsg_def_ex (filter, first, last, 5887, "epsg", 5887,
        "TGD2005 / Tonga Map Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Tonga_Geodetic_Datum_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=1500000 ");
    add_proj4text (p, 1,
        "+y_0=5000000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TGD2005 / Tonga Map Grid\",GEOGCS[\"TGD2005\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Tonga_Geodetic_Datum_2005\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1095\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"58");
    add_srs_wkt (p, 6,
        "86\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",1500000],PARAMETER[\"false_northing\",5000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5887\"]]");
    p = add_epsg_def_ex (filter, first, last, 5890, "epsg", 5890,
        "JAXA Snow Depth Polar Stereographic North", 0, 0,
        "Hughes 1980", "Greenwich",
        "Not_specified_based_on_Hughes_1980_ellipsoid", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=70 +lon_0=90 +k=1 +x_0=0 +");
    add_proj4text (p, 1,
        "y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAXA Snow Depth Polar Stereographic North\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Unspecified datum based upon the Hughes 1980 ellip");
    add_srs_wkt (p, 2,
        "soid\",DATUM[\"Not_specified_based_on_Hughes_1980_ellips");
    add_srs_wkt (p, 3,
        "oid\",SPHEROID[\"Hughes 1980\",6378273,298.279411123064,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"7058\"]],AUTHORITY[\"EPSG\",\"6054\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AUTHORITY[\"EPSG\",\"4054\"]],PROJECTION[\"Pola");
    add_srs_wkt (p, 8,
        "r_Stereographic\"],PARAMETER[\"latitude_of_origin\",70],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",90],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",SOUTH]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",SOUTH],AUTHORITY[\"EPSG\",\"5890\"]]");
    p = add_epsg_def_ex (filter, first, last, 5896, "epsg", 5896,
        "VN-2000 / TM-3 zone 481", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 481\",GEOGCS[\"VN-2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.257");
    add_srs_wkt (p, 2,
        "223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-191.904414");
    add_srs_wkt (p, 3,
        "29,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.0");
    add_srs_wkt (p, 4,
        "0427372,0.252906278],AUTHORITY[\"EPSG\",\"6756\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",102],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"5896\"]]");
    p = add_epsg_def_ex (filter, first, last, 5897, "epsg", 5897,
        "VN-2000 / TM-3 zone 482", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 482\",GEOGCS[\"VN-2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.257");
    add_srs_wkt (p, 2,
        "223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-191.904414");
    add_srs_wkt (p, 3,
        "29,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.0");
    add_srs_wkt (p, 4,
        "0427372,0.252906278],AUTHORITY[\"EPSG\",\"6756\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",105],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"5897\"]]");
    p = add_epsg_def_ex (filter, first, last, 5898, "epsg", 5898,
        "VN-2000 / TM-3 zone 491", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279,-1");
    add_proj4text (p, 2,
        "11.45032835,0.00928836,-0.01975479,0.00427372,0.25290627");
    add_proj4text (p, 3,
        "8 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 zone 491\",GEOGCS[\"VN-2000\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.257");
    add_srs_wkt (p, 2,
        "223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-191.904414");
    add_srs_wkt (p, 3,
        "29,-39.30318279,-111.45032835,0.00928836,-0.01975479,0.0");
    add_srs_wkt (p, 4,
        "0427372,0.252906278],AUTHORITY[\"EPSG\",\"6756\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",108],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"5898\"]]");
    p = add_epsg_def_ex (filter, first, last, 5899, "epsg", 5899,
        "VN-2000 / TM-3 Da Nang zone", 0, 0,
        "WGS 84", "Greenwich",
        "Vietnam_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=107.75 +k=0.9999 +x_0=500000");
    add_proj4text (p, 1,
        " +y_0=0 +ellps=WGS84 +towgs84=-191.90441429,-39.30318279");
    add_proj4text (p, 2,
        ",-111.45032835,0.00928836,-0.01975479,0.00427372,0.25290");
    add_proj4text (p, 3,
        "6278 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"VN-2000 / TM-3 Da Nang zone\",GEOGCS[\"VN-2000\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Vietnam_2000\",SPHEROID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 2,
        "257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-191.904");
    add_srs_wkt (p, 3,
        "41429,-39.30318279,-111.45032835,0.00928836,-0.01975479,");
    add_srs_wkt (p, 4,
        "0.00427372,0.252906278],AUTHORITY[\"EPSG\",\"6756\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4756\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",107.75],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",0.9999],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"5899\"]]");
    p = add_epsg_def_ex (filter, first, last, 5921, "epsg", 5921,
        "WGS 84 / EPSG Arctic Regional zone A1", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",81.317226],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-111],PARAMETER[\"standard_parallel_1\",85],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_2\",77],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5921\"]]");
    p = add_epsg_def_ex (filter, first, last, 5922, "epsg", 5922,
        "WGS 84 / EPSG Arctic Regional zone A2", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",81.317226],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-39],PARAMETER[\"standard_parallel_1\",85],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",77],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5922\"]]");
    p = add_epsg_def_ex (filter, first, last, 5923, "epsg", 5923,
        "WGS 84 / EPSG Arctic Regional zone A3", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",81.317226],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",33],PARAMETER[\"standard_parallel_1\",85],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_2\",77],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5923\"]]");
    p = add_epsg_def_ex (filter, first, last, 5924, "epsg", 5924,
        "WGS 84 / EPSG Arctic Regional zone A4", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",81.317226],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",105],PARAMETER[\"standard_parallel_1\",85],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",77],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5924\"]]");
    p = add_epsg_def_ex (filter, first, last, 5925, "epsg", 5925,
        "WGS 84 / EPSG Arctic Regional zone A5", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone A5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",81.317226],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",177],PARAMETER[\"standard_parallel_1\",85],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",77],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5925\"]]");
    p = add_epsg_def_ex (filter, first, last, 5926, "epsg", 5926,
        "WGS 84 / EPSG Arctic Regional zone B1", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",73.1557408611111],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-111],PARAMETER[\"standard_parallel_1\",77");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_2\",69],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5926\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5927, "epsg", 5927,
        "WGS 84 / EPSG Arctic Regional zone B2", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",73.1557408611111],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-39],PARAMETER[\"standard_parallel_1\",77]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",69],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5927\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5928, "epsg", 5928,
        "WGS 84 / EPSG Arctic Regional zone B3", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",73.1557408611111],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",33],PARAMETER[\"standard_parallel_1\",77],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_2\",69],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5928\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5929, "epsg", 5929,
        "WGS 84 / EPSG Arctic Regional zone B4", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",73.1557408611111],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",105],PARAMETER[\"standard_parallel_1\",77]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",69],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5929\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5930, "epsg", 5930,
        "WGS 84 / EPSG Arctic Regional zone B5", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone B5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",73.1557408611111],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",177],PARAMETER[\"standard_parallel_1\",77]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",69],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5930\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5931, "epsg", 5931,
        "WGS 84 / EPSG Arctic Regional zone C1", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C1\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",65.1012708888889],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-111],PARAMETER[\"standard_parallel_1\",69");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_2\",61],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5931\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5932, "epsg", 5932,
        "WGS 84 / EPSG Arctic Regional zone C2", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C2\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",65.1012708888889],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-39],PARAMETER[\"standard_parallel_1\",69]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",61],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5932\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5933, "epsg", 5933,
        "WGS 84 / EPSG Arctic Regional zone C3", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C3\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",65.1012708888889],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",33],PARAMETER[\"standard_parallel_1\",69],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_2\",61],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5933\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5934, "epsg", 5934,
        "WGS 84 / EPSG Arctic Regional zone C4", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C4\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",65.1012708888889],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",105],PARAMETER[\"standard_parallel_1\",69]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",61],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5934\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5935, "epsg", 5935,
        "WGS 84 / EPSG Arctic Regional zone C5", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +");
    add_proj4text (p, 1,
        "lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Arctic Regional zone C5\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",65.1012708888889],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",177],PARAMETER[\"standard_parallel_1\",69]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",61],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5935\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5936, "epsg", 5936,
        "WGS 84 / EPSG Alaska Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-150 +k=0.994 +x");
    add_proj4text (p, 1,
        "_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Alaska Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",90],PARAMETER[\"central_meridian\",-150]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",2000000],PARAMETER[\"false_northing\",2000000],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5936\"]]");
    p = add_epsg_def_ex (filter, first, last, 5937, "epsg", 5937,
        "WGS 84 / EPSG Canada Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-100 +k=0.994 +x");
    add_proj4text (p, 1,
        "_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Canada Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",90],PARAMETER[\"central_meridian\",-100]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",2000000],PARAMETER[\"false_northing\",2000000],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5937\"]]");
    p = add_epsg_def_ex (filter, first, last, 5938, "epsg", 5938,
        "WGS 84 / EPSG Greenland Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-33 +k=0.994 +x_");
    add_proj4text (p, 1,
        "0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Greenland Polar Stereographic\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",");
    add_srs_wkt (p, 2,
        "6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"432");
    add_srs_wkt (p, 6,
        "6\"]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",90],PARAMETER[\"central_meridian\",-3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",2000000],PARAMETER[\"false_northing\",2000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5938\"]]");
    p = add_epsg_def_ex (filter, first, last, 5939, "epsg", 5939,
        "WGS 84 / EPSG Norway Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=18 +k=0.994 +x_0");
    add_proj4text (p, 1,
        "=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Norway Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",90],PARAMETER[\"central_meridian\",18],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",2000000],PARAMETER[\"false_northing\",2000000],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "5939\"]]");
    p = add_epsg_def_ex (filter, first, last, 5940, "epsg", 5940,
        "WGS 84 / EPSG Russia Polar Stereographic", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Polar_Stereographic", "metre",
        "Easting", "South", "Northing", "South");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=90 +lat_ts=90 +lon_0=105 +k=0.994 +x_");
    add_proj4text (p, 1,
        "0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / EPSG Russia Polar Stereographic\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Polar_Stereographic\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",90],PARAMETER[\"central_meridian\",105],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.994],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",2000000],PARAMETER[\"false_northing\",2000000],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",SOUTH],AXIS[\"Northing\",SOUTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"5940\"]]");
    p = add_epsg_def_ex (filter, first, last, 5942, "epsg", 5942,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + NN2000 height\",GEOGCS[\"ETRS89\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"European_Terrestrial_Reference_System_1989\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 8,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 9,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5942\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5945, "epsg", 5945,
        "ETRS89 / NTM zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=5.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 5 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 5\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",5.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"5105\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5945\"]]");
    p = add_epsg_def_ex (filter, first, last, 5946, "epsg", 5946,
        "ETRS89 / NTM zone 6", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 6 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 6\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",6.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"5106\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5946\"]]");
    p = add_epsg_def_ex (filter, first, last, 5947, "epsg", 5947,
        "ETRS89 / NTM zone 7", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=7.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 7 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 7\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",7.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"5107\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5947\"]]");
    p = add_epsg_def_ex (filter, first, last, 5948, "epsg", 5948,
        "ETRS89 / NTM zone 8", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=8.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 8 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 8\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",8.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"5108\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5948\"]]");
    p = add_epsg_def_ex (filter, first, last, 5949, "epsg", 5949,
        "ETRS89 / NTM zone 9", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=9.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vun");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 9 + NN2000 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"ETRS89 / NTM zone 9\",GEOGCS[\"ETRS89\",DATUM[\"Europe");
    add_srs_wkt (p, 2,
        "an_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",9.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"5109\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5949\"]]");
    p = add_epsg_def_ex (filter, first, last, 5950, "epsg", 5950,
        "ETRS89 / NTM zone 10", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 10 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 10\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",10.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5110\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5950\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5951, "epsg", 5951,
        "ETRS89 / NTM zone 11", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=11.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 11 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 11\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",11.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5111\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5951\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5952, "epsg", 5952,
        "ETRS89 / NTM zone 12", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=12.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 12 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 12\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",12.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5112\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5952\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5953, "epsg", 5953,
        "ETRS89 / NTM zone 13", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=13.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 13 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 13\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",13.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5113\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5953\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5954, "epsg", 5954,
        "ETRS89 / NTM zone 14", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 14 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 14\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",14.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5114\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5954\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5955, "epsg", 5955,
        "ETRS89 / NTM zone 15", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=15.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 15 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 15\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",15.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5115\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5955\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5956, "epsg", 5956,
        "ETRS89 / NTM zone 16", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=16.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 16 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 16\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",16.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5116\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5956\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5957, "epsg", 5957,
        "ETRS89 / NTM zone 17", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=17.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 17 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 17\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",17.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5117\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5957\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5958, "epsg", 5958,
        "ETRS89 / NTM zone 18", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 18 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 18\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",18.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5118\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5958\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5959, "epsg", 5959,
        "ETRS89 / NTM zone 19", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=19.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 19 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 19\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",19.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5119\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5959\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5960, "epsg", 5960,
        "ETRS89 / NTM zone 20", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=20.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 20 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 20\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",20.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5120\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5960\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5961, "epsg", 5961,
        "ETRS89 / NTM zone 21", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=21.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 21 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 21\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",21.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5121\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5961\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5962, "epsg", 5962,
        "ETRS89 / NTM zone 22", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=22.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 22 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 22\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",22.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5122\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5962\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5963, "epsg", 5963,
        "ETRS89 / NTM zone 23", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=23.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 23 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 23\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",23.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5123\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5963\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5964, "epsg", 5964,
        "ETRS89 / NTM zone 24", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=24.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 24 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 24\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",24.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5124\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5964\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5965, "epsg", 5965,
        "ETRS89 / NTM zone 25", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=25.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 25 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 25\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",25.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5125\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5965\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5966, "epsg", 5966,
        "ETRS89 / NTM zone 26", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=26.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 26 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 26\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",26.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5126\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5966\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5967, "epsg", 5967,
        "ETRS89 / NTM zone 27", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=27.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 27 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 27\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",27.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5127\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5967\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5968, "epsg", 5968,
        "ETRS89 / NTM zone 28", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=28.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 28 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 28\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",28.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5128\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5968\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5969, "epsg", 5969,
        "ETRS89 / NTM zone 29", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=29.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 29 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 29\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",29.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5129\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5969\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5970, "epsg", 5970,
        "ETRS89 / NTM zone 30", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=30.5 +k=1 +x_0=100000 +y_0=");
    add_proj4text (p, 1,
        "1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vu");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / NTM zone 30 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / NTM zone 30\",GEOGCS[\"ETRS89\",DATUM[\"Euro");
    add_srs_wkt (p, 2,
        "pean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",30.5],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"5130\"]],VERT_CS[\"NN2000 ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 16,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 17,
        "THORITY[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5970\"]");
    add_srs_wkt (p, 18,
        "]");
    p = add_epsg_def_ex (filter, first, last, 5971, "epsg", 5971,
        "ETRS89 / UTM zone 31N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 31 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 31N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",3],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"25831\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5971\"]]");
    p = add_epsg_def_ex (filter, first, last, 5972, "epsg", 5972,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 32 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",9],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"25832\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5972\"]]");
    p = add_epsg_def_ex (filter, first, last, 5973, "epsg", 5973,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 33 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",15],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"25833\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5973\"]]");
    p = add_epsg_def_ex (filter, first, last, 5974, "epsg", 5974,
        "ETRS89 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 34 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 34N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",21],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"25834\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5974\"]]");
    p = add_epsg_def_ex (filter, first, last, 5975, "epsg", 5975,
        "ETRS89 / UTM zone 35N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 35 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 35N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",27],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"25835\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5975\"]]");
    p = add_epsg_def_ex (filter, first, last, 5976, "epsg", 5976,
        "ETRS89 / UTM zone 36N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 36 + NN2000 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 36N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",33],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"25836\"]],VERT_CS[\"NN2000 heigh");
    add_srs_wkt (p, 14,
        "t\",VERT_DATUM[\"Norway Normal Null 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 15,
        "Y[\"EPSG\",\"1096\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 16,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 17,
        "Y[\"EPSG\",\"5941\"]],AUTHORITY[\"EPSG\",\"5976\"]]");
    p = add_epsg_def_ex (filter, first, last, 6050, "epsg", 6050,
        "GR96 / EPSG Arctic zone 1-25", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.4");
    add_proj4text (p, 1,
        "3711833333333 +lon_0=-30 +x_0=25500000 +y_0=1500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 1-25\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4747\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",85.4371183333333],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-30],PARAMETER[\"standard_parallel_1\",87],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_2\",83.6666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",25500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6050\"]]");
    p = add_epsg_def_ex (filter, first, last, 6051, "epsg", 6051,
        "GR96 / EPSG Arctic zone 2-18", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-52 +x_0=18500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 2-18\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",82.058424888888");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"central_meridian\",-52],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",83.6666666666667],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",80.3333333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",18500000],PARAMETER[\"false_northing\",2500000],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "051\"]]");
    p = add_epsg_def_ex (filter, first, last, 6052, "epsg", 6052,
        "GR96 / EPSG Arctic zone 2-20", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=82.05842488888888 +lon_0=-12 +x_0=20500000 +y");
    add_proj4text (p, 2,
        "_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 2-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",82.058424888888");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"central_meridian\",-12],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",83.6666666666667],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",80.3333333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",20500000],PARAMETER[\"false_northing\",2500000],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "052\"]]");
    p = add_epsg_def_ex (filter, first, last, 6053, "epsg", 6053,
        "GR96 / EPSG Arctic zone 3-29", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-69 +x_0=29500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-29\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",78.707337527777");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",-69],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",80.3333333333333],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",77],PARAMETER[\"false_easting\",29500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",3500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6053\"]]");
    p = add_epsg_def_ex (filter, first, last, 6054, "epsg", 6054,
        "GR96 / EPSG Arctic zone 3-31", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-39 +x_0=31500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-31\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",78.707337527777");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",-39],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",80.3333333333333],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",77],PARAMETER[\"false_easting\",31500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",3500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6054\"]]");
    p = add_epsg_def_ex (filter, first, last, 6055, "epsg", 6055,
        "GR96 / EPSG Arctic zone 3-33", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.7");
    add_proj4text (p, 1,
        "0733752777778 +lon_0=-10 +x_0=33500000 +y_0=3500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 3-33\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",78.707337527777");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",-10],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",80.3333333333333],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",77],PARAMETER[\"false_easting\",33500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",3500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6055\"]]");
    p = add_epsg_def_ex (filter, first, last, 6056, "epsg", 6056,
        "GR96 / EPSG Arctic zone 4-20", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-64 +x_0=20500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-20\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4747\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",75.3644033055556],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-64],PARAMETER[\"standard_parallel_1\",77],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_2\",73.6666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",20500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6056\"]]");
    p = add_epsg_def_ex (filter, first, last, 6057, "epsg", 6057,
        "GR96 / EPSG Arctic zone 4-22", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-39 +x_0=22500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-22\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",75.364403305555");
    add_srs_wkt (p, 8,
        "6],PARAMETER[\"central_meridian\",-39],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",77],PARAMETER[\"standard_parallel_2\",7");
    add_srs_wkt (p, 10,
        "3.6666666666667],PARAMETER[\"false_easting\",22500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",4500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6057\"]]");
    p = add_epsg_def_ex (filter, first, last, 6058, "epsg", 6058,
        "GR96 / EPSG Arctic zone 4-24", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.3");
    add_proj4text (p, 1,
        "6440330555556 +lon_0=-14 +x_0=24500000 +y_0=4500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 4-24\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",75.364403305555");
    add_srs_wkt (p, 8,
        "6],PARAMETER[\"central_meridian\",-14],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",77],PARAMETER[\"standard_parallel_2\",7");
    add_srs_wkt (p, 10,
        "3.6666666666667],PARAMETER[\"false_easting\",24500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",4500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6058\"]]");
    p = add_epsg_def_ex (filter, first, last, 6059, "epsg", 6059,
        "GR96 / EPSG Arctic zone 5-41", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-62 +x_0=41500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-41\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",72.025009194444");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-62],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",73.6666666666667],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",70.3333333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",41500000],PARAMETER[\"false_northing\",5500000],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "059\"]]");
    p = add_epsg_def_ex (filter, first, last, 6060, "epsg", 6060,
        "GR96 / EPSG Arctic zone 5-43", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-42 +x_0=43500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-43\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",72.025009194444");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-42],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",73.6666666666667],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",70.3333333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",43500000],PARAMETER[\"false_northing\",5500000],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "060\"]]");
    p = add_epsg_def_ex (filter, first, last, 6061, "epsg", 6061,
        "GR96 / EPSG Arctic zone 5-45", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=72.02500919444445 +lon_0=-22 +x_0=45500000 +y");
    add_proj4text (p, 2,
        "_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 5-45\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",72.025009194444");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-22],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",73.6666666666667],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",70.3333333333333],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",45500000],PARAMETER[\"false_northing\",5500000],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "061\"]]");
    p = add_epsg_def_ex (filter, first, last, 6062, "epsg", 6062,
        "GR96 / EPSG Arctic zone 6-26", 0, 0,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.6");
    add_proj4text (p, 1,
        "8747555555557 +lon_0=-56 +x_0=26500000 +y_0=6500000 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / EPSG Arctic zone 6-26\",GEOGCS[\"GR96\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Greenland_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4747\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"latitude_of_origin\",68.687475555555");
    add_srs_wkt (p, 8,
        "6],PARAMETER[\"central_meridian\",-56],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",70.3333333333333],PARAMETER[\"standard_");
    add_srs_wkt (p, 10,
        "parallel_2\",67],PARAMETER[\"false_easting\",26500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",6500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6062\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

