/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_27 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 5295, "epsg", 5295,
        "DRUKREF 03 / Gasa TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.03333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Gasa TM\",GEOGCS[\"DRUKREF 03\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",90.0333333333333],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1],PARAMETER[\"false_easting\",250000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",-2500000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5295\"]]");
    p = add_epsg_def_ex (filter, first, last, 5296, "epsg", 5296,
        "DRUKREF 03 / Ha TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.15000000000001 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Ha TM\",GEOGCS[\"DRUKREF 03\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",90.15],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",1],PARAMETER[\"false_easting\",250000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"5296\"]]");
    p = add_epsg_def_ex (filter, first, last, 5297, "epsg", 5297,
        "DRUKREF 03 / Lhuentse TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=91.13333333333334 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Lhuentse TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",91.1333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5297\"]]");
    p = add_epsg_def_ex (filter, first, last, 5298, "epsg", 5298,
        "DRUKREF 03 / Mongar TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=91.23333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Mongar TM\",GEOGCS[\"DRUKREF 03\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",91.2333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5298\"]]");
    p = add_epsg_def_ex (filter, first, last, 5299, "epsg", 5299,
        "DRUKREF 03 / Paro TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=89.34999999999999 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Paro TM\",GEOGCS[\"DRUKREF 03\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",89.35],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",1],PARAMETER[\"false_easting\",250000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"5299\"]]");
    p = add_epsg_def_ex (filter, first, last, 5300, "epsg", 5300,
        "DRUKREF 03 / Pemagatshel TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=91.34999999999999 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Pemagatshel TM\",GEOGCS[\"DRUKREF ");
    add_srs_wkt (p, 1,
        "03\",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",91.35],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",250000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5300\"]]");
    p = add_epsg_def_ex (filter, first, last, 5301, "epsg", 5301,
        "DRUKREF 03 / Punakha TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=89.84999999999999 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Punakha TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",89.85],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",250000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"5301\"]]");
    p = add_epsg_def_ex (filter, first, last, 5302, "epsg", 5302,
        "DRUKREF 03 / Samdrup Jongkhar TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=91.56666666666666 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Samdrup Jongkhar TM\",GEOGCS[\"DRU");
    add_srs_wkt (p, 1,
        "KREF 03\",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1058\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",91.5666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "50000],PARAMETER[\"false_northing\",-2500000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5302\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5303, "epsg", 5303,
        "DRUKREF 03 / Samtse TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=89.06666666666666 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Samtse TM\",GEOGCS[\"DRUKREF 03\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",89.0666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5303\"]]");
    p = add_epsg_def_ex (filter, first, last, 5304, "epsg", 5304,
        "DRUKREF 03 / Sarpang TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.26666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Sarpang TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",90.2666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5304\"]]");
    p = add_epsg_def_ex (filter, first, last, 5305, "epsg", 5305,
        "DRUKREF 03 / Thimphu TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=89.55 +k=1 +x_0=250000 +y_0=");
    add_proj4text (p, 1,
        "-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Thimphu TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",89.55],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",250000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"5305\"]]");
    p = add_epsg_def_ex (filter, first, last, 5306, "epsg", 5306,
        "DRUKREF 03 / Trashigang TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=91.75 +k=1 +x_0=250000 +y_0=");
    add_proj4text (p, 1,
        "-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Trashigang TM\",GEOGCS[\"DRUKREF 0");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",91.75],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",250000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5306\"]]");
    p = add_epsg_def_ex (filter, first, last, 5307, "epsg", 5307,
        "DRUKREF 03 / Trongsa TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.5 +k=1 +x_0=250000 +y_0=-");
    add_proj4text (p, 1,
        "2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Trongsa TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",90.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",1],PARAMETER[\"false_easting\",250000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",-2500000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"5307\"]]");
    p = add_epsg_def_ex (filter, first, last, 5308, "epsg", 5308,
        "DRUKREF 03 / Tsirang TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.16666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Tsirang TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",90.1666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5308\"]]");
    p = add_epsg_def_ex (filter, first, last, 5309, "epsg", 5309,
        "DRUKREF 03 / Wangdue Phodrang TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.11666666666666 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Wangdue Phodrang TM\",GEOGCS[\"DRU");
    add_srs_wkt (p, 1,
        "KREF 03\",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1058\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",90.1166666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "50000],PARAMETER[\"false_northing\",-2500000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5309\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5310, "epsg", 5310,
        "DRUKREF 03 / Yangtse TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=91.56666666666666 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Yangtse TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",91.5666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5310\"]]");
    p = add_epsg_def_ex (filter, first, last, 5311, "epsg", 5311,
        "DRUKREF 03 / Zhemgang TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Bhutan_National_Geodetic_Datum", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90.86666666666666 +k=1 +x_0=");
    add_proj4text (p, 1,
        "250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DRUKREF 03 / Zhemgang TM\",GEOGCS[\"DRUKREF 03\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1058\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5264\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",90.8666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",-2500000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5311\"]]");
    p = add_epsg_def_ex (filter, first, last, 5316, "epsg", 5316,
        "ETRS89 / Faroe TM", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-7 +k=0.999997 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=-6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Faroe TM\",GEOGCS[\"ETRS89\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Terrestrial_Reference_System_1989\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-7],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.999997],PARAMETER[\"false_easting\",200000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",-6000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"5316\"]]");
    p = add_epsg_def_ex (filter, first, last, 5318, "epsg", 5318,
        "ETRS89 / Faroe TM", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-7 +k=0.999997 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=-6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Faroe TM + FVR09 height\",PROJCS[\"E");
    add_srs_wkt (p, 1,
        "TRS89 / Faroe TM\",GEOGCS[\"ETRS89\",DATUM[\"European_Te");
    add_srs_wkt (p, 2,
        "rrestrial_Reference_System_1989\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 3,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 4,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[");
    add_srs_wkt (p, 5,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 6,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-7],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 10,
        "97],PARAMETER[\"false_easting\",200000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",-6000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"5316\"]],VERT_CS[\"FVR09 heig");
    add_srs_wkt (p, 14,
        "ht\",VERT_DATUM[\"Faroe Islands Vertical Reference 2009\"");
    add_srs_wkt (p, 15,
        ",2005,AUTHORITY[\"EPSG\",\"1059\"]],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 16,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height");
    add_srs_wkt (p, 17,
        "\",UP],AUTHORITY[\"EPSG\",\"5317\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 18,
        "\"5318\"]]");
    p = add_epsg_def_ex (filter, first, last, 5320, "epsg", 5320,
        "NAD83 / Teranet Ontario Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.5 +lat_2=54.5 +lat_0=0 +lon_0=-84 +x");
    add_proj4text (p, 1,
        "_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Teranet Ontario Lambert\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-84],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",44.5],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",54.5],PARAMETER[\"false_easting\",1000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"5320\"]]");
    p = add_epsg_def_ex (filter, first, last, 5321, "epsg", 5321,
        "NAD83(CSRS) / Teranet Ontario Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.5 +lat_2=54.5 +lat_0=0 +lon_0=-84 +x");
    add_proj4text (p, 1,
        "_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Teranet Ontario Lambert\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_origin\",0],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",-84],PARAMETER[\"standard_parallel_1\",44.5],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_2\",54.5],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",1000000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5321\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5323, "epsg", 5323,
        "ISN2004", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2004", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"ISN2004\",DATUM[\"Islands N");
    add_srs_wkt (p, 1,
        "et 2004\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,L");
    add_srs_wkt (p, 2,
        "ENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNI");
    add_srs_wkt (p, 3,
        "T[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS");
    add_srs_wkt (p, 4,
        "[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433]],AXIS[\"geodetic longitude ");
    add_srs_wkt (p, 6,
        "(Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 7,
        "99433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENG");
    add_srs_wkt (p, 8,
        "THUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Ice");
    add_srs_wkt (p, 9,
        "land\"],BBOX[59.96,-30.87,69.59,-5.55]],ID[\"EPSG\",5323");
    add_srs_wkt (p, 10,
        "]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic ");
    add_srs_wkt (p, 11,
        "System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 12,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 13,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],AX");
    add_srs_wkt (p, 14,
        "IS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01");
    add_srs_wkt (p, 15,
        "74532925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 16,
        "NIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],");
    add_srs_wkt (p, 17,
        "ABRIDGEDTRANSFORMATION[\"ISN2004 to WGS 84 (1)\",METHOD[");
    add_srs_wkt (p, 18,
        "\"Geocentric translations (geog2D domain)\",ID[\"EPSG\",");
    add_srs_wkt (p, 19,
        "9603]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",86");
    add_srs_wkt (p, 20,
        "05]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606");
    add_srs_wkt (p, 21,
        "]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]]");
    add_srs_wkt (p, 22,
        ",USAGE[SCOPE[\"unknown\"],AREA[\"Iceland\"],BBOX[59.96,-");
    add_srs_wkt (p, 23,
        "30.87,69.59,-5.55]],ID[\"EPSG\",5327]]]");
    p = add_epsg_def_ex (filter, first, last, 5324, "epsg", 5324,
        "ISN2004", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2004", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ISN2004\",DATUM[\"Islands_Net_2004\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1060\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"5324\"]]");
    p = add_epsg_def_ex (filter, first, last, 5325, "epsg", 5325,
        "ISN2004 / Lambert 2004", 0, 0,
        "GRS 1980", "Greenwich",
        "Islands_Net_2004", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=64.25 +lat_2=65.75 +lat_0=65 +lon_0=-19");
    add_proj4text (p, 1,
        " +x_0=1700000 +y_0=300000 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2004 / Lambert 2004\",GEOGCS[\"ISN2004\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Islands_Net_2004\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"1060\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"5324\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"latitude_of_origin\",65],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-19],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",64.25],PARAMETER[\"standard_parallel_2\",65.75],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",1700000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"5325\"]]");
    p = add_epsg_def_ex (filter, first, last, 5329, "epsg", 5329,
        "Segara (Jakarta) / NEIEZ", 0, 0,
        "Bessel 1841", "Jakarta",
        "Gunung_Segara_Jakarta", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=390000");
    add_proj4text (p, 1,
        "0 +y_0=900000 +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 2,
        " +pm=jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Segara (Jakarta) / NEIEZ\",GEOGCS[\"Segara (Jak");
    add_srs_wkt (p, 1,
        "arta)\",DATUM[\"Gunung_Segara_Jakarta\",SPHEROID[\"Besse");
    add_srs_wkt (p, 2,
        "l 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "04\"]],TOWGS84[-403,684,41,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6820\"]],PRIMEM[\"Jakarta\",106.807719444444,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8908\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4820\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Mercator_1SP\"],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",3.19228055555556],PARAMETER[\"scale_factor\",0.997]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",3900000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",900000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5329\"]]");
    p = add_epsg_def_ex (filter, first, last, 5330, "epsg", 5330,
        "Batavia (Jakarta) / NEIEZ", 0, 0,
        "Bessel 1841", "Jakarta",
        "Batavia_Jakarta", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=390000");
    add_proj4text (p, 1,
        "0 +y_0=900000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,");
    add_proj4text (p, 2,
        "0 +pm=jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia (Jakarta) / NEIEZ\",GEOGCS[\"Batavia (J");
    add_srs_wkt (p, 1,
        "akarta)\",DATUM[\"Batavia_Jakarta\",SPHEROID[\"Bessel 18");
    add_srs_wkt (p, 2,
        "41\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6813\"]],PRIMEM[\"Jakarta\",106.");
    add_srs_wkt (p, 4,
        "807719444444,AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4813\"]],PROJECTION[\"Mercator_1SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"central_meridian\",3.19228055555556],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.997],PARAMETER[\"false_easting\",39");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",900000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5330\"]]");
    p = add_epsg_def_ex (filter, first, last, 5331, "epsg", 5331,
        "Makassar (Jakarta) / NEIEZ", 0, 0,
        "Bessel 1841", "Jakarta",
        "Makassar_Jakarta", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=390000");
    add_proj4text (p, 1,
        "0 +y_0=900000 +ellps=bessel +towgs84=-587.8,519.75,145.7");
    add_proj4text (p, 2,
        "6,0,0,0,0 +pm=jakarta +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Makassar (Jakarta) / NEIEZ\",GEOGCS[\"Makassar ");
    add_srs_wkt (p, 1,
        "(Jakarta)\",DATUM[\"Makassar_Jakarta\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 2,
        " 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[-587.8,519.75,145.76,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6804\"]],PRIMEM[\"Jakarta\",106.807719444444,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8908\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4804\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",3.19228055555556],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.997],PARAMETER[\"false_easting\",3900000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",900000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"5331\"]]");
    p = add_epsg_def_ex (filter, first, last, 5337, "epsg", 5337,
        "Aratu / UTM zone 25S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 25S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6208\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4208\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",-33],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5337\"]]");
    p = add_epsg_def_ex (filter, first, last, 5340, "epsg", 5340,
        "POSGAR 2007", 1, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"POSGAR 2007\",DATUM[\"Posiciones_Geodesicas_Arg");
    add_srs_wkt (p, 1,
        "entinas_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"1062\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 6,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5340\"");
    add_srs_wkt (p, 7,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5342, "epsg", 5342,
        "POSGAR 2007", 1, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"POSGAR 2007\",DATUM[\"Posic");
    add_srs_wkt (p, 1,
        "iones Geodesicas Argentinas 2007\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 3,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 4,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 5,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 6,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 7,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 8,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 9,
        "[\"unknown\"],AREA[\"Argentina\"],BBOX[-58.41,-73.59,-21");
    add_srs_wkt (p, 10,
        ".78,-52.63]],ID[\"EPSG\",5342]]],TARGETCRS[GEOGCRS[\"WGS");
    add_srs_wkt (p, 11,
        " 84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"W");
    add_srs_wkt (p, 12,
        "GS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],");
    add_srs_wkt (p, 13,
        "PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 14,
        "199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER");
    add_srs_wkt (p, 15,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"lon");
    add_srs_wkt (p, 16,
        "gitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 17,
        "199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"PO");
    add_srs_wkt (p, 18,
        "SGAR 2007 to WGS 84 (1)\",METHOD[\"Geocentric translatio");
    add_srs_wkt (p, 19,
        "ns (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-ax");
    add_srs_wkt (p, 20,
        "is translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis");
    add_srs_wkt (p, 21,
        " translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis t");
    add_srs_wkt (p, 22,
        "ranslation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 23,
        "],AREA[\"Argentina\"],BBOX[-58.41,-73.59,-21.78,-52.63]]");
    add_srs_wkt (p, 24,
        ",ID[\"EPSG\",5351]]]");
    p = add_epsg_def_ex (filter, first, last, 5343, "epsg", 5343,
        "POSGAR 2007 / Argentina 1", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 1\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-72],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",1500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"5343\"]]");
    p = add_epsg_def_ex (filter, first, last, 5344, "epsg", 5344,
        "POSGAR 2007 / Argentina 2", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 2\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-69],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",2500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"5344\"]]");
    p = add_epsg_def_ex (filter, first, last, 5345, "epsg", 5345,
        "POSGAR 2007 / Argentina 3", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 3\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-66],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",3500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"5345\"]]");
    p = add_epsg_def_ex (filter, first, last, 5346, "epsg", 5346,
        "POSGAR 2007 / Argentina 4", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 4\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-63],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",4500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"5346\"]]");
    p = add_epsg_def_ex (filter, first, last, 5347, "epsg", 5347,
        "POSGAR 2007 / Argentina 5", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 5\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-60],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",5500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"5347\"]]");
    p = add_epsg_def_ex (filter, first, last, 5348, "epsg", 5348,
        "POSGAR 2007 / Argentina 6", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 6\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-57],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",6500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"5348\"]]");
    p = add_epsg_def_ex (filter, first, last, 5349, "epsg", 5349,
        "POSGAR 2007 / Argentina 7", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / Argentina 7\",GEOGCS[\"POSGAR 200");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1062\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5340\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-90],PARAMETER[\"central_meridian\",-54],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",7500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"5349\"]]");
    p = add_epsg_def_ex (filter, first, last, 5353, "epsg", 5353,
        "MARGEN", 1, 1,
        "GRS 1980", "Greenwich",
        "Marco_Geodesico_Nacional_de_Bolivia", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"MARGEN\",DATUM[\"Marco Geod");
    add_srs_wkt (p, 1,
        "esico Nacional de Bolivia\",ELLIPSOID[\"GRS 1980\",63781");
    add_srs_wkt (p, 2,
        "37,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gree");
    add_srs_wkt (p, 3,
        "nwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[e");
    add_srs_wkt (p, 4,
        "llipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORD");
    add_srs_wkt (p, 5,
        "ER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"g");
    add_srs_wkt (p, 6,
        "eodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 7,
        "ee\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\"");
    add_srs_wkt (p, 8,
        ",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 9,
        "own\"],AREA[\"Bolivia\"],BBOX[-22.91,-69.66,-9.67,-57.52");
    add_srs_wkt (p, 10,
        "]],ID[\"EPSG\",5353]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATU");
    add_srs_wkt (p, 11,
        "M[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\",63");
    add_srs_wkt (p, 12,
        "78137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"G");
    add_srs_wkt (p, 13,
        "reenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],C");
    add_srs_wkt (p, 14,
        "S[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEU");
    add_srs_wkt (p, 15,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"longitude\",e");
    add_srs_wkt (p, 16,
        "ast,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],I");
    add_srs_wkt (p, 17,
        "D[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"MARGEN to WG");
    add_srs_wkt (p, 18,
        "S 84 (1)\",METHOD[\"Geocentric translations (geog2D doma");
    add_srs_wkt (p, 19,
        "in)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translation\"");
    add_srs_wkt (p, 20,
        ",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",0");
    add_srs_wkt (p, 21,
        ",ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0,I");
    add_srs_wkt (p, 22,
        "D[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Bolivi");
    add_srs_wkt (p, 23,
        "a\"],BBOX[-22.91,-69.66,-9.67,-57.52]],ID[\"EPSG\",5374]");
    add_srs_wkt (p, 24,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5354, "epsg", 5354,
        "MARGEN", 1, 1,
        "GRS 1980", "Greenwich",
        "Marco_Geodesico_Nacional_de_Bolivia", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MARGEN\",DATUM[\"Marco_Geodesico_Nacional_de_Bo");
    add_srs_wkt (p, 1,
        "livia\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"1063\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5354\"]]");
    p = add_epsg_def_ex (filter, first, last, 5355, "epsg", 5355,
        "MARGEN / UTM zone 20S", 0, 0,
        "GRS 1980", "Greenwich",
        "Marco_Geodesico_Nacional_de_Bolivia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MARGEN / UTM zone 20S\",GEOGCS[\"MARGEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Marco_Geodesico_Nacional_de_Bolivia\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1063\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5354\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-63],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5355\"]]");
    p = add_epsg_def_ex (filter, first, last, 5356, "epsg", 5356,
        "MARGEN / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Marco_Geodesico_Nacional_de_Bolivia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MARGEN / UTM zone 19S\",GEOGCS[\"MARGEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Marco_Geodesico_Nacional_de_Bolivia\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1063\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5354\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-69],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5356\"]]");
    p = add_epsg_def_ex (filter, first, last, 5357, "epsg", 5357,
        "MARGEN / UTM zone 21S", 0, 0,
        "GRS 1980", "Greenwich",
        "Marco_Geodesico_Nacional_de_Bolivia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MARGEN / UTM zone 21S\",GEOGCS[\"MARGEN\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Marco_Geodesico_Nacional_de_Bolivia\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1063\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"5354\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-57],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"5357\"]]");
    p = add_epsg_def_ex (filter, first, last, 5359, "epsg", 5359,
        "SIRGAS-Chile", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Chile", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"SIRGAS-Chile\",DATUM[\"SIRG");
    add_srs_wkt (p, 1,
        "AS-Chile\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUN");
    add_srs_wkt (p, 3,
        "IT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXI");
    add_srs_wkt (p, 4,
        "S[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433]],AXIS[\"geodetic longitude ");
    add_srs_wkt (p, 6,
        "(Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 7,
        "99433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENG");
    add_srs_wkt (p, 8,
        "THUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Chi");
    add_srs_wkt (p, 9,
        "le\"],BBOX[-59.87,-113.21,-17.5,-65.72]],ID[\"EPSG\",535");
    add_srs_wkt (p, 10,
        "9]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic");
    add_srs_wkt (p, 11,
        " System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 12,
        "3,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLE");
    add_srs_wkt (p, 13,
        "UNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],A");
    add_srs_wkt (p, 14,
        "XIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 15,
        "174532925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLE");
    add_srs_wkt (p, 16,
        "UNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]]");
    add_srs_wkt (p, 17,
        ",ABRIDGEDTRANSFORMATION[\"SIRGAS-Chile to WGS 84 (1)\",M");
    add_srs_wkt (p, 18,
        "ETHOD[\"Geocentric translations (geog2D domain)\",ID[\"E");
    add_srs_wkt (p, 19,
        "PSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EPS");
    add_srs_wkt (p, 20,
        "G\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 21,
        ",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8");
    add_srs_wkt (p, 22,
        "607]],USAGE[SCOPE[\"unknown\"],AREA[\"Chile\"],BBOX[-59.");
    add_srs_wkt (p, 23,
        "87,-113.21,-17.5,-65.72]],ID[\"EPSG\",5375]]]");
    p = add_epsg_def_ex (filter, first, last, 5360, "epsg", 5360,
        "SIRGAS-Chile", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_Chile", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-Chile\",DATUM[\"SIRGAS_Chile\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"106");
    add_srs_wkt (p, 3,
        "4\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"5360\"]]");
    p = add_epsg_def_ex (filter, first, last, 5361, "epsg", 5361,
        "SIRGAS-Chile / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "SIRGAS_Chile", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile / UTM zone 19S\",GEOGCS[\"SIRGAS-C");
    add_srs_wkt (p, 1,
        "hile\",DATUM[\"SIRGAS_Chile\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1064\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5360\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5361\"]]");
    p = add_epsg_def_ex (filter, first, last, 5362, "epsg", 5362,
        "SIRGAS-Chile / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "SIRGAS_Chile", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-Chile / UTM zone 18S\",GEOGCS[\"SIRGAS-C");
    add_srs_wkt (p, 1,
        "hile\",DATUM[\"SIRGAS_Chile\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1064\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5360\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"5362\"]]");
    p = add_epsg_def_ex (filter, first, last, 5364, "epsg", 5364,
        "CR05", 1, 1,
        "WGS 84", "Greenwich",
        "Costa_Rica_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"CR05\",DATUM[\"Costa Rica 2");
    add_srs_wkt (p, 1,
        "005\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Costa Rica");
    add_srs_wkt (p, 9,
        "\"],BBOX[2.15,-90.45,11.77,-81.43]],ID[\"EPSG\",5364]]],");
    add_srs_wkt (p, 10,
        "TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic Syst");
    add_srs_wkt (p, 11,
        "em 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LEN");
    add_srs_wkt (p, 12,
        "GTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[");
    add_srs_wkt (p, 13,
        "\"degree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"");
    add_srs_wkt (p, 14,
        "latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 15,
        "925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 16,
        "degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDG");
    add_srs_wkt (p, 17,
        "EDTRANSFORMATION[\"CR05 to WGS 84 (1)\",METHOD[\"Geocent");
    add_srs_wkt (p, 18,
        "ric translations (geog2D domain)\",ID[\"EPSG\",9603]],PA");
    add_srs_wkt (p, 19,
        "RAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARA");
    add_srs_wkt (p, 20,
        "METER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAME");
    add_srs_wkt (p, 21,
        "TER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SC");
    add_srs_wkt (p, 22,
        "OPE[\"unknown\"],AREA[\"Costa Rica\"],BBOX[2.15,-90.45,1");
    add_srs_wkt (p, 23,
        "1.77,-81.43]],ID[\"EPSG\",5376]]]");
    p = add_epsg_def_ex (filter, first, last, 5365, "epsg", 5365,
        "CR05", 1, 1,
        "WGS 84", "Greenwich",
        "Costa_Rica_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CR05\",DATUM[\"Costa_Rica_2005\",SPHEROID[\"WGS");
    add_srs_wkt (p, 1,
        " 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]");
    add_srs_wkt (p, 2,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1065\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"5365\"]]");
    p = add_epsg_def_ex (filter, first, last, 5367, "epsg", 5367,
        "CR05 / CRTM05", 0, 1,
        "WGS 84", "Greenwich",
        "Costa_Rica_2005", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CR05 / CRTM05\",GEOGCS[\"CR05\",DATUM[\"Costa_R");
    add_srs_wkt (p, 1,
        "ica_2005\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1065\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5365\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-84],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5367\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 5370, "epsg", 5370,
        "MACARIO SOLIS", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_Geodesico_Nacional_de_Panama_MACARIO_SOLIS", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"MACARIO SOLIS\",DATUM[\"Sis");
    add_srs_wkt (p, 1,
        "tema Geodesico Nacional de Panama MACARIO SOLIS\",ELLIPS");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metr");
    add_srs_wkt (p, 3,
        "e\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 4,
        "174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic lati");
    add_srs_wkt (p, 5,
        "tude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433]],AXIS[\"geodetic longitude (Lon)\",east,ORD");
    add_srs_wkt (p, 7,
        "ER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"e");
    add_srs_wkt (p, 8,
        "llipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 9,
        ",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Panama\"],BBOX[5,-8");
    add_srs_wkt (p, 10,
        "4.32,12.51,-77.04]],ID[\"EPSG\",5370]]],TARGETCRS[GEOGCR");
    add_srs_wkt (p, 11,
        "S[\"WGS 84\",DATUM[\"World Geodetic System 1984\",ELLIPS");
    add_srs_wkt (p, 12,
        "OID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 13,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 14,
        "532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north");
    add_srs_wkt (p, 15,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 16,
        "[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 17,
        "532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATIO");
    add_srs_wkt (p, 18,
        "N[\"MACARIO SOLIS to WGS 84 (1)\",METHOD[\"Geocentric tr");
    add_srs_wkt (p, 19,
        "anslations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETE");
    add_srs_wkt (p, 20,
        "R[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[");
    add_srs_wkt (p, 21,
        "\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"");
    add_srs_wkt (p, 22,
        "Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 23,
        "unknown\"],AREA[\"Panama\"],BBOX[5,-84.32,12.51,-77.04]]");
    add_srs_wkt (p, 24,
        ",ID[\"EPSG\",5377]]]");
    p = add_epsg_def_ex (filter, first, last, 5371, "epsg", 5371,
        "MACARIO SOLIS", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_Geodesico_Nacional_de_Panama_MACARIO_SOLIS", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MACARIO SOLIS\",DATUM[\"Sistema_Geodesico_Nacio");
    add_srs_wkt (p, 1,
        "nal_de_Panama_MACARIO_SOLIS\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1066\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"5371\"]]");
    p = add_epsg_def_ex (filter, first, last, 5372, "epsg", 5372,
        "Peru96", 1, 1,
        "GRS 1980", "Greenwich",
        "Peru96", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Peru96\",DATUM[\"Peru96\",E");
    add_srs_wkt (p, 1,
        "LLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Peru\"],BBOX[-2");
    add_srs_wkt (p, 9,
        "1.05,-84.68,-0.03,-68.67]],ID[\"EPSG\",5372]]],TARGETCRS");
    add_srs_wkt (p, 10,
        "[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\"");
    add_srs_wkt (p, 11,
        ",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 13,
        ",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\"");
    add_srs_wkt (p, 14,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 15,
        "],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 16,
        "0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFO");
    add_srs_wkt (p, 17,
        "RMATION[\"Peru96 to WGS 84 (1)\",METHOD[\"Geocentric tra");
    add_srs_wkt (p, 18,
        "nslations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER");
    add_srs_wkt (p, 19,
        "[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"");
    add_srs_wkt (p, 20,
        "Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-");
    add_srs_wkt (p, 21,
        "axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"un");
    add_srs_wkt (p, 22,
        "known\"],AREA[\"Peru\"],BBOX[-21.05,-84.68,-0.03,-68.67]");
    add_srs_wkt (p, 23,
        "],ID[\"EPSG\",5378]]]");
    p = add_epsg_def_ex (filter, first, last, 5373, "epsg", 5373,
        "Peru96", 1, 1,
        "GRS 1980", "Greenwich",
        "Peru96", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Peru96\",DATUM[\"Peru96\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 1,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 2,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1067\"]],PRIMEM");
    add_srs_wkt (p, 3,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 4,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 5,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"5373\"]]");
    p = add_epsg_def_ex (filter, first, last, 5380, "epsg", 5380,
        "SIRGAS-ROU98", 1, 1,
        "WGS 84", "Greenwich",
        "SIRGAS_ROU98", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"SIRGAS-ROU98\",DATUM[\"SIRG");
    add_srs_wkt (p, 1,
        "AS-ROU98\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Urug");
    add_srs_wkt (p, 9,
        "uay\"],BBOX[-37.77,-58.49,-30.09,-50.01]],ID[\"EPSG\",53");
    add_srs_wkt (p, 10,
        "80]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodeti");
    add_srs_wkt (p, 11,
        "c System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 12,
        "63,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGL");
    add_srs_wkt (p, 13,
        "EUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],");
    add_srs_wkt (p, 14,
        "AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 15,
        "0174532925199433]],AXIS[\"longitude\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 16,
        "EUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]");
    add_srs_wkt (p, 17,
        "],ABRIDGEDTRANSFORMATION[\"SIRGAS-ROU98 to WGS 84 (1)\",");
    add_srs_wkt (p, 18,
        "METHOD[\"Geocentric translations (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 22,
        ",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Uruguay\"],BBOX[");
    add_srs_wkt (p, 23,
        "-37.77,-58.49,-30.09,-50.01]],ID[\"EPSG\",5384]]]");
    p = add_epsg_def_ex (filter, first, last, 5381, "epsg", 5381,
        "SIRGAS-ROU98", 1, 1,
        "WGS 84", "Greenwich",
        "SIRGAS_ROU98", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS-ROU98\",DATUM[\"SIRGAS_ROU98\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "30\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1068\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"5381\"]]");
    p = add_epsg_def_ex (filter, first, last, 5382, "epsg", 5382,
        "SIRGAS-ROU98 / UTM zone 21S", 0, 0,
        "WGS 84", "Greenwich",
        "SIRGAS_ROU98", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-ROU98 / UTM zone 21S\",GEOGCS[\"SIRGAS-R");
    add_srs_wkt (p, 1,
        "OU98\",DATUM[\"SIRGAS_ROU98\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1068\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"5381\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-57],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5382\"]]");
    p = add_epsg_def_ex (filter, first, last, 5383, "epsg", 5383,
        "SIRGAS-ROU98 / UTM zone 22S", 0, 0,
        "WGS 84", "Greenwich",
        "SIRGAS_ROU98", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS-ROU98 / UTM zone 22S\",GEOGCS[\"SIRGAS-R");
    add_srs_wkt (p, 1,
        "OU98\",DATUM[\"SIRGAS_ROU98\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1068\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"5381\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-51],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"5383\"]]");
    p = add_epsg_def_ex (filter, first, last, 5387, "epsg", 5387,
        "Peru96 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "Peru96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 18S\",GEOGCS[\"Peru96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"53");
    add_srs_wkt (p, 6,
        "73\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5387\"]]");
    p = add_epsg_def_ex (filter, first, last, 5388, "epsg", 5388,
        "Peru96 / UTM zone 17S", 0, 0,
        "GRS 1980", "Greenwich",
        "Peru96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 17S\",GEOGCS[\"Peru96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"53");
    add_srs_wkt (p, 6,
        "73\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5839\"]]");
    p = add_epsg_def_ex (filter, first, last, 5389, "epsg", 5389,
        "Peru96 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Peru96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Peru96 / UTM zone 19S\",GEOGCS[\"Peru96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Peru96\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1067\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"53");
    add_srs_wkt (p, 6,
        "73\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"5389\"]]");
    p = add_epsg_def_ex (filter, first, last, 5392, "epsg", 5392,
        "SIRGAS_ES2007.8", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_ES2007_8", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"SIRGAS_ES2007.8\",DATUM[\"S");
    add_srs_wkt (p, 1,
        "IRGAS_ES2007.8\",ELLIPSOID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"El Salvador\"],BBOX[9.97,-91.43,14.44,-87.65]],ID[\"");
    add_srs_wkt (p, 10,
        "EPSG\",5392]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"Worl");
    add_srs_wkt (p, 11,
        "d Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,29");
    add_srs_wkt (p, 12,
        "8.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 13,
        "\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellips");
    add_srs_wkt (p, 14,
        "oidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"de");
    add_srs_wkt (p, 15,
        "gree\",0.0174532925199433]],AXIS[\"longitude\",east,ORDE");
    add_srs_wkt (p, 16,
        "R[2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG");
    add_srs_wkt (p, 17,
        "\",4326]]],ABRIDGEDTRANSFORMATION[\"SIRGAS_ES2007.8 to W");
    add_srs_wkt (p, 18,
        "GS 84 (1)\",METHOD[\"Geocentric translations (geog2D dom");
    add_srs_wkt (p, 19,
        "ain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translation");
    add_srs_wkt (p, 20,
        "\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\"");
    add_srs_wkt (p, 21,
        ",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0");
    add_srs_wkt (p, 22,
        ",ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"El S");
    add_srs_wkt (p, 23,
        "alvador\"],BBOX[9.97,-91.43,14.44,-87.65]],ID[\"EPSG\",5");
    add_srs_wkt (p, 24,
        "395]]]");
    p = add_epsg_def_ex (filter, first, last, 5393, "epsg", 5393,
        "SIRGAS_ES2007.8", 1, 1,
        "GRS 1980", "Greenwich",
        "SIRGAS_ES2007_8", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SIRGAS_ES2007.8\",DATUM[\"SIRGAS_ES2007_8\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1069\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"5393\"]]");
    p = add_epsg_def_ex (filter, first, last, 5396, "epsg", 5396,
        "SIRGAS 2000 / UTM zone 26S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 26S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6674\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4674\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 11,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"5396\"]]");
    p = add_epsg_def_ex (filter, first, last, 5451, "epsg", 5451,
        "Ocotepeque 1935", 1, 1,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=205,96,-98,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ocotepeque 1935\",DATUM[\"Ocotepeque_1935\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 6,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"5451\"]]");
    p = add_epsg_def_ex (filter, first, last, 5456, "epsg", 5456,
        "Ocotepeque 1935 / Costa Rica Norte", 0, 0,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=10.46666666666667 +lat_0=10.46666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-84.33333333333333 +k_0=0.99995696 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=271820.522 +ellps=clrk66 +towgs84=205,96,-98,0,0,");
    add_proj4text (p, 3,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Costa Rica Norte\",GEOGCS[\"O");
    add_srs_wkt (p, 1,
        "cotepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",10.4666666666667],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-84.3333333333333],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "99995696],PARAMETER[\"false_easting\",500000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",271820.522],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"5456\"]]");
    p = add_epsg_def_ex (filter, first, last, 5457, "epsg", 5457,
        "Ocotepeque 1935 / Costa Rica Sur", 0, 0,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=9 +lat_0=9 +lon_0=-83.66666666666667 +k");
    add_proj4text (p, 1,
        "_0=0.99995696 +x_0=500000 +y_0=327987.436 +ellps=clrk66 ");
    add_proj4text (p, 2,
        "+towgs84=205,96,-98,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Costa Rica Sur\",GEOGCS[\"Oco");
    add_srs_wkt (p, 1,
        "tepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",9],PARAMETER[\"central_meridian\",-83.66666");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"scale_factor\",0.99995696],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",327987.436],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"5457\"]]");
    p = add_epsg_def_ex (filter, first, last, 5458, "epsg", 5458,
        "Ocotepeque 1935 / Guatemala Norte", 0, 0,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=292209.579 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Guatemala Norte\",GEOGCS[\"Oc");
    add_srs_wkt (p, 1,
        "otepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",16.8166666666667],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-90.3333333333333],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "99992226],PARAMETER[\"false_easting\",500000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",292209.579],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"5559\"]]");
    p = add_epsg_def_ex (filter, first, last, 5459, "epsg", 5459,
        "Ocotepeque 1935 / Guatemala Sur", 0, 0,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=14.9 +lat_0=14.9 +lon_0=-90.33333333333");
    add_proj4text (p, 1,
        "333 +k_0=0.99989906 +x_0=500000 +y_0=325992.681 +ellps=c");
    add_proj4text (p, 2,
        "lrk66 +towgs84=205,96,-98,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Guatemala Sur\",GEOGCS[\"Ocot");
    add_srs_wkt (p, 1,
        "epeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
        "e 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",14.9],PARAMETER[\"central_meridian\",-90.333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"scale_factor\",0.99989906],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",325992.681],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"5459\"]]");
    p = add_epsg_def_ex (filter, first, last, 5460, "epsg", 5460,
        "Ocotepeque 1935 / El Salvador Lambert", 0, 0,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=13.78333333333333 +lat_0=13.78333333333");
    add_proj4text (p, 1,
        "333 +lon_0=-89 +k_0=0.99996704 +x_0=500000 +y_0=295809.1");
    add_proj4text (p, 2,
        "84 +ellps=clrk66 +towgs84=205,96,-98,0,0,0,0 +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / El Salvador Lambert\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Ocotepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",13.7833333333333],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-89],PARAMETER[\"scale_factor\",0.99996704],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",295809.184],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"5460\"]]");
    p = add_epsg_def_ex (filter, first, last, 5461, "epsg", 5461,
        "Ocotepeque 1935 / Nicaragua Norte", 0, 0,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=13.86666666666667 +lat_0=13.86666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-85.5 +k_0=0.99990314 +x_0=500000 +y_0=359891");
    add_proj4text (p, 2,
        ".816 +ellps=clrk66 +towgs84=205,96,-98,0,0,0,0 +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Nicaragua Norte\",GEOGCS[\"Oc");
    add_srs_wkt (p, 1,
        "otepeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",13.8666666666667],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-85.5],PARAMETER[\"scale_factor\",0.99990314],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",359891.816],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"5461\"]]");
    p = add_epsg_def_ex (filter, first, last, 5462, "epsg", 5462,
        "Ocotepeque 1935 / Nicaragua Sur", 0, 0,
        "Clarke 1866", "Greenwich",
        "Ocotepeque_1935", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=11.73333333333333 +lat_0=11.73333333333");
    add_proj4text (p, 1,
        "333 +lon_0=-85.5 +k_0=0.9999222800000001 +x_0=500000 +y_");
    add_proj4text (p, 2,
        "0=288876.327 +ellps=clrk66 +towgs84=205,96,-98,0,0,0,0 +");
    add_proj4text (p, 3,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ocotepeque 1935 / Nicaragua Sur\",GEOGCS[\"Ocot");
    add_srs_wkt (p, 1,
        "epeque 1935\",DATUM[\"Ocotepeque_1935\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
        "e 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],TOWGS84[205,96,-98,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1070\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5451\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",11.7333333333333],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-85.5],PARAMETER[\"scale_factor\",0.99992228],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",288876.327],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"5462\"]]");
    p = add_epsg_def_ex (filter, first, last, 5463, "epsg", 5463,
        "SAD69 / UTM zone 17N", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=aust_SA +towgs84=-66.87,4.37,-");
    add_proj4text (p, 1,
        "38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 17N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-81],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"5463\"]]");
    p = add_epsg_def_ex (filter, first, last, 5464, "epsg", 5464,
        "Sibun Gorge 1922", 1, 1,
        "Clarke 1858", "Greenwich",
        "Sibun_Gorge_1922", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sibun Gorge 1922\",DATUM[\"Sibun_Gorge_1922\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1858\",6378293.64520876,294.26067636926");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"107");
    add_srs_wkt (p, 3,
        "1\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"5464\"]]");
    p = add_epsg_def_ex (filter, first, last, 5466, "epsg", 5466,
        "Sibun Gorge 1922 / Colony Grid", 0, 0,
        "Clarke 1858", "Greenwich",
        "Sibun_Gorge_1922", "Transverse_Mercator", "Clarke's foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=17.06124194444444 +lon_0=-88.6318575 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=66220.02833082761 +y_0=135779.5099885299 +a=63");
    add_proj4text (p, 2,
        "78293.645208759 +b=6356617.987679838 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sibun Gorge 1922 / Colony Grid\",GEOGCS[\"Sibun");
    add_srs_wkt (p, 1,
        " Gorge 1922\",DATUM[\"Sibun_Gorge_1922\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1858\",6378293.64520876,294.260676369261,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"1071\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5464\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",17.0612419444444");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-88.6318575],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",217259.2");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_northing\",445474.83],UNIT[\"Clarke");
    add_srs_wkt (p, 11,
        "'s foot\",0.3047972654,AUTHORITY[\"EPSG\",\"9005\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"5589\"]]");
    p = add_epsg_def_ex (filter, first, last, 5467, "epsg", 5467,
        "Panama-Colon 1911", 1, 1,
        "Clarke 1866", "Greenwich",
        "Panama_Colon_1911", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Panama-Colon 1911\",DATUM[\"Panama_Colon_1911\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1866\",6378206.4,294.978698213898,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"1072\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"5467\"]]");
    p = add_epsg_def_ex (filter, first, last, 5469, "epsg", 5469,
        "Panama-Colon 1911 / Panama Lambert", 0, 0,
        "Clarke 1866", "Greenwich",
        "Panama_Colon_1911", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=8.416666666666666 +lat_0=8.416666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-80 +k_0=0.99989909 +x_0=500000 +y_0=294865.3");
    add_proj4text (p, 2,
        "03 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Panama-Colon 1911 / Panama Lambert\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "anama-Colon 1911\",DATUM[\"Panama_Colon_1911\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"1072\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5467\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",8.416666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-80],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.99989909],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",294865.303],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"546");
    add_srs_wkt (p, 13,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 5472, "epsg", 5472,
        "Panama-Colon 1911 / Panama Polyconic", 0, 0,
        "Clarke 1866", "Greenwich",
        "Panama_Colon_1911", "Polyconic", "Clarke's yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=8.25 +lon_0=-81 +x_0=914391.7962 +y_0=");
    add_proj4text (p, 1,
        "999404.7217154861 +ellps=clrk66 +to_meter=0.9143917962 +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Panama-Colon 1911 / Panama Polyconic\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Panama-Colon 1911\",DATUM[\"Panama_Colon_1911\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"1072\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"5467\"]],PROJECTION[\"Polyconic\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",8.25],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-81],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_northing\",1092972.1],UNIT[\"Clarke's yar");
    add_srs_wkt (p, 10,
        "d\",0.9143917962,AUTHORITY[\"EPSG\",\"9037\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"5472\"]]");
    p = add_epsg_def_ex (filter, first, last, 5479, "epsg", 5479,
        "RSRGD2000 / MSLC2000", 0, 1,
        "GRS 1980", "Greenwich",
        "Ross_Sea_Region_Geodetic_Datum_2000", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-78 +lon_0=163 +x_0=7000000 +y_0=5000000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / MSLC2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",-78],PARAMETER[\"central_meridian\",163],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",-76.6666666666667],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_2\",-79.3333333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",7000000],PARAMETER[\"false_northing\",5000000]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"5479\"]]");
    p = add_epsg_def_ex (filter, first, last, 5480, "epsg", 5480,
        "RSRGD2000 / BCLC2000", 0, 1,
        "GRS 1980", "Greenwich",
        "Ross_Sea_Region_Geodetic_Datum_2000", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-73.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-74.5 +lon_0=165 +x_0=5000000 +y_0=3000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / BCLC2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",-74.5],PARAMETER[\"central_meridian\",165],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",-73.6666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",-75.3333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",5000000],PARAMETER[\"false_northing\",300000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"5480\"]]");
    p = add_epsg_def_ex (filter, first, last, 5481, "epsg", 5481,
        "RSRGD2000 / PCLC2000", 0, 1,
        "GRS 1980", "Greenwich",
        "Ross_Sea_Region_Geodetic_Datum_2000", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-70.66666666666667 +lat_2=-72.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-71.5 +lon_0=166 +x_0=3000000 +y_0=1000000 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / PCLC2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",-71.5],PARAMETER[\"central_meridian\",166],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",-70.6666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",-72.3333333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",3000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"5481\"]]");
    p = add_epsg_def_ex (filter, first, last, 5482, "epsg", 5482,
        "RSRGD2000 / RSPS2000", 0, 0,
        "GRS 1980", "Greenwich",
        "Ross_Sea_Region_Geodetic_Datum_2000", "Polar_Stereographic", "metre",
        "Northing", "North", "Easting", "North");
    add_proj4text (p, 0,
        "+proj=stere +lat_0=-90 +lat_ts=-90 +lon_0=180 +k=0.994 +");
    add_proj4text (p, 1,
        "x_0=5000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / RSPS2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Polar");
    add_srs_wkt (p, 7,
        "_Stereographic\"],PARAMETER[\"latitude_of_origin\",-90],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",180],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.994],PARAMETER[\"false_easting\",5000000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",NORTH],AUTHORITY[\"EPSG\",\"5482\"]]");
    p = add_epsg_def_ex (filter, first, last, 5488, "epsg", 5488,
        "RGAF09", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Antilles_Francaises_2009", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGAF09\",DATUM[\"Reseau Geo");
    add_srs_wkt (p, 1,
        "desique des Antilles Francaises 2009\",ELLIPSOID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 4,
        "9433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\"");
    add_srs_wkt (p, 5,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 6,
        "],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 7,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal h");
    add_srs_wkt (p, 8,
        "eight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[S");
    add_srs_wkt (p, 9,
        "COPE[\"unknown\"],AREA[\"Caribbean - French Antilles\"],");
    add_srs_wkt (p, 10,
        "BBOX[14.08,-63.66,18.54,-57.52]],ID[\"EPSG\",5488]]],TAR");
    add_srs_wkt (p, 11,
        "GETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System ");
    add_srs_wkt (p, 12,
        "1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTH");
    add_srs_wkt (p, 13,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 14,
        "egree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"la");
    add_srs_wkt (p, 15,
        "titude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 16,
        "5199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 17,
        "egree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGE");
    add_srs_wkt (p, 18,
        "DTRANSFORMATION[\"RGAF09 to WGS 84 (1)\",METHOD[\"Geocen");
    add_srs_wkt (p, 19,
        "tric translations (geog2D domain)\",ID[\"EPSG\",9603]],P");
    add_srs_wkt (p, 20,
        "ARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PAR");
    add_srs_wkt (p, 21,
        "AMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAM");
    add_srs_wkt (p, 22,
        "ETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[S");
    add_srs_wkt (p, 23,
        "COPE[\"unknown\"],AREA[\"Caribbean - French Antilles\"],");
    add_srs_wkt (p, 24,
        "BBOX[14.08,-63.66,18.54,-57.52]],ID[\"EPSG\",5501]]]");
    p = add_epsg_def_ex (filter, first, last, 5489, "epsg", 5489,
        "RGAF09", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Antilles_Francaises_2009", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGAF09\",DATUM[\"Reseau_Geodesique_des_Antilles");
    add_srs_wkt (p, 1,
        "_Francaises_2009\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"1073\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"54");
    add_srs_wkt (p, 7,
        "89\"]]");
    p = add_epsg_def_ex (filter, first, last, 5490, "epsg", 5490,
        "RGAF09 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_des_Antilles_Francaises_2009", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGAF09 / UTM zone 20N\",GEOGCS[\"RGAF09\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Reseau_Geodesique_des_Antilles_Francaises_2009\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1073\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5489\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"5490\"]]");
    p = add_epsg_def_ex (filter, first, last, 5498, "epsg", 5498,
        "NAD83", 1, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=g2012a_conus.gtx,g2012a_alaska.gtx,g2012a_guam.gtx");
    add_proj4text (p, 2,
        ",g2012a_hawaii.gtx,g2012a_puertorico.gtx,g2012a_samoa.gt");
    add_proj4text (p, 3,
        "x +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83 + NAVD88 height\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],VERT_CS[\"NAVD88 height\",VERT_DATU");
    add_srs_wkt (p, 8,
        "M[\"North American Vertical Datum 1988\",2005,AUTHORITY[");
    add_srs_wkt (p, 9,
        "\"EPSG\",\"5103\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"5703\"]],AUTHORITY[\"EPSG\",\"5498\"]]");
    p = add_epsg_def_ex (filter, first, last, 5499, "epsg", 5499,
        "NAD83(HARN)", 1, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=g2012a_conus.gtx,g2012a_alaska.gtx,g2012a_guam.gtx");
    add_proj4text (p, 2,
        ",g2012a_hawaii.gtx,g2012a_puertorico.gtx,g2012a_samoa.gt");
    add_proj4text (p, 3,
        "x +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(HARN) + NAVD88 height\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],VERT_CS[\"N");
    add_srs_wkt (p, 8,
        "AVD88 height\",VERT_DATUM[\"North American Vertical Datu");
    add_srs_wkt (p, 9,
        "m 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-relate");
    add_srs_wkt (p, 11,
        "d height\",UP],AUTHORITY[\"EPSG\",\"5703\"]],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"5499\"]]");
    p = add_epsg_def_ex (filter, first, last, 5500, "epsg", 5500,
        "NAD83(NSRS2007)", 1, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=g2012a_conus.gtx,g2012a_alaska.gtx,g2012a_guam.gtx");
    add_proj4text (p, 2,
        ",g2012a_hawaii.gtx,g2012a_puertorico.gtx,g2012a_samoa.gt");
    add_proj4text (p, 3,
        "x +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(NSRS2007) + NAVD88 height\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],VERT_CS[\"NAVD88 height\",VERT_DATUM[\"North American");
    add_srs_wkt (p, 9,
        " Vertical Datum 1988\",2005,AUTHORITY[\"EPSG\",\"5103\"]");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"5703\"");
    add_srs_wkt (p, 12,
        "]],AUTHORITY[\"EPSG\",\"5500\"]]");
    p = add_epsg_def_ex (filter, first, last, 5513, "epsg", 5513,
        "S-JTSK / Krovak", 0, 0,
        "Bessel 1841", "Greenwich",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network", "Krovak", "metre",
        "Southing", "South", "Westing", "West");
    add_proj4text (p, 0,
        "+proj=krovak +lat_0=49.5 +lon_0=24.83333333333333 +alpha");
    add_proj4text (p, 1,
        "=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=589,76,480,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"S-JTSK / Krovak\",GEOGCS[\"S-JTSK\",DATUM[\"Sys");
    add_srs_wkt (p, 1,
        "tem_of_the_Unified_Trigonometrical_Cadastral_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7004\"]],TOWGS84[589,76,480,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6156\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4156\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Krovak\"],PARAMETER[\"latitude_of_center");
    add_srs_wkt (p, 8,
        "\",49.5],PARAMETER[\"longitude_of_center\",24.8333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"azimuth\",30.2881397527778],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "pseudo_standard_parallel_1\",78.5],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 11,
        "tor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Southing\",SOUTH],AXIS[\"Westing\",WES");
    add_srs_wkt (p, 14,
        "T],AUTHORITY[\"EPSG\",\"5513\"]]");
    p = add_epsg_def_ex (filter, first, last, 5514, "epsg", 5514,
        "S-JTSK / Krovak East North", 0, 0,
        "Bessel 1841", "Greenwich",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network", "Krovak", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=krovak +lat_0=49.5 +lon_0=24.83333333333333 +alpha");
    add_proj4text (p, 1,
        "=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=589,76,480,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"S-JTSK / Krovak East North\",GEOGCS[\"S-JTSK\",");
    add_srs_wkt (p, 1,
        "DATUM[\"System_of_the_Unified_Trigonometrical_Cadastral_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"Bessel 1841\",6377397.155,299.15281");
    add_srs_wkt (p, 3,
        "28,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[589,76,480,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6156\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4156\"]],PROJECTION[\"Krovak\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_center\",49.5],PARAMETER[\"longitude_of_center\",2");
    add_srs_wkt (p, 9,
        "4.8333333333333],PARAMETER[\"azimuth\",30.2881397527778]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"pseudo_standard_parallel_1\",78.5],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"5514\"]]");
    p = add_epsg_def_ex (filter, first, last, 5518, "epsg", 5518,
        "CI1971 / Chatham Islands Map Grid", 0, 1,
        "International 1924", "Greenwich",
        "Chatham_Islands_Datum_1971", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=350000 +y");
    add_proj4text (p, 1,
        "_0=650000 +ellps=intl +towgs84=175,-38,113,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CI1971 / Chatham Islands Map Grid\",GEOGCS[\"Ch");
    add_srs_wkt (p, 1,
        "atham Islands 1971\",DATUM[\"Chatham_Islands_Datum_1971\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[175,-38,113,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6672\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4672\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",-44],PARAMETER[\"central_meridian\",-176.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",350000],PARAMETER[\"false_northing\",650000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"5518");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 5519, "epsg", 5519,
        "CI1979 / Chatham Islands Map Grid", 0, 1,
        "International 1924", "Greenwich",
        "Chatham_Islands_Datum_1979", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=350000 +y");
    add_proj4text (p, 1,
        "_0=650000 +ellps=intl +towgs84=174.05,-25.49,112.57,0,0,");
    add_proj4text (p, 2,
        "0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CI1979 / Chatham Islands Map Grid\",GEOGCS[\"Ch");
    add_srs_wkt (p, 1,
        "atham Islands 1979\",DATUM[\"Chatham_Islands_Datum_1979\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[174.05,-25.49,112.57,0,0,0.554");
    add_srs_wkt (p, 4,
        ",0.2263],AUTHORITY[\"EPSG\",\"6673\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4673\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",-44],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",-176.5],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",350000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",650000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"5519\"]]");
    p = add_epsg_def_ex (filter, first, last, 5520, "epsg", 5520,
        "DHDN / 3-degree Gauss-Kruger zone 1", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 1\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",3],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",1500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"5520\"]]");
    p = add_epsg_def_ex (filter, first, last, 5523, "epsg", 5523,
        "WGS 84 / Gabon TM 2011", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=0.9996 +x_0=1500000 ");
    add_proj4text (p, 1,
        "+y_0=5500000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Gabon TM 2011\",GEOGCS[\"WGS 84\",DATU");
    add_srs_wkt (p, 1,
        "M[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 6,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"central_meridian\",11.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 8,
        "factor\",0.9996],PARAMETER[\"false_easting\",1500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",5500000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"5523\"]]");
    p = add_epsg_def_ex (filter, first, last, 5524, "epsg", 5524,
        "Corrego Alegre 1961", 1, 1,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1961", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Corrego Alegre 1961\",DATUM[\"Corrego_Alegre_19");
    add_srs_wkt (p, 1,
        "61\",SPHEROID[\"International 1924\",6378388,297,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"1074\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"5524\"]]");
    p = add_epsg_def_ex (filter, first, last, 5527, "epsg", 5527,
        "SAD69(96)", 1, 1,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-67.35,3.88,-38.22");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SAD69(96)\",DATUM[\"South_American_Datum_1969_9");
    add_srs_wkt (p, 1,
        "6\",SPHEROID[\"GRS 1967 Modified\",6378160,298.25,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7050\"]],TOWGS84[-67.35,3.88,-38.22,0,0,0");
    add_srs_wkt (p, 3,
        ",0],AUTHORITY[\"EPSG\",\"1075\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 5,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"55");
    add_srs_wkt (p, 7,
        "27\"]]");
    p = add_epsg_def_ex (filter, first, last, 5530, "epsg", 5530,
        "SAD69(96) / Brazil Polyconic", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Polyconic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / Brazil Polyconic\",GEOGCS[\"SAD69(9");
    add_srs_wkt (p, 1,
        "6)\",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "050\"]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Polyconic\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-54],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",5000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"5530\"]]");
    p = add_epsg_def_ex (filter, first, last, 5531, "epsg", 5531,
        "SAD69(96) / UTM zone 21S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 21S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5531\"]]");
    p = add_epsg_def_ex (filter, first, last, 5532, "epsg", 5532,
        "SAD69(96) / UTM zone 22S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-66.87");
    add_proj4text (p, 1,
        ",4.37,-38.52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 22S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5858\"]]");
    p = add_epsg_def_ex (filter, first, last, 5533, "epsg", 5533,
        "SAD69(96) / UTM zone 23S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 23S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-45],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5533\"]]");
    p = add_epsg_def_ex (filter, first, last, 5534, "epsg", 5534,
        "SAD69(96) / UTM zone 24S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 24S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-39],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5534\"]]");
    p = add_epsg_def_ex (filter, first, last, 5535, "epsg", 5535,
        "SAD69(96) / UTM zone 25S", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969_96", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=aust_SA +towgs84=-67.35");
    add_proj4text (p, 1,
        ",3.88,-38.22,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69(96) / UTM zone 25S\",GEOGCS[\"SAD69(96)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"South_American_Datum_1969_96\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-67.35,3.88,-38.22,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1075\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"5527\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-33],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5535\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

