/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_25 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4801, "epsg", 4801,
        "Bern 1898 (Bern)", 1, 1,
        "Bessel 1841", "Bern",
        "CH1903_Bern", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.");
    add_proj4text (p, 1,
        "346,0,0,0,0 +pm=bern +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bern 1898 (Bern)\",DATUM[\"CH1903_Bern\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6801\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Bern\",7.43958333333333,AUTHORITY[\"EPSG\",\"8907\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4801\"]]");
    p = add_epsg_def_ex (filter, first, last, 4802, "epsg", 4802,
        "Bogota 1975 (Bogota)", 1, 1,
        "International 1924", "Bogota",
        "Bogota_1975_Bogota", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 ");
    add_proj4text (p, 1,
        "+pm=bogota +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bogota 1975 (Bogota)\",DATUM[\"Bogota_1975_Bogo");
    add_srs_wkt (p, 1,
        "ta\",SPHEROID[\"International 1924\",6378388,297,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7022\"]],TOWGS84[307,304,-318,0,0,0,0],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6802\"]],PRIMEM[\"Bogota\",-74.0809166");
    add_srs_wkt (p, 4,
        "666667,AUTHORITY[\"EPSG\",\"8904\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4802\"]]");
    p = add_epsg_def_ex (filter, first, last, 4803, "epsg", 4803,
        "Lisbon (Lisbon)", 1, 1,
        "International 1924", "Lisbon",
        "Lisbon_1937_Lisbon", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-304.046,-60.576,103.");
    add_proj4text (p, 1,
        "64,0,0,0,0 +pm=lisbon +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],TOWGS84[-288.885,-91.744,126.244,-1.69");
    add_srs_wkt (p, 3,
        "1,0.41,-0.211,-4.598],AUTHORITY[\"EPSG\",\"6803\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Lisbon\",-9.13190611111111,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "2\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4803\"]]");
    p = add_epsg_def_ex (filter, first, last, 4804, "epsg", 4804,
        "Makassar (Jakarta)", 1, 1,
        "Bessel 1841", "Jakarta",
        "Makassar_Jakarta", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.7");
    add_proj4text (p, 1,
        "6,0,0,0,0 +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Makassar (Jakarta)\",DATUM[\"Makassar_Jakarta\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7004\"]],TOWGS84[-587.8,519.75,145.76,0,0");
    add_srs_wkt (p, 3,
        ",0,0],AUTHORITY[\"EPSG\",\"6804\"]],PRIMEM[\"Jakarta\",1");
    add_srs_wkt (p, 4,
        "06.807719444444,AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4804\"]]");
    p = add_epsg_def_ex (filter, first, last, 4805, "epsg", 4805,
        "MGI (Ferro)", 1, 1,
        "Bessel 1841", "Ferro",
        "Militar_Geographische_Institut_Ferro", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,");
    add_proj4text (p, 1,
        "0 +pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MGI (Ferro)\",DATUM[\"Militar_Geographische_Ins");
    add_srs_wkt (p, 1,
        "titut_Ferro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1");
    add_srs_wkt (p, 2,
        "528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6805\"]],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8909\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4805\"]]");
    p = add_epsg_def_ex (filter, first, last, 4806, "epsg", 4806,
        "Monte Mario (Rome)", 1, 1,
        "International 1924", "Rome",
        "Monte_Mario_Rome", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.9");
    add_proj4text (p, 1,
        "71,-2.917,0.714,-11.68 +pm=rome +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Monte Mario (Rome)\",DATUM[\"Monte_Mario_Rome\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6806\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Rome\",12.4523333333333,AUTHORITY[\"EPSG\",\"8906\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4806\"]]");
    p = add_epsg_def_ex (filter, first, last, 4807, "epsg", 4807,
        "NTF (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,");
    add_proj4text (p, 1,
        "320,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Fr");
    add_srs_wkt (p, 1,
        "ancaise_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2");
    add_srs_wkt (p, 2,
        ",293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-168,-60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Paris\",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4807\"]]");
    p = add_epsg_def_ex (filter, first, last, 4808, "epsg", 4808,
        "Padang (Jakarta)", 1, 1,
        "Bessel 1841", "Jakarta",
        "Padang_1884_Jakarta", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Padang (Jakarta)\",DATUM[\"Padang_1884_Jakarta\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6808\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Jakarta\",106.807719444444,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "908\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 6,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4808\"]]");
    p = add_epsg_def_ex (filter, first, last, 4809, "epsg", 4809,
        "Belge 1950 (Brussels)", 1, 1,
        "International 1924", "Brussels",
        "Reseau_National_Belge_1950_Brussels", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +pm=brussels +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Belge 1950 (Brussels)\",DATUM[\"Reseau_National");
    add_srs_wkt (p, 1,
        "_Belge_1950_Brussels\",SPHEROID[\"International 1924\",6");
    add_srs_wkt (p, 2,
        "378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6809\"]],PRIMEM[\"Brussels\",4.367975,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8910\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4809\"]]");
    p = add_epsg_def_ex (filter, first, last, 4810, "epsg", 4810,
        "Tananarive (Paris)", 1, 1,
        "International 1924", "Paris",
        "Tananarive_1925_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0");
    add_proj4text (p, 1,
        " +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925_Pa");
    add_srs_wkt (p, 1,
        "ris\",SPHEROID[\"International 1924\",6378388,297,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7022\"]],TOWGS84[-198.383,-240.517,-107.9");
    add_srs_wkt (p, 3,
        "09,0,0,0,0],AUTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Paris");
    add_srs_wkt (p, 4,
        "\",2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "grad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4810\"]]");
    p = add_epsg_def_ex (filter, first, last, 4811, "epsg", 4811,
        "Voirol 1875 (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Voirol_1875_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,");
    add_proj4text (p, 1,
        "227,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1875 (Paris)\",DATUM[\"Voirol_1875_Paris");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129");
    add_srs_wkt (p, 2,
        "3627,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-73,-247,227,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6811\"]],PRIMEM[\"Paris\",");
    add_srs_wkt (p, 4,
        "2.33722916999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gr");
    add_srs_wkt (p, 5,
        "ad\",0.0157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AX");
    add_srs_wkt (p, 6,
        "IS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4811\"]]");
    p = add_epsg_def_ex (filter, first, last, 4812, "epsg", 4812,
        "New Beijing / 3-degree Gauss-Kruger CM 132E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 132E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",132],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4812\"]]");
    p = add_epsg_def_ex (filter, first, last, 4813, "epsg", 4813,
        "Batavia (Jakarta)", 1, 1,
        "Bessel 1841", "Jakarta",
        "Batavia_Jakarta", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-377,681,-50,0,0,0,");
    add_proj4text (p, 1,
        "0 +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Batavia (Jakarta)\",DATUM[\"Batavia_Jakarta\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6813\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Jakarta\",106.807719444444,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "8\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4813\"]]");
    p = add_epsg_def_ex (filter, first, last, 4814, "epsg", 4814,
        "RT38 (Stockholm)", 1, 1,
        "Bessel 1841", "Stockholm",
        "Stockholm_1938_Stockholm", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=stockholm +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RT38 (Stockholm)\",DATUM[\"Stockholm_1938_Stock");
    add_srs_wkt (p, 1,
        "holm\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6814\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Stockholm\",18.0582777777778,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8911\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4814\"]]");
    p = add_epsg_def_ex (filter, first, last, 4815, "epsg", 4815,
        "Greek (Athens)", 1, 1,
        "Bessel 1841", "Athens",
        "Greek_Athens", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +pm=athens +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Greek (Athens)\",DATUM[\"Greek_Athens\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6815\"]],PRIMEM[\"A");
    add_srs_wkt (p, 3,
        "thens\",23.7163375,AUTHORITY[\"EPSG\",\"8912\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4815\"]]");
    p = add_epsg_def_ex (filter, first, last, 4816, "epsg", 4816,
        "Carthage (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Carthage_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-263,6,43");
    add_proj4text (p, 1,
        "1,0,0,0,0 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Carthage (Paris)\",DATUM[\"Carthage_Paris\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293627,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-263,6,431,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6816\"]],PRIMEM[\"Paris\",2.337229");
    add_srs_wkt (p, 4,
        "16999999,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.0");
    add_srs_wkt (p, 5,
        "157079632679489,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4816\"]]");
    p = add_epsg_def_ex (filter, first, last, 4817, "epsg", 4817,
        "NGO 1948 (Oslo)", 1, 1,
        "Bessel Modified", "Oslo",
        "NGO_1948_Oslo", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs");
    add_proj4text (p, 1,
        "84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NGO 1948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Bessel Modified\",6377492.018,299.1528128,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,");
    add_srs_wkt (p, 3,
        "-6.61,6.21],AUTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\"");
    add_srs_wkt (p, 4,
        ",10.7229166666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4817\"]]");
    p = add_epsg_def_ex (filter, first, last, 4818, "epsg", 4818,
        "S-JTSK (Ferro)", 1, 1,
        "Bessel 1841", "Ferro",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_Ferro", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=589,76,480,0,0,0,0 ");
    add_proj4text (p, 1,
        "+pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"S-JTSK (Ferro)\",DATUM[\"System_of_the_Unified_");
    add_srs_wkt (p, 1,
        "Trigonometrical_Cadastral_Network_Ferro\",SPHEROID[\"Bes");
    add_srs_wkt (p, 2,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7004\"]],AUTHORITY[\"EPSG\",\"6818\"]],PRIMEM[\"Ferro\",");
    add_srs_wkt (p, 4,
        "-17.6666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4818\"]]");
    p = add_epsg_def_ex (filter, first, last, 4819, "epsg", 4819,
        "Nord Sahara 1959", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-209.3622,-87.8162,");
    add_proj4text (p, 1,
        "404.6198,0.0046,3.4784,0.5805,-1.4547 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nord Sahara 1959\",DATUM[\"Nord_Sahara_1959\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7012\"]],TOWGS84[-209.3622,-87.8162,404.6");
    add_srs_wkt (p, 3,
        "198,0.0046,3.4784,0.5805,-1.4547],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "307\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4307\"]]");
    p = add_epsg_def_ex (filter, first, last, 4820, "epsg", 4820,
        "Segara (Jakarta)", 1, 1,
        "Bessel 1841", "Jakarta",
        "Gunung_Segara_Jakarta", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 1,
        " +pm=jakarta +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Segara (Jakarta)\",DATUM[\"Gunung_Segara_Jakart");
    add_srs_wkt (p, 1,
        "a\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7004\"]],TOWGS84[-403,684,41,0,0,0,0],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6820\"]],PRIMEM[\"Jakarta\",106.807");
    add_srs_wkt (p, 4,
        "719444444,AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4820\"]]");
    p = add_epsg_def_ex (filter, first, last, 4821, "epsg", 4821,
        "Voirol 1879 (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Voirol_1879_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +pm=paris +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1879 (Paris)\",DATUM[\"Voirol_1879_Paris");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129");
    add_srs_wkt (p, 2,
        "3627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6821\"]],PRIMEM[\"Paris\",2.33722916999999,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4821\"]]");
    p = add_epsg_def_ex (filter, first, last, 4822, "epsg", 4822,
        "New Beijing / 3-degree Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "New_Beijing", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"New Beijing / 3-degree Gauss-Kruger CM 135E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"New Beijing\",DATUM[\"New_Beijing\",SPHEROID[\"K");
    add_srs_wkt (p, 2,
        "rassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1045\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4555\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",135],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4822\"]]");
    p = add_epsg_def_ex (filter, first, last, 4823, "epsg", 4823,
        "Sao Tome", 1, 1,
        "International 1924", "Greenwich",
        "Sao_Tome", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sao Tome\",DATUM[\"Sao_Tome\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1044\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4823");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4824, "epsg", 4824,
        "Principe", 1, 1,
        "International 1924", "Greenwich",
        "Principe", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Principe\",DATUM[\"Principe\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1046\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4824");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4826, "epsg", 4826,
        "WGS 84 / Cape Verde National", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=15 +lat_2=16.66666666666667 +lat_0=15.8");
    add_proj4text (p, 1,
        "3333333333333 +lon_0=-24 +x_0=161587.83 +y_0=128511.202 ");
    add_proj4text (p, 2,
        "+datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Cape Verde National\",GEOGCS[\"WGS 84\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",15.8333333333333],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-24],PARAMETER[\"standard_parallel_1\",15],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_2\",16.6666666666667],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",161587.83],PARAMETER[\"false_northing\",12");
    add_srs_wkt (p, 11,
        "8511.202],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"4826\"]]");
    p = add_epsg_def_ex (filter, first, last, 4839, "epsg", 4839,
        "ETRS89 / LCC Germany (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.66666666666666 +lat_2=53.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=51 +lon_0=10.5 +x_0=0 +y_0=0 +ellps=GRS80 +to");
    add_proj4text (p, 2,
        "wgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / LCC Germany (N-E)\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",51],PARAMETER[\"central_meridian\",10.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_1\",48.6666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",53.6666666666667],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "4839\"]]");
    p = add_epsg_def_ex (filter, first, last, 4855, "epsg", 4855,
        "ETRS89 / NTM zone 5", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=5.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 5\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",5.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",100000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"5105\"]]");
    p = add_epsg_def_ex (filter, first, last, 4856, "epsg", 4856,
        "ETRS89 / NTM zone 6", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 6\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",6.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",100000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"5106\"]]");
    p = add_epsg_def_ex (filter, first, last, 4857, "epsg", 4857,
        "ETRS89 / NTM zone 7", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=7.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 7\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",7.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",100000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"5107\"]]");
    p = add_epsg_def_ex (filter, first, last, 4858, "epsg", 4858,
        "ETRS89 / NTM zone 8", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=8.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 8\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",8.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",100000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"5108\"]]");
    p = add_epsg_def_ex (filter, first, last, 4859, "epsg", 4859,
        "ETRS89 / NTM zone 9", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=1 +x_0=100000 +y_0=10");
    add_proj4text (p, 1,
        "00000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 9\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",58],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",9.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",100000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AUTHORITY[\"EPSG\",\"5109\"]]");
    p = add_epsg_def_ex (filter, first, last, 4860, "epsg", 4860,
        "ETRS89 / NTM zone 10", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 10\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",10.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5110\"]]");
    p = add_epsg_def_ex (filter, first, last, 4861, "epsg", 4861,
        "ETRS89 / NTM zone 11", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 11\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",11.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5111\"]]");
    p = add_epsg_def_ex (filter, first, last, 4862, "epsg", 4862,
        "ETRS89 / NTM zone 12", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 12\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",12.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5112\"]]");
    p = add_epsg_def_ex (filter, first, last, 4863, "epsg", 4863,
        "ETRS89 / NTM zone 13", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 13\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",13.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5113\"]]");
    p = add_epsg_def_ex (filter, first, last, 4864, "epsg", 4864,
        "ETRS89 / NTM zone 14", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=14.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 14\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",14.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5114\"]]");
    p = add_epsg_def_ex (filter, first, last, 4865, "epsg", 4865,
        "ETRS89 / NTM zone 15", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 15\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",15.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5115\"]]");
    p = add_epsg_def_ex (filter, first, last, 4866, "epsg", 4866,
        "ETRS89 / NTM zone 16", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 16\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",16.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5116\"]]");
    p = add_epsg_def_ex (filter, first, last, 4867, "epsg", 4867,
        "ETRS89 / NTM zone 17", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 17\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",17.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5117\"]]");
    p = add_epsg_def_ex (filter, first, last, 4868, "epsg", 4868,
        "ETRS89 / NTM zone 18", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 18\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",18.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5118\"]]");
    p = add_epsg_def_ex (filter, first, last, 4869, "epsg", 4869,
        "ETRS89 / NTM zone 19", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 19\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",19.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5119\"]]");
    p = add_epsg_def_ex (filter, first, last, 4870, "epsg", 4870,
        "ETRS89 / NTM zone 20", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 20\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",20.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5120\"]]");
    p = add_epsg_def_ex (filter, first, last, 4871, "epsg", 4871,
        "ETRS89 / NTM zone 21", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 21\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",21.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5121\"]]");
    p = add_epsg_def_ex (filter, first, last, 4872, "epsg", 4872,
        "ETRS89 / NTM zone 22", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 22\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",22.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5122\"]]");
    p = add_epsg_def_ex (filter, first, last, 4873, "epsg", 4873,
        "ETRS89 / NTM zone 23", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 23\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",23.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5123\"]]");
    p = add_epsg_def_ex (filter, first, last, 4874, "epsg", 4874,
        "ETRS89 / NTM zone 24", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 24\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",24.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5124\"]]");
    p = add_epsg_def_ex (filter, first, last, 4875, "epsg", 4875,
        "ETRS89 / NTM zone 25", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 25\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",25.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5125\"]]");
    p = add_epsg_def_ex (filter, first, last, 4876, "epsg", 4876,
        "ETRS89 / NTM zone 26", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=26.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 26\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",26.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5126\"]]");
    p = add_epsg_def_ex (filter, first, last, 4877, "epsg", 4877,
        "ETRS89 / NTM zone 27", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 27\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",27.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5127\"]]");
    p = add_epsg_def_ex (filter, first, last, 4878, "epsg", 4878,
        "ETRS89 / NTM zone 28", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 28\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",28.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5128\"]]");
    p = add_epsg_def_ex (filter, first, last, 4879, "epsg", 4879,
        "ETRS89 / NTM zone 29", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 29\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",29.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5129\"]]");
    p = add_epsg_def_ex (filter, first, last, 4880, "epsg", 4880,
        "ETRS89 / NTM zone 30", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30.5 +k=1 +x_0=100000 +y_0=1");
    add_proj4text (p, 1,
        "000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / NTM zone 30\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 4,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "8],PARAMETER[\"central_meridian\",30.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",100000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"5130\"]]");
    p = add_epsg_def_ex (filter, first, last, 4883, "epsg", 4883,
        "Slovenia 1996", 1, 1,
        "GRS 1980", "Greenwich",
        "Slovenia_Geodetic_Datum_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Slovenia 1996\",DATUM[\"Slo");
    add_srs_wkt (p, 1,
        "venia Geodetic Datum 1996\",ELLIPSOID[\"GRS 1980\",63781");
    add_srs_wkt (p, 2,
        "37,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gree");
    add_srs_wkt (p, 3,
        "nwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[e");
    add_srs_wkt (p, 4,
        "llipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORD");
    add_srs_wkt (p, 5,
        "ER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"g");
    add_srs_wkt (p, 6,
        "eodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 7,
        "ee\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\"");
    add_srs_wkt (p, 8,
        ",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 9,
        "own\"],AREA[\"Slovenia\"],BBOX[45.42,13.38,46.88,16.61]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",4883]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[");
    add_srs_wkt (p, 11,
        "\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378");
    add_srs_wkt (p, 12,
        "137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gre");
    add_srs_wkt (p, 13,
        "enwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[");
    add_srs_wkt (p, 14,
        "ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNI");
    add_srs_wkt (p, 15,
        "T[\"degree\",0.0174532925199433]],AXIS[\"longitude\",eas");
    add_srs_wkt (p, 16,
        "t,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[");
    add_srs_wkt (p, 17,
        "\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"Slovenia 1996 ");
    add_srs_wkt (p, 18,
        "to WGS 84 (1)\",METHOD[\"Geocentric translations (geog2D");
    add_srs_wkt (p, 19,
        " domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis transla");
    add_srs_wkt (p, 20,
        "tion\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translati");
    add_srs_wkt (p, 21,
        "on\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation");
    add_srs_wkt (p, 22,
        "\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 23,
        "Slovenia\"],BBOX[45.42,13.38,46.88,16.61]],ID[\"EPSG\",1");
    add_srs_wkt (p, 24,
        "5976]]]");
    p = add_epsg_def_ex (filter, first, last, 4885, "epsg", 4885,
        "RSRGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Ross_Sea_Region_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RSRGD2000\",DATUM[\"Ross Se");
    add_srs_wkt (p, 1,
        "a Region Geodetic Datum 2000\",ELLIPSOID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],C");
    add_srs_wkt (p, 4,
        "S[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,");
    add_srs_wkt (p, 5,
        "ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[");
    add_srs_wkt (p, 6,
        "\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 7,
        "egree\",0.0174532925199433]],AXIS[\"ellipsoidal height (");
    add_srs_wkt (p, 8,
        "h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"Antarctica - Ross Sea Region\"],BBOX[-");
    add_srs_wkt (p, 10,
        "90,144.99,-59.99,-144.99]],ID[\"EPSG\",4885]]],TARGETCRS");
    add_srs_wkt (p, 11,
        "[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\"");
    add_srs_wkt (p, 12,
        ",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 14,
        ",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\"");
    add_srs_wkt (p, 15,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 16,
        "],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 17,
        "0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFO");
    add_srs_wkt (p, 18,
        "RMATION[\"RSRGD2000 to WGS 84 (1)\",METHOD[\"Geocentric ");
    add_srs_wkt (p, 19,
        "translations (geog2D domain)\",ID[\"EPSG\",9603]],PARAME");
    add_srs_wkt (p, 20,
        "TER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETE");
    add_srs_wkt (p, 21,
        "R[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[");
    add_srs_wkt (p, 22,
        "\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[");
    add_srs_wkt (p, 23,
        "\"unknown\"],AREA[\"Antarctica - Ross Sea Region\"],BBOX");
    add_srs_wkt (p, 24,
        "[-90,144.99,-59.99,-144.99]],ID[\"EPSG\",15974]]]");
    p = add_epsg_def_ex (filter, first, last, 4887, "epsg", 4887,
        "BDA2000", 1, 1,
        "WGS 84", "Greenwich",
        "Bermuda_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"BDA2000\",DATUM[\"Bermuda 2");
    add_srs_wkt (p, 1,
        "000\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Bermuda\"]");
    add_srs_wkt (p, 9,
        ",BBOX[28.91,-68.83,35.73,-60.7]],ID[\"EPSG\",4887]]],TAR");
    add_srs_wkt (p, 10,
        "GETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System ");
    add_srs_wkt (p, 11,
        "1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTH");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 13,
        "egree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"la");
    add_srs_wkt (p, 14,
        "titude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 15,
        "5199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 16,
        "egree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGE");
    add_srs_wkt (p, 17,
        "DTRANSFORMATION[\"BDA2000 to WGS 84 (1)\",METHOD[\"Geoce");
    add_srs_wkt (p, 18,
        "ntric translations (geog2D domain)\",ID[\"EPSG\",9603]],");
    add_srs_wkt (p, 19,
        "PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PA");
    add_srs_wkt (p, 20,
        "RAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARA");
    add_srs_wkt (p, 21,
        "METER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[");
    add_srs_wkt (p, 22,
        "SCOPE[\"unknown\"],AREA[\"Bermuda\"],BBOX[28.91,-68.83,3");
    add_srs_wkt (p, 23,
        "5.73,-60.7]],ID[\"EPSG\",15971]]]");
    p = add_epsg_def_ex (filter, first, last, 4889, "epsg", 4889,
        "HTRS96", 1, 1,
        "GRS 1980", "Greenwich",
        "Croatian_Terrestrial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"HTRS96\",DATUM[\"Croatian T");
    add_srs_wkt (p, 1,
        "errestrial Reference System\",ELLIPSOID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS");
    add_srs_wkt (p, 4,
        "[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,O");
    add_srs_wkt (p, 5,
        "RDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 6,
        "geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 7,
        "ree\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)");
    add_srs_wkt (p, 8,
        "\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"un");
    add_srs_wkt (p, 9,
        "known\"],AREA[\"Croatia\"],BBOX[41.62,13,46.54,19.43]],I");
    add_srs_wkt (p, 10,
        "D[\"EPSG\",4889]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 11,
        "World Geodetic System 1984\",ELLIPSOID[\"WGS 84\",637813");
    add_srs_wkt (p, 12,
        "7,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Green");
    add_srs_wkt (p, 13,
        "wich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[el");
    add_srs_wkt (p, 14,
        "lipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 15,
        "\"degree\",0.0174532925199433]],AXIS[\"longitude\",east,");
    add_srs_wkt (p, 16,
        "ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"");
    add_srs_wkt (p, 17,
        "EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"HTRS96 to WGS 84");
    add_srs_wkt (p, 18,
        " (1)\",METHOD[\"Geocentric translations (geog2D domain)\"");
    add_srs_wkt (p, 19,
        ",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translation\",0,I");
    add_srs_wkt (p, 20,
        "D[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[");
    add_srs_wkt (p, 21,
        "\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"");
    add_srs_wkt (p, 22,
        "EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Croatia\"]");
    add_srs_wkt (p, 23,
        ",BBOX[41.62,13,46.54,19.43]],ID[\"EPSG\",15967]]]");
    p = add_epsg_def_ex (filter, first, last, 4891, "epsg", 4891,
        "WGS 66", 1, 1,
        "NWL 9D", "Greenwich",
        "World_Geodetic_System_1966", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=NWL9D +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 66\",DATUM[\"World Geodetic System 1966\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"NWL 9D\",6378145,298.25,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 2,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 3,
        "532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitud");
    add_srs_wkt (p, 4,
        "e (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[");
    add_srs_wkt (p, 6,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"elli");
    add_srs_wkt (p, 7,
        "psoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 8,
        "],USAGE[SCOPE[\"unknown\"],AREA[\"World\"],BBOX[-90,-180");
    add_srs_wkt (p, 9,
        ",90,180]],ID[\"EPSG\",4891]]");
    p = add_epsg_def_ex (filter, first, last, 4893, "epsg", 4893,
        "NAD83(NSRS2007)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"NAD83(NSRS2007)\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "AD83 (National Spatial Reference System 2007)\",ELLIPSOI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 3,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 4,
        "532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitud");
    add_srs_wkt (p, 5,
        "e (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[");
    add_srs_wkt (p, 7,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"elli");
    add_srs_wkt (p, 8,
        "psoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 9,
        "],USAGE[SCOPE[\"unknown\"],AREA[\"USA - CONUS and Alaska");
    add_srs_wkt (p, 10,
        "; PRVI\"],BBOX[14.92,167.65,74.71,-63.88]],ID[\"EPSG\",4");
    add_srs_wkt (p, 11,
        "893]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodet");
    add_srs_wkt (p, 12,
        "ic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 13,
        "563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 14,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,2]");
    add_srs_wkt (p, 15,
        ",AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 16,
        ".0174532925199433]],AXIS[\"longitude\",east,ORDER[2],ANG");
    add_srs_wkt (p, 17,
        "LEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]");
    add_srs_wkt (p, 18,
        "]],ABRIDGEDTRANSFORMATION[\"NAD83(NSRS2007) to WGS 84 (1");
    add_srs_wkt (p, 19,
        ")\",METHOD[\"Geocentric translations (geog2D domain)\",I");
    add_srs_wkt (p, 20,
        "D[\"EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[");
    add_srs_wkt (p, 21,
        "\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"");
    add_srs_wkt (p, 22,
        "EPSG\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 23,
        "SG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"USA - CONUS ");
    add_srs_wkt (p, 24,
        "and Alaska; PRVI\"],BBOX[14.92,167.65,74.71,-63.88]],ID[");
    add_srs_wkt (p, 25,
        "\"EPSG\",15931]]]");
    p = add_epsg_def_ex (filter, first, last, 4895, "epsg", 4895,
        "JAD2001", 1, 1,
        "WGS 84", "Greenwich",
        "Jamaica_2001", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"JAD2001\",DATUM[\"Jamaica 2");
    add_srs_wkt (p, 1,
        "001\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Jamaica\"]");
    add_srs_wkt (p, 9,
        ",BBOX[14.08,-80.6,19.36,-74.51]],ID[\"EPSG\",4895]]],TAR");
    add_srs_wkt (p, 10,
        "GETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System ");
    add_srs_wkt (p, 11,
        "1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTH");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 13,
        "egree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"la");
    add_srs_wkt (p, 14,
        "titude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 15,
        "5199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 16,
        "egree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGE");
    add_srs_wkt (p, 17,
        "DTRANSFORMATION[\"JAD2001 to WGS 84 (1)\",METHOD[\"Geoce");
    add_srs_wkt (p, 18,
        "ntric translations (geog2D domain)\",ID[\"EPSG\",9603]],");
    add_srs_wkt (p, 19,
        "PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PA");
    add_srs_wkt (p, 20,
        "RAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARA");
    add_srs_wkt (p, 21,
        "METER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[");
    add_srs_wkt (p, 22,
        "SCOPE[\"unknown\"],AREA[\"Jamaica\"],BBOX[14.08,-80.6,19");
    add_srs_wkt (p, 23,
        ".36,-74.51]],ID[\"EPSG\",15925]]]");
    p = add_epsg_def_ex (filter, first, last, 4898, "epsg", 4898,
        "DGN95", 1, 1,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"DGN95\",DATUM[\"Datum Geode");
    add_srs_wkt (p, 1,
        "si Nasional 1995\",ELLIPSOID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"Indonesia\"],BBOX[-13.95,92.01,7.79,141.46]],ID[\"EP");
    add_srs_wkt (p, 10,
        "SG\",4898]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World ");
    add_srs_wkt (p, 11,
        "Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 12,
        "257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 13,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 14,
        "dal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 15,
        "ee\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[");
    add_srs_wkt (p, 16,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",4326]]],ABRIDGEDTRANSFORMATION[\"DGN95 to WGS 84 (1)\",");
    add_srs_wkt (p, 18,
        "METHOD[\"Geocentric translations (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 22,
        ",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Indonesia\"],BBO");
    add_srs_wkt (p, 23,
        "X[-13.95,92.01,7.79,141.46]],ID[\"EPSG\",15912]]]");
    p = add_epsg_def_ex (filter, first, last, 4900, "epsg", 4900,
        "LGD2006", 1, 1,
        "International 1924", "Greenwich",
        "Libyan_Geodetic_Datum_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-208.4058,-109.8777,-");
    add_proj4text (p, 1,
        "2.5764,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"LGD2006\",DATUM[\"Libyan Ge");
    add_srs_wkt (p, 1,
        "odetic Datum 2006\",ELLIPSOID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoid");
    add_srs_wkt (p, 4,
        "al,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],AN");
    add_srs_wkt (p, 5,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic ");
    add_srs_wkt (p, 6,
        "longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 7,
        "174532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORD");
    add_srs_wkt (p, 8,
        "ER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],");
    add_srs_wkt (p, 9,
        "AREA[\"Libya\"],BBOX[19.5,9.31,35.23,26.21]],ID[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",4900]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geod");
    add_srs_wkt (p, 11,
        "etic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 12,
        "23563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 13,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 14,
        "2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 15,
        ",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[2],A");
    add_srs_wkt (p, 16,
        "NGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",432");
    add_srs_wkt (p, 17,
        "6]]],ABRIDGEDTRANSFORMATION[\"LGD2006 to WGS 84 (1)\",ME");
    add_srs_wkt (p, 18,
        "THOD[\"Geocentric translations (geog2D domain)\",ID[\"EP");
    add_srs_wkt (p, 19,
        "SG\",9603]],PARAMETER[\"X-axis translation\",-208.4058,I");
    add_srs_wkt (p, 20,
        "D[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",-109.");
    add_srs_wkt (p, 21,
        "8777,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\"");
    add_srs_wkt (p, 22,
        ",-2.5764,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 23,
        "A[\"Libya\"],BBOX[19.5,9.31,35.23,26.21]],ID[\"EPSG\",15");
    add_srs_wkt (p, 24,
        "908]]]");
    p = add_epsg_def_ex (filter, first, last, 4901, "epsg", 4901,
        "ATF (Paris)", 1, 1,
        "Plessis 1817", "Paris RGS",
        "Ancienne_Triangulation_Francaise_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376523 +b=6355862.933255573 +pm=2.3372");
    add_proj4text (p, 1,
        "08333333333 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ATF (Paris)\",DATUM[\"Ancienne_Triangulation_Fr");
    add_srs_wkt (p, 1,
        "ancaise_Paris\",SPHEROID[\"Plessis 1817\",6376523,308.64");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Paris RGS\",2.33720833333333,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8914\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4901\"]]");
    p = add_epsg_def_ex (filter, first, last, 4902, "epsg", 4902,
        "ATF (Paris)", 1, 1,
        "Plessis 1817", "Paris RGS",
        "Ancienne_Triangulation_Francaise_Paris", "none", "grad",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376523 +b=6355862.933255573 +pm=paris ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ATF (Paris)\",DATUM[\"Ancienne_Triangulation_Fr");
    add_srs_wkt (p, 1,
        "ancaise_Paris\",SPHEROID[\"Plessis 1817\",6376523,308.64");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Paris RGS\",2.33720833333333,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8914\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4901\"]]");
    p = add_epsg_def_ex (filter, first, last, 4903, "epsg", 4903,
        "Madrid 1870 (Madrid)", 1, 1,
        "Struve 1860", "Madrid",
        "Madrid_1870_Madrid", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378298.3 +b=6356657.142669561 +pm=madr");
    add_proj4text (p, 1,
        "id +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Madrid 1870 (Madrid)\",DATUM[\"Madrid_1870_Madr");
    add_srs_wkt (p, 1,
        "id\",SPHEROID[\"Struve 1860\",6378298.3,294.73,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7028\"]],AUTHORITY[\"EPSG\",\"6903\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Madrid\",-3.68793888888889,AUTHORITY[\"EPSG\",\"8905");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 6,
        ",EAST],AUTHORITY[\"EPSG\",\"4903\"]]");
    p = add_epsg_def_ex (filter, first, last, 4904, "epsg", 4904,
        "Lisbon 1890 (Lisbon)", 1, 1,
        "Bessel 1841", "Lisbon",
        "Lisbon_1890_Lisbon", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,56");
    add_proj4text (p, 1,
        "5.223,0,0,0,0 +pm=lisbon +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon 1890 (Lisbon)\",DATUM[\"Lisbon_1890_Lisb");
    add_srs_wkt (p, 1,
        "on\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7004\"]],TOWGS84[631.392,-66.551,481.");
    add_srs_wkt (p, 3,
        "442,1.09,-4.445,-4.487,-4.43],AUTHORITY[\"EPSG\",\"6904\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Lisbon\",-9.13190611111111,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8902\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4904\"]]");
    p = add_epsg_def_ex (filter, first, last, 4907, "epsg", 4907,
        "RGNC91-93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91_93", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGNC91-93\",DATUM[\"Reseau ");
    add_srs_wkt (p, 1,
        "Geodesique de Nouvelle Caledonie 91-93\",ELLIPSOID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat");
    add_srs_wkt (p, 5,
        ")\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANG");
    add_srs_wkt (p, 7,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoida");
    add_srs_wkt (p, 8,
        "l height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAG");
    add_srs_wkt (p, 9,
        "E[SCOPE[\"unknown\"],AREA[\"New Caledonia\"],BBOX[-26.45");
    add_srs_wkt (p, 10,
        ",156.25,-14.83,174.28]],ID[\"EPSG\",4907]]],TARGETCRS[GE");
    add_srs_wkt (p, 11,
        "OGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",EL");
    add_srs_wkt (p, 12,
        "LIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"me");
    add_srs_wkt (p, 13,
        "tre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 14,
        ".0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",");
    add_srs_wkt (p, 15,
        "north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 16,
        ",AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 17,
        ".0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFOR");
    add_srs_wkt (p, 18,
        "MATION[\"RGNC91-93 to WGS 84 (1)\",METHOD[\"Geocentric t");
    add_srs_wkt (p, 19,
        "ranslations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMET");
    add_srs_wkt (p, 20,
        "ER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER");
    add_srs_wkt (p, 21,
        "[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"");
    add_srs_wkt (p, 22,
        "Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 23,
        "unknown\"],AREA[\"New Caledonia\"],BBOX[-26.45,156.25,-1");
    add_srs_wkt (p, 24,
        "4.83,174.28]],ID[\"EPSG\",15880]]]");
    p = add_epsg_def_ex (filter, first, last, 4909, "epsg", 4909,
        "GR96", 1, 1,
        "GRS 1980", "Greenwich",
        "Greenland_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"GR96\",DATUM[\"Greenland 19");
    add_srs_wkt (p, 1,
        "96\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTH");
    add_srs_wkt (p, 2,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 3,
        "egree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"ge");
    add_srs_wkt (p, 4,
        "odetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)");
    add_srs_wkt (p, 6,
        "\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 7,
        "]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNI");
    add_srs_wkt (p, 8,
        "T[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Greenlan");
    add_srs_wkt (p, 9,
        "d\"],BBOX[56.38,-75,87.03,8.12]],ID[\"EPSG\",4909]]],TAR");
    add_srs_wkt (p, 10,
        "GETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System ");
    add_srs_wkt (p, 11,
        "1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTH");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"d");
    add_srs_wkt (p, 13,
        "egree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"la");
    add_srs_wkt (p, 14,
        "titude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 15,
        "5199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 16,
        "egree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGE");
    add_srs_wkt (p, 17,
        "DTRANSFORMATION[\"GR96 to WGS 84 (1)\",METHOD[\"Geocentr");
    add_srs_wkt (p, 18,
        "ic translations (geog2D domain)\",ID[\"EPSG\",9603]],PAR");
    add_srs_wkt (p, 19,
        "AMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAM");
    add_srs_wkt (p, 20,
        "ETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMET");
    add_srs_wkt (p, 21,
        "ER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCO");
    add_srs_wkt (p, 22,
        "PE[\"unknown\"],AREA[\"Greenland\"],BBOX[56.38,-75,87.03");
    add_srs_wkt (p, 23,
        ",8.12]],ID[\"EPSG\",15879]]]");
    p = add_epsg_def_ex (filter, first, last, 4921, "epsg", 4921,
        "GDM2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Geodetic_Datum_of_Malaysia_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"GDM2000\",DATUM[\"Geodetic Datum of Malaysia 2");
    add_srs_wkt (p, 1,
        "000\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Malaysi");
    add_srs_wkt (p, 9,
        "a\"],BBOX[0.85,98.02,7.81,119.61]],ID[\"EPSG\",4921]]");
    p = add_epsg_def_ex (filter, first, last, 4923, "epsg", 4923,
        "PZ-90", 1, 1,
        "PZ-90", "Greenwich",
        "Parametry_Zemli_1990", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136 +rf=298.257839303 +towgs84=0,0,");
    add_proj4text (p, 1,
        "1.5,0,0,0.076,0 +no_defs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"PZ-90\",DATUM[\"Parametry Z");
    add_srs_wkt (p, 1,
        "emli 1990\",ELLIPSOID[\"PZ-90\",6378136,298.257839303,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Worl");
    add_srs_wkt (p, 9,
        "d\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4923]]],TARGETCR");
    add_srs_wkt (p, 10,
        "S[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\"");
    add_srs_wkt (p, 11,
        ",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 13,
        ",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\"");
    add_srs_wkt (p, 14,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 15,
        "],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 16,
        "0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFO");
    add_srs_wkt (p, 17,
        "RMATION[\"PZ-90 to WGS 84 (1)\",METHOD[\"Coordinate Fram");
    add_srs_wkt (p, 18,
        "e rotation (geog2D domain)\",ID[\"EPSG\",9607]],PARAMETE");
    add_srs_wkt (p, 19,
        "R[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[");
    add_srs_wkt (p, 20,
        "\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"");
    add_srs_wkt (p, 21,
        "Z-axis translation\",1.5,ID[\"EPSG\",8607]],PARAMETER[\"");
    add_srs_wkt (p, 22,
        "X-axis rotation\",0,ID[\"EPSG\",8608]],PARAMETER[\"Y-axi");
    add_srs_wkt (p, 23,
        "s rotation\",0,ID[\"EPSG\",8609]],PARAMETER[\"Z-axis rot");
    add_srs_wkt (p, 24,
        "ation\",-0.076,ID[\"EPSG\",8610]],PARAMETER[\"Scale diff");
    add_srs_wkt (p, 25,
        "erence\",1,ID[\"EPSG\",8611]],USAGE[SCOPE[\"unknown\"],A");
    add_srs_wkt (p, 26,
        "REA[\"World\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",15843]");
    add_srs_wkt (p, 27,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4925, "epsg", 4925,
        "Mauritania 1999", 1, 1,
        "GRS 1980", "Greenwich",
        "Mauritania_1999", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Mauritania 1999\",DATUM[\"M");
    add_srs_wkt (p, 1,
        "auritania 1999\",ELLIPSOID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"Mauritania\"],BBOX[14.72,-20.04,27.3,-4.8]],ID[\"EPS");
    add_srs_wkt (p, 10,
        "G\",4925]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World G");
    add_srs_wkt (p, 11,
        "eodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 12,
        "57223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 13,
        "0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoid");
    add_srs_wkt (p, 14,
        "al,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 15,
        "e\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[2");
    add_srs_wkt (p, 16,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",");
    add_srs_wkt (p, 17,
        "4326]]],ABRIDGEDTRANSFORMATION[\"Mauritania 1999 to WGS ");
    add_srs_wkt (p, 18,
        "84 (1)\",METHOD[\"Geocentric translations (geog2D domain");
    add_srs_wkt (p, 19,
        ")\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translation\",");
    add_srs_wkt (p, 20,
        "0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",0,");
    add_srs_wkt (p, 21,
        "ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0,ID");
    add_srs_wkt (p, 22,
        "[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Maurita");
    add_srs_wkt (p, 23,
        "nia\"],BBOX[14.72,-20.04,27.3,-4.8]],ID[\"EPSG\",15860]]");
    add_srs_wkt (p, 24,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4927, "epsg", 4927,
        "Korea 2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_datum_of_Korea", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Korea 2000\",DATUM[\"Geocen");
    add_srs_wkt (p, 1,
        "tric datum of Korea\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"]");
    add_srs_wkt (p, 9,
        ",AREA[\"Korea, Republic of (South Korea)\"],BBOX[28.6,12");
    add_srs_wkt (p, 10,
        "2.71,40.27,134.28]],ID[\"EPSG\",4927]]],TARGETCRS[GEOGCR");
    add_srs_wkt (p, 11,
        "S[\"WGS 84\",DATUM[\"World Geodetic System 1984\",ELLIPS");
    add_srs_wkt (p, 12,
        "OID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 13,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 14,
        "532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north");
    add_srs_wkt (p, 15,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 16,
        "[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 17,
        "532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATIO");
    add_srs_wkt (p, 18,
        "N[\"Korea 2000 to WGS 84 (1)\",METHOD[\"Geocentric trans");
    add_srs_wkt (p, 19,
        "lations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"");
    add_srs_wkt (p, 20,
        "X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-");
    add_srs_wkt (p, 21,
        "axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-ax");
    add_srs_wkt (p, 22,
        "is translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 23,
        "own\"],AREA[\"Korea, Republic of (South Korea)\"],BBOX[2");
    add_srs_wkt (p, 24,
        "8.6,122.71,40.27,134.28]],ID[\"EPSG\",15831]]]");
    p = add_epsg_def_ex (filter, first, last, 4929, "epsg", 4929,
        "POSGAR 94", 1, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"POSGAR 94\",DATUM[\"Posicio");
    add_srs_wkt (p, 1,
        "nes Geodesicas Argentinas 1994\",ELLIPSOID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],C");
    add_srs_wkt (p, 4,
        "S[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,");
    add_srs_wkt (p, 5,
        "ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[");
    add_srs_wkt (p, 6,
        "\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 7,
        "egree\",0.0174532925199433]],AXIS[\"ellipsoidal height (");
    add_srs_wkt (p, 8,
        "h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"Argentina\"],BBOX[-58.41,-73.59,-21.78");
    add_srs_wkt (p, 10,
        ",-52.63]],ID[\"EPSG\",4929]]],TARGETCRS[GEOGCRS[\"WGS 84");
    add_srs_wkt (p, 11,
        "\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS ");
    add_srs_wkt (p, 12,
        "84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 13,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 14,
        "433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1]");
    add_srs_wkt (p, 15,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longit");
    add_srs_wkt (p, 16,
        "ude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 17,
        "433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"POSGA");
    add_srs_wkt (p, 18,
        "R 94 to WGS 84 (1)\",METHOD[\"Geocentric translations (g");
    add_srs_wkt (p, 19,
        "eog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis tr");
    add_srs_wkt (p, 20,
        "anslation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis tran");
    add_srs_wkt (p, 21,
        "slation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis transl");
    add_srs_wkt (p, 22,
        "ation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 23,
        "EA[\"Argentina\"],BBOX[-58.41,-73.59,-21.78,-52.63]],ID[");
    add_srs_wkt (p, 24,
        "\"EPSG\",1210]]]");
    p = add_epsg_def_ex (filter, first, last, 4931, "epsg", 4931,
        "Australian Antarctic", 1, 1,
        "GRS 1980", "Greenwich",
        "Australian_Antarctic_Datum_1998", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Australian Antarctic\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Australian Antarctic Datum 1998\",ELLIPSOID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 4,
        "433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\"");
    add_srs_wkt (p, 5,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 6,
        "],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 7,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal h");
    add_srs_wkt (p, 8,
        "eight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[S");
    add_srs_wkt (p, 9,
        "COPE[\"unknown\"],AREA[\"Antarctica - Australian sector\"");
    add_srs_wkt (p, 10,
        "],BBOX[-90,45,-60,160]],ID[\"EPSG\",4931]]],TARGETCRS[GE");
    add_srs_wkt (p, 11,
        "OGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",EL");
    add_srs_wkt (p, 12,
        "LIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"me");
    add_srs_wkt (p, 13,
        "tre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 14,
        ".0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",");
    add_srs_wkt (p, 15,
        "north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 16,
        ",AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 17,
        ".0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFOR");
    add_srs_wkt (p, 18,
        "MATION[\"Australian Antarctic to WGS 84 (1)\",METHOD[\"G");
    add_srs_wkt (p, 19,
        "eocentric translations (geog2D domain)\",ID[\"EPSG\",960");
    add_srs_wkt (p, 20,
        "3]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]");
    add_srs_wkt (p, 21,
        "],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],");
    add_srs_wkt (p, 22,
        "PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],US");
    add_srs_wkt (p, 23,
        "AGE[SCOPE[\"unknown\"],AREA[\"Antarctica - Australian se");
    add_srs_wkt (p, 24,
        "ctor\"],BBOX[-90,45,-60,160]],ID[\"EPSG\",1890]]]");
    p = add_epsg_def_ex (filter, first, last, 4933, "epsg", 4933,
        "CHTRF95", 1, 1,
        "GRS 1980", "Greenwich",
        "Swiss_Terrestrial_Reference_Frame_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"CHTRF95\",DATUM[\"Swiss Ter");
    add_srs_wkt (p, 1,
        "restrial Reference Frame 1995\",ELLIPSOID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 4,
        "CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north");
    add_srs_wkt (p, 5,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 6,
        "[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 7,
        "degree\",0.0174532925199433]],AXIS[\"ellipsoidal height ");
    add_srs_wkt (p, 8,
        "(h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"Europe - Liechtenstein and Switzerland");
    add_srs_wkt (p, 10,
        "\"],BBOX[45.82,5.96,47.81,10.49]],ID[\"EPSG\",4933]]],TA");
    add_srs_wkt (p, 11,
        "RGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System");
    add_srs_wkt (p, 12,
        " 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGT");
    add_srs_wkt (p, 13,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 14,
        "degree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"l");
    add_srs_wkt (p, 15,
        "atitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 16,
        "25199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 17,
        "degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDG");
    add_srs_wkt (p, 18,
        "EDTRANSFORMATION[\"CHTRF95 to WGS 84 (1)\",METHOD[\"Geoc");
    add_srs_wkt (p, 19,
        "entric translations (geog2D domain)\",ID[\"EPSG\",9603]]");
    add_srs_wkt (p, 20,
        ",PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],P");
    add_srs_wkt (p, 21,
        "ARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PAR");
    add_srs_wkt (p, 22,
        "AMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE");
    add_srs_wkt (p, 23,
        "[SCOPE[\"unknown\"],AREA[\"Europe - Liechtenstein and Sw");
    add_srs_wkt (p, 24,
        "itzerland\"],BBOX[45.82,5.96,47.81,10.49]],ID[\"EPSG\",1");
    add_srs_wkt (p, 25,
        "511]]]");
    p = add_epsg_def_ex (filter, first, last, 4935, "epsg", 4935,
        "EST97", 1, 1,
        "GRS 1980", "Greenwich",
        "Estonia_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"EST97\",DATUM[\"Estonia 199");
    add_srs_wkt (p, 1,
        "7\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Estonia\"]");
    add_srs_wkt (p, 9,
        ",BBOX[57.52,20.37,60,28.2]],ID[\"EPSG\",4935]]],TARGETCR");
    add_srs_wkt (p, 10,
        "S[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\"");
    add_srs_wkt (p, 11,
        ",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 13,
        ",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\"");
    add_srs_wkt (p, 14,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 15,
        "],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 16,
        "0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFO");
    add_srs_wkt (p, 17,
        "RMATION[\"EST97 to WGS 84 (1)\",METHOD[\"Geocentric tran");
    add_srs_wkt (p, 18,
        "slations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[");
    add_srs_wkt (p, 19,
        "\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"");
    add_srs_wkt (p, 20,
        "Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-");
    add_srs_wkt (p, 21,
        "axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"un");
    add_srs_wkt (p, 22,
        "known\"],AREA[\"Estonia\"],BBOX[57.52,20.37,60,28.2]],ID");
    add_srs_wkt (p, 23,
        "[\"EPSG\",1649]]]");
    p = add_epsg_def_ex (filter, first, last, 4937, "epsg", 4937,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"ETRS89\",DATUM[\"European T");
    add_srs_wkt (p, 1,
        "errestrial Reference System 1989\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 3,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 4,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 5,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 6,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 7,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 8,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 9,
        "[\"unknown\"],AREA[\"Europe - ETRS89\"],BBOX[32.88,-16.1");
    add_srs_wkt (p, 10,
        ",84.17,40.18]],ID[\"EPSG\",4937]]],TARGETCRS[GEOGCRS[\"W");
    add_srs_wkt (p, 11,
        "GS 84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"");
    add_srs_wkt (p, 12,
        "WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 13,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 14,
        "5199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDE");
    add_srs_wkt (p, 15,
        "R[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"lo");
    add_srs_wkt (p, 16,
        "ngitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 17,
        "5199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"E");
    add_srs_wkt (p, 18,
        "TRS89 to WGS 84 (1)\",METHOD[\"Geocentric translations (");
    add_srs_wkt (p, 19,
        "geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis t");
    add_srs_wkt (p, 20,
        "ranslation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis tra");
    add_srs_wkt (p, 21,
        "nslation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis trans");
    add_srs_wkt (p, 22,
        "lation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],A");
    add_srs_wkt (p, 23,
        "REA[\"Europe - ETRS89\"],BBOX[32.88,-16.1,84.17,40.18]],");
    add_srs_wkt (p, 24,
        "ID[\"EPSG\",1149]]]");
    p = add_epsg_def_ex (filter, first, last, 4939, "epsg", 4939,
        "GDA94", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"GDA94\",DATUM[\"Geocentric ");
    add_srs_wkt (p, 1,
        "Datum of Australia 1994\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"Australia - GDA\"],BBOX[-60.56,93.41,-8.47,");
    add_srs_wkt (p, 10,
        "173.35]],ID[\"EPSG\",4939]]],TARGETCRS[GEOGCRS[\"WGS 84\"");
    add_srs_wkt (p, 11,
        ",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84");
    add_srs_wkt (p, 12,
        "\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIME");
    add_srs_wkt (p, 13,
        "M[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 14,
        "3]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],A");
    add_srs_wkt (p, 15,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitud");
    add_srs_wkt (p, 16,
        "e\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 17,
        "3]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"GDA94 t");
    add_srs_wkt (p, 18,
        "o WGS 84 (1)\",METHOD[\"Geocentric translations (geog2D ");
    add_srs_wkt (p, 19,
        "domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translat");
    add_srs_wkt (p, 20,
        "ion\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translatio");
    add_srs_wkt (p, 21,
        "n\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\"");
    add_srs_wkt (p, 22,
        ",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Au");
    add_srs_wkt (p, 23,
        "stralia - GDA\"],BBOX[-60.56,93.41,-8.47,173.35]],ID[\"E");
    add_srs_wkt (p, 24,
        "PSG\",1150]]]");
    p = add_epsg_def_ex (filter, first, last, 4941, "epsg", 4941,
        "Hartebeesthoek94", 1, 1,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Hartebeesthoek94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Hartebeesthoek94\",ELLIPSOID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"Africa - South Africa, Lesotho and Eswatini.\"],BBOX");
    add_srs_wkt (p, 10,
        "[-50.32,13.33,-22.13,42.85]],ID[\"EPSG\",4941]]],TARGETC");
    add_srs_wkt (p, 11,
        "RS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984");
    add_srs_wkt (p, 12,
        "\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT");
    add_srs_wkt (p, 13,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 14,
        "e\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitu");
    add_srs_wkt (p, 15,
        "de\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 16,
        "433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 17,
        "e\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRA");
    add_srs_wkt (p, 18,
        "NSFORMATION[\"Hartebeesthoek94 to WGS 84 (1)\",METHOD[\"");
    add_srs_wkt (p, 19,
        "Geocentric translations (geog2D domain)\",ID[\"EPSG\",96");
    add_srs_wkt (p, 20,
        "03]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605");
    add_srs_wkt (p, 21,
        "]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]]");
    add_srs_wkt (p, 22,
        ",PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],U");
    add_srs_wkt (p, 23,
        "SAGE[SCOPE[\"unknown\"],AREA[\"Africa - South Africa, Le");
    add_srs_wkt (p, 24,
        "sotho and Eswatini.\"],BBOX[-50.32,13.33,-22.13,42.85]],");
    add_srs_wkt (p, 25,
        "ID[\"EPSG\",1505]]]");
    p = add_epsg_def_ex (filter, first, last, 4943, "epsg", 4943,
        "IRENET95", 1, 1,
        "GRS 1980", "Greenwich",
        "IRENET95", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"IRENET95\",DATUM[\"IRENET95");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Europe - Ire");
    add_srs_wkt (p, 9,
        "land (Republic and Ulster) - onshore\"],BBOX[51.39,-10.5");
    add_srs_wkt (p, 10,
        "6,55.43,-5.34]],ID[\"EPSG\",4943]]],TARGETCRS[GEOGCRS[\"");
    add_srs_wkt (p, 11,
        "WGS 84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[");
    add_srs_wkt (p, 12,
        "\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 13,
        "]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 14,
        "925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,OR");
    add_srs_wkt (p, 15,
        "DER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 16,
        "longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 17,
        "925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"");
    add_srs_wkt (p, 18,
        "IRENET95 to WGS 84 (1)\",METHOD[\"Geocentric translation");
    add_srs_wkt (p, 19,
        "s (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axi");
    add_srs_wkt (p, 20,
        "s translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis ");
    add_srs_wkt (p, 21,
        "translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis tr");
    add_srs_wkt (p, 22,
        "anslation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 23,
        "],AREA[\"Europe - Ireland (Republic and Ulster) - onshor");
    add_srs_wkt (p, 24,
        "e\"],BBOX[51.39,-10.56,55.43,-5.34]],ID[\"EPSG\",1678]]]");
    p = add_epsg_def_ex (filter, first, last, 4945, "epsg", 4945,
        "ISN93", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"ISN93\",DATUM[\"Islands Net");
    add_srs_wkt (p, 1,
        " 1993\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LEN");
    add_srs_wkt (p, 2,
        "GTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[");
    add_srs_wkt (p, 3,
        "\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"");
    add_srs_wkt (p, 4,
        "geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433]],AXIS[\"geodetic longitude (Lo");
    add_srs_wkt (p, 6,
        "n)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 7,
        "33]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHU");
    add_srs_wkt (p, 8,
        "NIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Icelan");
    add_srs_wkt (p, 9,
        "d\"],BBOX[59.96,-30.87,69.59,-5.55]],ID[\"EPSG\",4945]]]");
    add_srs_wkt (p, 10,
        ",TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic Sys");
    add_srs_wkt (p, 11,
        "tem 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LE");
    add_srs_wkt (p, 12,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 13,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[");
    add_srs_wkt (p, 14,
        "\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 15,
        "32925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT");
    add_srs_wkt (p, 16,
        "[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABR");
    add_srs_wkt (p, 17,
        "IDGEDTRANSFORMATION[\"ISN93 to WGS 84 (1)\",METHOD[\"Geo");
    add_srs_wkt (p, 18,
        "centric translations (geog2D domain)\",ID[\"EPSG\",9603]");
    add_srs_wkt (p, 19,
        "],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],");
    add_srs_wkt (p, 20,
        "PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PA");
    add_srs_wkt (p, 21,
        "RAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAG");
    add_srs_wkt (p, 22,
        "E[SCOPE[\"unknown\"],AREA[\"Iceland\"],BBOX[59.96,-30.87");
    add_srs_wkt (p, 23,
        ",69.59,-5.55]],ID[\"EPSG\",1952]]]");
    p = add_epsg_def_ex (filter, first, last, 4947, "epsg", 4947,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"JGD2000\",DATUM[\"Japanese ");
    add_srs_wkt (p, 1,
        "Geodetic Datum 2000\",ELLIPSOID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 2,
        ".257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 4,
        "dal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],A");
    add_srs_wkt (p, 5,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic");
    add_srs_wkt (p, 6,
        " longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.");
    add_srs_wkt (p, 7,
        "0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,OR");
    add_srs_wkt (p, 8,
        "DER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"]");
    add_srs_wkt (p, 9,
        ",AREA[\"Japan\"],BBOX[17.09,122.38,46.05,157.65]],ID[\"E");
    add_srs_wkt (p, 10,
        "PSG\",4947]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World");
    add_srs_wkt (p, 11,
        " Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 12,
        ".257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 13,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 14,
        "dal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 15,
        "ee\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[");
    add_srs_wkt (p, 16,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",4326]]],ABRIDGEDTRANSFORMATION[\"JGD2000 to WGS 84 (1)\"");
    add_srs_wkt (p, 18,
        ",METHOD[\"Geocentric translations (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 22,
        ",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Japan\"],BBOX[17");
    add_srs_wkt (p, 23,
        ".09,122.38,46.05,157.65]],ID[\"EPSG\",1826]]]");
    p = add_epsg_def_ex (filter, first, last, 4949, "epsg", 4949,
        "LKS92", 1, 1,
        "GRS 1980", "Greenwich",
        "Latvia_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"LKS92\",DATUM[\"Latvia 1992");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Latvia\"],BB");
    add_srs_wkt (p, 9,
        "OX[55.67,19.06,58.09,28.24]],ID[\"EPSG\",4949]]],TARGETC");
    add_srs_wkt (p, 10,
        "RS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984");
    add_srs_wkt (p, 11,
        "\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 13,
        "e\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitu");
    add_srs_wkt (p, 14,
        "de\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 15,
        "433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 16,
        "e\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRA");
    add_srs_wkt (p, 17,
        "NSFORMATION[\"LKS92 to WGS 84 (1)\",METHOD[\"Geocentric ");
    add_srs_wkt (p, 18,
        "translations (geog2D domain)\",ID[\"EPSG\",9603]],PARAME");
    add_srs_wkt (p, 19,
        "TER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETE");
    add_srs_wkt (p, 20,
        "R[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[");
    add_srs_wkt (p, 21,
        "\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[");
    add_srs_wkt (p, 22,
        "\"unknown\"],AREA[\"Latvia\"],BBOX[55.67,19.06,58.09,28.");
    add_srs_wkt (p, 23,
        "24]],ID[\"EPSG\",1958]]]");
    p = add_epsg_def_ex (filter, first, last, 4951, "epsg", 4951,
        "LKS94", 1, 1,
        "GRS 1980", "Greenwich",
        "Lithuania_1994_ETRS89", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"LKS94\",DATUM[\"Lithuania 1");
    add_srs_wkt (p, 1,
        "994 (ETRS89)\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[");
    add_srs_wkt (p, 9,
        "\"Lithuania\"],BBOX[53.89,19.02,56.45,26.82]],ID[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",4951]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geod");
    add_srs_wkt (p, 11,
        "etic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 12,
        "23563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 13,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 14,
        "2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 15,
        ",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[2],A");
    add_srs_wkt (p, 16,
        "NGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",432");
    add_srs_wkt (p, 17,
        "6]]],ABRIDGEDTRANSFORMATION[\"LKS94 to WGS 84 (1)\",METH");
    add_srs_wkt (p, 18,
        "OD[\"Geocentric translations (geog2D domain)\",ID[\"EPSG");
    add_srs_wkt (p, 19,
        "\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8");
    add_srs_wkt (p, 21,
        "606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",860");
    add_srs_wkt (p, 22,
        "7]],USAGE[SCOPE[\"unknown\"],AREA[\"Lithuania\"],BBOX[53");
    add_srs_wkt (p, 23,
        ".89,19.02,56.45,26.82]],ID[\"EPSG\",1283]]]");
    p = add_epsg_def_ex (filter, first, last, 4953, "epsg", 4953,
        "Moznet", 1, 1,
        "WGS 84", "Greenwich",
        "Moznet_ITRF94", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Moznet\",DATUM[\"Moznet (IT");
    add_srs_wkt (p, 1,
        "RF94)\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Mozambi");
    add_srs_wkt (p, 9,
        "que\"],BBOX[-27.71,30.21,-10.09,43.03]],ID[\"EPSG\",4953");
    add_srs_wkt (p, 10,
        "]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic ");
    add_srs_wkt (p, 11,
        "System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 12,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 13,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],AX");
    add_srs_wkt (p, 14,
        "IS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01");
    add_srs_wkt (p, 15,
        "74532925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 16,
        "NIT[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],");
    add_srs_wkt (p, 17,
        "ABRIDGEDTRANSFORMATION[\"Moznet to WGS 84 (1)\",METHOD[\"");
    add_srs_wkt (p, 18,
        "Coordinate Frame rotation (geog2D domain)\",ID[\"EPSG\",");
    add_srs_wkt (p, 19,
        "9607]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",86");
    add_srs_wkt (p, 20,
        "05]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606");
    add_srs_wkt (p, 21,
        "]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]]");
    add_srs_wkt (p, 22,
        ",PARAMETER[\"X-axis rotation\",0,ID[\"EPSG\",8608]],PARA");
    add_srs_wkt (p, 23,
        "METER[\"Y-axis rotation\",0,ID[\"EPSG\",8609]],PARAMETER");
    add_srs_wkt (p, 24,
        "[\"Z-axis rotation\",0,ID[\"EPSG\",8610]],PARAMETER[\"Sc");
    add_srs_wkt (p, 25,
        "ale difference\",1,ID[\"EPSG\",8611]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 26,
        "own\"],AREA[\"Mozambique\"],BBOX[-27.71,30.21,-10.09,43.");
    add_srs_wkt (p, 27,
        "03]],ID[\"EPSG\",1302]]]");
    p = add_epsg_def_ex (filter, first, last, 4955, "epsg", 4955,
        "NAD83(CSRS)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"NAD83(CSRS)\",DATUM[\"NAD83");
    add_srs_wkt (p, 1,
        " Canadian Spatial Reference System\",ELLIPSOID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 4,
        "33]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",");
    add_srs_wkt (p, 5,
        "north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUN");
    add_srs_wkt (p, 7,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal he");
    add_srs_wkt (p, 8,
        "ight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SC");
    add_srs_wkt (p, 9,
        "OPE[\"unknown\"],AREA[\"Canada\"],BBOX[40.04,-141.01,86.");
    add_srs_wkt (p, 10,
        "46,-47.74]],ID[\"EPSG\",4955]]],TARGETCRS[GEOGCRS[\"WGS ");
    add_srs_wkt (p, 11,
        "84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WG");
    add_srs_wkt (p, 12,
        "S 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 13,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 14,
        "99433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[");
    add_srs_wkt (p, 15,
        "1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"long");
    add_srs_wkt (p, 16,
        "itude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 17,
        "99433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"NAD");
    add_srs_wkt (p, 18,
        "83(CSRS) to WGS 84 (1)\",METHOD[\"Geocentric translation");
    add_srs_wkt (p, 19,
        "s (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axi");
    add_srs_wkt (p, 20,
        "s translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis ");
    add_srs_wkt (p, 21,
        "translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis tr");
    add_srs_wkt (p, 22,
        "anslation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 23,
        "],AREA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]],ID[");
    add_srs_wkt (p, 24,
        "\"EPSG\",1842]]]");
    p = add_epsg_def_ex (filter, first, last, 4957, "epsg", 4957,
        "NAD83(HARN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"NAD83(HARN)\",DATUM[\"NAD83");
    add_srs_wkt (p, 1,
        " (High Accuracy Reference Network)\",ELLIPSOID[\"GRS 198");
    add_srs_wkt (p, 2,
        "0\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 4,
        "33]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",");
    add_srs_wkt (p, 5,
        "north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUN");
    add_srs_wkt (p, 7,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal he");
    add_srs_wkt (p, 8,
        "ight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SC");
    add_srs_wkt (p, 9,
        "OPE[\"unknown\"],AREA[\"USA - HARN\"],BBOX[-14.59,144.58");
    add_srs_wkt (p, 10,
        ",71.4,-64.51]],ID[\"EPSG\",4957]]],TARGETCRS[GEOGCRS[\"W");
    add_srs_wkt (p, 11,
        "GS 84\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"");
    add_srs_wkt (p, 12,
        "WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 13,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 14,
        "5199433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDE");
    add_srs_wkt (p, 15,
        "R[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"lo");
    add_srs_wkt (p, 16,
        "ngitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 17,
        "5199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"N");
    add_srs_wkt (p, 18,
        "AD83(HARN) to WGS 84 (1)\",METHOD[\"Geocentric translati");
    add_srs_wkt (p, 19,
        "ons (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-a");
    add_srs_wkt (p, 20,
        "xis translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axi");
    add_srs_wkt (p, 21,
        "s translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis ");
    add_srs_wkt (p, 22,
        "translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown");
    add_srs_wkt (p, 23,
        "\"],AREA[\"USA - HARN\"],BBOX[-14.59,144.58,71.4,-64.51]");
    add_srs_wkt (p, 24,
        "],ID[\"EPSG\",1580]]]");
    p = add_epsg_def_ex (filter, first, last, 4959, "epsg", 4959,
        "NZGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"NZGD2000\",DATUM[\"New Zeal");
    add_srs_wkt (p, 1,
        "and Geodetic Datum 2000\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkno");
    add_srs_wkt (p, 9,
        "wn\"],AREA[\"New Zealand\"],BBOX[-55.95,160.6,-25.88,-17");
    add_srs_wkt (p, 10,
        "1.2]],ID[\"EPSG\",4959]]],TARGETCRS[GEOGCRS[\"WGS 84\",D");
    add_srs_wkt (p, 11,
        "ATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\"");
    add_srs_wkt (p, 12,
        ",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 13,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 14,
        "],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANG");
    add_srs_wkt (p, 15,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitude\"");
    add_srs_wkt (p, 16,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 17,
        ",ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"NZGD2000 t");
    add_srs_wkt (p, 18,
        "o WGS 84 (1)\",METHOD[\"Geocentric translations (geog2D ");
    add_srs_wkt (p, 19,
        "domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translat");
    add_srs_wkt (p, 20,
        "ion\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translatio");
    add_srs_wkt (p, 21,
        "n\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\"");
    add_srs_wkt (p, 22,
        ",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Ne");
    add_srs_wkt (p, 23,
        "w Zealand\"],BBOX[-55.95,160.6,-25.88,-171.2]],ID[\"EPSG");
    add_srs_wkt (p, 24,
        "\",1565]]]");
    p = add_epsg_def_ex (filter, first, last, 4961, "epsg", 4961,
        "POSGAR 98", 1, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"POSGAR 98\",DATUM[\"Posicio");
    add_srs_wkt (p, 1,
        "nes Geodesicas Argentinas 1998\",ELLIPSOID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 4,
        "CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north");
    add_srs_wkt (p, 5,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 6,
        "[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 7,
        "degree\",0.0174532925199433]],AXIS[\"ellipsoidal height ");
    add_srs_wkt (p, 8,
        "(h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"Argentina\"],BBOX[-58.41,-73.59,-21.78");
    add_srs_wkt (p, 10,
        ",-52.63]],ID[\"EPSG\",4961]]],TARGETCRS[GEOGCRS[\"WGS 84");
    add_srs_wkt (p, 11,
        "\",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS ");
    add_srs_wkt (p, 12,
        "84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 13,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 14,
        "433]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1]");
    add_srs_wkt (p, 15,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longit");
    add_srs_wkt (p, 16,
        "ude\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 17,
        "433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"POSGA");
    add_srs_wkt (p, 18,
        "R 98 to WGS 84 (1)\",METHOD[\"Geocentric translations (g");
    add_srs_wkt (p, 19,
        "eog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis tr");
    add_srs_wkt (p, 20,
        "anslation\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis tran");
    add_srs_wkt (p, 21,
        "slation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis transl");
    add_srs_wkt (p, 22,
        "ation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 23,
        "EA[\"Argentina\"],BBOX[-58.41,-73.59,-21.78,-52.63]],ID[");
    add_srs_wkt (p, 24,
        "\"EPSG\",1773]]]");
    p = add_epsg_def_ex (filter, first, last, 4963, "epsg", 4963,
        "REGVEN", 1, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Venezolana", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"REGVEN\",DATUM[\"Red Geodes");
    add_srs_wkt (p, 1,
        "ica Venezolana\",ELLIPSOID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],ARE");
    add_srs_wkt (p, 9,
        "A[\"Venezuela\"],BBOX[0.64,-73.38,16.75,-58.95]],ID[\"EP");
    add_srs_wkt (p, 10,
        "SG\",4963]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World ");
    add_srs_wkt (p, 11,
        "Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 12,
        "257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 13,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 14,
        "dal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 15,
        "ee\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[");
    add_srs_wkt (p, 16,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",4326]]],ABRIDGEDTRANSFORMATION[\"REGVEN to WGS 84 (1)\"");
    add_srs_wkt (p, 18,
        ",METHOD[\"Geocentric translations (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 22,
        ",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Venezuela\"],BBO");
    add_srs_wkt (p, 23,
        "X[0.64,-73.38,16.75,-58.95]],ID[\"EPSG\",1768]]]");
    p = add_epsg_def_ex (filter, first, last, 4965, "epsg", 4965,
        "RGF93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGF93\",DATUM[\"Reseau Geod");
    add_srs_wkt (p, 1,
        "esique Francais 1993\",ELLIPSOID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellips");
    add_srs_wkt (p, 4,
        "oidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1]");
    add_srs_wkt (p, 5,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodet");
    add_srs_wkt (p, 6,
        "ic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 7,
        "0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,");
    add_srs_wkt (p, 8,
        "ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 9,
        "],AREA[\"France\"],BBOX[41.15,-9.86,51.56,10.38]],ID[\"E");
    add_srs_wkt (p, 10,
        "PSG\",4965]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World");
    add_srs_wkt (p, 11,
        " Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 12,
        ".257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 13,
        ",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoi");
    add_srs_wkt (p, 14,
        "dal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 15,
        "ee\",0.0174532925199433]],AXIS[\"longitude\",east,ORDER[");
    add_srs_wkt (p, 16,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",4326]]],ABRIDGEDTRANSFORMATION[\"RGF93 to WGS 84 (1)\",");
    add_srs_wkt (p, 18,
        "METHOD[\"Geocentric translations (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\"");
    add_srs_wkt (p, 22,
        ",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"France\"],BBOX[4");
    add_srs_wkt (p, 23,
        "1.15,-9.86,51.56,10.38]],ID[\"EPSG\",1671]]]");
    p = add_epsg_def_ex (filter, first, last, 4967, "epsg", 4967,
        "RGFG95", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGFG95\",DATUM[\"Reseau Geo");
    add_srs_wkt (p, 1,
        "desique Francais Guyane 1995\",ELLIPSOID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],C");
    add_srs_wkt (p, 4,
        "S[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,");
    add_srs_wkt (p, 5,
        "ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[");
    add_srs_wkt (p, 6,
        "\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"d");
    add_srs_wkt (p, 7,
        "egree\",0.0174532925199433]],AXIS[\"ellipsoidal height (");
    add_srs_wkt (p, 8,
        "h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"French Guiana\"],BBOX[2.11,-54.6,8.88,");
    add_srs_wkt (p, 10,
        "-49.46]],ID[\"EPSG\",4967]]],TARGETCRS[GEOGCRS[\"WGS 84\"");
    add_srs_wkt (p, 11,
        ",DATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84");
    add_srs_wkt (p, 12,
        "\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIME");
    add_srs_wkt (p, 13,
        "M[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 14,
        "3]],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],A");
    add_srs_wkt (p, 15,
        "NGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitud");
    add_srs_wkt (p, 16,
        "e\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 17,
        "3]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"RGFG95 ");
    add_srs_wkt (p, 18,
        "to WGS 84 (2)\",METHOD[\"Geocentric translations (geog2D");
    add_srs_wkt (p, 19,
        " domain)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis transla");
    add_srs_wkt (p, 20,
        "tion\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translati");
    add_srs_wkt (p, 21,
        "on\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation");
    add_srs_wkt (p, 22,
        "\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 23,
        "French Guiana\"],BBOX[2.11,-54.6,8.88,-49.46]],ID[\"EPSG");
    add_srs_wkt (p, 24,
        "\",4840]]]");
    p = add_epsg_def_ex (filter, first, last, 4969, "epsg", 4969,
        "RGNC91-93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Nouvelle_Caledonie_91_93", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGNC91-93\",DATUM[\"Reseau ");
    add_srs_wkt (p, 1,
        "Geodesique de Nouvelle Caledonie 91-93\",ELLIPSOID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat");
    add_srs_wkt (p, 5,
        ")\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANG");
    add_srs_wkt (p, 7,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoida");
    add_srs_wkt (p, 8,
        "l height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAG");
    add_srs_wkt (p, 9,
        "E[SCOPE[\"unknown\"],AREA[\"New Caledonia\"],BBOX[-26.45");
    add_srs_wkt (p, 10,
        ",156.25,-14.83,174.28]],ID[\"EPSG\",4907]]],TARGETCRS[GE");
    add_srs_wkt (p, 11,
        "OGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",EL");
    add_srs_wkt (p, 12,
        "LIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"me");
    add_srs_wkt (p, 13,
        "tre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 14,
        ".0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\",");
    add_srs_wkt (p, 15,
        "north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 16,
        ",AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 17,
        ".0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFOR");
    add_srs_wkt (p, 18,
        "MATION[\"RGNC91-93 to WGS 84 (1)\",METHOD[\"Geocentric t");
    add_srs_wkt (p, 19,
        "ranslations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMET");
    add_srs_wkt (p, 20,
        "ER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER");
    add_srs_wkt (p, 21,
        "[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"");
    add_srs_wkt (p, 22,
        "Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 23,
        "unknown\"],AREA[\"New Caledonia\"],BBOX[-26.45,156.25,-1");
    add_srs_wkt (p, 24,
        "4.83,174.28]],ID[\"EPSG\",15880]]]");
    p = add_epsg_def_ex (filter, first, last, 4971, "epsg", 4971,
        "RGR92", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RGR92\",DATUM[\"Reseau Geod");
    add_srs_wkt (p, 1,
        "esique de la Reunion 1992\",ELLIPSOID[\"GRS 1980\",63781");
    add_srs_wkt (p, 2,
        "37,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gree");
    add_srs_wkt (p, 3,
        "nwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[e");
    add_srs_wkt (p, 4,
        "llipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORD");
    add_srs_wkt (p, 5,
        "ER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"g");
    add_srs_wkt (p, 6,
        "eodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 7,
        "ee\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\"");
    add_srs_wkt (p, 8,
        ",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unkn");
    add_srs_wkt (p, 9,
        "own\"],AREA[\"Reunion\"],BBOX[-24.72,51.83,-18.28,58.24]");
    add_srs_wkt (p, 10,
        "],ID[\"EPSG\",4971]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM");
    add_srs_wkt (p, 11,
        "[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\",637");
    add_srs_wkt (p, 12,
        "8137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Gr");
    add_srs_wkt (p, 13,
        "eenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS");
    add_srs_wkt (p, 14,
        "[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 15,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"longitude\",ea");
    add_srs_wkt (p, 16,
        "st,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID");
    add_srs_wkt (p, 17,
        "[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"RGR92 to WGS ");
    add_srs_wkt (p, 18,
        "84 (1)\",METHOD[\"Geocentric translations (geog2D domain");
    add_srs_wkt (p, 19,
        ")\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translation\",");
    add_srs_wkt (p, 20,
        "0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",0,");
    add_srs_wkt (p, 21,
        "ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0,ID");
    add_srs_wkt (p, 22,
        "[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Reunion");
    add_srs_wkt (p, 23,
        "\"],BBOX[-24.72,51.83,-18.28,58.24]],ID[\"EPSG\",1912]]]");
    p = add_epsg_def_ex (filter, first, last, 4973, "epsg", 4973,
        "RRAF 1991", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"RRAF 1991\",DATUM[\"Reseau ");
    add_srs_wkt (p, 1,
        "de Reference des Antilles Francaises 1991\",ELLIPSOID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 4,
        "925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (");
    add_srs_wkt (p, 5,
        "Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],");
    add_srs_wkt (p, 7,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipso");
    add_srs_wkt (p, 8,
        "idal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],U");
    add_srs_wkt (p, 9,
        "SAGE[SCOPE[\"unknown\"],AREA[\"Caribbean - French Antill");
    add_srs_wkt (p, 10,
        "es\"],BBOX[14.08,-63.66,18.54,-57.52]],ID[\"EPSG\",4557]");
    add_srs_wkt (p, 11,
        "]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic S");
    add_srs_wkt (p, 12,
        "ystem 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,");
    add_srs_wkt (p, 13,
        "LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUN");
    add_srs_wkt (p, 14,
        "IT[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],AXI");
    add_srs_wkt (p, 15,
        "S[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 16,
        "4532925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUN");
    add_srs_wkt (p, 17,
        "IT[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],A");
    add_srs_wkt (p, 18,
        "BRIDGEDTRANSFORMATION[\"RRAF 1991 to WGS 84 (1)\",METHOD");
    add_srs_wkt (p, 19,
        "[\"Geocentric translations (geog2D domain)\",ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",9603]],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8");
    add_srs_wkt (p, 21,
        "605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",860");
    add_srs_wkt (p, 22,
        "6]],PARAMETER[\"Z-axis translation\",0,ID[\"EPSG\",8607]");
    add_srs_wkt (p, 23,
        "],USAGE[SCOPE[\"unknown\"],AREA[\"Caribbean - French Ant");
    add_srs_wkt (p, 24,
        "illes\"],BBOX[14.08,-63.66,18.54,-57.52]],ID[\"EPSG\",45");
    add_srs_wkt (p, 25,
        "60]]]");
    p = add_epsg_def_ex (filter, first, last, 4975, "epsg", 4975,
        "SIRGAS 1995", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"SIRGAS 1995\",DATUM[\"Siste");
    add_srs_wkt (p, 1,
        "ma de Referencia Geocentrico para America del Sur 1995\"");
    add_srs_wkt (p, 2,
        ",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT");
    add_srs_wkt (p, 3,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodet");
    add_srs_wkt (p, 5,
        "ic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 6,
        "0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",e");
    add_srs_wkt (p, 7,
        "ast,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],A");
    add_srs_wkt (p, 8,
        "XIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 9,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"South Americ");
    add_srs_wkt (p, 10,
        "a - SIRGAS 1995 by country\"],BBOX[-59.87,-113.21,16.75,");
    add_srs_wkt (p, 11,
        "-26]],ID[\"EPSG\",4975]]],TARGETCRS[GEOGCRS[\"WGS 84\",D");
    add_srs_wkt (p, 12,
        "ATUM[\"World Geodetic System 1984\",ELLIPSOID[\"WGS 84\"");
    add_srs_wkt (p, 13,
        ",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 14,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 15,
        "],CS[ellipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANG");
    add_srs_wkt (p, 16,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"longitude\"");
    add_srs_wkt (p, 17,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 18,
        ",ID[\"EPSG\",4326]]],ABRIDGEDTRANSFORMATION[\"SIRGAS to ");
    add_srs_wkt (p, 19,
        "WGS 84 (1)\",METHOD[\"Geocentric translations (geog2D do");
    add_srs_wkt (p, 20,
        "main)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translatio");
    add_srs_wkt (p, 21,
        "n\",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\"");
    add_srs_wkt (p, 22,
        ",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0");
    add_srs_wkt (p, 23,
        ",ID[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Sout");
    add_srs_wkt (p, 24,
        "h America - SIRGAS 1995 by country\"],BBOX[-59.87,-113.2");
    add_srs_wkt (p, 25,
        "1,16.75,-26]],ID[\"EPSG\",1581]]]");
    p = add_epsg_def_ex (filter, first, last, 4977, "epsg", 4977,
        "SWEREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"SWEREF99\",DATUM[\"SWEREF99");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Sweden\"],BB");
    add_srs_wkt (p, 9,
        "OX[54.96,10.03,69.07,24.17]],ID[\"EPSG\",4977]]],TARGETC");
    add_srs_wkt (p, 10,
        "RS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984");
    add_srs_wkt (p, 11,
        "\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 13,
        "e\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitu");
    add_srs_wkt (p, 14,
        "de\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 15,
        "433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 16,
        "e\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRA");
    add_srs_wkt (p, 17,
        "NSFORMATION[\"SWEREF99 to WGS 84 (1)\",METHOD[\"Geocentr");
    add_srs_wkt (p, 18,
        "ic translations (geog2D domain)\",ID[\"EPSG\",9603]],PAR");
    add_srs_wkt (p, 19,
        "AMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAM");
    add_srs_wkt (p, 20,
        "ETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMET");
    add_srs_wkt (p, 21,
        "ER[\"Z-axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCO");
    add_srs_wkt (p, 22,
        "PE[\"unknown\"],AREA[\"Sweden\"],BBOX[54.96,10.03,69.07,");
    add_srs_wkt (p, 23,
        "24.17]],ID[\"EPSG\",1879]]]");
    p = add_epsg_def_ex (filter, first, last, 4979, "epsg", 4979,
        "WGS 84", 1, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"World (by count");
    add_srs_wkt (p, 9,
        "ry)\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4979]]");
    p = add_epsg_def_ex (filter, first, last, 4981, "epsg", 4981,
        "Yemen NGN96", 1, 1,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"Yemen NGN96\",DATUM[\"Yemen");
    add_srs_wkt (p, 1,
        " National Geodetic Network 1996\",ELLIPSOID[\"WGS 84\",6");
    add_srs_wkt (p, 2,
        "378137,298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 4,
        "CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north");
    add_srs_wkt (p, 5,
        ",ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 6,
        "[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"");
    add_srs_wkt (p, 7,
        "degree\",0.0174532925199433]],AXIS[\"ellipsoidal height ");
    add_srs_wkt (p, 8,
        "(h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"");
    add_srs_wkt (p, 9,
        "unknown\"],AREA[\"Yemen\"],BBOX[8.95,41.08,19,57.96]],ID");
    add_srs_wkt (p, 10,
        "[\"EPSG\",4981]]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 11,
        "orld Geodetic System 1984\",ELLIPSOID[\"WGS 84\",6378137");
    add_srs_wkt (p, 12,
        ",298.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 13,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 14,
        "ipsoidal,2],AXIS[\"latitude\",north,ORDER[1],ANGLEUNIT[\"");
    add_srs_wkt (p, 15,
        "degree\",0.0174532925199433]],AXIS[\"longitude\",east,OR");
    add_srs_wkt (p, 16,
        "DER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],ID[\"EP");
    add_srs_wkt (p, 17,
        "SG\",4326]]],ABRIDGEDTRANSFORMATION[\"Yemen NGN96 to WGS");
    add_srs_wkt (p, 18,
        " 84 (1)\",METHOD[\"Geocentric translations (geog2D domai");
    add_srs_wkt (p, 19,
        "n)\",ID[\"EPSG\",9603]],PARAMETER[\"X-axis translation\"");
    add_srs_wkt (p, 20,
        ",0,ID[\"EPSG\",8605]],PARAMETER[\"Y-axis translation\",0");
    add_srs_wkt (p, 21,
        ",ID[\"EPSG\",8606]],PARAMETER[\"Z-axis translation\",0,I");
    add_srs_wkt (p, 22,
        "D[\"EPSG\",8607]],USAGE[SCOPE[\"unknown\"],AREA[\"Yemen\"");
    add_srs_wkt (p, 23,
        "],BBOX[8.95,41.08,19,57.96]],ID[\"EPSG\",1540]]]");
    p = add_epsg_def_ex (filter, first, last, 4983, "epsg", 4983,
        "IGM95", 1, 1,
        "WGS 84", "Greenwich",
        "Istituto_Geografico_Militaire_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"IGM95\",DATUM[\"Istituto Ge");
    add_srs_wkt (p, 1,
        "ografico Militaire 1995\",ELLIPSOID[\"WGS 84\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellip");
    add_srs_wkt (p, 4,
        "soidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1");
    add_srs_wkt (p, 5,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geode");
    add_srs_wkt (p, 6,
        "tic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 7,
        ",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up");
    add_srs_wkt (p, 8,
        ",ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown");
    add_srs_wkt (p, 9,
        "\"],AREA[\"Italy - including San Marino and Vatican\"],B");
    add_srs_wkt (p, 10,
        "BOX[34.76,5.93,47.1,18.99]],ID[\"EPSG\",4983]]],TARGETCR");
    add_srs_wkt (p, 11,
        "S[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\"");
    add_srs_wkt (p, 12,
        ",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 13,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 14,
        ",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitude\"");
    add_srs_wkt (p, 15,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 16,
        "],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 17,
        "0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRANSFO");
    add_srs_wkt (p, 18,
        "RMATION[\"IGM95 to WGS 84 (1)\",METHOD[\"Geocentric tran");
    add_srs_wkt (p, 19,
        "slations (geog2D domain)\",ID[\"EPSG\",9603]],PARAMETER[");
    add_srs_wkt (p, 20,
        "\"X-axis translation\",0,ID[\"EPSG\",8605]],PARAMETER[\"");
    add_srs_wkt (p, 21,
        "Y-axis translation\",0,ID[\"EPSG\",8606]],PARAMETER[\"Z-");
    add_srs_wkt (p, 22,
        "axis translation\",0,ID[\"EPSG\",8607]],USAGE[SCOPE[\"un");
    add_srs_wkt (p, 23,
        "known\"],AREA[\"Italy - including San Marino and Vatican");
    add_srs_wkt (p, 24,
        "\"],BBOX[34.76,5.93,47.1,18.99]],ID[\"EPSG\",1099]]]");
    p = add_epsg_def_ex (filter, first, last, 4985, "epsg", 4985,
        "WGS 72", 1, 1,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.");
    add_proj4text (p, 1,
        "2263 +no_defs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"WGS 72\",DATUM[\"World Geod");
    add_srs_wkt (p, 1,
        "etic System 1972\",ELLIPSOID[\"WGS 72\",6378135,298.26,L");
    add_srs_wkt (p, 2,
        "ENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNI");
    add_srs_wkt (p, 3,
        "T[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS");
    add_srs_wkt (p, 4,
        "[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433]],AXIS[\"geodetic longitude ");
    add_srs_wkt (p, 6,
        "(Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 7,
        "99433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENG");
    add_srs_wkt (p, 8,
        "THUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Wor");
    add_srs_wkt (p, 9,
        "ld\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4985]]],TARGETC");
    add_srs_wkt (p, 10,
        "RS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984");
    add_srs_wkt (p, 11,
        "\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degre");
    add_srs_wkt (p, 13,
        "e\",0.0174532925199433]],CS[ellipsoidal,2],AXIS[\"latitu");
    add_srs_wkt (p, 14,
        "de\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 15,
        "433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUNIT[\"degre");
    add_srs_wkt (p, 16,
        "e\",0.0174532925199433]],ID[\"EPSG\",4326]]],ABRIDGEDTRA");
    add_srs_wkt (p, 17,
        "NSFORMATION[\"WGS 72 to WGS 84 (1)\",METHOD[\"Position V");
    add_srs_wkt (p, 18,
        "ector transformation (geog2D domain)\",ID[\"EPSG\",9606]");
    add_srs_wkt (p, 19,
        "],PARAMETER[\"X-axis translation\",0,ID[\"EPSG\",8605]],");
    add_srs_wkt (p, 20,
        "PARAMETER[\"Y-axis translation\",0,ID[\"EPSG\",8606]],PA");
    add_srs_wkt (p, 21,
        "RAMETER[\"Z-axis translation\",4.5,ID[\"EPSG\",8607]],PA");
    add_srs_wkt (p, 22,
        "RAMETER[\"X-axis rotation\",0,ID[\"EPSG\",8608]],PARAMET");
    add_srs_wkt (p, 23,
        "ER[\"Y-axis rotation\",0,ID[\"EPSG\",8609]],PARAMETER[\"");
    add_srs_wkt (p, 24,
        "Z-axis rotation\",0.554,ID[\"EPSG\",8610]],PARAMETER[\"S");
    add_srs_wkt (p, 25,
        "cale difference\",1.0000002263,ID[\"EPSG\",8611]],USAGE[");
    add_srs_wkt (p, 26,
        "SCOPE[\"unknown\"],AREA[\"World\"],BBOX[-90,-180,90,180]");
    add_srs_wkt (p, 27,
        "],ID[\"EPSG\",1237]]]");
    p = add_epsg_def_ex (filter, first, last, 4987, "epsg", 4987,
        "WGS 72BE", 1, 1,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0");
    add_proj4text (p, 1,
        ".38 +no_defs");
    add_srs_wkt (p, 0,
        "BOUNDCRS[SOURCECRS[GEOGCRS[\"WGS 72BE\",DATUM[\"WGS 72 T");
    add_srs_wkt (p, 1,
        "ransit Broadcast Ephemeris\",ELLIPSOID[\"WGS 72\",637813");
    add_srs_wkt (p, 2,
        "5,298.26,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoid");
    add_srs_wkt (p, 4,
        "al,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],AN");
    add_srs_wkt (p, 5,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic ");
    add_srs_wkt (p, 6,
        "longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 7,
        "174532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORD");
    add_srs_wkt (p, 8,
        "ER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],");
    add_srs_wkt (p, 9,
        "AREA[\"World\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4987]");
    add_srs_wkt (p, 10,
        "]],TARGETCRS[GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic S");
    add_srs_wkt (p, 11,
        "ystem 1984\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,");
    add_srs_wkt (p, 12,
        "LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUN");
    add_srs_wkt (p, 13,
        "IT[\"degree\",0.0174532925199433]],CS[ellipsoidal,2],AXI");
    add_srs_wkt (p, 14,
        "S[\"latitude\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 15,
        "4532925199433]],AXIS[\"longitude\",east,ORDER[2],ANGLEUN");
    add_srs_wkt (p, 16,
        "IT[\"degree\",0.0174532925199433]],ID[\"EPSG\",4326]]],A");
    add_srs_wkt (p, 17,
        "BRIDGEDTRANSFORMATION[\"WGS 72BE to WGS 84 (1)\",METHOD[");
    add_srs_wkt (p, 18,
        "\"Position Vector transformation (geog2D domain)\",ID[\"");
    add_srs_wkt (p, 19,
        "EPSG\",9606]],PARAMETER[\"X-axis translation\",0,ID[\"EP");
    add_srs_wkt (p, 20,
        "SG\",8605]],PARAMETER[\"Y-axis translation\",0,ID[\"EPSG");
    add_srs_wkt (p, 21,
        "\",8606]],PARAMETER[\"Z-axis translation\",1.9,ID[\"EPSG");
    add_srs_wkt (p, 22,
        "\",8607]],PARAMETER[\"X-axis rotation\",0,ID[\"EPSG\",86");
    add_srs_wkt (p, 23,
        "08]],PARAMETER[\"Y-axis rotation\",0,ID[\"EPSG\",8609]],");
    add_srs_wkt (p, 24,
        "PARAMETER[\"Z-axis rotation\",0.814,ID[\"EPSG\",8610]],P");
    add_srs_wkt (p, 25,
        "ARAMETER[\"Scale difference\",0.99999962,ID[\"EPSG\",861");
    add_srs_wkt (p, 26,
        "1]],USAGE[SCOPE[\"unknown\"],AREA[\"World - WGS72 BE to ");
    add_srs_wkt (p, 27,
        "WGS 84 - by country\"],BBOX[-90,-180,90,180]],ID[\"EPSG\"");
    add_srs_wkt (p, 28,
        ",1240]]]");
}

#endif /* full EPSG initialization enabled/disabled */

