/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Sat May  4 11:57:02 2019

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_02 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 2209, "epsg", 2209,
        "ED50 / 3-degree Gauss-Kruger zone 12", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-84.1,-101.8,-129.7,0,0,0.468,1.05],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",36],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",125000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2209\"]]");
    p = add_epsg_def_ex (filter, first, last, 2210, "epsg", 2210,
        "ED50 / 3-degree Gauss-Kruger zone 13", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-84.1,-101.8,-129.7,0,0,0.468,1.05],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",39],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",135000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2210\"]]");
    p = add_epsg_def_ex (filter, first, last, 2211, "epsg", 2211,
        "ED50 / 3-degree Gauss-Kruger zone 14", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-84.1,-101.8,-129.7,0,0,0.468,1.05],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",42],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",145000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2211\"]]");
    p = add_epsg_def_ex (filter, first, last, 2212, "epsg", 2212,
        "ED50 / 3-degree Gauss-Kruger zone 15", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / 3-degree Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-84.1,-101.8,-129.7,0,0,0.468,1.05],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6230\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4230\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",45],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",155000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2212\"]]");
    p = add_epsg_def_ex (filter, first, last, 2213, "epsg", 2213,
        "ETRS89 / TM 30 NE", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / TM 30 NE\",GEOGCS[\"ETRS89\",DATUM[\"E");
    add_srs_wkt (p, 1,
        "uropean_Terrestrial_Reference_System_1989\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",30],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2213\"]]");
    p = add_epsg_def_ex (filter, first, last, 2214, "epsg", 2214,
        "Douala 1948 / AEF west", 0, 0,
        "International 1924", "Greenwich",
        "Douala_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +");
    add_proj4text (p, 1,
        "y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Douala 1948 / AEF west\",GEOGCS[\"Douala 1948\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Douala_1948\",SPHEROID[\"International 1924\",6");
    add_srs_wkt (p, 2,
        "378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-206.1,");
    add_srs_wkt (p, 3,
        "-174.7,-87.7,0,0,0,0],AUTHORITY[\"EPSG\",\"6192\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4192\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",10.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.999],PARAMETER[\"false_easting\",1000000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3119\"]]");
    p = add_epsg_def_ex (filter, first, last, 2215, "epsg", 2215,
        "Manoca 1962 / UTM zone 32N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Manoca_1962", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-70.");
    add_proj4text (p, 1,
        "9,-151.8,-41.4,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Manoca 1962 / UTM zone 32N\",GEOGCS[\"Manoca 19");
    add_srs_wkt (p, 1,
        "62\",DATUM[\"Manoca_1962\",SPHEROID[\"Clarke 1880 (IGN)\"");
    add_srs_wkt (p, 2,
        ",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[-70.9,-151.8,-41.4,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6193\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4193\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2215\"]]");
    p = add_epsg_def_ex (filter, first, last, 2216, "epsg", 2216,
        "Qornoq 1927 / UTM zone 22N", 0, 0,
        "International 1924", "Greenwich",
        "Qornoq_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=intl +towgs84=164,138,-189,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Qornoq 1927 / UTM zone 22N\",GEOGCS[\"Qornoq 19");
    add_srs_wkt (p, 1,
        "27\",DATUM[\"Qornoq_1927\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[163");
    add_srs_wkt (p, 3,
        ".511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6194\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4194\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2216\"]]");
    p = add_epsg_def_ex (filter, first, last, 2217, "epsg", 2217,
        "Qornoq 1927 / UTM zone 23N", 0, 0,
        "International 1924", "Greenwich",
        "Qornoq_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=intl +towgs84=164,138,-189,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Qornoq 1927 / UTM zone 23N\",GEOGCS[\"Qornoq 19");
    add_srs_wkt (p, 1,
        "27\",DATUM[\"Qornoq_1927\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[163");
    add_srs_wkt (p, 3,
        ".511,127.533,-159.789,0,0,0.814,-0.6],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6194\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4194\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-45],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2217\"]]");
    p = add_epsg_def_ex (filter, first, last, 2219, "epsg", 2219,
        "ATS77 / UTM zone 19N", 0, 0,
        "Average Terrestrial System 1977", "Greenwich",
        "Average_Terrestrial_System_1977", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +a=6378135 +b=6356750.304921594 +unit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATS77 / UTM zone 19N\",GEOGCS[\"ATS77\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Average_Terrestrial_System_1977\",SPHEROID[\"Average Ter");
    add_srs_wkt (p, 2,
        "restrial System 1977\",6378135,298.257,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7041\"]],AUTHORITY[\"EPSG\",\"6122\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4122\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-69],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2219\"]]");
    p = add_epsg_def_ex (filter, first, last, 2220, "epsg", 2220,
        "ATS77 / UTM zone 20N", 0, 0,
        "Average Terrestrial System 1977", "Greenwich",
        "Average_Terrestrial_System_1977", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +a=6378135 +b=6356750.304921594 +unit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATS77 / UTM zone 20N\",GEOGCS[\"ATS77\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Average_Terrestrial_System_1977\",SPHEROID[\"Average Ter");
    add_srs_wkt (p, 2,
        "restrial System 1977\",6378135,298.257,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7041\"]],AUTHORITY[\"EPSG\",\"6122\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4122\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-63],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2220\"]]");
    p = add_epsg_def_ex (filter, first, last, 2222, "epsg", 2222,
        "NAD83 / Arizona East (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona East (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-110.166666666667],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",700000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2222\"]]");
    p = add_epsg_def_ex (filter, first, last, 2223, "epsg", 2223,
        "NAD83 / Arizona Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona Central (ft)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",31],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-111.916666666667],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",700000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2223\"]]");
    p = add_epsg_def_ex (filter, first, last, 2224, "epsg", 2224,
        "NAD83 / Arizona West (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Arizona West (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-113.75],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.999933333],PARAMETER[\"false_easting\",700000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2224\"]]");
    p = add_epsg_def_ex (filter, first, last, 2225, "epsg", 2225,
        "NAD83 / California zone 1 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=5000");
    add_proj4text (p, 2,
        "00.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 1 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.3333333333333],PARAMETER[\"central_meridian\",-122],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",41.6666666666667],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",40],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",6561666.667],PARAMETER[\"false_northing\",1640416.");
    add_srs_wkt (p, 12,
        "667],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 14,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2225\"]]");
    p = add_epsg_def_ex (filter, first, last, 2226, "epsg", 2226,
        "NAD83 / California zone 2 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.00");
    add_proj4text (p, 2,
        "01016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 2 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",37.6666666666667],PARAMETER[\"central_meridian\",-122],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",39.8333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",38.3333333333333],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",6561666.667],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",1640416.667],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 13,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2226\"]]");
    p = add_epsg_def_ex (filter, first, last, 2227, "epsg", 2227,
        "NAD83 / California zone 3 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=");
    add_proj4text (p, 2,
        "500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 3,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 3 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36.5],PARAMETER[\"central_meridian\",-120.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",38.4333333333333],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",37.0666666666667],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",6561666.667],PARAMETER[\"false_northing\",1640");
    add_srs_wkt (p, 12,
        "416.667],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2227\"]]");
    p = add_epsg_def_ex (filter, first, last, 2228, "epsg", 2228,
        "NAD83 / California zone 4 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.000101600");
    add_proj4text (p, 2,
        "1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 4 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",35.3333333333333],PARAMETER[\"central_meridian\",-119],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",37.25],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_2\",36],PARAMETER[\"false_easting\",65616");
    add_srs_wkt (p, 11,
        "66.667],PARAMETER[\"false_northing\",1640416.667],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"2228\"]]");
    p = add_epsg_def_ex (filter, first, last, 2229, "epsg", 2229,
        "NAD83 / California zone 5 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=50");
    add_proj4text (p, 2,
        "0000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 3,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 5 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",33.5],PARAMETER[\"central_meridian\",-118],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",35.4666666666667],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",34.0333333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",6561666.667],PARAMETER[\"false_northing\",164041");
    add_srs_wkt (p, 12,
        "6.667],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 14,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2229\"]]");
    p = add_epsg_def_ex (filter, first, last, 2230, "epsg", 2230,
        "NAD83 / California zone 6 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000");
    add_proj4text (p, 2,
        ".0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / California zone 6 (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",32.1666666666667],PARAMETER[\"central_meridian\",-116.2");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_1\",33.8833333333333],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",32.7833333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",6561666.667],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",1640416.667],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2230\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2231, "epsg", 2231,
        "NAD83 / Colorado North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",39.");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"central_meridian\",-105.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_1\",40.7833333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",39.7166666666667],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",3000000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "1000000],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2231\"]]");
    p = add_epsg_def_ex (filter, first, last, 2232, "epsg", 2232,
        "NAD83 / Colorado Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.60");
    add_proj4text (p, 2,
        "96012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado Central (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "37.8333333333333],PARAMETER[\"central_meridian\",-105.5]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_1\",39.75],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",38.45],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 11,
        "000000],PARAMETER[\"false_northing\",1000000],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"2232\"]]");
    p = add_epsg_def_ex (filter, first, last, 2233, "epsg", 2233,
        "NAD83 / Colorado South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8");
    add_proj4text (p, 2,
        "288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Colorado South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"central_meridian\",-105.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_1\",38.4333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",37.2333333333333],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",3000000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "1000000],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"2233\"]]");
    p = add_epsg_def_ex (filter, first, last, 2234, "epsg", 2234,
        "NAD83 / Connecticut (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_");
    add_proj4text (p, 2,
        "0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 3,
        "+units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Connecticut (ftUS)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",40.83");
    add_srs_wkt (p, 8,
        "33333333333],PARAMETER[\"central_meridian\",-72.75],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_1\",41.8666666666667],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",41.2],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",1000000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"2234\"]]");
    p = add_epsg_def_ex (filter, first, last, 2235, "epsg", 2235,
        "NAD83 / Delaware (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Delaware (ftUS)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",38],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-75.4166666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999995],PARAMETER[\"false_easting\",656166.66");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 11,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"2235\"]]");
    p = add_epsg_def_ex (filter, first, last, 2236, "epsg", 2236,
        "NAD83 / Florida East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2,
        "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida East (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",24.3333333333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"central_meridian\",-81],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.999941177],PARAMETER[\"false_easting\",656");
    add_srs_wkt (p, 10,
        "166.667],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 11,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"2236\"]]");
    p = add_epsg_def_ex (filter, first, last, 2237, "epsg", 2237,
        "NAD83 / Florida West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2,
        "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida West (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",24.3333333333");
    add_srs_wkt (p, 8,
        "333],PARAMETER[\"central_meridian\",-82],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.999941177],PARAMETER[\"false_easting\",656");
    add_srs_wkt (p, 10,
        "166.667],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 11,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"2237\"]]");
    p = add_epsg_def_ex (filter, first, last, 2238, "epsg", 2238,
        "NAD83 / Florida North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Florida North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",29]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-84.5],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",30.75],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",29.5833333333333],PARAMETER[\"false_easting\",1968500],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"2238\"]]");
    p = add_epsg_def_ex (filter, first, last, 2239, "epsg", 2239,
        "NAD83 / Georgia East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Georgia East (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-82.1666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",656166.6");
    add_srs_wkt (p, 10,
        "67],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 11,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"2239\"]]");
    p = add_epsg_def_ex (filter, first, last, 2240, "epsg", 2240,
        "NAD83 / Georgia West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Georgia West (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",30],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-84.1666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",2296583.");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"2240\"]]");
    p = add_epsg_def_ex (filter, first, last, 2241, "epsg", 2241,
        "NAD83 / Idaho East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho East (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",41.66666666666");
    add_srs_wkt (p, 8,
        "67],PARAMETER[\"central_meridian\",-112.166666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",0.999947368],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",656166.667],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"2241\"]]");
    p = add_epsg_def_ex (filter, first, last, 2242, "epsg", 2242,
        "NAD83 / Idaho Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho Central (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",41.66666666");
    add_srs_wkt (p, 8,
        "66667],PARAMETER[\"central_meridian\",-114],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.999947368],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "1640416.667],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2242\"]]");
    p = add_epsg_def_ex (filter, first, last, 2243, "epsg", 2243,
        "NAD83 / Idaho West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Idaho West (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",41.66666666666");
    add_srs_wkt (p, 8,
        "67],PARAMETER[\"central_meridian\",-115.75],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.999933333],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "2624666.667],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2243\"]]");
    p = add_epsg_def_ex (filter, first, last, 2244, "epsg", 2244,
        "NAD83 / Indiana East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Indiana East (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-85.6666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.999966667],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 10,
        "28083.333],PARAMETER[\"false_northing\",820208.333],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"2965\"]]");
    p = add_epsg_def_ex (filter, first, last, 2245, "epsg", 2245,
        "NAD83 / Indiana West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Indiana West (ftUS)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",37.5],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-87.0833333333333],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.999966667],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "952750],PARAMETER[\"false_northing\",820208.333],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2966\"]]");
    p = add_epsg_def_ex (filter, first, last, 2246, "epsg", 2246,
        "NAD83 / Kentucky North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37.");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-84.25],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",37.9666666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",38.9666666666667],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",1640416.667],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 12,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2246\"]]");
    p = add_epsg_def_ex (filter, first, last, 2247, "epsg", 2247,
        "NAD83 / Kentucky South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0");
    add_proj4text (p, 2,
        "001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 3,
        ",0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Kentucky South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"central_meridian\",-85.75],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_1\",37.9333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",36.7333333333333],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",1640416.667],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",1640416.667],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2247\"]]");
    p = add_epsg_def_ex (filter, first, last, 2248, "epsg", 2248,
        "NAD83 / Maryland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maryland (ftUS)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37.66666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-77],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",39.45],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_2\",38.3],PARAMETER[\"false_easting\",1312333.333],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"2248\"]]");
    p = add_epsg_def_ex (filter, first, last, 2249, "epsg", 2249,
        "NAD83 / Massachusetts Mainland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=7");
    add_proj4text (p, 2,
        "50000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Massachusetts Mainland (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",41],PARAMETER[\"central_meridian\",-71.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",42.6833333333333],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",41.7166666666667],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",656166.667],PARAMETER[\"false_northing\",24606");
    add_srs_wkt (p, 12,
        "25],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 14,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2249\"]]");
    p = add_epsg_def_ex (filter, first, last, 2250, "epsg", 2250,
        "NAD83 / Massachusetts Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0");
    add_proj4text (p, 2,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Massachusetts Island (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",41],PARAMETER[\"central_meridian\",-70.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",41.4833333333333],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",41.2833333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",1640416.667],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"2250\"]]");
    p = add_epsg_def_ex (filter, first, last, 2251, "epsg", 2251,
        "NAD83 / Michigan North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999");
    add_proj4text (p, 2,
        "968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan North (ft)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",44.78");
    add_srs_wkt (p, 8,
        "33333333333],PARAMETER[\"central_meridian\",-87],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",47.0833333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",45.4833333333333],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",26246719.16],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"2251\"]]");
    p = add_epsg_def_ex (filter, first, last, 2252, "epsg", 2252,
        "NAD83 / Michigan Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43");
    add_proj4text (p, 1,
        ".31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.9");
    add_proj4text (p, 2,
        "99976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 3,
        "ts=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan Central (ft)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 8,
        "3166666666667],PARAMETER[\"central_meridian\",-84.366666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"standard_parallel_1\",45.7],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_2\",44.1833333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",19685039.37],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"2252\"]]");
    p = add_epsg_def_ex (filter, first, last, 2253, "epsg", 2253,
        "NAD83 / Michigan South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41");
    add_proj4text (p, 1,
        ".5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Michigan South (ft)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-84.3666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",43.6666666666667],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",42.1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",13123359.58],PARAMETER[\"false_northing\",0],UNIT[\"f");
    add_srs_wkt (p, 12,
        "oot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "2253\"]]");
    p = add_epsg_def_ex (filter, first, last, 2254, "epsg", 2254,
        "NAD83 / Mississippi East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi East (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",29.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-88.8333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.99995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "984250],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"2254\"]]");
    p = add_epsg_def_ex (filter, first, last, 2255, "epsg", 2255,
        "NAD83 / Mississippi West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "9995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi West (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",29.5],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-90.3333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.99995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "2296583.333],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2255\"]]");
    p = add_epsg_def_ex (filter, first, last, 2256, "epsg", 2256,
        "NAD83 / Montana (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5");
    add_proj4text (p, 1,
        " +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Montana (ft)\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Co");
    add_srs_wkt (p, 7,
        "nic_2SP\"],PARAMETER[\"latitude_of_origin\",44.25],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-109.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",49],PARAMETER[\"standard_parallel_2\",45],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",1968503.937],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2256\"]]");
    p = add_epsg_def_ex (filter, first, last, 2257, "epsg", 2257,
        "NAD83 / New Mexico East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico East (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",31],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-104.333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.999909091],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "541337.5],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2257\"]]");
    p = add_epsg_def_ex (filter, first, last, 2258, "epsg", 2258,
        "NAD83 / New Mexico Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=5000");
    add_proj4text (p, 1,
        "00.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico Central (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",31],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-106.25],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9999],PARAMETER[\"false_easting\",1640416.667]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 11,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"2258\"]]");
    p = add_epsg_def_ex (filter, first, last, 2259, "epsg", 2259,
        "NAD83 / New Mexico West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs");
    add_proj4text (p, 2,
        "84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico West (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",31],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-107.833333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.999916667],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "2723091.667],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2259\"]]");
    p = add_epsg_def_ex (filter, first, last, 2260, "epsg", 2260,
        "NAD83 / New York East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York East (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",38.83333333");
    add_srs_wkt (p, 8,
        "33333],PARAMETER[\"central_meridian\",-74.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",49212");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 11,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"2260\"]]");
    p = add_epsg_def_ex (filter, first, last, 2261, "epsg", 2261,
        "NAD83 / New York Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York Central (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",40],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-76.5833333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9999375],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "820208.333],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 11,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2261\"]]");
    p = add_epsg_def_ex (filter, first, last, 2262, "epsg", 2262,
        "NAD83 / New York West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York West (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-78.5833333333333],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9999375],PARAMETER[\"false_easting\",114");
    add_srs_wkt (p, 10,
        "8291.667],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"2262\"]]");
    p = add_epsg_def_ex (filter, first, last, 2263, "epsg", 2263,
        "NAD83 / New York Long Island (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000");
    add_proj4text (p, 2,
        "000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York Long Island (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",40.1666666666667],PARAMETER[\"central_meridian\",-74");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",41.0333333333333],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"standard_parallel_2\",40.6666666666667],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",984250],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2263\"]]");
    p = add_epsg_def_ex (filter, first, last, 2264, "epsg", 2264,
        "NAD83 / North Carolina (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Carolina (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",33.");
    add_srs_wkt (p, 8,
        "75],PARAMETER[\"central_meridian\",-79],PARAMETER[\"stan");
    add_srs_wkt (p, 9,
        "dard_parallel_1\",36.1666666666667],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",34.3333333333333],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"2264\"]]");
    p = add_epsg_def_ex (filter, first, last, 2265, "epsg", 2265,
        "NAD83 / North Dakota North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Dakota North (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"central_meridian\",-100.5],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_1\",48.7333333333333],PARAMETER[\"stand");
    add_srs_wkt (p, 10,
        "ard_parallel_2\",47.4333333333333],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",1968503.937],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"2265\"]]");
    p = add_epsg_def_ex (filter, first, last, 2266, "epsg", 2266,
        "NAD83 / North Dakota South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9");
    add_proj4text (p, 2,
        "999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / North Dakota South (ft)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "45.6666666666667],PARAMETER[\"central_meridian\",-100.5]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_1\",47.4833333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"standard_parallel_2\",46.1833333333333],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",1968503.937],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"2266\"]]");
    p = add_epsg_def_ex (filter, first, last, 2267, "epsg", 2267,
        "NAD83 / Oklahoma North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Oklahoma North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",35]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-98],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",36.7666666666667],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",35.5666666666667],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"2267\"]]");
    p = add_epsg_def_ex (filter, first, last, 2268, "epsg", 2268,
        "NAD83 / Oklahoma South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Oklahoma South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",33.");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"central_meridian\",-98],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",35.2333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",33.9333333333333],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",1968500],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 12,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"2268\"]]");
    p = add_epsg_def_ex (filter, first, last, 2269, "epsg", 2269,
        "NAD83 / Oregon North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Oregon North (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43.666");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"central_meridian\",-120.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",46],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",44.3333333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",8202099.738],PARAMETER[\"false_northing\",0],UNIT[\"foo");
    add_srs_wkt (p, 12,
        "t\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"226");
    add_srs_wkt (p, 14,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 2270, "epsg", 2270,
        "NAD83 / Oregon South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Oregon South (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",41.666");
    add_srs_wkt (p, 8,
        "6666666667],PARAMETER[\"central_meridian\",-120.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",44],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",42.3333333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",4921259.843],PARAMETER[\"false_northing\",0],UNIT[\"foo");
    add_srs_wkt (p, 12,
        "t\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"227");
    add_srs_wkt (p, 14,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 2271, "epsg", 2271,
        "NAD83 / Pennsylvania North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Pennsylvania North (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",40.1666666666667],PARAMETER[\"central_meridian\",-77.75");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",41.95],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",40.8833333333333],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",1968500],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"2271\"]]");
    p = add_epsg_def_ex (filter, first, last, 2272, "epsg", 2272,
        "NAD83 / Pennsylvania South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +");
    add_proj4text (p, 2,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Pennsylvania South (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.3333333333333],PARAMETER[\"central_meridian\",-77.75");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",40.9666666666667],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"standard_parallel_2\",39.9333333333333],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",1968500],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 14,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"2272\"]]");
    p = add_epsg_def_ex (filter, first, last, 2273, "epsg", 2273,
        "NAD83 / South Carolina (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31");
    add_proj4text (p, 1,
        ".83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / South Carolina (ft)\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",31.83");
    add_srs_wkt (p, 8,
        "33333333333],PARAMETER[\"central_meridian\",-81],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",34.8333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",32.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0");
    add_srs_wkt (p, 12,
        ".3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2273\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2274, "epsg", 2274,
        "NAD83 / Tennessee (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=3");
    add_proj4text (p, 1,
        "4.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Tennessee (ftUS)\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",34.33333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-86],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",36.4166666666667],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",35.25],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 11,
        "968500],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"2274\"]]");
    p = add_epsg_def_ex (filter, first, last, 2275, "epsg", 2275,
        "NAD83 / Texas North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.99989");
    add_proj4text (p, 2,
        "83998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas North (ftUS)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",34],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-101.5],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_1\",36.1833333333333],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",34.65],PARAMETER[\"false_easting\",656166.66");
    add_srs_wkt (p, 11,
        "7],PARAMETER[\"false_northing\",3280833.333],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"2275\"]]");
    p = add_epsg_def_ex (filter, first, last, 2276, "epsg", 2276,
        "NAD83 / Texas North Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333");
    add_proj4text (p, 1,
        "333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y");
    add_proj4text (p, 2,
        "_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 3,
        "units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas North Central (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",31.6666666666667],PARAMETER[\"central_meridian\",-98.");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_1\",33.9666666666667],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",32.1333333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",1968500],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",6561666.667],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2276\"]]");
    p = add_epsg_def_ex (filter, first, last, 2277, "epsg", 2277,
        "NAD83 / Texas Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84");
    add_proj4text (p, 3,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas Central (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",29.");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"central_meridian\",-100.33333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"standard_parallel_1\",31.8833333333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"standard_parallel_2\",30.1166666666667]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",2296583.333],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",9842500],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"227");
    add_srs_wkt (p, 15,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 2278, "epsg", 2278,
        "NAD83 / Texas South Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas South Central (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambe");
    add_srs_wkt (p, 7,
        "rt_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",27.8333333333333],PARAMETER[\"central_meridian\",-99]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_1\",30.2833333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"standard_parallel_2\",28.3833333333333],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",1968500],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",13123333.333],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2278\"]]");
    p = add_epsg_def_ex (filter, first, last, 2279, "epsg", 2279,
        "NAD83 / Texas South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.00");
    add_proj4text (p, 2,
        "00000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Texas South (ftUS)\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",25.66");
    add_srs_wkt (p, 8,
        "66666666667],PARAMETER[\"central_meridian\",-98.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",27.8333333333333],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"standard_parallel_2\",26.1666666666667],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",984250],PARAMETER[\"false_northing\",1640");
    add_srs_wkt (p, 12,
        "4166.667],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2279\"]]");
    p = add_epsg_def_ex (filter, first, last, 2280, "epsg", 2280,
        "NAD83 / Utah North (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Utah North (ft)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",40.33333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-111.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",41.7833333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",40.7166666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",1640419.948],PARAMETER[\"false_northing\",32");
    add_srs_wkt (p, 12,
        "80839.895],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "2\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"2280\"]]");
    p = add_epsg_def_ex (filter, first, last, 2281, "epsg", 2281,
        "NAD83 / Utah Central (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=");
    add_proj4text (p, 2,
        "1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Utah Central (ft)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",38.333");
    add_srs_wkt (p, 8,
        "3333333333],PARAMETER[\"central_meridian\",-111.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"standard_parallel_1\",40.65],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",39.0166666666667],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",1640419.948],PARAMETER[\"false_northing\",6561679.79");
    add_srs_wkt (p, 12,
        "],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"2281\"]]");
    p = add_epsg_def_ex (filter, first, last, 2282, "epsg", 2282,
        "NAD83 / Utah South (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=");
    add_proj4text (p, 2,
        "2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Utah South (ft)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.66666");
    add_srs_wkt (p, 8,
        "66666667],PARAMETER[\"central_meridian\",-111.5],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",38.35],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",37.2166666666667],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",1640419.948],PARAMETER[\"false_northing\",9842519.685],");
    add_srs_wkt (p, 12,
        "UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"2282\"]]");
    p = add_epsg_def_ex (filter, first, last, 2283, "epsg", 2283,
        "NAD83 / Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2");
    add_proj4text (p, 2,
        "000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Virginia North (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",37.");
    add_srs_wkt (p, 8,
        "6666666666667],PARAMETER[\"central_meridian\",-78.5],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",39.2],PARAMETER[\"standar");
    add_srs_wkt (p, 10,
        "d_parallel_2\",38.0333333333333],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",11482916.667],PARAMETER[\"false_northing\",6561666.");
    add_srs_wkt (p, 12,
        "667],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 14,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2283\"]]");
    p = add_epsg_def_ex (filter, first, last, 2284, "epsg", 2284,
        "NAD83 / Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0");
    add_proj4text (p, 2,
        "001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,");
    add_proj4text (p, 3,
        "0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Virginia South (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",36.");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"central_meridian\",-78.5],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",37.9666666666667],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"standard_parallel_2\",36.7666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",11482916.667],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",3280833.333],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2284\"]]");
    p = add_epsg_def_ex (filter, first, last, 2285, "epsg", 2285,
        "NAD83 / Washington North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0");
    add_proj4text (p, 2,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Washington North (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"central_meridian\",-120.833333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_1\",48.7333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",47.5],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",1640416.667],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 12,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2285\"]]");
    p = add_epsg_def_ex (filter, first, last, 2286, "epsg", 2286,
        "NAD83 / Washington South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0");
    add_proj4text (p, 2,
        "001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 3,
        "its=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Washington South (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "45.3333333333333],PARAMETER[\"central_meridian\",-120.5]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_1\",47.3333333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"standard_parallel_2\",45.8333333333333],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",1640416.667],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"2286\"]]");
    p = add_epsg_def_ex (filter, first, last, 2287, "epsg", 2287,
        "NAD83 / Wisconsin North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0");
    add_proj4text (p, 2,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wisconsin North (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 8,
        ".1666666666667],PARAMETER[\"central_meridian\",-90],PARA");
    add_srs_wkt (p, 9,
        "METER[\"standard_parallel_1\",46.7666666666667],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",45.5666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",1968500],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"2287\"]]");
    p = add_epsg_def_ex (filter, first, last, 2288, "epsg", 2288,
        "NAD83 / Wisconsin Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wisconsin Central (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43.8333333333333],PARAMETER[\"central_meridian\",-90],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",45.5],PARAMETER[\"stand");
    add_srs_wkt (p, 10,
        "ard_parallel_2\",44.25],PARAMETER[\"false_easting\",1968");
    add_srs_wkt (p, 11,
        "500],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"2288\"]]");
    p = add_epsg_def_ex (filter, first, last, 2289, "epsg", 2289,
        "NAD83 / Wisconsin South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Wisconsin South (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",42");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-90],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_1\",44.0666666666667],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",42.7333333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"2289\"]]");
    p = add_epsg_def_ex (filter, first, last, 2290, "epsg", 2290,
        "ATS77 / Prince Edward Isl. Stereographic (ATS77)", 0, 0,
        "Average Terrestrial System 1977", "Greenwich",
        "Average_Terrestrial_System_1977", "Oblique_Stereographic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=70");
    add_proj4text (p, 1,
        "0000 +y_0=400000 +a=6378135 +b=6356750.304921594 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATS77 / Prince Edward Isl. Stereographic (ATS77");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"ATS77\",DATUM[\"Average_Terrestrial_System_");
    add_srs_wkt (p, 2,
        "1977\",SPHEROID[\"Average Terrestrial System 1977\",6378");
    add_srs_wkt (p, 3,
        "135,298.257,AUTHORITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6122\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4122\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Oblique_Stereographic\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",47.25],PARAMETER[\"central_meridian\",-63],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.999912],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",700000],PARAMETER[\"false_northing\",400000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "290\"]]");
    p = add_epsg_def_ex (filter, first, last, 2291, "epsg", 2291,
        "NAD83(CSRS98) / Prince Edward Isl. Stereographic (NAD83) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Oblique_Stereographic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=40");
    add_proj4text (p, 1,
        "0000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / Prince Edward Isl. Stereographi");
    add_srs_wkt (p, 1,
        "c (NAD83) (deprecated)\",GEOGCS[\"NAD83(CSRS98) (depreca");
    add_srs_wkt (p, 2,
        "ted)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree minute second hemisphere\",0.0");
    add_srs_wkt (p, 7,
        "174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[");
    add_srs_wkt (p, 8,
        "\"EPSG\",\"4140\"]],PROJECTION[\"Oblique_Stereographic\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"latitude_of_origin\",47.25],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-63],PARAMETER[\"scale_factor\",0.99991");
    add_srs_wkt (p, 11,
        "2],PARAMETER[\"false_easting\",400000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2292\"]]");
    p = add_epsg_def_ex (filter, first, last, 2292, "epsg", 2292,
        "NAD83(CSRS) / Prince Edward Isl. Stereographic (NAD83)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Oblique_Stereographic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=40");
    add_proj4text (p, 1,
        "0000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Prince Edward Isl. Stereographic ");
    add_srs_wkt (p, 1,
        "(NAD83)\",GEOGCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4617\"]],PROJECTION[\"Oblique_Stereographic");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",47.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",-63],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "912],PARAMETER[\"false_easting\",400000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"2954\"]]");
    p = add_epsg_def_ex (filter, first, last, 2294, "epsg", 2294,
        "ATS77 / MTM Nova Scotia zone 4", 0, 0,
        "Average Terrestrial System 1977", "Greenwich",
        "Average_Terrestrial_System_1977", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=4500000");
    add_proj4text (p, 1,
        " +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATS77 / MTM Nova Scotia zone 4\",GEOGCS[\"ATS77");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Average_Terrestrial_System_1977\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Average Terrestrial System 1977\",6378135,298.257,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\",\"6122\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4122\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-61.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9999],PARAMETER[\"false_easting\",4500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"2294\"]]");
    p = add_epsg_def_ex (filter, first, last, 2295, "epsg", 2295,
        "ATS77 / MTM Nova Scotia zone 5", 0, 0,
        "Average Terrestrial System 1977", "Greenwich",
        "Average_Terrestrial_System_1977", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=5500000");
    add_proj4text (p, 1,
        " +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATS77 / MTM Nova Scotia zone 5\",GEOGCS[\"ATS77");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Average_Terrestrial_System_1977\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Average Terrestrial System 1977\",6378135,298.257,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7041\"]],AUTHORITY[\"EPSG\",\"6122\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4122\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-64.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9999],PARAMETER[\"false_easting\",5500000],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"2295\"]]");
    p = add_epsg_def_ex (filter, first, last, 2308, "epsg", 2308,
        "Batavia / TM 109 SE", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=109 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=10000000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / TM 109 SE\",GEOGCS[\"Batavia\",DATUM[");
    add_srs_wkt (p, 1,
        "\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.152");
    add_srs_wkt (p, 2,
        "8128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-378.873,676.");
    add_srs_wkt (p, 3,
        "002,-46.255,0,0,0,0],AUTHORITY[\"EPSG\",\"6211\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4211\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",109],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"2308\"]]");
    p = add_epsg_def_ex (filter, first, last, 2309, "epsg", 2309,
        "WGS 84 / TM 116 SE", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=116 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 116 SE\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"central_meridian\",116],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 8,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2309\"]]");
    p = add_epsg_def_ex (filter, first, last, 2310, "epsg", 2310,
        "WGS 84 / TM 132 SE", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 132 SE\",GEOGCS[\"WGS 84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"central_meridian\",132],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 8,
        "r\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2310\"]]");
    p = add_epsg_def_ex (filter, first, last, 2311, "epsg", 2311,
        "WGS 84 / TM 6 NE", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0");
    add_proj4text (p, 1,
        "=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 6 NE\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 6,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"central_meridian\",6],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 8,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 11,
        "H],AUTHORITY[\"EPSG\",\"2311\"]]");
    p = add_epsg_def_ex (filter, first, last, 2312, "epsg", 2312,
        "Garoua / UTM zone 33N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Garoua", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Garoua / UTM zone 33N\",GEOGCS[\"Garoua\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Garoua\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,2");
    add_srs_wkt (p, 2,
        "93.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"6197\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 4,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4197\"]],PROJECTIO");
    add_srs_wkt (p, 6,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 7,
        "n\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2312\"]]");
    p = add_epsg_def_ex (filter, first, last, 2313, "epsg", 2313,
        "Kousseri / UTM zone 33N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Kousseri", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kousseri / UTM zone 33N\",GEOGCS[\"Kousseri\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Kousseri\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6198\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4198\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",15],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2313\"]]");
    p = add_epsg_def_ex (filter, first, last, 2314, "epsg", 2314,
        "Trinidad 1903 / Trinidad Grid (ftCla)", 0, 0,
        "Clarke 1858", "Greenwich",
        "Trinidad_1903", "Cassini_Soldner", "Clarke's foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=10.44166666666667 +lon_0=-61.333333333");
    add_proj4text (p, 1,
        "33334 +x_0=86501.46392052001 +y_0=65379.0134283 +a=63782");
    add_proj4text (p, 2,
        "93.645208759 +b=6356617.987679838 +towgs84=-61.702,284.4");
    add_proj4text (p, 3,
        "88,472.052,0,0,0,0 +to_meter=0.3047972654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Trinidad 1903 / Trinidad Grid (ftCla)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Trinidad 1903\",DATUM[\"Trinidad_1903\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1858\",6378293.64520876,294.260676369261,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7007\"]],TOWGS84[-61.702,284.488,472.052,0,0,0,");
    add_srs_wkt (p, 4,
        "0],AUTHORITY[\"EPSG\",\"6302\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4302\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",10.4416666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-61.3333333333333],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",283800],PARAMETER[\"false_northing\",214500],UNIT[\"");
    add_srs_wkt (p, 11,
        "Clarke's foot\",0.3047972654,AUTHORITY[\"EPSG\",\"9005\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2314\"]]");
    p = add_epsg_def_ex (filter, first, last, 2315, "epsg", 2315,
        "Campo Inchauspe / UTM zone 19S", 0, 0,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=intl +towgs84=-148,136,");
    add_proj4text (p, 1,
        "90,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / UTM zone 19S\",GEOGCS[\"Campo");
    add_srs_wkt (p, 1,
        " Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2315\"]]");
    p = add_epsg_def_ex (filter, first, last, 2316, "epsg", 2316,
        "Campo Inchauspe / UTM zone 20S", 0, 0,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=intl +towgs84=-148,136,");
    add_proj4text (p, 1,
        "90,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / UTM zone 20S\",GEOGCS[\"Campo");
    add_srs_wkt (p, 1,
        " Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-148,136,90,0,0,0,0],AUTHORITY[\"EPSG\",\"6221\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4221\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2316\"]]");
    p = add_epsg_def_ex (filter, first, last, 2317, "epsg", 2317,
        "PSAD56 / ICN Regional", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=9 +lat_2=3 +lat_0=6 +lon_0=-66 +x_0=100");
    add_proj4text (p, 1,
        "0000 +y_0=1000000 +ellps=intl +towgs84=-288,175,-376,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / ICN Regional\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",6],PARAMETER[\"central_meridian\",-66],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",9],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",3],PARAMETER[\"false_easting\",1000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"2317\"]]");
    p = add_epsg_def_ex (filter, first, last, 2318, "epsg", 2318,
        "Ain el Abd / Aramco Lambert", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=17 +lat_2=33 +lat_0=25.08951 +lon_0=48 ");
    add_proj4text (p, 1,
        "+x_0=0 +y_0=0 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / Aramco Lambert\",GEOGCS[\"Ain el A");
    add_srs_wkt (p, 1,
        "bd\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4204\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",25.");
    add_srs_wkt (p, 8,
        "08951],PARAMETER[\"central_meridian\",48],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",17],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",33],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2318\"]]");
    p = add_epsg_def_ex (filter, first, last, 2319, "epsg", 2319,
        "ED50 / TM27", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM27\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
        "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-84.1,-101.8,-129");
    add_srs_wkt (p, 3,
        ".7,0,0,0.468,1.05],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",27],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2319\"]]");
    p = add_epsg_def_ex (filter, first, last, 2320, "epsg", 2320,
        "ED50 / TM30", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM30\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
        "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-84.1,-101.8,-129");
    add_srs_wkt (p, 3,
        ".7,0,0,0.468,1.05],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",30],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2320\"]]");
    p = add_epsg_def_ex (filter, first, last, 2321, "epsg", 2321,
        "ED50 / TM33", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM33\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
        "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-84.1,-101.8,-129");
    add_srs_wkt (p, 3,
        ".7,0,0,0.468,1.05],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",33],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2321\"]]");
    p = add_epsg_def_ex (filter, first, last, 2322, "epsg", 2322,
        "ED50 / TM36", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM36\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
        "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-84.1,-101.8,-129");
    add_srs_wkt (p, 3,
        ".7,0,0,0.468,1.05],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",36],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2322\"]]");
    p = add_epsg_def_ex (filter, first, last, 2323, "epsg", 2323,
        "ED50 / TM39", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM39\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
        "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-84.1,-101.8,-129");
    add_srs_wkt (p, 3,
        ".7,0,0,0.468,1.05],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",39],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2323\"]]");
    p = add_epsg_def_ex (filter, first, last, 2324, "epsg", 2324,
        "ED50 / TM42", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM42\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
        "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-84.1,-101.8,-129");
    add_srs_wkt (p, 3,
        ".7,0,0,0.468,1.05],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4230\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",42],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2324\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

