# -----------------------------------------------------------------------------
# Print the ratio between peak intensities for peaks with matching assignments
# in two spectra.  Use the accelerator "ir" twice to select the two spectra.
#
# The output is printed to the Python shell window.  Show this window with
# the Extensions/Python shell menu entry or py command.
#
# To make the "ir" command available when you start Sparky put this file
# in your Sparky/Python directory and have a sparky_init.py file in that
# directory containing
#
#       def initialize_session(session):
#         import peakratio
#         peakratio.register_accelerator(session, 'ir')
#

# -----------------------------------------------------------------------------
# Call this routine twice.  The first time it remembers the selected spectrum.
# Then select another spectrum and call it again.  It uses the remembered
# spectrum and the currently selected one to print peak intensity ratios.
#
first_spectrum = None
def peak_intensity_ratios(session):

  spectrum = session.selected_spectrum()
  if spectrum:
    global first_spectrum
    if first_spectrum == None:
      first_spectrum = spectrum
    else:
      print_peak_intensity_ratios(first_spectrum, spectrum)
      first_spectrum = None
  
# -----------------------------------------------------------------------------
# Print peak intensity ratios for two spectra.
#
def print_peak_intensity_ratios(spectrum1, spectrum2):

  peak_table = {}
  for p1 in spectrum1.peak_list():
    if p1.is_assigned:
      peak_table[p1.assignment] = p1

  import sputil
  for p2 in spectrum2.peak_list():
    if peak_table.has_key(p2.assignment):
      p1 = peak_table[p2.assignment]
      h1 = sputil.peak_height(p1)
      h2 = sputil.peak_height(p2)
      if h2 != 0:
        ratio = p1.data_height / p2.data_height
      else:
        ratio = 0
      print '%25s %5.2f %8.3g %8.3g' % (p2.assignment, ratio, h1, h2)

# -----------------------------------------------------------------------------
# Register accelerator.
#
def register_accelerator(session, accel):

  def cb(s=session):
    peak_intensity_ratios(s)
  session.add_command('ir', 'Peak intensity ratio', cb)

