# -----------------------------------------------------------------------------
# Command to put peak labels on all assigned peaks.
#

# -----------------------------------------------------------------------------
#
def initialize_session(session):

  cb = lambda s=session, f=label_assigned_peaks: f(s.selected_spectrum())
  session.add_command('lA', 'Assignment/Label Assigned Peaks', cb)
  
# -----------------------------------------------------------------------------
#
def label_assigned_peaks(spectrum):

  if spectrum == None:
    return
  
  import sputil
  for p in spectrum.peak_list():
    if not sputil.is_peak_unassigned(p):
      p.show_assignment_label()
