# -----------------------------------------------------------------------------
# Read a peak list from cyana and create a new sparky assignment list.
#
import string
import re
import Tkinter

import pyutil
import sparky
import sputil
import tkutil

# -----------------------------------------------------------------------------
#
class read_cyana_peaks_dialog(tkutil.Dialog, tkutil.Stoppable):

  def __init__(self, session):

    self.session = session
    self.selection_notice = None

    tkutil.Dialog.__init__(self, session.tk, 'Convert Cyana/Garant peaklist into Sparky list')

    tspectra=('2D','3D')
    initial=tspectra[0]
    self.spectratype = tkutil.option_menu(self.top, "Select spectra dimension", tspectra, initial)
    self.spectratype.frame.pack(side = 'top', anchor = 'w')

    order=('xy','yx','xyz','yxz','xzy','zyx','zxy','yzx')
    initial=order[0]
    self.order = tkutil.option_menu(self.top, "Select output order", order, initial)
    self.order.frame.pack(side = 'top', anchor = 'w')    

    self.plp = tkutil.file_field(self.top, 'Cyana/Garant output peak file: ', 'peaklist')
    self.plp.frame.pack(side = 'top', anchor = 'e')
    self.peak_list_path = self.plp
    
    self.pl = tkutil.file_field(self.top,   'Cyana/Garant input proton file:', 'protlist')
    self.pl.frame.pack(side = 'top', anchor = 'e')
    self.proton_list_path = self.pl

    self.sl = tkutil.file_field(self.top,   'Sequence file: ', 'seqlist')
    self.sl.frame.pack(side = 'top', anchor = 'e')
    self.sequence_list_path = self.sl

    self.of = tkutil.file_field(self.top,   'Sparky peak list: ', 'outfile')
    self.of.frame.pack(side = 'top', anchor = 'e')
    self.output_file_path = self.of
    
    progress_label = Tkinter.Label(self.top, anchor = 'nw')
    progress_label.pack(side = 'top', anchor = 'w')

    br = tkutil.button_row(self.top,
			   ('Create peaks', self.read_cb),
			   ('Stop', self.stop_cb),
			   ('Close', self.close_cb),
                           ('Help', sputil.help_cb(session, 'ReadPeaks')),
			   )
    br.frame.pack(side = 'top', anchor = 'w')

    tkutil.Stoppable.__init__(self, progress_label, br.buttons[1])

    #self.settings = self.get_settings()
  # ---------------------------------------------------------------------------
  #
  def read_cb(self):

    fin = self.peak_list_path.get()
    fout = self.output_file_path.get()
    fprot = self.proton_list_path.get()
    fseq = self.sequence_list_path.get()
    if  fin and fout and fprot and fseq:
       self.stoppable_call(self.read_peaks, fin, fout, fprot, fseq)

  # ---------------------------------------------------------------------------
  #
  def read_peaks(self, fin, fout, fprot, fseq):
 
    #s = self.get_settings()
    #self.settings = s

    stype=self.spectratype.get()
    if stype == '2D':
	type='2D'
    else:
        type='3D'

    order=self.order.get()
    if len(order) == 3 and stype == '2D':
    	message='You have to select 2D order'
	self.progress_report(message)
	return None
    elif len(order) == 2 and stype == '3D':
	message='You have to select 3D order'
	self.progress_report(message)
	return None

    amino={'ALA' : 'A', # alanine
       'CYS' : 'C', # cysteine
       'CYSS' : 'C', # cysteine
       'ASP' : 'D', # aspartate
       'ASP-' : 'D', # aspartate
       'GLU' : 'E', # glutamate
       'GLU-' : 'E', # glutamate
       'PHE' : 'F', # phenylalanine
       'GLY' : 'G', # glycine
       'HIS' : 'H', # histidine
       'HIS+' : 'H', # histidine
       'HEM' : 'H', # histidine
       'ILE' : 'I', # isoleucine
       'LYS' : 'K', # lysine
       'LYS+' : 'K', # lysine
       'LEU' : 'L', # leucine
       'ASN' : 'N', # asparagine
       'MET' : 'M', # methionine
       'PRO' : 'P', # proline
       'GLN' : 'Q', # glutamine
       'ARG' : 'R', # arginine
       'ARG+' : 'R', # arginine
       'SER' : 'S', # serine
       'THR' : 'T', # threonine
       'VAL' : 'V', # valine
       'TRP' : 'W', # tryptophan
       'TYR' : 'Y'} # tyrosine


    input = open(fin, 'r')
    splines = input.readlines()
    input.close()

    input = open(fprot, 'r')
    plines=input.readlines()
    input.close()

    input = open(fseq, 'r')
    slines = input.readlines()
    input.close()

    seq={}
    for i in range(len(slines)):
      sf=string.split(string.lstrip(slines[i]))
      seq[sf[1]]=sf[0]
   
    try:
      outfile = open(fout, 'w')
    except IOError:
      return None


    at1=""
    col1=""
    col2=""
    col3=""
    icol=""
    far=[]
    for i in range(len(splines)):
      self.check_for_stop()
      if re.compile("^#").search(splines[i], 0):
        continue
      fields=string.split(splines[i])


      np=fields[0]
      x=float(fields[1])
      y=float(fields[2])
      if type == '2D':
        integ=float(fields[5])
        if int(fields[9]) == 0 and int(fields[10]) == 0:
          icol='?-?'
          if order == 'xy':
  	        outfile.write("%17s %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, x, y, integ, np))
          elif order == 'yx':
          	outfile.write("%17s %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, y, x, integ, np))

      else:
        z=float(fields[3])
        integ=float(fields[6])

        if int(fields[10]) == 0 and int(fields[11]) == 0 and int(fields[12]) == 0:
          icol='?-?-?'
  	  if order == 'xyz':
          	outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, x, y, z, integ, np))
          elif order == 'yxz':
          	outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, y, x, z, integ, np))
          elif order == 'xzy':
          	outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, x, z, y, integ, np))
          elif order == 'zyx':
          	outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, z, y, x, integ, np))
          elif order == 'zxy':
          	outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, z, x, y, integ, np))
          elif order == 'yzx':
          	outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, y, z, x, integ, np))


      nar=[]
      nn=[]

      if type == '3D':
        nn.append(fields[10])
        nn.append(fields[11])
        nn.append(fields[12])
      else:
        nn.append(fields[9])
        nn.append(fields[10])
      for jj in range(len(nn)):
        for j in range(len(plines)):
          pfields=string.split(plines[j])
          if nn[jj] == pfields[0]:
             atm=pfields[3]
             if atm[0] == 'C':
               nuc='13C'
             elif atm[0] == 'N':
               nuc='15N'
             else:
               nuc='1H'
             amm=amino[seq[pfields[4]]] + pfields[4]
             if jj == 0:
               nar.append([amm, atm, nuc, x, integ])
             elif jj == 1:
               nar.append([amm, atm, nuc, y, np])
             else:
               nar.append([amm, atm, nuc, z])
             break
      
      if type == '3D' and len(nar)==3:
        far.append([nar[0], nar[1], nar[2]])
      elif type == '2D' and len(nar)==2:
        far.append([nar[0],nar[1]])
   
    for i in range(len(far)):
      x=float(far[i][0][3])
      integ=float(far[i][0][4])
      npeack=far[i][1][4]
      y=float(far[i][1][3])
      if type == '3D':
        z=float(far[i][2][3])

      if far[i][0][0]==far[i][1][0]:
         if type == '3D':
	   if order=='yxz':
	     col2=far[i][0][1]
             if far[i][2][0]==far[i][0][0]:
   	       col3=far[i][2][1]
             else:
	       col3=far[i][2][0]+far[i][2][1]
	   if order=='zxy':
             col2=far[i][0][1]
             if far[i][1][0]==far[i][0][0]:
	       col3=far[i][1][1]
	     else:
	       col3=far[i][1][0]+far[i][1][1]
	   if order=='yzx':
	     col2=far[i][2][1]
 	     if far[i][0][0]==far[i][2][0]:
	       col3=far[i][0][1]
	     else:
	       col3=far[i][0][0]+far[i][0][1]
	   if order=='xzy':
	     col2=far[i][2][1]
  	     if far[i][1][0]==far[i][2][0]:
	       col3=far[i][1][1]
	     else:
	       col3=far[i][1][0]+far[i][1][1] 
	   if order=='zyx':
	     col2=far[i][1][1]
	     if far[i][1][0]==far[i][0][0]:
	       col3=far[i][0][1]
 	     else:
	       col3=far[i][0][0]+far[i][0][1]
	   elif order=='xyz':
             col2=far[i][1][1]
	     if far[i][1][0]==far[i][2][0]:
	       col3=far[i][2][1]
	     else:
               col3=far[i][2][0]+far[i][2][1]
         else:
           if order=="yx":
             col2=far[i][0][1]
           else:
             col2=far[i][1][1]
      else:
         if type == '3D':
	   if order=='yxz':
             col2=far[i][0][0]+far[i][0][1]
             if far[i][0][0]==far[i][2][0]:
               col3=far[i][2][1]
             else:
               col3=far[i][2][0]+far[i][2][1]
	   elif order=='xzy':
	     if far[i][1][0]==far[i][2][0]:
               col3=far[i][1][1]
               col2=far[i][2][0]+far[i][2][1]
	   elif order=='zyx':
	     if far[i][1][0]==far[i][2][0]:
	       col2=far[i][1][1]
	     else:
	       col2=far[i][1][0]+far[i][1][1]
             if far[i][0][0]==far[i][1][0]:
               col3=far[i][0][1]
             else:
	       col3=far[i][0][0]+far[i][0][1]
	   elif order=="zxy":
	     if far[i][0][0]==far[i][2][0]:
	       col2=far[i][0][1]
	     else:
	       col2=far[i][0][0]+far[i][0][1]
	     if far[i][1][0]==far[i][0][0]:
	       col3=far[i][1][1]
	     else:
	       col3=far[i][1][0]+far[i][1][1]
	   elif order=="yzx":
	     if far[i][1][0]==far[i][2][0]:
	       col2=far[i][2][1]
	     else:
	       col2=far[i][2][0]+far[i][2][1]
	     if far[i][2][0]==far[i][0][0]:
	       col3=far[i][0][1]
	     else:
	       col3=far[i][0][0]+far[i][0][1]
           elif order=='xyz':
	     if far[i][0][0]==far[i][1][0]:
    	       col2=far[i][1][1]
	     else: 
               col2=far[i][1][0]+far[i][1][1]
	     if far[i][1][0]==far[i][2][0]:
	       col3=far[i][2][1]
  	     else:
	       col3=far[i][2][0]+far[i][2][1]
         else:
           if order=='yx':
             col2=far[i][0][0]+far[i][0][1]
           else:
             col2=far[i][1][0]+far[i][1][1]

           
      if type == '3D':
        if order == 'xyz':
	  col1=far[i][0][0]+far[i][0][1]
          icol=col1+'-'+col2+'-'+col3
	  outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, x, y, z, integ, npeack))
	elif order == 'yxz':
	  col1=far[i][1][0]+far[i][1][1]
	  icol=col1+'-'+col2+'-'+col3    
	  outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, y, x, z, integ, npeack))
	elif order == 'xzy':
	  col1=far[i][0][0]+far[i][0][1]
          icol=col1+'-'+col2+'-'+col3
	  outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, x, z, y, integ, npeack))
	elif order == 'zyx':
	  col1=far[i][2][0]+far[i][2][1]
          icol=col1+'-'+col2+'-'+col3
	  outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, z, y, x, integ, npeack))
	elif order == 'zxy':
	  col1=far[i][2][0]+far[i][2][1]
          icol=col1+'-'+col2+'-'+col3
	  outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, z, x, y, integ, npeack))
	elif order == 'yzx':
	  col1=far[i][1][0]+far[i][1][1]
          icol=col1+'-'+col2+'-'+col3
	  outfile.write("%17s %10.3f %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, y, z, x, integ, npeack))
      else:
	if order == 'xy':
          col1=far[i][0][0]+far[i][0][1]
	  icol=col1+'-'+col2
          outfile.write("%17s %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, x, y, integ, npeack))
	elif order == 'yx':
          col1=far[i][1][0]+far[i][1][1]
	  icol=col1+'-'+col2
          outfile.write("%17s %10.3f %10.3f %10.2e lo NP%-5s\n" % (icol, y, x, integ, npeack))
    outfile.close()
    
    print far

# -----------------------------------------------------------------------------
#
def read_cyana_peak_list(session):
  sputil.the_dialog(read_cyana_peaks_dialog,session).show_window(1)
