// ----------------------------------------------------------------------------
//

#include "list.h"		// Use List
#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "num.h"		// Use max()
#include "project.h"		// use Project
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "spoint.h"		// Use SPoint
#include "stringc.h"		// Use Stringy
#include "uicomponents.h"	// Use View_Menu
#include "uidialogs.h"		// use help_cb()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "uiview.h"		// Use View
#include "winsystem.h"		// Use ws.widget_table(), ...

// ----------------------------------------------------------------------------
//
class view_depth_dialog : public Dialog
{
public:
  view_depth_dialog(Session &);
  ~view_depth_dialog();

  static view_depth_dialog *the(Session &);

  void show(View *v);
  void update(View *v);

private:
  Widget table;
  View_Menu *view_menu;
  View *view;

  static void will_delete_view_cb(void *idialog, void *view);
  static void view_menu_cb(Widget, CB_Data, CB_Data);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_view_depth_dialog(Session &s, View *v)
  { view_depth_dialog::the(s)->show(v); }

// ----------------------------------------------------------------------------
//
view_depth_dialog::view_depth_dialog(Session &s) : Dialog(s, "viewDepthDialog")
{
  view = NULL;

  view_menu = new View_Menu(s, dialog, "viewMenu");
  ws.option_callback(view_menu->option_menu(), view_menu_cb, this);

  Widget heading = ws.create_label(dialog, "heading");

  Table_Entry label = TABLE_LABEL;
  Table_Entry value = TABLE_TEXT_FIELD;
  table = ws.widget_table(dialog, "depths", 4, 2,
		       label, value,
		       label, value,
		       label, value,
		       label, value);

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       "help", help_cb, &s,
			       NULL);

  ws.column_attachments(separator, view_menu->option_menu(), heading, table,
		     separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_will_delete_view, will_delete_view_cb, this);
}

// ----------------------------------------------------------------------------
//
view_depth_dialog::~view_depth_dialog()
{
  session.dialog_table().delete_dialog("view_depth_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_will_delete_view, will_delete_view_cb, this);

  delete view_menu;
}

// ----------------------------------------------------------------------------
// The default view_depth_dialog instance.
//
view_depth_dialog *view_depth_dialog::the(Session &s)
{
  Stringy name = "view_depth_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new view_depth_dialog(s));
  return (view_depth_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void view_depth_dialog::will_delete_view_cb(void *vddialog, void *view)
{
  view_depth_dialog *vdd = (view_depth_dialog *) vddialog;
  View *v = (View *) view;

  if (vdd->view == v)
    vdd->update(NULL);
}

// ----------------------------------------------------------------------------
//
void view_depth_dialog::view_menu_cb(Widget, CB_Data client_data, CB_Data)
{
  view_depth_dialog *vdd = (view_depth_dialog *) client_data;
  View *v = vdd->view_menu->selected_view();
  if (v)
    vdd->update(v);
}

// ----------------------------------------------------------------------------
//
void view_depth_dialog::show(View *v)
{
  update(v);
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void view_depth_dialog::update(View *v)
{
  this->view = v;

  Stringy view_name = (view ? view->name() : Stringy(""));
  Stringy title = Stringy("View Depth ") + view_name;
  ws.set_dialog_title(dialog, title);

  view_menu->set_view_choice(view);
  Spectrum *sp = (view == NULL ? NULL : view->spectrum());
  int dim = (sp == NULL ? 2 : sp->dimension());
  for (int a = 0 ; a < dim ; ++a)
    ws.set_label_text(ws.table_element(table,a,0),
		      table_axis_label(sp, a, ""));
  if (dim > 2)
    {
      for (int a = 0 ; a < dim ; ++a)
	{
	  double d = (sp == NULL ? 0 :
		      sp->scale(view->visible_depth(a), a, PPM, INDEX));
	  ws.set_numeric_text_field(ws.table_element(table, a, 1),
				    "%.0f", d-1);
	}
      ws.manage_table_children(table, dim, 2);
    }
  else
    ws.manage_table_children(table, 0, 2);
}

// ----------------------------------------------------------------------------
//
void view_depth_dialog::apply()
{
  if (view == NULL)
    return;

  Spectrum *sp = view->spectrum();
  if (sp->dimension() > 2)
    {
      IPoint index_depth(sp->dimension());
      for (int a = 0 ; a < sp->dimension() ; ++a)
	index_depth[a] =
	  max(0, (int) ws.numeric_text_field(ws.table_element(table, a, 1)))+1;
      SPoint depth = sp->scale(index_depth, INDEX, PPM);
      view->set_visible_depth(depth);
    }
}
