// ----------------------------------------------------------------------------
//

#include "format.h"		// Use open_sparky_file()
#include "project.h"		// Use Project
#include "reporter.h"		// use Reporter
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "stringc.h"
#include "uifile.h"
#include "uiview.h"		// Use View
#include "winsystem.h"		// Use WinSys

#define DEFAULTPROJ		"noname.proj"

// ----------------------------------------------------------------------------
//
void show_spectrum_open_dialog(Session &s)
{
  Stringy defpath = s.project().save_path("");
  WinSys &ws = s.window_system();
  Stringy path = ws.open_file_dialog(ws.main_widget(), "Open File",
				     defpath, "save", true);
  Stringy error_msg;
  if (! path.is_empty())
    if (! open_sparky_file(s, path, &error_msg))
      if (! error_msg.is_empty())
	s.reporter().warning(error_msg.cstring());
}

// ----------------------------------------------------------------------------
//
void show_spectrum_saveas_dialog(View *view)
{
  Spectrum *sp = view->spectrum();
  Session &s = view->session();

  Stringy path = sp->save_file().path();
  if (path.is_empty())
    path = s.project().new_save_file_path(sp->name());

  Stringy title = "Save Spectrum " + sp->name();
  WinSys &ws = s.window_system();
  path = ws.saveas_file_dialog(view->frame(), title, path, "save", false);
  if (! path.is_empty())
    {
      sp->save_file().set_path(path);
      save_spectrum(s, sp, false);
    }
}

// ----------------------------------------------------------------------------
//
void show_project_open_dialog(Session &s)
{
  WinSys &ws = s.window_system();
  Stringy path = ws.open_file_dialog(ws.main_widget(), "Open Project",
				     s.project().project_path(""),
				     "project", true);
  Stringy error_msg;
  if (! path.is_empty())
    if (! open_sparky_file(s, path, &error_msg))
      if (! error_msg.is_empty())
	s.reporter().warning(error_msg.cstring());
}

// ----------------------------------------------------------------------------
//
void show_project_saveas_dialog(Session &s)
{
  Project &proj = s.project();
  Stringy path = proj.save_file().path();
  if (path.is_empty())
    path = proj.project_path(DEFAULTPROJ);

  WinSys &ws = s.window_system();
  path = ws.saveas_file_dialog(ws.main_widget(), "Save Project",
			       path, "project", false);
  if (! path.is_empty())
    {
      proj.save_file().set_path(path);
      save_project(s, false);
    }
}
