// ----------------------------------------------------------------------------
// Drawing display
//

#ifndef DRAWING_HEADER_INCLUDED
#define DRAWING_HEADER_INCLUDED

#include "color.h"		// Use Color
#include "rectangle.h"
#include "region.h"
#include "winsystem.h"		// Use WinSys, Widget, CB_Data

class Stringy;

// ----------------------------------------------------------------------------
//
class Drawing
{
 public:

  Rectangle view_rectangle() const;
  double aspect() const;	// Display aspect of a ppm unit square.
  void set_drawing_color(const Color &color);
  void erase_rectangle(const Rectangle &r, bool exposures = true);
  void erase();
  void set_contour_graying(bool onoff);
  void draw_line(double x1, double y1, double x2, double y2,
		 bool xor_mode = false);
  void draw_point(double x, double y);
  void set_font_height(double height);
  void text_size(const Stringy &text, double *width,
		 double *ascent, double *descent);
  void draw_text(double center_x, double center_y, const Stringy &text);
  void draw_rectangle(Rectangle r, bool xor_mode = false);
  void draw_triangle(double x1, double y1,
		     double x2, double y2,
		     double x3, double y3);		// Filled triangle.
  void draw_ellipse(Rectangle r);
  void screen_size(int *xsize, int *ysize);
  Widget drawing_widget();

// ----------------------------------------------------------------------------
//
 protected:

  WinSys &ws;

  Drawing(WinSys &ws, Widget parent,
	  int w, int h, double x_center, double y_center,
	  double x_pixel_size, double y_pixel_size, Rectangle drawing,
	  Rectangle repaint_tile, double repaint_priority,
	  bool contour_graying);
  virtual ~Drawing();

  double pixel_size(Axis a) const;
  virtual void redraw_rectangle(Rectangle r);
  void set_redraw_priority(double priority);
  const Region2 &repaint_region();

  void set_center(double x, double y);
  void set_pixel_size(double xsize, double ysize);

  void set_drawing(Rectangle r);
  void set_redraw_tile(Rectangle r);
  virtual void drawing_resized();

  void set_display_size(int width, int height);

  bool pointer_position(double *x, double *y);
  virtual void buttondown(double x, double y, bool shift);	// Mouse down.
  virtual void buttonup(double x, double y);		// Mouse up.
  virtual void move(double x, double y);		// Mouse move.
  virtual void enter_window(double x, double y);	// Mouse entered window
  virtual void exit_window(double x, double y);		// Mouse exited window
  virtual void drag(double x, double y);		// Mouse drag.
  virtual void key_pressed(char c);
  virtual void function_key_pressed(int f, bool shifted);
  virtual void got_focus();

// ----------------------------------------------------------------------------
//
 private:

  Drawing_Window *c;
  double font_height;
  int vw, vh;
  double x_center, y_center, x_pixel_size, y_pixel_size;
  Rectangle drawing_rect;
  Region2 repaint_reg;
  Rectangle redraw_tile;
  double redraw_priority;
  bool pointer_in_view;
  int pointer_x, pointer_y;
  bool contour_graying;

  static void expose_cb(Widget, CB_Data, CB_Data);
  static void resize_cb(Widget, CB_Data, CB_Data);
  static void enter_window_cb(Widget, CB_Data, CB_Data);
  static void leave_window_cb(Widget, CB_Data, CB_Data);
  static void button_press_cb(Widget, CB_Data, CB_Data);
  static void button_release_cb(Widget, CB_Data, CB_Data);
  static void pointer_move_cb(Widget, CB_Data, CB_Data);
  static void pointer_drag_cb(Widget, CB_Data, CB_Data);
  static void got_focus_cb(Widget, CB_Data, CB_Data);
  static void key_press_cb(Widget, CB_Data, CB_Data);

  static void repaint_tile(CB_Data drawing);	// Work procedure.

  bool event_position(CB_Data event, double *x, double *y);
  Rectangle drawing_rectangle() const;	// Area that gets repainted.
  void paint_coordinates(double x, double y, int *px, int *py);
  int paint_coordinate(double d, Axis a);
  void rectangle_paint_coordinates(Rectangle r,
				   int *x, int *y, int *w, int *h);
  void drawing_coordinates(int px, int py, double *x, double *y);
  void update_font_height();
  void view_rectangle_changed();

  void resize(int width, int height);
  void repaint(int x, int y, int w, int h);
  void translate_view(double delta_x, double delta_y);
};

#endif
