// ----------------------------------------------------------------------------
// Choose colors for peaks and labels.
//

#include "color.h"		// Use Color
#include "list.h"		// Use List
#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "ornament.h"		// Use Ornament
#include "project.h"		// Use Project
#include "session.h"		// use Session
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "winsystem.h"		// Use radio_menu() ...

// ----------------------------------------------------------------------------
//
class color_dialog : public Dialog
{
public:
  color_dialog(Session &);
  ~color_dialog();

  static color_dialog *the(Session &);

  void show();
  void update();

private:
  Widget colors;

  static void selection_changed_cb(void *, void *);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_ornament_color_dialog(Session &s)
  { color_dialog::the(s)->show(); }

// ----------------------------------------------------------------------------
//
color_dialog::color_dialog(Session &s) : Dialog(s, "colorDialog")
{
  colors = ws.create_radio_buttons(dialog, "colors");

  const char *clist[] = {"black", "white", "gray", "red", "green", "blue",
			 "yellow", "magenta", "cyan", "light blue",
			 "light green", "light yellow", "gold", "orange",
			 "pink", "beige", "turquoise", "coral", "maroon",
			 "purple", "tomato",
			 NULL};
  for (int ci = 0 ; clist[ci] ; ++ci)
    ws.add_radio_button(colors, clist[ci]);

  ws.radio_callback(colors, apply_cb, this);

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "close", close_cb, this,
			       NULL);

  ws.column_attachments(separator, colors, separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_selected_ornaments_changed, selection_changed_cb, this);
}

// ----------------------------------------------------------------------------
//
color_dialog::~color_dialog()
{
  session.dialog_table().delete_dialog("color_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_selected_ornaments_changed, selection_changed_cb, this);
}

// ----------------------------------------------------------------------------
// The default color_dialog instance.
//
color_dialog *color_dialog::the(Session &s)
{
  Stringy name = "color_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new color_dialog(s));
  return (color_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void color_dialog::selection_changed_cb(void *cdialog, void *)
{
  color_dialog *cd = (color_dialog *) cdialog;

  if (cd->shown())
    cd->update();
}

// ----------------------------------------------------------------------------
//
void color_dialog::show()
{
  update();
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void color_dialog::update()
{
  List sel = session.project().selected_ornaments();
  if (sel.size() == 1)
    ws.set_radio_button(colors, ((Ornament *)sel[0])->GetColor().name());
}

// ----------------------------------------------------------------------------
//
void color_dialog::apply()
{
  Stringy color = ws.radio_selection(colors);
  List sel = session.project().selected_ornaments();
  for (int oi = 0 ; oi < sel.size() ; ++oi)
    ((Ornament *) sel[oi])->SetColor(color);
}
