// ----------------------------------------------------------------------------
//

#include "memalloc.h"		// use new()
#include "project.h"		// use Project
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "spectrumdata.h"	// Use ppm
#include "uicomponents.h"	// Use Spectrum_Menu
#include "uidialogs.h"		// use help_cb()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "uiview.h"		// Use View
#include "notifier.h"		// use Notifier
#include "winsystem.h"		// use WinSys, ...

// ----------------------------------------------------------------------------
//
class assignment_copy_dialog : public Dialog
{
public:
  assignment_copy_dialog(Session &);
  ~assignment_copy_dialog();

  static assignment_copy_dialog *the(Session &);

  void show(Spectrum *sp);
  void update(Spectrum *sp);

private:
  Widget thresholds;
  Spectrum_Menu *spectrum_menu, *copy_from;
  Spectrum *spectrum;

  static void will_delete_spectrum_cb(void *idialog, void *spectrum);
  static void spectrum_menu_cb(Widget, CB_Data, CB_Data);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_assignment_copy_dialog(Session &s, Spectrum *sp)
  { assignment_copy_dialog::the(s)->show(sp); }

// ----------------------------------------------------------------------------
//
assignment_copy_dialog::assignment_copy_dialog(Session &s)
  : Dialog(s, "assignCopyDialog")
{
  this->spectrum = NULL;

  spectrum_menu = new Spectrum_Menu(s, dialog, "spectrumMenu");
  ws.option_callback(spectrum_menu->option_menu(), spectrum_menu_cb, this);

  thresholds = ws.widget_table(dialog, "thresholds", 4, 2,
			       TABLE_LABEL, TABLE_TEXT_FIELD,
			       TABLE_LABEL, TABLE_TEXT_FIELD,
			       TABLE_LABEL, TABLE_TEXT_FIELD,
			       TABLE_LABEL, TABLE_TEXT_FIELD);

  Widget sep = ws.create_separator(dialog, "separator");
  Widget heading = ws.create_label(dialog, "pmHeading");
  copy_from = new Spectrum_Menu(s, dialog, "copyFrom");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       "help", help_cb, &s,
			       NULL);

  ws.column_attachments(separator, spectrum_menu->option_menu(), thresholds,
		     sep, heading, copy_from->option_menu(),
		     separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_will_delete_spectrum, will_delete_spectrum_cb, this);
}

// ----------------------------------------------------------------------------
//
assignment_copy_dialog::~assignment_copy_dialog()
{
  session.dialog_table().delete_dialog("assignment_copy_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_will_delete_spectrum, will_delete_spectrum_cb, this);

  delete spectrum_menu;
  delete copy_from;
}

// ----------------------------------------------------------------------------
// The default dialog instance.
//
assignment_copy_dialog *assignment_copy_dialog::the(Session &s)
{
  Stringy name = "assignment_copy_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new assignment_copy_dialog(s));
  return (assignment_copy_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void assignment_copy_dialog::will_delete_spectrum_cb(void *acdialog,
						     void *spectrum)
{
  assignment_copy_dialog *acd = (assignment_copy_dialog *) acdialog;
  Spectrum *sp = (Spectrum *) spectrum;

  if (acd->spectrum == sp)
    acd->update(NULL);
}

// ----------------------------------------------------------------------------
//
void assignment_copy_dialog::spectrum_menu_cb(Widget, CB_Data client_data,
					      CB_Data)
{
  assignment_copy_dialog *acd = (assignment_copy_dialog *) client_data;
  Spectrum *spect = acd->spectrum_menu->selected_spectrum();

  if (spect)
    acd->update(spect);
}

// ----------------------------------------------------------------------------
//
void assignment_copy_dialog::show(Spectrum *sp)
{
  update(sp);
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void assignment_copy_dialog::update(Spectrum *sp)
{
  this->spectrum = sp;

  Stringy dialog_title = (spectrum == NULL ?
			  Stringy("Assignment Copy") :
			  Stringy("Assignment Copy ") + spectrum->name());
  ws.set_dialog_title(dialog, dialog_title);

  spectrum_menu->set_spectrum_choice(spectrum);

  int dim = (spectrum == NULL ? 2 : spectrum->dimension());
  ws.manage_table_children(thresholds, dim, 2);
  SPoint thresh = (spectrum == NULL ? SPoint(dim) :
		   spectrum->assignment_copy_threshold());
  for (int a = 0 ; a < dim ; ++a)
    {
      ws.set_label_text(ws.table_element(thresholds,a,0),
			table_axis_label(spectrum, a, " tolerance"));
      ws.set_numeric_text_field(ws.table_element(thresholds,a,1),
				"%.5f", thresh[a]);
    }

  Spectrum *from_sp = session.project().assignment_copy_from_spectrum();
  copy_from->set_spectrum_choice(from_sp);
}

// ----------------------------------------------------------------------------
//
void assignment_copy_dialog::apply()
{
  if (spectrum == NULL)
    return;

  int dim = spectrum->dimension();
  SPoint thresh(dim);
  for (int a = 0 ; a < dim ; ++a)
    thresh[a] = ws.numeric_text_field(ws.table_element(thresholds, a, 1));

  spectrum->set_assignment_copy_threshold(thresh);

  Spectrum *from_sp = copy_from->selected_spectrum();
  session.project().set_assignment_copy_from_spectrum(from_sp);
}
