// ----------------------------------------------------------------------------
// Maps between keys and values.
//

#ifndef TABLE_HEADER_INCLUDED
#define TABLE_HEADER_INCLUDED

typedef const void *TableKey;
typedef void *TableData;

class List;

class Table
{
 public:
  Table();
  Table(bool equal(TableKey k1, TableKey k2),
	unsigned long hash(TableKey key));
  virtual ~Table();

  void insert(TableKey key, TableData data);
  TableKey remove(TableKey key);
  void erase();
  bool find(TableKey key, TableData *data) const;
  List keys() const;
  List values() const;
  int entry_count() const;

 private:
  int size, used;
  struct TableEntry *entries;
  bool (*equal)(TableKey k1, TableKey k2);
  unsigned long (*hash)(TableKey key); 
  struct TableEntry *table_entry(TableKey key, unsigned long h) const;
  struct TableEntry *next_entry(struct TableEntry *te) const;
  void resize_table();
  void insert(TableKey key, TableData data, unsigned long hash);
};

unsigned long hash_combine(unsigned long, unsigned long);

#endif
