// ----------------------------------------------------------------------------
// Routines for working with multi-dimensional subarrays with bounds specified
// by IRegion objects.
//

#ifndef SUBARRAY_HEADER_INCLUDED
#define SUBARRAY_HEADER_INCLUDED

#include "offsettype.h"		// use offset_type
#include "spoint.h"		// use IRegion, IPoint

// ----------------------------------------------------------------------------
// Used for scanning multidimensional subarrays.
//
class Subarray_Iterator
{
 public:
  Subarray_Iterator(const IRegion &subregion, const IRegion &region,
		    bool big_endian_indexing);
  offset_type index() const;
  const IPoint &position() const;
  bool finished() const;
  void next();
  int step_size(int axis) const;
 private:
  IRegion subregion;
  IPoint pos;
  int dim, dimfast, dimstep, dimend, step[DIM];
  offset_type indx;
  bool done;
  bool axis_step(int a);
};

IPoint index_position(offset_type index, const IRegion &region,
		      bool big_endian_indexing);
offset_type position_index(const IPoint &point, const IRegion &region,
			   bool big_endian_indexing);
int array_step(int axis, const IRegion &region, bool big_endian_indexing);
void little_to_big_endian_indexing(const IRegion &region,
				   float *le, float *be);
void big_to_little_endian_indexing(const IRegion &region,
				   float *be, float *le);
void copy_array(const void *source, void *destination, int element_size,
		const IRegion &rs, const IRegion &rd);

#endif
