// ----------------------------------------------------------------------------
// Maintain information about backup files.
//
#ifndef SAVEFILE_HEADER_INCLUDED
#define SAVEFILE_HEADER_INCLUDED

#include <iostream>		// use ostream
#include <stdio.h>		// Use FILE

#include "list.h"		// Use List
#include "stringc.h"		// Use Stringy

class Session;

enum SAVEFILE_TYPE {
	SAVEFILE_SPECTRUM,
	SAVEFILE_PROJECT
};

// ----------------------------------------------------------------------------
//
class SaveFile
{
public:
	SaveFile(Session &, SAVEFILE_TYPE, bool save_previous);

  	SaveFile &operator=(const SaveFile &);

	void		set_path(const Stringy &path);
	Stringy 	path() const;
	Stringy		ShortPath() const;
	Stringy		directory() const;

	FILE *		OpenForSaving(bool backup);
  	std::ostream *	OpenForWriting(bool backup);
	FILE *		OpenForReading();
	bool		EndRead(FILE *);
	bool		EndSave(FILE *, bool backup, bool success);
  	bool		EndWrite(std::ostream *, bool backup, bool success);
	bool		NeedsSaving() const;
	void		NeedsSaving(bool state);

	void remove_backup();
	static void remove_auto_backups();

private:
	static List	backup_paths;

	Session &	session;
	Stringy 	mPath;
	SAVEFILE_TYPE	mType;
	bool		mSavePrevious;		// write .BAK file?
	bool		mNeedsSaving;
	bool		mNeedsBackup;
	Stringy		mBackupInUse;

	bool		save_path(bool backup, Stringy *path);
	Stringy		load_path();
	Stringy		auto_backup_path();
	bool		old_backup_exists();
	void		end_of_write(bool backup, bool success);
};

bool check_file_type(const Stringy &path, SAVEFILE_TYPE t,
		     int *version = 0, int *release = 0);

#endif
