// ----------------------------------------------------------------------------
// Rectangles in the plane.
//

#ifndef RECTANGLE_HEADER_INCLUDED
#define RECTANGLE_HEADER_INCLUDED

#include <iostream>		 // use ostream

class List;

enum Axis {X, Y, NOT_XY};

// ----------------------------------------------------------------------------
//
class Rectangle
{
 public:

  Rectangle(double x1, double y1, double x2, double y2);
  Rectangle(const Rectangle &r);
  Rectangle();

  double min(Axis a) const;
  double max(Axis a) const;
  double size(Axis a) const;
  double center(Axis a) const;
  double aspect() const;
  double area() const;
  double edge_distance(double x, double y) const;
  bool operator==(const Rectangle &r) const;
  bool no_interior() const;
  bool contains(double x, double y) const;
  bool contains(const Rectangle &r) const;
  bool intersects(const Rectangle &r) const;
  bool intersects_interior(const Rectangle &r) const;
  bool is_translation(const Rectangle &r) const;
  void closest_point(double x, double y, double *cx, double *cy) const;

  void operator=(const Rectangle &r);
  void scale(double factor);
  void scale(double cx, double cy, double factor);
  void scale(Axis a, double factor);
  void clip(const Rectangle &r);
  void encompass(double x, double y);
  void encompass(const Rectangle &r);
  void translate(double dx, double dy);
  void translate(double delta, Axis a);
  void translate_to(double x, double y);
  void recenter(double x, double y);
  void transpose();
  void match_aspect(double aspect);
  void match_aspect(const Rectangle &r);

 private:

  double xmin, xmax, ymin, ymax;
};

Axis other_axis(Axis a);
std::ostream &operator<<(std::ostream &s, const Rectangle &r);
void free_rectangle_list_entries(const List &rectangles);
void unoverlap_rectangles(const List &movable, const List &fixed,
			  double step_fraction, int max_iterations);

#endif
