/*
 * peakgp.h - Interface for the PeakGp class.
 *
 * A PeakGp object is a collection of Peaks in an NMR Spectrum.
 * Peaks and PeakGps are both specializations of CrossPeaks.
 *
 */
#ifndef _PeakGp_h
#define _PeakGp_h

class PeakGp;

#include "crosspeak.h"		// Use CrossPeak
#include "list.h"		// Use List

class Axis_Map;
class Peak;
class Spectrum;

// ----------------------------------------------------------------------------
//
class PeakGp : public CrossPeak
{
public:
  PeakGp(Spectrum *, const List &peaks);
  PeakGp(Spectrum *, const SPoint &position);
  ~PeakGp();

  virtual Ornament *copy(Spectrum *to, const Axis_Map &axismap);

  virtual Ornament_Type	type() const;
  virtual const char	*type_name() const;

  void			add(Peak &);
  void			remove(Peak &);
  void			removeAllPeaks();

  const List &		peaklets() const;

  virtual void		set_alias(const SPoint &); // moves peak group marker
  void			recompute_position();

  virtual bool		volume(double *vol = 0, Stringy *method = 0) const;
  virtual double	SignalToNoise() const;

  //
  // Ornament section
  //
  virtual void		print(ODraw &, FILE *fp,
			      double xsc, double ysc,
			      Rectangle r) const;

  //
  // Change the PeakGroup location.
  //
  virtual void	IncrementLocation(const SPoint &dr);

private:

  List		mPeaks;  // There is at least one peaklet per crosspeak.

  void		match_peaklet_alias();
  SPoint	average_position() const;
};

bool define_peak_group(Spectrum *sp);

#endif
