// ----------------------------------------------------------------------------
//
#ifndef MOLECULE_HEADER_INCLUDED
#define MOLECULE_HEADER_INCLUDED

#include "attacheddata.h"	// use AttachedData
#include "list.h"		// Use List
#include "stringc.h"		// use Stringy
#include "table.h"		// use Table

class Atom;
class Condition;
class Group;
class Model;
class Notifier;
class Session;

// ----------------------------------------------------------------------------
//
class Molecule
{
public:
		Molecule(Session &, const Stringy &name);
  virtual	~Molecule();

  Stringy	name() const;
  Session &	session();

  //
  // Groups
  //

  const List &	GroupList() const;
  Group *	define_group(const Stringy &name);
  void		add_group(Group *g);
  void		remove_group(Group *g);
  Group *	find_group(const Stringy &nm) const;

  //
  // Atoms
  //

  const List & 	AtomList(void) const;
  List		AtomList(const Group *) const;
  Atom *	define_atom(const Stringy &group, const Stringy &atom,
			    const Stringy &nucleus);
  void		add_atom(Atom *a);
  void		remove_atom(Atom *a);
  Atom *	find_atom(const Stringy &group, const Stringy &atom) const;

  //
  // Conditions
  //

  const List &	condition_list() const;
  void		add_condition(Condition *);
  void		remove_condition(Condition *);
  Condition *	define_condition(const Stringy &condition_name);
  Condition *	find_condition(const Stringy &condition_name);

  //
  // Models
  //

  const List &	model_list() const;
  void		add_model(Model *);
  void		remove_model(Model *);
  void		remove_all_models();

  //
  // Extra data attached to molecules (eg. sequence) and saved in files
  //
  AttachedData &saved_values();

private:
  Session &	ses;
  Stringy	mName;
  List		mCondition;	// all Conditions of this Molecule
  List		mAtom;		// all Atoms of this Molecule
  List		mGroup;		// all Groups of this Molecule
  List		mModel;		// models
  Table		name_to_atom;	// map group/atom name to atom object
  AttachedData	attached_data;	// key, value pairs attached by extensions
};

#endif
