// ----------------------------------------------------------------------------
// Manage a cache of objects freeing them when necessary to keep the total
// memory use below a specified value.  An object must be locked when in
// use to guarantee that it will not be freed if other objects are added to
// the cache.  The maximum cache size can be exceeded if objects are added
// to the cache and there are no unlocked objects.  Object memory allocation,
// determination of object size, and freeing of objects is done externally.
// Deleting the cache does not cause the objects to be freed.  And removing
// an object from the cache does not cause it to be freed.
//
#ifndef MEMCACHE_HEADER_INCLUDED
#define MEMCACHE_HEADER_INCLUDED

#include <stddef.h>		// use size_t

#include "table.h"		// use Table;

class Cache_Entry;

// ----------------------------------------------------------------------------
//
class Memory_Cache
{
public:
  Memory_Cache(size_t max_size);
  ~Memory_Cache();

  void add_to_cache(void *object,
		    size_t size,
		    void (*free_cb)(void *object, void *cb_data),
		    void *cb_data);
  bool remove_from_cache(void *object);
  void lock(void *object);
  void unlock(void *object);
  void free_all();
  void resize(size_t bytes);

private:
  size_t max_size;
  size_t current_size;
  Table object_to_entry;
  Cache_Entry *newest, *oldest;

  void remove_from_cache(Cache_Entry *e);
  void make_room();
};

#endif
