// ----------------------------------------------------------------------------
// Memory allocation routines for tracking memory leaks.
// A table of all memory allocations is maintained and can be printed
// on request.  The table records file and line numbers for all uses of
// new.
//
// This works by using the placement syntax for new and delete.
// A serious problem is that a new(file,line)[] with a delete[] without
// file and line arguments causes an abort on SGI because it requires
// the placement syntax to match.  (Maybe it sticks some info in vtbl?)
// So if this header is included in the file that does the new but
// not the delete it will cause a run time crash.  But the SGI 7.30
// compiler has placement delete disabled.  So the memory tracking
// code will not work on the SGI and should be disabled.
//

#ifndef MEMALLOC_HEADER_INCLUDED
#define MEMALLOC_HEADER_INCLUDED

#include <new>		// use bad_alloc
#include <stddef.h>	// use size_t

void *operator new(size_t size) throw(std::bad_alloc);
void operator delete(void *p) throw();

void *operator new[](size_t size) throw(std::bad_alloc);
void operator delete[](void *p) throw();

// ----------------------------------------------------------------------------
// The lines below are for tracking all memory allocated with new.
// The allocation_report routine prints a summary of all allocated memory
// according to what file and line of code allocated it.
//
// Uncomment these lines for tracking memory leaks:
//
// void *operator new(size_t size, const char *file, int line);
// void *operator new[](size_t size, const char *file, int line);
// #define new new(__FILE__,__LINE__)
//
// And set the TRACKING_MEMORY variable to 1
//
#define TRACKING_MEMORY 0

void allocation_report();

#endif
