// ----------------------------------------------------------------------------
// Main program for statically linked Python and Sparky.
// Used for debugging and profiling.
//
#include <Python.h>		// Use Py_Initialize()

#include "paths.h"		// Use installation_path()
#include "stringc.h"		// Use Stringy
#include "utility.h"		// Use fatal_error()


extern "C" void init_tkinter();
extern "C" void initspy();

// ----------------------------------------------------------------------------
//
main(int ac, char *av[])
{
  Py_Initialize();

  Stringy args = "[";
  for (int a = 0 ; a < ac ; ++a)
    args << formatted_string("'%s,'", av[a]);
  args << "]";

  Stringy path = installation_path("python");
  Stringy path_cmd = formatted_string("sys.path = ['%s'] + sys.path\n",
				      path.cstring());
  Stringy argv_cmd = "sys.argv = " + args + "\n";

  if (PyRun_SimpleString("import sys\n") != 0 ||
      PyRun_SimpleString((char *) path_cmd.cstring()) != 0 ||
      PyRun_SimpleString((char *) argv_cmd.cstring()) != 0)
    fatal_error("main(): Error initializing Python path or argv.\n");

  init_tkinter();
  initspy();		// Need this so Python doesn't dynamically load spy

  if (PyRun_SimpleString("import start_sparky\n") != 0)
    fatal_error("main(): Error importing start_sparky.\n");

  return 0;
}
