/*
 * line.h:	Interface to the Line ornament class.
 *
 * A line is an ornament drawn between 2 points, either horizontally
 * or vertically.
 *
 */
#ifndef _Line_h
#define _Line_h

#include "spoint.h"		// Use SPoint
#include "ornament.h"

class Axis_Map;

//
// The Line class
//
class Line : public Ornament {

public:

	SPoint			bl;		// actual BL corner
	SPoint			tr;		// actual TR corner
	int			axis;		// the direction
	int			ends;		// 0, 1, 2, or 3

	Line(Spectrum *sp, const SPoint &p1, const SPoint &p2);
	~Line();

	virtual Ornament *copy(Spectrum *to, const Axis_Map &axismap);

	//
	// Change the location incrementally
	//
	virtual void		IncrementLocation(const SPoint &);

	//
	// Routines for ornament display
	//
	virtual void		display(ODraw &) const;
	virtual SRegion		erasure_region(ODraw &) const;
	virtual void		print(ODraw &, FILE *fp,
				      double xsc, double ysc,
				      Rectangle r) const;

	virtual Ornament_Type		type() const;
	virtual const char	*type_name() const;
};

#endif
