// ----------------------------------------------------------------------------
// Maps from axes of one spectrum to axes of another spectrum used for
// interspectrum operations.
//

#ifndef AXISMAP_HEADER_INCLUDED
#define AXISMAP_HEADER_INCLUDED

#include "spoint.h"		// Use IPoint, SPoint, SRegion

class Spectrum;

// ----------------------------------------------------------------------------
//
class Axis_Map
{
 public:
  Axis_Map();

  void set_map(const IPoint &to_axis);

  int map(int axis) const;
  SPoint map(const SPoint &p) const;
  SRegion map(const SRegion &r) const;

  int invert(int axis) const;
  SPoint invert(const SPoint &p) const;
  SRegion invert(const SRegion &r) const;

 private:
  IPoint to_axis;
};

bool identity_axis_map(Spectrum *from, Spectrum *to, Axis_Map *axismap);
bool unique_axis_map(Spectrum *from, Spectrum *to, Axis_Map *axismap);

#endif
