// ----------------------------------------------------------------------------
// Guess peak assignments using currently known resonances.
// A sequence index constraint can be applied.  For example the w1 and w2
// axis assignments can be required to be to groups i-1 and i respectively.
// The atom name for each axis can also be specified.  Or a list of allowed
// atom names can be specified, for example HB1|HB2.  A maximum ppm range
// from peak position to resonance position can be specified for each axis.
//
#ifndef ASSIGNGUESS_HEADER_INCLUDED
#define ASSIGNGUESS_HEADER_INCLUDED

#include "spoint.h"		// use SPoint, SRegion
#include "stringc.h"		// use Stringy

class CrossPeak;
class List;
class Resonance;
class Spectrum;

// ----------------------------------------------------------------------------
//
class Guess_Assignments
{
public:
  Guess_Assignments(int dim);
  Guess_Assignments(const Guess_Assignments &);
  Guess_Assignments &operator=(const Guess_Assignments &);
  virtual ~Guess_Assignments();

  List guesses(CrossPeak *) const;
  List apply_unique_guesses(const List &crosspeaks) const;
  List guessable_resonances(Spectrum *sp,
			    const SRegion &ppm_region, int axis) const;

  //
  // Sequence constraints.
  //
  static const char *any_group;
  static const char *this_group;
  static const char *previous_group;
  static const char *this_or_previous_group;
  static const char *no_group;

  static const char *constraint_names[];

  int dimension;
  const char **sequence_constraint;	// array of length dimension
  Stringy *atom_constraint;		// array of length dimension
  SPoint ppm_range;
};

// ----------------------------------------------------------------------------
//
class Assignment_Guess
{
public:
  Assignment_Guess(int dim, Resonance *rp[]);
  virtual ~Assignment_Guess();
  int dimension() const;
  Resonance *resonance(int i) const;

private:
  int dim;
  Resonance **mRes;
  Assignment_Guess(const Assignment_Guess &);
  Assignment_Guess &operator=(const Assignment_Guess &);
};

// ----------------------------------------------------------------------------
//
void free_assignment_guesses(List &glist);

#endif
