// -*- c++ -*-
/****************************************************************************
** $Id: smtp.h,v 1.5 2003/08/11 07:45:18 rom_vinot Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
** Copyright (C) 1999-2003 Hiroyuki Yamamoto
**
*****************************************************************************/

#ifndef SMTP_H
#define SMTP_H

#include <qobject.h>
#include <qstring.h>

class QSocket;
class QTextStream;
class QDns;

typedef enum
  {
    SMTP_READY,
    SMTP_CONNECTED,
    SMTP_HELO,
    SMTP_EHLO,
    SMTP_FROM,
    SMTP_AUTH,
    SMTP_AUTH_LOGIN_USER,
    SMTP_AUTH_LOGIN_PASS,
    SMTP_RCPT,
    SMTP_DATA,
    SMTP_SEND_DATA,
    SMTP_QUIT,
    SMTP_ERROR,
    SMTP_DISCONNECTED,
    
    N_SMTP_PHASE
  } SMTPState;


class Smtp : public QObject
{
  Q_OBJECT
    
 public:
  Smtp( const QString &smtp, const QString &port, const QString &from, 
	const QString &to, QString &msg, bool useAuthentification, QString &login,
	QString &password);
  ~Smtp();
  void doNothing();
  void error(QString msg);
  
  void sendFrom();
  void sendRcpt();
  void sendData();
  void sendBodyData();
  void sendQuit();

  void sendAuthLogin();
  void receivedAuth(QString &responseLine);
  
 signals:
  void finished();
  void status( const QString & );
  
 private slots:
  void readyRead();
  void deleteMe();
  void dnsLookupHelper();
  void problemTimeOut();

 private:
  QSocket *socket;
  QTextStream * t;
  QString response;
  QDns * dnsLookup;
  SMTPState state;
  
  QString message;
  QString from;
  QString rcpt;
  QString port;
  QString host;
  
  bool useAuthentification;
  QString login;
  QString password;
};

// BASE64

class Base64
{
 public:
  static void Encode(char *out, const char *in, int inlen);
  static int Decode(char *out, const char *in, int inlen);
};

/* MD5 is not working currently : I can't make it to work on Windows... */
/* #include "utils.h" */

/* typedef struct { */
/*   u32 A,B,C,D; */
/*   u32  nblocks; */
/*   unsigned char buf[64]; */
/*   int  count; */
/*   int  finalized; */
/* } MD5_CONTEXT; */

/* void md5_init(MD5_CONTEXT *ctx); */
/* void md5_update(MD5_CONTEXT *hd, const unsigned char *inbuf, size_t inlen); */
/* void md5_final(unsigned char *digest, MD5_CONTEXT *ctx); */

/* void md5_hex_digest(char *hexdigest, const unsigned char *s); */

/* void md5_hmac(unsigned char *digest, */
/*               const unsigned char* text, int text_len, */
/*               const unsigned char* key, int key_len); */


#endif
