#include "qsoundsystem.h"
#include "variables.h"

#include <qsound.h>
#include <iostream>

using namespace std;

QtSoundSystem::QtSoundSystem()
{
  if(!QSound::available()) 
    cout << "Error : no sound device" << endl;
  SoundDir = DATA_DIR;
  SoundDir += DIR_DELIMITER;
  SoundDir += "sounds";
  SoundDir += DIR_DELIMITER;
  SoundFiles[MarineDie] = SoundDir + "marine_killed.wav";
  SoundFiles[MarineMove] = SoundDir + "marine_move.wav";
  SoundFiles[MarineShoot] = SoundDir + "marine_shoot.wav";
  SoundFiles[MarineShootDoor] = SoundDir + "marine_shoot_door.wav";
  SoundFiles[MarineAttack] = SoundDir + "marine_attack.wav";
  SoundFiles[MarineFlame] = SoundDir + "marine_fire.wav";
  SoundFiles[MarineJam] = SoundDir + "marine_jam.wav";
  SoundFiles[MarineUnjam] = SoundDir + "marine_jam.wav";
  SoundFiles[GenestealerAttack] = SoundDir + "genestealer_attack.wav";
  SoundFiles[GenestealerMove] = SoundDir + "marine_move.wav";
  SoundFiles[GenestealerDie] = SoundDir + "genestealer_attack.wav";
  SoundFiles[BlipMove] = SoundDir + "blip_move.wav";
  SoundFiles[DoorOpen] = SoundDir + "door_open.wav";
  SoundFiles[DoorClose] = SoundDir + "door_close.wav";
}

void QtSoundSystem::setSound(SoundSystem::Sound event, QString filename)
{
  SoundFiles[event] = SoundDir + filename;
}

void QtSoundSystem::playSound(SoundSystem::Sound event, bool wait)
{
  if(QSound::available())
    QSound::play(SoundFiles[event]);
}
