#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#include "qinterfaceimpl.h"

#include <qlineedit.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qscrollbar.h>

#include "qpixmapboard.h"
#include "gamemanager.h"
#include "qcommandline.h"
#include "datastoring.h"

/* 
 *  Constructs a QInterfaceImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 */
QInterfaceImpl::QInterfaceImpl( QWidget* parent,  const char* name, WFlags fl )
  : QInterface( parent, name, fl ), cmd(0)
{
  qTurnLabel->setText("No game.");

  bTakeOrDrop->hide();
  // Add the child frames : scrollview and minimap.
  bsv = new BoardScrollView(qmap);
  minimap = new QMiniMap(qmap, bsv);
  minimap->setGeometry(5,5,0,0);
  bsv->pb->setMiniMap(minimap);
  if (store->getPref("minimap")=="hidden")
    minimap->hide();

  // Add a layout on this frame : the scrollview must get all the size.
  QVBoxLayout* vbox = new QVBoxLayout(qmap);
  vbox->addWidget(bsv);
  vbox->activate();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
QInterfaceImpl::~QInterfaceImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */

void QInterfaceImpl::setCommandLine(QCommandLine *cl) 
{
  cmd = cl;
  bsv->pb->setCommandLine(cl);
}

QPixmapBoard * QInterfaceImpl::getPixmapBoard(void) {return bsv->pb;}

void QInterfaceImpl::select(void)
{
  man->selectOnView();
}

void QInterfaceImpl::switchView()
{
  bsv->switchView();
}

void QInterfaceImpl::toggleMinimap()
{
  if (minimap->isVisible())
    minimap->hide();
  else
    minimap->show();
}

bool QInterfaceImpl::isMinimapVisible()
{
  return minimap->isVisible();
}

void QInterfaceImpl::setObjectButtonsVisible(bool vis)
{
  if (vis) {
    bTakeOrDrop->show();
  }
  else {
    bTakeOrDrop->hide();
  }
}

void QInterfaceImpl::customEvent(QCustomEvent *e)
{
  if (e->type() == 1000) {
    QString msg = ((WriteCustomEvent *) e)->getMsg();
    qinfo->append(msg);
#if QT_VERSION < 300
    // QT2
    qinfo->setCursorPosition(qinfo->numLines(),0);
#else
    // QT3:
    QScrollBar *scroll = qinfo->verticalScrollBar();
    scroll->setValue(scroll->maxValue());
#endif
  }
  else if (e->type() == 1001) {
    QString msg = ((WriteCustomEvent *) e)->getMsg();
    qListCreatures->append(msg);
  }
  else if (e->type() == 1002) {
    WriteCustomEvent *we = (WriteCustomEvent *) e;
    QString msg = we->getMsg();
    qSelectedLabel->setText(msg);
  }
  else if (e->type() == 1003) {
    WriteCustomEvent *we = (WriteCustomEvent *) e;
    QString msg = qViewLabel->text();
    if (msg!="")
      msg += "\n";
    msg += we->getMsg();
    qViewLabel->setText(msg);
  }
  else if (e->type() == 1010) {
    ResizeCustomEvent *ev = dynamic_cast<ResizeCustomEvent *>(e);
    int x = ev->getX();
    int y = ev->getY();
    bsv->pb->resize(x,y);
    bsv->pb->update();
    minimap->resize(x/bsv->pb->getZoomSize()*4+1,y/bsv->pb->getZoomSize()*4+1);
    if (store->getPref("minimap")=="hidden")
      minimap->hide();
    else
      minimap->update();
    
  }
  else if (e->type() == 1011) {
    ButtonShowHideCustomEvent *ev=dynamic_cast<ButtonShowHideCustomEvent*>(e);
    setObjectButtonsVisible(ev->getStatus());
  }
  else if (e->type() == 1020) {
    DrawInterfaceCustomEvent *ev = dynamic_cast<DrawInterfaceCustomEvent*>(e);
    if (ev->mustDrawAll())
      cmd->GUIDrawInterface();
    else if (ev->mustClearCreatureList())
      cmd->GUIClearListCreatures();
    else if (ev->mustClearInfoPanel())
      cmd->GUI_ClearInfoPanel();
  }
  else if (e->type() == 1025) {
    CenterCustomEvent *ev = dynamic_cast<CenterCustomEvent*>(e);
    int caseId = ev->centerCaseId();
    bsv->centerView(caseId);
  }
  else
    cmd->GetEvent();
}

void QInterfaceImpl::commandAttack() {cmd->getCommand("attack");}
void QInterfaceImpl::commandShoot() {cmd->getCommand("shoot");}
void QInterfaceImpl::commandFire() {cmd->getCommand("fire");}
void QInterfaceImpl::commandClose(){cmd->getCommand("close");}
void QInterfaceImpl::commandEnter(){cmd->getCommand("enter");}
void QInterfaceImpl::commandMoveEast(){cmd->getCommand("move east");}
void QInterfaceImpl::commandMoveNorth(){cmd->getCommand("move north");}
void QInterfaceImpl::commandMoveSouth(){cmd->getCommand("move south");}
void QInterfaceImpl::commandMoveWest(){cmd->getCommand("move west");}
void QInterfaceImpl::commandMoveNorthEast(){cmd->getCommand("move north-east");}
void QInterfaceImpl::commandMoveNorthWest(){cmd->getCommand("move north-west");}
void QInterfaceImpl::commandMoveSouthEast(){cmd->getCommand("move south-east");}
void QInterfaceImpl::commandMoveSouthWest(){cmd->getCommand("move south-west");}
void QInterfaceImpl::commandOpen(){cmd->getCommand("open");}
void QInterfaceImpl::commandOverwatch(){cmd->getCommand("overwatch");}
void QInterfaceImpl::commandReload(){cmd->getCommand("reload");}
void QInterfaceImpl::commandRevert(){cmd->getCommand("revert");}
void QInterfaceImpl::commandStop(){cmd->getCommand("stop");}
void QInterfaceImpl::commandTurnNorth(){cmd->getCommand("turn north");}
void QInterfaceImpl::commandTurnSouth(){cmd->getCommand("turn south");}
void QInterfaceImpl::commandTurnEast(){cmd->getCommand("turn east");}
void QInterfaceImpl::commandTurnWest(){cmd->getCommand("turn west");}
void QInterfaceImpl::commandUnjam(){cmd->getCommand("unjam");}
void QInterfaceImpl::commandEndTurn(){cmd->getCommand("endturn");}
void QInterfaceImpl::commandTakeOrDrop() {cmd->getCommand("takeordrop");}


void QInterfaceImpl::EnableDisableButtons(void)
{
  Creature *sel = man->getSelected();
  if (sel==0) {
    // No creature selected. You can remove all buttons about actions.
    bMoveNorth->setDisabled(true);
    bMoveNorthEast->setDisabled(true);
    bMoveNorthWest->setDisabled(true);
    bMoveEast->setDisabled(true);
    bMoveWest->setDisabled(true);
    bMoveSouth->setDisabled(true);
    bMoveSouthEast->setDisabled(true);
    bMoveSouthWest->setDisabled(true);
    bTurnNorth->setDisabled(true);
    bTurnSouth->setDisabled(true);
    bTurnEast->setDisabled(true);
    bTurnWest->setDisabled(true);
    bOpen->setDisabled(true);
    bClose->setDisabled(true);
    bTakeOrDrop->setDisabled(true);
    bAttack->setDisabled(true);
    bEnter->setDisabled(true);
    bRevert->setDisabled(true);
    bShoot->setDisabled(true);
    bFire->setDisabled(true);
    bReload->setDisabled(true);
    bStop->setDisabled(true);
    bOverwatch->setDisabled(true);
    bUnjam->setDisabled(true);
    if (man->isInGame()) bEndTurn->setEnabled(true);
    else bEndTurn->setDisabled(true);
    return;
  }
  bEndTurn->setEnabled(true);
  bMoveNorth->setEnabled(true);
  bMoveNorthEast->setEnabled(true);
  bMoveNorthWest->setEnabled(true);
  bMoveEast->setEnabled(true);
  bMoveWest->setEnabled(true);
  bMoveSouth->setEnabled(true);
  bMoveSouthEast->setEnabled(true);
  bMoveSouthWest->setEnabled(true);
  bOpen->setEnabled(true);
  bClose->setEnabled(true);
  
  ObjectType ty = sel->Type();
  if (ty == BLIP || ty == CAT) {
    bTurnNorth->setDisabled(true);
    bTurnSouth->setDisabled(true);
    bTurnEast->setDisabled(true);
    bTurnWest->setDisabled(true);
  }
  else {
    bTurnNorth->setEnabled(true);
    bTurnSouth->setEnabled(true);
    bTurnEast->setEnabled(true);
    bTurnWest->setEnabled(true);
  }

  if (ty==BLIP || ty==GENESTEALER) {
    bAttack->setEnabled(true);
    bEnter->setEnabled(true);
    bRevert->setEnabled(true);
    bShoot->setDisabled(true);
    bFire->setDisabled(true);
    bReload->setDisabled(true);
    bStop->setDisabled(true);
    bOverwatch->setDisabled(true);
    bUnjam->setDisabled(true);
    bTakeOrDrop->setDisabled(true);
  }
  else if (ty==CAT) {
    bAttack->setDisabled(true);
    bEnter->setDisabled(true);
    bRevert->setDisabled(true);
    bShoot->setDisabled(true);
    bFire->setDisabled(true);
    bReload->setDisabled(true);
    bStop->setDisabled(true);
    bOverwatch->setDisabled(true);
    bUnjam->setDisabled(true);
    bTakeOrDrop->setDisabled(true);
  }
  else if (ty==BOLTERMARINE || ty==SERGEANT) {
    bAttack->setEnabled(true);
    bEnter->setDisabled(true);
    bRevert->setDisabled(true);
    bShoot->setEnabled(true);
    bFire->setDisabled(true);
    bReload->setDisabled(true);
    bStop->setEnabled(true);
    bOverwatch->setEnabled(true);
    bUnjam->setEnabled(true);
    bTakeOrDrop->setEnabled(true);
  }
  else if (ty==FLAMER) {
    bAttack->setEnabled(true);
    bEnter->setDisabled(true);
    bRevert->setDisabled(true);
    bShoot->setDisabled(true);
    bFire->setEnabled(true);
    bReload->setEnabled(true);
    bStop->setEnabled(true);
    bOverwatch->setDisabled(true);
    bUnjam->setDisabled(true);
    bTakeOrDrop->setEnabled(true);
  }
}
