// -*- c++ -*-
/****************************************************************************
** $Id: qapplicationwindow.h,v 1.15 2003/09/29 12:05:06 rom_vinot Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H


#ifdef _WIN32

#pragma warning (disable : 4786)

#endif


#include <qmainwindow.h>
#include <qdialog.h>

#include "qinterfaceimpl.h"
#include "qthemeengine.h"

class QMultiLineEdit;
class QToolBar;
class QString;

class ApplicationWindow: public QMainWindow
{
  friend class QDataStoring;
  Q_OBJECT
public:
  ApplicationWindow();
  ~ApplicationWindow();
  
  QInterfaceImpl *getMainWindow();
protected:
  void closeEvent( QCloseEvent* );
  
public slots:
  void newGame();
  void connectPlayer();  
  void load();
  void load(QString filename);
  void save();
  void save(QString filename);
  void quicksave();
  void quickload();
  
  void savePrefs();
  
  void printLevelInfo();
  void switchview();
  void changeTheme(int themeId);
  void useRandomGround(void);
  void viewObjective(void);
  void toggleMinimap(void);
  void changeReplaySpeed(void);

  void rulebook();
  void about();
  void aboutQt();
  
  void redo();
  void message();
  void record();
  void undo();
  
  void boardUp();
  void boardDown();
  void boardLeft();
  void boardRight();
public:
  QInterfaceImpl *main;
private:
  QToolBar *fileTools;
  QString quickfile;
  
  QThemeEngine *themeEngine;
  QPopupMenu *themes;
  
  QPopupMenu *view;
  QPopupMenu *command;
  int buttonRandomGround;
  int buttonObjective;
  int buttonRecording;
  
  int idNewButton;
  map<int, QString> themesId;
  map<QString, int> themesString;
};

class QMessageWindow : public QDialog
{ 
  Q_OBJECT
  
public:
  QMessageWindow( QWidget* parent, QString *msg );
  ~QMessageWindow();
  
  QLabel *title;
  QMultiLineEdit *qmsg;
  QPushButton* ok;
  
private slots:
  void finish();
  
protected:
  QVBoxLayout* msgLayout;
  QHBoxLayout* Layout3;
  
private:
  QString *msg;
};

#endif
