/***************************************************************************
                          network.cpp  -  description
                             -------------------
    begin                : lun aug 21 15:20:00 CET 2003
    copyright            : (C) 2003 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#ifdef _WIN32
#include "zlib.h"
#else
#include <zlib.h>
#endif

#include <qsocket.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qregexp.h>

#include "network.h"

#include "guicommandline.h"
#include "gamemanager.h"

const float NETPROTOCOL_VERSION=1;

NetworkServer::NetworkServer(GUICommandLine *gc)
  : QServerSocket(9678,1), guicmd(gc)
{}

NetworkServer::~NetworkServer() {}

void NetworkServer::newConnection(int socket)
{
  guicmd->Write("Connection received. The game can begin.");
  man->setConnection(socket);
}

NetworkInterface::NetworkInterface(GUICommandLine *gc, QString ip)
  : guicmd(gc), socket(), stateRetrieving(false)
{
  socket = new QSocket();
  socket->connectToHost(ip,9678);
  stream = new QTextStream( socket );
  connect ( socket, SIGNAL (readyRead()), this, SLOT(readyRead()) );
  connect ( socket, SIGNAL (hostFound()), this, SLOT(hostFound()) );
  connect ( socket, SIGNAL (connected()), this, SLOT(connected()) );
  connect ( socket, SIGNAL (connectionClosed()),this,SLOT(connectionClosed()));
}

NetworkInterface::NetworkInterface(GUICommandLine *gc, int socketid)
  : guicmd(gc), socket(), stateRetrieving(false)
{
  socket = new QSocket();
  socket->setSocket(socketid);
  stream = new QTextStream( socket );
  connect ( socket, SIGNAL( readyRead() ), this, SLOT( readyRead() ) );
  connect ( socket, SIGNAL (connectionClosed()),this,SLOT(connectionClosed()));
}

NetworkInterface::~NetworkInterface()
{
  delete stream;
  delete socket;
}

void NetworkInterface::connectionClosed()
{
  guicmd->Write("The connection has been closed");
}

void NetworkInterface::hostFound()
{
  guicmd->Write("The host has been found.");
}

void NetworkInterface::connected()
{
  QString msg;
  msg.sprintf("protocolversion %f",NETPROTOCOL_VERSION);
  sendCommand(msg);
  guicmd->Write("Connection done with the other player.\n"
		"You will now receive the map.");
}

void NetworkInterface::readyRead()
{
  while( socket->canReadLine() ) {
    QString responseLine = socket->readLine();
    cout << "Network message : [" << responseLine.latin1() << "]\n";
    
    if (stateRetrieving) {
      if (responseLine.startsWith("file end")) {
	guicmd->getCommand("network filereceived");
	stateRetrieving = false;
      }
      else
	fileContent += responseLine;
    }
    else if (responseLine.startsWith("protocolversion")) {
      float version = responseLine.right(responseLine.length()-16).toFloat();
      if (version != NETPROTOCOL_VERSION) {
	QString msg;
	msg.sprintf("A connection is established with a client of protocol "
		    "version %f.\nYou have the version %f.\nThe game cannot "
		    "be played with different versions of the protocol.",
		    version,NETPROTOCOL_VERSION);
	guicmd->Write(msg);
	socket->close();
	return;
      } 
      guicmd->getCommand("network init");
    }
    else if (responseLine.startsWith("file begin ")) {
      fileContent="";
      stateRetrieving=true;
    }
    else if (responseLine.startsWith("file end ")) {
      guicmd->getCommand("network filereceived");
      cout << fileContent << endl;
    }
    else {
      responseLine.truncate(responseLine.length()-1);
      cout << "Command received: [" << responseLine.latin1() << "]\n";
      man->replaysMutex.lock();
      man->replays.push_back(responseLine);
      man->replaysMutex.unlock();
      guicmd->PostNetworkCommand();
    }
  }
}

void NetworkInterface::sendSaveGame(QString &content, bool initgame)
{
  *stream << "file begin load\n" << content << "file end load\n";
}

void NetworkInterface::sendCommand(QString &cmd)
{
  *stream << cmd << endl;
}

QString NetworkInterface::getFileContent(void)
{
  return fileContent;
}
