#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#include <sstream>

#include "levelobject.h"
#include "level.h"
#include "board.h"
#include "guicommandline.h"
#include "gamemanager.h"

using namespace std;

/******************
 * class LevelRef *
 ******************/

LevelRef::LevelRef(LvlObjectType ptype, QString pname)
{
  type = ptype;
  name = pname;
}

LevelRef::LevelRef(LvlObjectType ptype, LevelObject *pobject,
		   QString pname)
{
  type = ptype;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlBlip *pobject, QString pname)
{
  type = OT_BLIP;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlGenestealer *pobject, QString pname)
{
  type = OT_GENESTEALER;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlBolter *pobject, QString pname)
{
  type = OT_TERMINATOR;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlSergeant *pobject, QString pname)
{
  type = OT_SERGEANT;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlFlamer *pobject, QString pname)
{
  type = OT_FLAMER;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlCAT *pobject, QString pname)
{
  type = OT_CAT;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlEntry *pobject, QString pname)
{
  type = OT_ENTRY;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlDoor *pobject, QString pname)
{
  type = OT_DOOR;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlBulkhead *pobject, QString pname)
{
  type = OT_BULKHEAD;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlExit *pobject, QString pname)
{
  type = OT_EXIT;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlExtensible *pobject, QString pname)
{
  type = OT_EXTENSIBLE;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlZone *pobject, QString pname)
{
  type = OT_ZONE;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlZoneList *pobject, QString pname)
{
  type = OT_ZONELIST;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlSquad *pobject, QString pname)
{
  type = OT_SQUAD;
  objects.push_back(pobject);
  name = pname;
}

LevelRef::LevelRef(LvlValue *pobject, QString pname)
{
  type = OT_VALUE;
  objects.push_back(pobject);
  name = pname;
}

LevelObject& LevelRef::operator*()
{
  return **objects.begin();
}

LevelRef::~LevelRef()
{
  iterator i;
  for(i = begin() ; i != end() ; i++)
    {
      delete *i;
    }
}

const QString& LevelRef::getName()
{
  return name;
}

LvlObjectType LevelRef::getType()
{
  return type;
}

LevelRef::iterator LevelRef::begin()
{
  return objects.begin();
}

LevelRef::iterator LevelRef::end()
{
  return objects.end();
}

int LevelRef::size()
{
  return objects.size();
}

void LevelRef::AddObject(LvlObjectType t, LevelObject *object)
{
  if(t & type)
    {
      objects.push_back(object);
    }
}

void LevelRef::AddObject(LvlBlip *object)
{
  if(type & OT_BLIP)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlGenestealer *object)
{
  if(type & OT_GENESTEALER)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlBolter *object)
{
  if(type & OT_TERMINATOR)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlSergeant *object)
{
  if(type & OT_SERGEANT)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlFlamer *object)
{
  if(type & OT_FLAMER)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlCAT *object)
{
  if(type & OT_FLAMER)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlEntry *object)
{
  if(type & OT_ENTRY)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlDoor *object)
{
  if(type & OT_DOOR)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlBulkhead *object)
{
  if(type & OT_BULKHEAD)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlExit *object)
{
  if(type & OT_EXIT)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlExtensible *object)
{
  if (type & OT_EXTENSIBLE)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlZone *object)
{
  if(type & OT_ZONE)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlZoneList *object)
{
  if(type & OT_ZONELIST)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlSquad *object)
{
  if(type & OT_SQUAD)
    {
      AddObject(type, object);
    }
}

void LevelRef::AddObject(LvlValue *object)
{
  if(type & OT_VALUE)
    {
      AddObject(type, object);
    }
}

/***********************
 * LevelObject classes *
 ***********************/

LevelObject::LevelObject()
{
  is_ref = false;
  guiCreature = NULL;
  guiCmdLine = NULL;
  level = NULL;
}

LvlObjectType LevelObject::Type()
{
  return type;
}

LvlObjectType LevelObject::Name2LvlType(QString name)
{
  if(name == "terminator")
    {
      return OT_TERMINATOR;
    }
  else if(name == "flamer")
    {
      return OT_FLAMER;
    }
  else if(name == "sergeant")
    {
      return OT_SERGEANT;
    }
  else if(name == "squad")
    {
      return OT_SQUAD;
    }
  else if(name == "genestealer")
    {
      return OT_GENESTEALER;
    }
  else if(name == "blip")
    {
      return OT_BLIP;
    }
  else if(name == "cat")
    {
      return OT_CAT;
    }
  else if(name == "floor")
    {
      return OT_FLOOR;
    }
  else if(name == "door")
    {
      return OT_DOOR;
    }
  else if(name == "bulkhead")
    {
      return OT_BULKHEAD;
    }
  else if(name == "entry")
    {
      return OT_ENTRY;
    }
  else if(name == "exit")
    {
      return OT_EXIT;
    }
  else if (name == "extensible")
    {
      return OT_EXTENSIBLE;
    }
  else if(name == "zone")
    {
      return OT_ZONE;
    }
  else if(name == "zone_set")
    {
      return OT_ZONELIST;
    }
  else if(name == "creature")
    {
      return OT_CREATURE;
    }
  else if(name == "alien")
    {
      return OT_ALIEN;
    }
  else if(name == "marine")
    {
      return OT_MARINE;
    }
  return OT_NONE;
}

QString LevelObject::LvlType2Name(LvlObjectType object)
{
  switch(object)
    {
    case OT_TERMINATOR:
      return "terminator";
    case OT_FLAMER:
      return "flamer";
    case OT_SERGEANT:
      return "sergeant";
    case OT_SQUAD:
      return "squad";
    case OT_GENESTEALER:
      return "genestealer";
    case OT_BLIP:
      return "blip";
    case OT_CAT:
      return "cat";
    case OT_FLOOR:
      return "floor";
    case OT_DOOR:
      return "door";
    case OT_BULKHEAD:
      return "bulkhead";
    case OT_ENTRY:
      return "entry";
    case OT_EXIT:
      return "exit";
    case OT_EXTENSIBLE:
      return "extensible";
    case OT_ZONE:
      return "zone";
    case OT_ZONELIST:
      return "zone_set";
    case OT_CREATURE:
      return "creature";
    case OT_ALIEN:
      return "alien";
    case OT_MARINE:
      return "marine";
    default:
      return "";
    }
}

LvlObjectType LevelObject::Type2LvlType(ObjectType type)
{
  switch(type)
    {
    case DOOR:
      return OT_DOOR;
    case BULKHEAD:
      return OT_BULKHEAD;
    case ENTRYZONE:
      return OT_ENTRY;
    case EXIT:
      return OT_EXIT;
    case EXTENSIBLE:
      return OT_EXTENSIBLE;
    case FLAME:
      return OT_NONE;
    case CAT:
      return OT_CAT;
    case GENESTEALER:
      return OT_GENESTEALER;
    case BLIP:
      return OT_BLIP;
    case BOLTERMARINE:
      return OT_TERMINATOR;
    case SERGEANT:
      return OT_SERGEANT;
    case FLAMER:
      return OT_FLAMER;
    default:
      return OT_NONE;
    }
}

ObjectType LevelObject::LvlType2Type(LvlObjectType type)
{
  switch(type)
    {
    case OT_DOOR:
      return DOOR;
    case OT_BULKHEAD:
      return BULKHEAD;
    case OT_ENTRY:
      return ENTRYZONE;
    case OT_EXIT:
      return EXIT;
    case OT_EXTENSIBLE:
      return EXTENSIBLE;
    case OT_CAT:
      return CAT;
    case OT_GENESTEALER:
      return GENESTEALER;
    case OT_BLIP:
      return BLIP;
    case OT_TERMINATOR:
      return BOLTERMARINE;
    case OT_SERGEANT:
      return SERGEANT;
    case OT_FLAMER:
      return FLAMER;
    default:
      return NB_OBJECT_TYPE;
    }
}

LvlValue::LvlValue()
{
  type = OT_VALUE;
  value = 0;
}

LvlValue::LvlValue(int v)
{
  type = OT_VALUE;
  value = v;
}

LvlUserPutObject::LvlUserPutObject()
{
  unit = NULL;
  position = -1;
  dir = NODIRECTION;
}

void LvlUserPutObject::getParameters(set<int> *cases)
{
  if(dir == NODIRECTION)
    {
      pair<int,pair<Direction,bool> > param = 
	guiCmdLine->GetCaseAndDirection(cases, PlaceUnit(),false);
      position = param.first;
      dir = param.second.first;
      man->recordCommand(QString("get casedir ") + QString::number(position) +
			 " " + dir2string(dir) + " noreuse");
    }
  else
    {
      position = guiCmdLine->GetCase(cases, PlaceUnit());
      man->recordCommand(QString("get case ") + QString::number(position));
    }
}

LvlUnit* LvlUnit::ConvertUnit(Object *obj, Level *level)
{
  switch(obj->Type())
    {
    case CAT:
      return LvlCAT::Build(dynamic_cast<ModuleCAT*>(obj), level);
    case GENESTEALER:
      return LvlGenestealer::Build(dynamic_cast<Genestealer*>(obj), level);
    case BLIP:
      return LvlBlip::Build(dynamic_cast<Blip*>(obj), level);
    case BOLTERMARINE:
      return LvlBolter::Build(dynamic_cast<BolterMarine*>(obj), level);
    case SERGEANT:
      return LvlSergeant::Build(dynamic_cast<Sergeant*>(obj), level);
    case FLAMER:
      return LvlFlamer::Build(dynamic_cast<FlamerMarine*>(obj), level);
    default:
      return NULL;
    }
}

LvlUnit::LvlUnit()
{}

int LvlUnit::getActPts()
{
  return (dynamic_cast<Creature*>(unit))->EndTurnActionPts();
}

bool LvlUnit::hasAnObject()
{
  return (dynamic_cast<Creature*>(unit))->hasAnObject();
}

LvlZone::LvlZone()
{
  type = OT_ZONE;
}

set<int>* LvlZone::getCases()
{
  return new set<int>(cases);
}

QString LvlZone::getDesc()
{
  return "a zone";
}

bool LvlZone::contains(int Position)
{
  set<int>::iterator it;
  for(it = cases.begin() ; it != cases.end() ; it++)
    {
      if((*it) == Position)
	{
	  return true;
	}
    }
  return false;
}

LvlZone* LvlZone::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  QString str_x, str_y;
  int x1,y1,x2,y2;
  LvlZone* result = NULL;
  if(!child.isNull()) 
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlZone*>(&**l->getRef(name));
	  //cout << "Zone reference : " << name << endl;
	}
      else
	{
	  result = new LvlZone;
	  while(!child.isNull())
	    {
	      if(child.tagName() == "case")
		{
		  str_x = child.attribute("x");
		  str_y = child.attribute("y");
		  x1 = atoi(str_x);
		  y1 = atoi(str_y);
		  result->cases.insert(result->cases.end(),board->getCaseId(x1,y1));
		  //cout << "Add point " << x1 << "," << y1 << " => "
		  //     << "size of set = " << result->cases.size() << endl;
		}
	      else if (child.tagName() == "rect")
		{
		  str_x = child.attribute("x1");
		  str_y = child.attribute("y1");
		  x1 = atoi(str_x);
		  y1 = atoi(str_y);
		  str_x = child.attribute("x2");
		  str_y = child.attribute("y2");
		  x2 = atoi(str_x);
		  y2 = atoi(str_y);
		  for(int x = x1 ; x <= x2 ; x++)
		    {
		      for(int y = y1 ; y <= y2 ; y++)
			{
			  result->cases.insert(result->cases.end(), board->getCaseId(x,y));
			  //cout << "Add point " << x << "," << y << " => "
			  //     << "size of set = " << result->cases.size() << endl;
			}
		    }
		}
	      else if(child.tagName() == "zone_set")
		{
		  LvlZoneList *zonelist = LvlZoneList::Build(child, l);
		  set<int>* cases = zonelist->getCases();
		  for (set<int>::iterator it=cases->begin(); it!=cases->end(); it++) 
			result->cases.insert(*it);
		  delete cases;
		  if(!zonelist->is_ref)
		    {
		      delete zonelist;
		    }
		}
	      child = child.nextSibling().toElement();
	    }
	  QString name = e.attribute("name");
	  if(!name.isNull())
	    {
	      LevelRef *ref = new LevelRef(result, name);
	      l->setRef(ref);
	      result->is_ref = true;
	    }
	}
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
    }
  return result;
}

LvlZoneList::LvlZoneList()
{
  type = OT_ZONELIST;
}

set<int>* LvlZoneList::getCases()
{
  std::list<LvlZone*>::iterator it;
  set<int> *result = new set<int>, *local;
  for(it = zone_list.begin() ; it != zone_list.end() ; it++)
    {
      local = (*it)->getCases();
      for (set<int>::iterator ite=local->begin(); ite!=local->end(); ite++) {
	result->insert(*ite);
      }
      delete local;
    }
  return result;
}

QString LvlZoneList::getDesc()
{
  return "a zone list";
}

LvlZone* LvlZoneList::containing(int Position)
{
  list<LvlZone*>::iterator it;
  for(it = zone_list.begin() ; it != zone_list.end() ; it++)
    {
      if((*it)->contains(Position))
	{
	  return *it;
	}
    }
  return NULL;
}

LvlZoneList* LvlZoneList::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  LvlZoneList* result = NULL;
  if(!child.isNull())
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlZoneList*>(&**l->getRef(name));
	}
      else
	{
	  result = new LvlZoneList;
	  while(!child.isNull())
	    {
	      if(child.tagName() == "zone")
		{
		  result->zone_list.push_back(LvlZone::Build(child,l));
		}
	      child = child.nextSibling().toElement();
	    }
	  QString name = e.attribute("name");
	  if(!name.isNull())
	    {
	      LevelRef *ref = new LevelRef(result, name);
	      l->setRef(ref);
	      result->is_ref = true;
	    }	
	}
    }
  return result;
}



/*******************
 * LvlUnit classes *
 *******************/


LvlSquad::LvlSquad()
{
  type = OT_SQUAD;
}

LvlSquad* LvlSquad::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  LvlSquad* result = NULL;
  QString str_dir = e.attribute("direction", "none");
  Direction dir(NODIRECTION);
  if(str_dir == "none")
    {
      dir = NODIRECTION;
    }
  else if(str_dir == "east")
    {
      dir = EAST;
    }
  else if(str_dir == "west")
    {
      dir = WEST;
    }
  else if(str_dir == "north")
    {
      dir = NORTH;
    }
  else if(str_dir == "south")
    {
      dir = SOUTH;
    }
  if(!child.isNull())
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlSquad*>(&**l->getRef(name));
	}
      else
	{
	  LvlUnit *m;
	  result = new LvlSquad;
	  while(!child.isNull())
	    {
	      if(child.tagName() == "terminator")
		{
		  m = LvlBolter::Build(child, l);
		}
	      else if(child.tagName() == "flamer")
		{
		  m = LvlFlamer::Build(child, l);
		}
	      else if(child.tagName() == "sergeant")
		{
		  m = LvlSergeant::Build(child, l);
		}
	      else if(child.tagName() == "blip")
		{
		  m = LvlBlip::Build(child, l);
		}
	      else if(child.tagName() == "genestealer")
		{
		  m = LvlGenestealer::Build(child, l);
		}
	      else if(child.tagName() == "cat")
		{
		  m = LvlCAT::Build(child, l);
		}
	      else
		{
		  cout << "Error, " << child.tagName() << " cannot be part of a squad" << endl;
		  exit(10);
		}
	      m->dir = dir;
	      result->members.push_back(m);
	      child = child.nextSibling().toElement();
	    }
	}
    }
  else
    {
      LvlUnit *unit;
      result = new LvlSquad;
      unit = new LvlBolter;
      unit->guiCmdLine = l->guiCmdLine;
      unit->guiCreature = l->guiCreature;
      unit->level = l;
      unit->dir = dir;
      result->members.push_front(unit);
      unit = new LvlBolter;
      unit->guiCmdLine = l->guiCmdLine;
      unit->guiCreature = l->guiCreature;
      unit->level = l;
      unit->dir = dir;
      result->members.push_front(unit);
      unit = new LvlBolter;
      unit->guiCmdLine = l->guiCmdLine;
      unit->guiCreature = l->guiCreature;
      unit->level = l;
      unit->dir = dir;
      result->members.push_front(unit);
      unit = new LvlFlamer;
      unit->guiCmdLine = l->guiCmdLine;
      unit->guiCreature = l->guiCreature;
      dynamic_cast<LvlFlamer*>(unit)->charger = 1;
      unit->level = l;
      unit->dir = dir;
      result->members.push_front(unit);
      unit = new LvlSergeant;
      unit->guiCmdLine = l->guiCmdLine;
      unit->guiCreature = l->guiCreature;
      unit->level = l;
      unit->dir = dir;
      result->members.push_front(unit);
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}	
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
    }
  return result;
}

QString LvlSquad::getDesc()
{
  QString result;
  if(!name.isNull())
    {
      result = QString("a squad ") + name + " with :\n";
    }
  else
    {
      result = "a squad with;\n";
    }
  list<LvlUserPutObject*>::iterator i;
  for(i = members.begin() ; i != members.end() ; i++)
    {
      result += "\t" + (*i)->getDesc() + "\n";
    }
  return result;
}


LvlBlip::LvlBlip()
{
  type = OT_BLIP;
}

void LvlBlip::getParameters(set<int> *cases)
{
  set<int> finalCases;
  for (set<int>::iterator it=cases->begin(); it!=cases->end(); it++) {
    set<Object *>* obj = board->getObject(*it);
    int count=0;
    int max=3;
    for(set<Object*>::iterator ite = obj->begin() ; ite!=obj->end() ; ite++) {
      if((*ite)->Type() == BLIP)
	count ++;
      else if ((*ite)->Type() == ENTRYZONE)
	max = dynamic_cast<EntryZone *>(*ite)->getMaxBlip();
    }
    if(count < max)
      finalCases.insert(*it);
  }
  
  if (finalCases.size()==0)
    position = -1;
  else {
    position = guiCmdLine->GetCase(&finalCases, PlaceUnit());
    man->recordCommand(QString("get case ") + QString::number(position));
  }
}

QString LvlBlip::PlaceUnit()
{
  return "Select the position of this blip";
}

Object* LvlBlip::CreateObject()
{
  Blip *object;
  object = new Blip(guiCreature, guiCmdLine, position, man->getCurrentMaxId(), nbGen);
  if(position != -1)
    {
      man->NewCreature(object);
    }
  return object;
}

QString LvlBlip::getDesc()
{
  QString res;
  if (man->isInReplayMode())
    res = "a blip with unknown number of genestealers";
  else
    res.sprintf("a blip with %d genestealer",nbGen);
  return res;
}

LvlBlip* LvlBlip::Build(Blip *obj, Level *l)
{
  LvlBlip *result = new LvlBlip;
  result->guiCmdLine = l->guiCmdLine;
  result->guiCreature = l->guiCreature;
  result->level = l;
  result->unit = obj;
  return result;
}

LvlBlip* LvlBlip::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  LvlBlip* result = NULL;
  if(!child.isNull())
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlBlip*>(&**l->getRef(name));
	}
    }
  else
    {
      result = new LvlBlip;
      QString wait = e.attribute("wait","yes");
      result->wait = (wait == "yes")?true:false;
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}	
      result->unit = NULL;
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
    }
  return result;
}

LvlGenestealer::LvlGenestealer()
{
  type = OT_GENESTEALER;
}

QString LvlGenestealer::PlaceUnit()
{
  return "Give the position and direction the genestealer";
}

Object* LvlGenestealer::CreateObject()
{
  Genestealer *object = new Genestealer(guiCreature, guiCmdLine, position, man->getCurrentMaxId(), dir);
  man->NewCreature(object);
  return object;
}

QString LvlGenestealer::getDesc()
{
  return "a genestealer";
}

LvlGenestealer* LvlGenestealer::Build(Genestealer *obj, Level *l)
{
  LvlGenestealer *result = new LvlGenestealer;
  result->guiCmdLine = l->guiCmdLine;
  result->guiCreature = l->guiCreature;
  result->level = l;
  result->unit = obj;
  result->dir = NODIRECTION;
  return result;
}

LvlGenestealer* LvlGenestealer::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  LvlGenestealer* result = NULL;
  QString str_dir = e.attribute("direction", "none");
  Direction dir(NODIRECTION);
  if(str_dir == "none")
    {
      dir = NODIRECTION;
    }
  else if(str_dir == "east")
    {
      dir = EAST;
    }
  else if(str_dir == "west")
    {
      dir = WEST;
    }
  else if(str_dir == "north")
    {
      dir = NORTH;
    }
  else if(str_dir == "south")
    {
      dir = SOUTH;
    }
  if(!child.isNull())
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlGenestealer*>(&**l->getRef(name));
	}
    }
  else
    {
      result = new LvlGenestealer;
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}	
      result->unit = NULL;
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
      result->dir = dir;
    }
  return result;
}

LvlBolter::LvlBolter()
{
  type = OT_TERMINATOR;
}

QString LvlBolter::PlaceUnit()
{
  return "Give the position and direction the terminator ";
}

Object* LvlBolter::CreateObject()
{
  BolterMarine *object = new BolterMarine(guiCreature, guiCmdLine, position, man->getCurrentMaxId(), dir, level->CmdPts);
  man->NewCreature(object);
  return object;
}

QString LvlBolter::getDesc()
{
  return "a bolter";
}

LvlBolter* LvlBolter::Build(BolterMarine *obj, Level *l)
{
  LvlBolter *result = new LvlBolter;
  result->guiCmdLine = l->guiCmdLine;
  result->guiCreature = l->guiCreature;
  result->level = l;
  result->unit = obj;
  result->dir = NODIRECTION;
  return result;
}

LvlBolter* LvlBolter::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  LvlBolter* result = NULL;
  QString str_dir = e.attribute("direction", "none");
  Direction dir(NODIRECTION);
  if(str_dir == "none")
    {
      dir = NODIRECTION;
    }
  else if(str_dir == "east")
    {
      dir = EAST;
    }
  else if(str_dir == "west")
    {
      dir = WEST;
    }
  else if(str_dir == "north")
    {
      dir = NORTH;
    }
  else if(str_dir == "south")
    {
      dir = SOUTH;
    }
  if(!child.isNull())
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlBolter*>(&**l->getRef(name));
	}
    }
  else
    {
      result = new LvlBolter;
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}
      result->unit = NULL;
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
      result->dir = dir;
    }
  return result;
}

LvlFlamer::LvlFlamer()
{
  type = OT_FLAMER;
}

QString LvlFlamer::PlaceUnit()
{
  return "Give the position and direction the flamer";
}

Object* LvlFlamer::CreateObject()
{
  FlamerMarine *object = new FlamerMarine(guiCreature, guiCmdLine, position, man->getCurrentMaxId(), dir, level->CmdPts, charger);
  man->NewCreature(object);
  return object;
}

QString LvlFlamer::getDesc()
{
  return "a flamer";
}

LvlFlamer* LvlFlamer::Build(FlamerMarine *obj, Level *l)
{
  LvlFlamer *result = new LvlFlamer;
  result->guiCmdLine = l->guiCmdLine;
  result->guiCreature = l->guiCreature;
  result->level = l;
  result->unit = obj;
  result->dir = NODIRECTION;
  result->charger = 1;
  return result;
}

LvlFlamer* LvlFlamer::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  LvlFlamer* result = NULL;
  QString str_dir = e.attribute("direction", "none");
  Direction dir(NODIRECTION);
  if(str_dir == "none")
    {
      dir = NODIRECTION;
    }
  else if(str_dir == "east")
    {
      dir = EAST;
    }
  else if(str_dir == "west")
    {
      dir = WEST;
    }
  else if(str_dir == "north")
    {
      dir = NORTH;
    }
  else if(str_dir == "south")
    {
      dir = SOUTH;
    }
  if(!child.isNull())
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlFlamer*>(&**l->getRef(name));
	}
    }
  else
    {
      result = new LvlFlamer;
      result->charger = e.attribute("charger","1").toInt();
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}
      result->unit = NULL;
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
      result->dir = dir;
    }
  return result;
}

LvlSergeant::LvlSergeant()
{
  type = OT_SERGEANT;
}

QString LvlSergeant::PlaceUnit()
{
  return "Give the position and direction the sergeant";
}

Object* LvlSergeant::CreateObject()
{
  Sergeant *object = new Sergeant(guiCreature, guiCmdLine, position, man->getCurrentMaxId(), dir, level->CmdPts);
  man->NewCreature(object);
  return object;
}

QString LvlSergeant::getDesc()
{
  return "a sergeant";
}

LvlSergeant* LvlSergeant::Build(Sergeant *obj, Level *l)
{
  LvlSergeant *result = new LvlSergeant;
  result->guiCmdLine = l->guiCmdLine;
  result->guiCreature = l->guiCreature;
  result->level = l;
  result->unit = obj;
  result->dir = NODIRECTION;
  return result;
}

LvlSergeant* LvlSergeant::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  LvlSergeant* result = NULL;
  QString str_dir = e.attribute("direction", "none");
  Direction dir(NODIRECTION);
  if(str_dir == "none")
    {
      dir = NODIRECTION;
    }
  else if(str_dir == "east")
    {
      dir = EAST;
    }
  else if(str_dir == "west")
    {
      dir = WEST;
    }
  else if(str_dir == "north")
    {
      dir = NORTH;
    }
  else if(str_dir == "south")
    {
      dir = SOUTH;
    }
  if(!child.isNull())
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlSergeant*>(&**l->getRef(name));
	}
    }
  else
    {
      result = new LvlSergeant;
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}
      result->unit = NULL;
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
      result->dir = dir;
    }
  return result;
}

LvlCAT::LvlCAT()
{
  type = OT_CAT;
}

void LvlCAT::getParameters(set<int> *cases)
{
  position = guiCmdLine->GetCase(cases, PlaceUnit());
  man->recordCommand(QString("get case ") + QString::number(position));
}

QString LvlCAT::PlaceUnit()
{
  return "Give the position of the CAT module";
}

Object* LvlCAT::CreateObject()
{
  ModuleCAT *object = new ModuleCAT(guiCreature, guiCmdLine, position, man->getCurrentMaxId());
  man->NewCreature(object);
  set<Object *> *obj = board->getObject(position);
  if (obj) {
    set<Object *>::iterator it = obj->begin();
    if (it!=obj->end())
      (*it)->automaticTakeObject(object);
  }
  guiCmdLine->setObjectButtonsVisible(true);
  return object;
}

QString LvlCAT::getDesc()
{
  return "a CAT module";
}

LvlCAT* LvlCAT::Build(ModuleCAT *obj, Level *l)
{
  LvlCAT *result = new LvlCAT;
  result->guiCmdLine = l->guiCmdLine;
  result->guiCreature = l->guiCreature;
  result->level = l;
  result->unit = obj;
  result->dir = NODIRECTION;
  return result;
}

LvlCAT* LvlCAT::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  LvlCAT* result = NULL;
  if(!child.isNull())
    {
      if(child.tagName() == "ref")
	{
	  QString name = child.attribute("name");
	  result = dynamic_cast<LvlCAT*>(&**l->getRef(name));
	}
    }
  else
    {
      result = new LvlCAT;
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}
      result->unit = NULL;
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
      result->dir = NODIRECTION;
    }
  return result;
}

/******************
 * class LvlFloor *
 ******************/

LvlFloor::LvlFloor()
{
  type = OT_FLOOR;
}

void LvlFloor::ApplyOnBoard()
{
  set<int>::iterator i;
  for(i = zone->cases.begin(); i != zone->cases.end() ; i++)
    {
      board->addCase(*i);
    }
  object = NULL;
}

LvlFloor* LvlFloor::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  if(child.tagName() == "zone")
    {
      LvlFloor *result = new LvlFloor;
      result->zone = LvlZone::Build(child,l);
      if(result != NULL)
	{
	  result->guiCmdLine = l->guiCmdLine;
	  result->guiCreature = l->guiCreature;
	  result->level = l;
	}
      return result;
    }
  else
    {
      cout << "Error, first child of node " << e.tagName()
	   << " must be \"zone\"" << endl;
      exit(2);
    }
}

/*****************
 * class LvlDoor *
 *****************/

LvlDoor::LvlDoor()
{
  type = OT_DOOR;
}

LvlDoor* LvlDoor::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  QString open = e.attribute("open", "no");
  QString vertical = e.attribute("vertical", "no");
  if(child.tagName() == "ref")
    {
      QString name = child.attribute("name");
      return dynamic_cast<LvlDoor*>(&**l->getRef(name));
    }
  else if(child.tagName() == "zone")
    {
      LvlDoor *result = new LvlDoor;
      result->zone = LvlZone::Build(child,l);
      result->object = new Door(l->guiCreature, l->guiCmdLine, 0, (vertical == "yes")?true:false, (open == "yes")?OPEN:CLOSE);
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef((LvlDoor*)result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}
      if(result != NULL)
	{
	  result->guiCmdLine = l->guiCmdLine;
	  result->guiCreature = l->guiCreature;
	  result->level = l;
	}
      return result;	
    }
  else
    {
      cout << "Error, first child of node " << e.tagName()
	   << " must be \"zone\"" << endl;
      exit(2);
    }
}

LvlDoor* LvlDoor::Build(Door* d, Level *l)
{
  LvlDoor *result = new LvlDoor;
  result->object = d;
  result->level = l;
  result->guiCmdLine = l->guiCmdLine;
  result->guiCreature = l->guiCreature;
  return result;
}


/*********************
 * class LvlBulkhead *
 *********************/

LvlBulkhead::LvlBulkhead()
{
  type = OT_BULKHEAD;
}

LvlBulkhead* LvlBulkhead::Build(const QDomElement& e, Level *l)
{
  QDomElement child = e.firstChild().toElement();
  QString open = e.attribute("open", "yes");
  QString can_open = e.attribute("can_open", "no");
  QString can_close = e.attribute("can_closed", "yes");
  QString vertical = e.attribute("vertical", "no");
  if(child.tagName() == "ref")
    {
      QString name = child.attribute("name");
      return dynamic_cast<LvlBulkhead*>(&**l->getRef(name));
    }
  else if(child.tagName() == "zone")
    {
      LvlBulkhead *result = new LvlBulkhead;
      result->zone = LvlZone::Build(child,l);
      result->object = new Bulkhead(l->guiCreature, l->guiCmdLine, 0,
				    (open == "yes")?OPEN:CLOSE,
				    (vertical == "yes"), (can_open == "yes"),
				    (can_close == "yes"));
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef((LvlBulkhead*)result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}
      if(result != NULL)
	{
	  result->guiCmdLine = l->guiCmdLine;
	  result->guiCreature = l->guiCreature;
	  result->level = l;
	}
      return result;	
    }
  else
    {
      cout << "Error, first child of node " << e.tagName()
	   << " must be \"zone\"" << endl;
      exit(2);
    }
}


/**********************
 * class LvlMapObject *
 **********************/

QString LvlMapObject::getDesc()
{
  return "a map object";
}

void LvlMapObject::ApplyOnBoard()
{
  set<int>::iterator i;
  int posId;
  for(i = zone->cases.begin(); i != zone->cases.end() ; i++)
    {
      posId = board->addCase(*i);
      //cout << "Object on case : " << (*i).x << "," << (*i).y << endl;
      Object* copy = object->getCopy();
      copy->setPosition(posId);
      board->addObject(copy);
    }
}

LvlMapObject::~LvlMapObject()
{
  if(!zone->is_ref)
    {
      delete zone;
    }
  if(object != NULL)
    {
      delete object;
    }
}

/******************
 * class LvlEntry *
 ******************/

LvlEntry::LvlEntry()
{
  type = OT_ENTRY;
}

LvlEntry* LvlEntry::Build(const QDomElement& e, Level *l)
{
  QString ori = e.attribute("direction", "north");
  Direction direc(NORTH);
  if (ori=="north")
    {
      direc=NORTH;
    }
  else if (ori=="south")
    {
      direc=SOUTH;
    }
  else if (ori=="west") 
    {
      direc=WEST;
    }
  else if (ori=="east") 
    {
      direc=EAST;
    }
  int maxblip = e.attribute("maxblip", "3").toInt();
  QDomElement child = e.firstChild().toElement();
  if(child.tagName() == "ref")
    {
      QString name = child.attribute("name");
      return dynamic_cast<LvlEntry*>(&**l->getRef(name));
    }
  else if(child.tagName() == "zone")
    {
      LvlEntry* result = new LvlEntry;
      result->zone = LvlZone::Build(child, l);
      result->object = new EntryZone(l->guiCreature, l->guiCmdLine, 0, direc,
				     maxblip);
      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}
      if(result != NULL)
	{
	  result->guiCmdLine = l->guiCmdLine;
	  result->guiCreature = l->guiCreature;
	  result->level = l;
	}
     return result;
    }
  else
    {
      cout << "Error, first child of node " << e.tagName()
	   << " must be \"zone\"" << endl;
      exit(2);
    }
  return NULL;
}

/******************
 * class LvlExit *
 ******************/

LvlExit::LvlExit()
{
  type = OT_EXIT;
}

LvlExit* LvlExit::Build(const QDomElement& e, Level *l)
{
  QString ori = e.attribute("direction", "north");
  Direction direc(NORTH);
  if (ori=="north")
    {
      direc=NORTH;
    }
  else if (ori=="south")
    {
      direc=SOUTH;
    }
  else if (ori=="west") 
    {
      direc=WEST;
    }
  else if (ori=="east") 
    {
      direc=EAST;
    }
  QDomElement child = e.firstChild().toElement();
  QString player = e.attribute("player", "marine");
  if(child.tagName() == "ref")
    {
      QString name = child.attribute("name");
      return dynamic_cast<LvlExit*>(&**l->getRef(name));
    }
  else if(child.tagName() == "zone")
    {
      LvlExit* result = new LvlExit;
      result->zone = LvlZone::Build(child, l);
      result->object = new Exit(l->guiCreature, l->guiCmdLine, 0, (player == "marine")?MARINE_TURN:GENESTEALER_TURN, direc);

      QString name = e.attribute("name");
      if(!name.isNull())
	{
	  LevelRef *ref = new LevelRef(result, name);
	  l->setRef(ref);
	  result->is_ref = true;
	}
      if(result != NULL)
	{
	  result->guiCmdLine = l->guiCmdLine;
	  result->guiCreature = l->guiCreature;
	  result->level = l;
	}
     return result;
    }
  else
    {
      cout << "Error, first child of node " << e.tagName()
	   << " must be \"zone\"" << endl;
      exit(2);
    }
  return NULL;
}

/***********************
 * class Lvlxtensible  *
 ***********************/

LvlExtensible::LvlExtensible()
{
  type = OT_EXTENSIBLE;
}

LvlExtensible* LvlExtensible::Build(const QDomElement& e, Level *l,bool isUnit)
{
  QDomElement child = e.firstChild().toElement();
  if(child.tagName() == "ref")
    {
      QString name = child.attribute("name");
      return dynamic_cast<LvlExtensible*>(&**l->getRef(name));
    }
  
  LvlExtensible* result = new LvlExtensible;
  ExtensibleObject *ext = new ExtensibleObject(l->guiCreature, 
					       l->guiCmdLine, 0);

  QString str = e.attribute("desc");
  ext->setDesc(str);
  str = e.attribute("graphic");
  ext->setGraphic(str);
  if (e.attribute("empty","no")=="yes")
    ext->setEmpty(true);
  if (e.attribute("attackable","no")=="yes")
    ext->setAttackable(true);
  ext->setShootable(e.attribute("shootable","0").toInt());
  if (e.attribute("fireable","no")=="yes")
    ext->setFireable(true);
  ext->setTaken(e.attribute("takeable","0").toInt());
  ext->setDropable(e.attribute("dropable","0").toInt());
  ext->setTransferable(e.attribute("transferable","0").toInt());
  if (e.attribute("shootwith","no")=="yes")
    ext->setShootWith(true);
  if (e.attribute("usedoorwith","no")=="yes")
    ext->setUseDoorWith(true);
  
  if (ext->canBeTaken())
    l->guiCmdLine->setObjectButtonsVisible(true);
  
  result->object = ext;
  result->unit = ext;
  QString name = e.attribute("name");
  if(!name.isNull())
    {
      LevelRef *ref = new LevelRef(result, name);
      l->setRef(ref);
      result->is_ref = true;
    }
  if(result != NULL)
    {
      result->guiCmdLine = l->guiCmdLine;
      result->guiCreature = l->guiCreature;
      result->level = l;
    }

  if(child.tagName() == "zone")
    result->zone = LvlZone::Build(child, l);
  else if (!isUnit) {
    cout << "Error, first child of node " << e.tagName()
	   << " must be \"zone\" in this context." << endl;
    exit(2);
  }
  return result;
}

Object* LvlExtensible::CreateObject()
{
  if (unit->canBeTaken()) {
    set<Object *> *obj = board->getObject(position);
    if (obj) {
      set<Object *>::iterator it = obj->begin();
      if (it!=obj->end())
	(*it)->automaticTakeObject(unit);
    }
  }
  unit->setPosition(position);
  board->addObject(unit);
  return unit;
}

void LvlExtensible::getParameters(set<int> *cases)
{
  position = guiCmdLine->GetCase(cases, PlaceUnit());
  man->recordCommand(QString("get case ") + QString::number(position));
}

QString LvlExtensible::PlaceUnit()
{
  QString res = "Select the position of the ";
  res += dynamic_cast<ExtensibleObject*>(unit)->getDesc();
  return res;
}

QString LvlExtensible::getDesc()
{
  if (unit)
    return dynamic_cast<ExtensibleObject*>(unit)->getDesc();
  else
    return "object";
}

ostream& operator<<(ostream& s, const Point& p)
{
  s << p.x << "," << p.y;
  return s;
}
