// -*- c++ -*-

#ifndef _LEVELCOND_H_
#define _LEVELCOND_H_

#include <list>
#include <qdom.h>

#include "levelobject.h"

class LvlFct;
class Level;

class LvlCond
{
public:
  LvlCond();
  LvlCond(QDomElement cond, Level *l);
  virtual ~LvlCond();
  virtual bool Eval();
  QDomElement node_cond;
  Level *level;
  LvlCond *cond;
  bool keep_yes, keep_no, keeped;
  bool value, named;
  QString name;
};

class LvlCondRef : public LvlCond
{
public:
  LvlCondRef();
  LvlCondRef(QDomElement cond, Level *l);
  virtual bool Eval();
};

class LvlCondEval : public LvlCond
{
public:
  LvlCondEval();
  LvlCondEval(QDomElement cond, Level *l);
  virtual bool Eval();
protected:
  LvlFct *fct;
};

class LvlCondAnd : public LvlCond
{
public:
  LvlCondAnd(QDomElement cond, Level *l);
  ~LvlCondAnd();
  virtual bool Eval();
  list<LvlCond*> conds;
  bool test_all;
};

class LvlCondOr : public LvlCond
{
public:
  LvlCondOr(QDomElement cond, Level *l);
  ~LvlCondOr();
  virtual bool Eval();
  list<LvlCond*> conds;
  bool test_all;
};

class LvlCondNot : public LvlCond
{
public:
  LvlCondNot(QDomElement cond, Level *l);
  virtual bool Eval();
};

class LvlCondTrue : public LvlCond
{
public:
  LvlCondTrue(QDomElement cond, Level *l);
  virtual bool Eval();
};

class LvlCondFalse : public LvlCond
{
public:
  LvlCondFalse(QDomElement cond, Level *l);
  virtual bool Eval();
};

class LvlTest : public LvlCond
{
public:
  LvlTest();
  LvlTest(QDomElement cond, Level *l);
  virtual bool Eval();
};

typedef enum
  {
    TS_ONFIRE,
    TS_FREE,
    TS_BLOCKED,
    TS_OCCUPIED
  } TestState;

class LvlTestState : public LvlTest
{
public:
  LvlTestState(QDomElement cond, Level *l);
  virtual bool Eval();
};

class LvlTestOnboard : public LvlTest
{
public:
  LvlTestOnboard(QDomElement cond, Level *l);
  virtual bool Eval();
};

class LvlTestInf : public LvlTest
{
public:
  LvlTestInf(QDomElement cond, Level *l);
  virtual bool Eval();
protected:
  LvlFct *first, *second;
};

class LvlTestSup : public LvlTest
{
public:
  LvlTestSup(QDomElement cond, Level *l);
  virtual bool Eval();
protected:
  LvlFct *first, *second;
};

class LvlTestEqual : public LvlTest
{
public:
  LvlTestEqual(QDomElement cond, Level *l);
  virtual bool Eval();
protected:
  LvlFct *first, *second;
};

class LvlTestPosition : public LvlTest
{
public:
  LvlTestPosition(QDomElement cond, Level *l);
  virtual bool Eval();
  LvlZone *zone;
  LvlObjectType lvl_type;
  Direction dir1, dir2, dir3;
};

class LvlTestTurnType : public LvlTest
{
public:
  LvlTestTurnType(QDomElement cond, Level *l);
  virtual bool Eval();
  Turn type;
};

#endif

