// -*- c++ -*-
/***************************************************************************
                          board.h  -  description
                             -------------------
    begin                : ven fv 22 17:11:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _BOARD_H_
#define _BOARD_H_
 
#include <map>
#include <vector>
#include <set>
using namespace std;

#include "variables.h"

class Object;
class Flame;
class Creature;
class GUICreature;
class GUICommandLine;
class EntryZone;

class Board
{
  friend class XBoard;
  friend class QPixmapBoard;
  friend class QMiniMap;
  friend class DataStoring;
public:
  Board();
  ~Board();
  
  int getCaseId(int x, int y);
  void setMax(int x, int y);

  int addCase(int x, int y);
  int addCase(int caseId);
  bool addObject(Object *, bool force=false); 

  void delObject(Object *obj);
  set<Object *>* getObject(int caseId);

  bool isNotWall(int caseId);
  bool isEmpty(int caseId);
  bool isEntryZoneCase(int caseId);
  bool isEntryBlocked(int caseId);
  QString getStringEntryZoneCase(void);
  const set<int>* getEntryZoneCases(void);
  bool isExitCase(int caseId);
  bool hasObject(int caseId, ObjectType type);

  set<int> * getExits(void);

  void move(Object *c, int from, int to);
  bool areNeighbors(int c1, int c2);
  int Distance(int c1, int c2);
  int DistanceSum(int c1, int c2);

  void removeAll(void);
public:
  // Dimension of board.
  int Xmax;
  int Ymax;

private:
  // Each non-wall cases contains a set of objects.
  map<int, set<Object *> > cases;

  set<int> entryzone;
  set<int> exitzone;
};

extern Board *board;

#endif
