/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.ntriples;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class NTriplesParser
extends RDFParserBase {
    private Reader reader;
    private int lineNo;
    private Resource subject;
    private URI predicate;
    private Value object;

    public NTriplesParser() {
    }

    public NTriplesParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public final RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        try {
            this.parse(new InputStreamReader(in, "US-ASCII"), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader can not be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("base URI can not be 'null'");
        }
        this.rdfHandler.startRDF();
        this.reader = reader;
        this.lineNo = 1;
        this.reportLocation(this.lineNo, 1);
        try {
            int c = reader.read();
            c = this.skipWhitespace(c);
            while (c != -1) {
                c = c == 35 ? this.skipLine(c) : (c == 13 || c == 10 ? this.skipLine(c) : this.parseTriple(c));
                c = this.skipWhitespace(c);
            }
        }
        finally {
            this.clear();
        }
        this.rdfHandler.endRDF();
    }

    private int skipWhitespace(int c) throws IOException {
        while (c == 32 || c == 9) {
            c = this.reader.read();
        }
        return c;
    }

    private int skipLine(int c) throws IOException {
        while (c != -1 && c != 13 && c != 10) {
            c = this.reader.read();
        }
        if (c == 10) {
            c = this.reader.read();
            ++this.lineNo;
            this.reportLocation(this.lineNo, 1);
        } else if (c == 13) {
            c = this.reader.read();
            if (c == 10) {
                c = this.reader.read();
            }
            ++this.lineNo;
            this.reportLocation(this.lineNo, 1);
        }
        return c;
    }

    private int parseTriple(int c) throws IOException, RDFParseException, RDFHandlerException {
        c = this.parseSubject(c);
        c = this.skipWhitespace(c);
        c = this.parsePredicate(c);
        c = this.skipWhitespace(c);
        c = this.parseObject(c);
        if ((c = this.skipWhitespace(c)) == -1) {
            this.throwEOFException();
        } else if (c != 46) {
            this.reportFatalError("Expected '.', found: " + (char)c);
        }
        c = this.skipLine(c);
        Statement st = this.createStatement(this.subject, this.predicate, this.object);
        this.rdfHandler.handleStatement(st);
        this.subject = null;
        this.predicate = null;
        this.object = null;
        return c;
    }

    private int parseSubject(int c) throws IOException, RDFParseException {
        StringBuilder sb = new StringBuilder(100);
        if (c == 60) {
            c = this.parseUriRef(c, sb);
            this.subject = this.createURI(sb.toString());
        } else if (c == 95) {
            c = this.parseNodeID(c, sb);
            this.subject = this.createBNode(sb.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<' or '_', found: " + (char)c);
        }
        return c;
    }

    private int parsePredicate(int c) throws IOException, RDFParseException {
        StringBuilder sb = new StringBuilder(100);
        if (c == 60) {
            c = this.parseUriRef(c, sb);
            this.predicate = this.createURI(sb.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<', found: " + (char)c);
        }
        return c;
    }

    private int parseObject(int c) throws IOException, RDFParseException {
        StringBuilder sb = new StringBuilder(100);
        if (c == 60) {
            c = this.parseUriRef(c, sb);
            this.object = this.createURI(sb.toString());
        } else if (c == 95) {
            c = this.parseNodeID(c, sb);
            this.object = this.createBNode(sb.toString());
        } else if (c == 34) {
            StringBuilder lang = new StringBuilder(8);
            StringBuilder datatype = new StringBuilder(40);
            c = this.parseLiteral(c, sb, lang, datatype);
            this.object = this.createLiteral(sb.toString(), lang.toString(), datatype.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<', '_' or '\"', found: " + (char)c);
        }
        return c;
    }

    private int parseUriRef(int c, StringBuilder uriRef) throws IOException, RDFParseException {
        assert (c == 60) : "Supplied char should be a '<', is: " + c;
        c = this.reader.read();
        while (c != 62) {
            if (c == -1) {
                this.throwEOFException();
            }
            uriRef.append((char)c);
            c = this.reader.read();
        }
        c = this.reader.read();
        return c;
    }

    private int parseNodeID(int c, StringBuilder name) throws IOException, RDFParseException {
        assert (c == 95) : "Supplied char should be a '_', is: " + c;
        c = this.reader.read();
        if (c == -1) {
            this.throwEOFException();
        } else if (c != 58) {
            this.reportError("Expected ':', found: " + (char)c);
        }
        c = this.reader.read();
        if (c == -1) {
            this.throwEOFException();
        } else if (!NTriplesUtil.isLetter(c)) {
            this.reportError("Expected a letter, found: " + (char)c);
        }
        name.append((char)c);
        c = this.reader.read();
        while (c != -1 && NTriplesUtil.isLetterOrNumber(c)) {
            name.append((char)c);
            c = this.reader.read();
        }
        return c;
    }

    private int parseLiteral(int c, StringBuilder value, StringBuilder lang, StringBuilder datatype) throws IOException, RDFParseException {
        assert (c == 34) : "Supplied char should be a '\"', is: " + c;
        c = this.reader.read();
        while (c != 34) {
            if (c == -1) {
                this.throwEOFException();
            }
            value.append((char)c);
            if (c == 92) {
                c = this.reader.read();
                if (c == -1) {
                    this.throwEOFException();
                }
                value.append((char)c);
            }
            c = this.reader.read();
        }
        c = this.reader.read();
        if (c == 64) {
            c = this.reader.read();
            while (c != -1 && c != 46 && c != 94 && c != 32 && c != 9) {
                lang.append((char)c);
                c = this.reader.read();
            }
        } else if (c == 94) {
            c = this.reader.read();
            if (c == -1) {
                this.throwEOFException();
            } else if (c != 94) {
                this.reportError("Expected '^', found: " + (char)c);
            }
            c = this.reader.read();
            if (c == -1) {
                this.throwEOFException();
            } else if (c != 60) {
                this.reportError("Expected '<', found: " + (char)c);
            }
            c = this.parseUriRef(c, datatype);
        }
        return c;
    }

    protected URI createURI(String uri) throws RDFParseException {
        try {
            uri = NTriplesUtil.unescapeString(uri);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage());
        }
        return super.createURI(uri);
    }

    protected Literal createLiteral(String label, String lang, String datatype) throws RDFParseException {
        try {
            label = NTriplesUtil.unescapeString(label);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage());
        }
        if (lang.length() == 0) {
            lang = null;
        }
        if (datatype.length() == 0) {
            datatype = null;
        }
        URI dtURI = null;
        if (datatype != null) {
            dtURI = this.createURI(datatype);
        }
        return super.createLiteral(label, lang, dtURI);
    }

    protected void reportWarning(String msg) {
        this.reportWarning(msg, this.lineNo, -1);
    }

    protected void reportError(String msg) throws RDFParseException {
        this.reportError(msg, this.lineNo, -1);
    }

    protected void reportFatalError(String msg) throws RDFParseException {
        this.reportFatalError(msg, this.lineNo, -1);
    }

    protected void reportFatalError(Exception e) throws RDFParseException {
        this.reportFatalError(e, this.lineNo, -1);
    }

    private void throwEOFException() throws RDFParseException {
        throw new RDFParseException("Unexpected end of file");
    }
}

