# snowleopardfixes
a library of common functions missing from the standard install of MacOSX 10.6 Snow Leopard

MacOSX 10.6 is missing a few commonly available functions that are frequently not tested for when current software uses autotools to generate  build instructions; paramount among them are srtrnlen() and getline(). This library aims to replace these functions to allow newer software to compile on SnowLeopard more easily. Currently strnlen, memmem, strndup, getline, and getdelim are replaced. 

O_CLOEXEC is defined to 0, which allows compilation of ports that call for this flag, but the function of this flag has not been replaced at present. This approach may be reviewed further if it causes issues with any ports; so far, it does not seem to, and this is commonly done in MacPorts at present (eg gtk3).

A list of further functions to be replaced to bring standard up to 10.7 (a good benchmark) as I know them:

stpcpy, dprintf (and I believe there may be a few others)

To install the snowleopardfixes library, use this portfile:
https://github.com/kencu/SnowLeopardPorts/blob/master/sysutils/snowleopardfixes/Portfile

You may decide to clone the entire SnowLeopardPorts repo as well, to get other specific fixes for 10.6.8: 
https://github.com/kencu/SnowLeopardPorts

In all tested cases so far, adding a block like this to a MacPorts portfile that fails to build on SnowLeopard due to missing functions that are replaced as above will resolve the problem.
```
platform darwin 10 {
	depends_lib-append          port:snowleopardfixes
	configure.ldflags-append   -lsnowleopardfixes
	configure.cxxflags-append  -include ${prefix}/include/snowleopardfixes.h
	configure.cflags-append    -include ${prefix}/include/snowleopardfixes.h
}
```
There are other issues that can arise on 10.6 (SDK deficiencies) that this library does not presently fix.
