/*
 * VRT RULES
 *
 * Copyright (C) 2014-2020 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule9999eval(void *p);

/* references for sid 9999 */
static RuleReference *rule9999refs[] =
{
    NULL
};

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow for sid 9999 */
/* flow:established; */
static FlowFlags rule9999flow1 =
{
    FLOW_ESTABLISHED
};

static RuleOption rule9999option1 =
{
    OPTION_TYPE_FLOWFLAGS,
    { &rule9999flow1 }
};

/* content for sid 9999 */
// content:"|FF E2|";
static ContentInfo rule9999content2 =
{
    (u_int8_t *)"|FF E2|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length */
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule9999option2 =
{
    OPTION_TYPE_CONTENT,
    { &rule9999content2 }
};

// content:"ICC_PROFILE|00|", offset 2, depth 12, relative;
static ContentInfo rule9999content3 =
{
    (u_int8_t *)"ICC_PROFILE|00|", /* pattern (now in snort content format) */
    12, /* depth */
    2, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length */
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule9999option3 =
{
    OPTION_TYPE_CONTENT,
    { &rule9999content3 }
};

/* byte_extract for sid 9999 */
/* loop_count = byte_extract:size 4, offset 130, relative; */
static ByteExtract rule9999byte_extract4 =
{
    4, /* size */
    130, /* offset */
    0, /* multiplier (note used for byte_extract) */
    BYTE_BIG_ENDIAN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    "loopend", /* reference Id */
    NULL, /* Place holder for data location */
    0 // align  
};

static RuleOption rule9999option4 =
{
    OPTION_TYPE_BYTE_EXTRACT,
    { &rule9999byte_extract4 }
};

/* set_cursor for sid 9999 */
// set_cursor:offset 134, relative;
static CursorInfo rule9999set_cursor5 =
{
    134, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, // offset_refId
    NULL  // offset_location
};

static RuleOption rule9999option5 =
{
    OPTION_TYPE_SET_CURSOR,
    { &rule9999set_cursor5 }
};

static DynamicElement loopStart =
{
    DYNAMIC_TYPE_INT_STATIC,
    NULL,
    { 0 }
};

static DynamicElement loopEnd =
{
    DYNAMIC_TYPE_INT_REF,
    "loopend",
    { NULL }
};

static DynamicElement loopIncr =
{
    DYNAMIC_TYPE_INT_STATIC,
    NULL,
    { (void *)1 }   /* compiler complains if not cast to void * even though union contains int */
};

static CursorInfo loopCursor =
{
    12, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED,  /* flags */
    NULL, // offset_refId
    NULL  // offset_location
};

/* these don't get structures... lets hope this works :) */
/* pcre for sid 9999 */
// pcre:"^[rbg]XYZ", relative;
static PCREInfo rule9999pcre7 =
{
    "^[rbg]XYZ", /* pattern */
    NULL,                               /* holder for compiled pattern */
    NULL,                               /* holder for compiled pattern flags */
    0,     /* compile flags */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED,     /* content flags */
    0 /* offset */
};

static RuleOption rule9999option7 =
{
    OPTION_TYPE_PCRE,
    { &rule9999pcre7 }
};

/* byte_test for sid 9999 */
/* byte_test:size 4, value 60, operator >, offset 4, relative; */
static ByteData rule9999byte_test8 =
{
    4, /* size */
    CHECK_GT, /* operator */
    60, /* value */
    4, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule9999option8 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule9999byte_test8 }
};

RuleOption *rule9999loop6options[] =
{
    &rule9999option7,
    &rule9999option8,
    NULL
};

Rule rule9999loop6subRule =
{
    /****** IPInfo Duplicated from rule9999 ******/
    /* rule header, akin to => tcp any any -> any any               */
    {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
    },
    /****** metadata Duplicated from rule9999 ******/
    {
       3,  /* genid (HARDCODED!!!) */
       9999, /* sigid */
       1, /* revision */

       "misc-attack", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "WEB-CLIENT JPEG ICC_PROFILE overflow attempt",     /* message */
       rule9999refs, /* ptr to references */
       NULL /* metadata */
    },
    rule9999loop6options,
    NULL,
    0, /* initialized -- set to 1 when rule is registered */
    0, /* num options -- initialized when rule is registered */
    0, /* Rule Don't alert flag -- initialized via Flowbit no alert */
    NULL /* Pointer to internal Rule Data -- initialized during rule registration */
};

static LoopInfo rule9999loop6 =
{
    &loopStart,
    &loopEnd,
    &loopIncr,
    CHECK_LTE,
    &loopCursor,
    &rule9999loop6subRule,  /* Reference to subrule */
    0,                      /* Initialized */
    0                       /* flags, NOT_FLAG if necessary */
};

static RuleOption rule9999option6 =
{
    OPTION_TYPE_LOOP,
    { &rule9999loop6 }
};

/* loop for sid 9999 */

RuleOption *rule9999options[] =
{
    &rule9999option1,
    &rule9999option2,
    &rule9999option3,
    &rule9999option4,
    &rule9999option5,
    &rule9999option6,
    NULL
};

Rule rule9999 = {

   /* rule header, akin to => tcp any any -> any any               */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       9999, /* sigid */
       1, /* revision */

       "misc-attack", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "WEB-CLIENT JPEG ICC_PROFILE overflow attempt",     /* message */
       rule9999refs, /* ptr to references */
       NULL /* metadata */
   },
   rule9999options, /* ptr to rule options */
   NULL, //&rule9999eval, /* ptr to rule detection function */
   0, /* am I initialized yet? */
   0, /* num options -- initialized when rule is registered */
   0, /* Rule Don't alert flag -- initialized via Flowbit no alert */
   NULL /* Pointer to internal Rule Data -- initialized during rule registration */
};




/* detection functions */

int rule9999eval(void *p) {
    /* cursors, formally known as doe_ptr */
    const u_int8_t *cursor_normal = 0;

    // flow:established;
    if (checkFlow(p, rule9999options[0]->option_u.flowFlags) > 0 ) {
        // content:"|FF E2|";
        if (contentMatch(p, rule9999options[1]->option_u.content, &cursor_normal) > 0) {
            // content:"ICC_PROFILE|00|", offset 2, depth 12, relative;
            if (contentMatch(p, rule9999options[2]->option_u.content, &cursor_normal) > 0) {
                //if (extractValue(p, rule9999options[3]->option_u.byte, &(rule9999options[5]->option_u.loop->end), cursor_normal) > 0) {
                if (extractValue(p, rule9999options[3]->option_u.byteExtract, cursor_normal) > 0) {
                    // set_cursor:offset 134, relative;
                    if (setCursor(p, rule9999options[4]->option_u.cursor, &cursor_normal) > 0) {
                        if (loopEval(p, rule9999options[5]->option_u.loop, &cursor_normal) > 0) {
                            return RULE_MATCH;
                        }
                    }
                }
            }
        }
    }
    return RULE_NOMATCH;
}

