/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __UTILITIES_H_
#define __UTILITIES_H_ 1

#include <pcap.h>

/* Gets a page through HTTP GET requests */
char* get_page(char* url);

char* get_between_tags(char* input, char* open_tag);

/* Using libpcap methods, obtain the network device to use when sniffing */
char* get_device();


/* Get a list of device names that are suitable to sniff */
char* get_devices();


/* opened pcap to sniff any device */
pcap_t* open_any_device(pcap_t* handle, char* dev);

/* convert a string to all lower case */
void lowercase_string(char* s);


#endif /* __UTILITIES_H_ */

