/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __TCPIP_PACKET_H_
#define __TCPIP_PACKET_H_ 1

/* #include <sys/types.h> */
#include <pcap.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <sys/socket.h>
#include <net/if.h>
#include <limits.h>

#if USHRT_MAX == 65535
typedef unsigned short u_short;
#else
#error no suitable type for 2 bytes is on your system
#endif

#if CHAR_BIT == 8
typedef unsigned char u_char;
#else
#error no suitable type for 1 byte is on your system
#endif



#define IP_HL(ip)   ((ip)->ver_hlen & 0xF) /* get last 4 bits */
#define IP_VER(ip)  ((ip)->ver_hlen>> 4) /* first 4 bits */
#define TH_OFF(th)  ((th)->data_offset_reserved >> 4) /* first 4 bits */
#define SIZE_OF_ETHERNET_HEADER 14
#define SIZE_OF_ETHERNET_ADDRESS 6

/* TESTING */
struct raw_packet
{
#define ETHH_SIZE 14
#define ETHH_DEST_MAC(eh) (eh)
#define ETHH_SRC_MAC(eh) (eh+6)
#define ETHH_TYPE(eh) ((unsigned short)eh+12)
  u_char* eth_header;

#define IPH_VERSION(ih) ((*ih) >> 4)	/* first four bits */
#define IPH_HEADER_LENGTH(ih) ((*ih) & 0x0F)*4
#define IPH_TOS(ih) (ih+1)
#define IPH_PACKET_LENGTH(ih) ntohs(((unsigned short)(ih+2)))
  u_char* ip_header;

#define TCPH_HEADER_LENGTH(th) (*(th+12) >> 4) * 4
  u_char* tcp_header;
  u_char* payload;
};


/* struct for the ethernet header */
typedef struct{
  /* 6bytes 6bytes 2bytes */
  u_char dest_mac[SIZE_OF_ETHERNET_ADDRESS]; /* destination address */
  u_char src_mac[SIZE_OF_ETHERNET_ADDRESS]; /* source address */


  u_short type; /* IP, etc */

#define ETHERTYPE_IP4 0x0800 	/* All that i care about currently */

} eth_header;


/* struct for the IP header */
typedef struct{
  u_char ver_hlen;		/* first 4 bits are version (>> 4), last 4 are length(& 0xF) */
#define IPVER_4 (0|1|0|0)
  u_char tos;					/* type of service */
  u_short length_of_packet;		/* in bytes */
  u_short id;					/* identification */
  u_short offset;				/* first 3 bits are info, last 13 bits are fragment offset*/
#define IP_RESERVED_FRAGMENT 0x8000		/* reserved fragment flag */
#define IP_DONT_FRAGMENT 0x4000		/* dont fragment flag */
#define IP_MORE_FRAGMENTS 0x2000		/* more fragments flag */
#define IP_OFFMASK 0x1fff	/* mask for fragmenting bits */
  u_char ttl;					/* time to live */
  u_char protocol;		    	/* protocol */
  u_short csum;					/* checksum */
  
  /* source and dest address */
  struct in_addr src;
  struct in_addr dest; 
}ip_header;


/* struct for tcp header */
typedef struct{
  u_short src_port;				/* source port */
  u_short dest_port;			/* destination port */
  u_char sequence_number[4];		/* sequence number */
  u_char ack_number[4];			/* acknowledgement number */
  u_char data_offset_reserved;	/* data offset (first 4 bits), rsvd */
  u_char flags;
#define TH_FIN 0x01
#define TH_SYN 0x02
#define TH_RST 0x04
#define TH_PUSH 0x08
#define TH_ACK 0x10
#define TH_URG 0x20
#define TH_ECE 0x40
#define TH_CWR 0x80
#define TH_FLAGS (TH_FIN|TH_SYN|TH_RST|TH_ACK|TH_URG|TH_ECE|TH_CWR)
  u_short window_size;			/* window size */
  u_short csum;					/* checksum */
  u_short urg_p;				/* urgent pointer */  
} tcp_header;


/* struct representing a packet */
typedef struct{
  eth_header* eh;
  ip_header* ih;
  tcp_header* th;
  u_char* payload;
  u_int ip_size;
  u_int tcp_size;
  u_int payload_size;
  u_char* original_packet;

  struct raw_packet rp;
}tcpip_packet;


/* packet is a pointer to the start of the packet in memory, header is info from pcap, 
output is a pointer to a packet struct to be constructed */
int construct_packet(const u_char* packet, tcpip_packet* output);

/* output some array(the packet) to a file */
void print_packet(char* file_name, const u_char* packet, int len);

#endif /* __TCPIP_PACKET_H_ */
