/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "packet_join_request.h"
#include <glib.h>


void construct_player_join_request_packet(const warcraft_packet* wp, 
					  player_join_request_packet* output,
					  const tcpip_packet* for_ip_info)
{
  output->header = (player_join_request_packet_header*)(wp->data);
  output->player_name = (u_char*)(wp->data + PJRH_SIZE);
  output->closer = (player_join_request_packet_closer*)(wp->data + 
							PJRH_SIZE + 
							PJR_PN_SIZE(wp));

  output->ext_addr.sin_port = for_ip_info->th->src_port; /* For the
							   external
							   address use
							   the
							   external
							   port sent
							   in the packet */
  output->ext_addr.sin_addr = for_ip_info->ih->src; /* Only the
						       internal
						       address is
						       given in the
						       warcraft
						       packet, but
						       I'll use the
						       source IP from
						       the ip header */
}






