/*   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PACKET_BNET_MESSAGE_H
#define PACKET_BNET_MESSAGE_H 1

#include "warcraft_info.h"

/* TYPE = FF */
#define SIG_MESSAGE_FROM_BNET 0x0F

typedef struct
{
  char type; 			/* 0x04 = friend joined */
#define MFBP_TYPE_FRIEND_JOINED 0x04
  char unknown[23];
  char* account_from;
  char* message;
} message_from_bnet_packet;


void construct_message_from_bnet_packet(const warcraft_packet* wp, 
					 message_from_bnet_packet* out,
					 const tcpip_packet* for_ip_info);


#endif /* PACKET_BNET_MESSAGE_H */

