/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "packet_accpet_join_request.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>



void construct_accept_join_request_packet(const warcraft_packet* wp, 
					  accept_join_request_packet* out,
					  const tcpip_packet* for_ip_info)
{
  construct_slot_info_packet(wp, &out->sip);
  out->closer = g_slice_new(accept_join_request_packet_closer);
  memmove(&out->closer->pid, (wp->data + out->sip.header->slot_info_size + 2), 1);
  memmove(&out->closer->ext_addr.sin_family, (wp->data + out->sip.header->slot_info_size + 3), 2);
  /* memmove(&out->closer->ext_addr.sin_port, (wp->data + out->sip.header->slot_info_size + 5), 2); */
  /* memmove(&out->closer->ext_addr.sin_addr.s_addr, (wp->data + out->sip.header->slot_info_size + 7), 4); */
  out->closer->ext_addr.sin_port = for_ip_info->th->dest_port;
  out->closer->ext_addr.sin_addr.s_addr = for_ip_info->ih->dest.s_addr;
  memmove(&out->closer->ext_addr.sin_zero, (wp->data + out->sip.header->slot_info_size + 11), 8);
}
