/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "brain.h"

#define HOME getenv("HOME")
#define DEFAULT_MAP_DIR ".wine/drive_c/Program Files/Warcraft III/Maps/Download"
#define GET_DOTA_URL "http://www.getdota.com/"

void update_dota(char* directory)
{
  printf("Checking for newer version of Dota . . . "); 
  fflush(stdout);
  /* get newest version, the format will be <div class="header">Latest Map: <span class="version">6.54b</span></div> */

  char* page = (char*)get_page(GET_DOTA_URL);
  char* version = (char*)get_between_tags(page, "<span class=\"version\">");

  char mapdir[500];
  
  if(directory)
    {				/* they gave the arg to non default map dir */
      sprintf(mapdir, "%s", directory);
    }
  else
    {
      sprintf(mapdir, "%s/%s", HOME, DEFAULT_MAP_DIR);
    }

  char map_file[500];
  sprintf(map_file, "%s/DotA Allstars v%s.w3x", mapdir, version); 

  FILE* fd = fopen(map_file, "r");
  /* File found */
  if (fd)
    {
      printf("[OK]\n");
      fclose(fd);
      return;
    }
  printf("[UPDATE FOUND]\n");
  printf("Downloading version %s . . . ", version);
  fflush(stdout);
  char dl[500];
  sprintf(dl, "http://dota.ws/download/eng/DotA\\ Allstars\\ v%s.w3x", version);
  char cmd[500];
  sprintf(cmd, "cd \"%s\"; wget -q %s", mapdir, dl);
  system(cmd);
  free(page);
  printf("[OK]\n");
  brain_perm_set_file_to_user(map_file);
}


