/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __COMM_H_
#define __COMM_H_ 1

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <sys/socket.h>
#include <net/if.h>

/* DONT BOTHER WITH THIS FILE IF YOU'RE LOOKING AT THIS.  IT DOES NOTHING. */
     


int _fd[2]; /* [0]=input [1]=output */

/* initialize the pipe */
void comm_init();

/*  write a byte array to [1] output */
void comm_write(const void* msg);


void comm_send_player_joined(struct in_addr ip_p, char pid, u_char* name);

typedef struct{
#define CH_SIZE 4
  u_char type;
  u_char sig;
  u_short size;
} comm_header;

typedef struct{
  comm_header* header;
  u_char* data;
} comm_message;

typedef struct{
#define COMM_PLAYER_JOINED_TYPE 0xFF
#define COMM_PLAYER_JOINED_SIG 0xFF
  struct in_addr ip_and_port;
  char pid;
  u_char* name;
} player_joined;

#endif /* __COMM_H_ */

