/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle, Shae Smittle   *
 *   pandagoat@gmail.com, starfall87@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "banlist.h"
#include "utilities.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <math.h>
#include <sys/stat.h>
#include <time.h>
#include "brain.h"

int banlist_update(enum realm r)
{
 
  char file_path[500]; 
  if(r == AZEROTH)
    sprintf(file_path, "%s/.snoopy/snoopy_global_azeroth.bl", getenv("HOME"));
  else if(r == LORDAERON)
    sprintf(file_path, "%s/.snoopy/snoopy_global_lordaeron.bl", getenv("HOME"));
  else if(r == KALIMDOR)
    sprintf(file_path, "%s/.snoopy/snoopy_global_kalimdor.bl", getenv("HOME"));
  else if(r == NORTHREND)
    sprintf(file_path, "%s/.snoopy/snoopy_global_northrend.bl", getenv("HOME"));
  else
    return -1;  

  struct stat s;
  int e = stat("/home/devin/.snoopy/snoopy_global_azeroth.bl", &s);

  if(e != -1)
    {
      time_t epoch;
      time(&epoch);
      
      struct tm* ta = gmtime(&s.st_mtime);
      int bl_a = ta->tm_yday;
      struct tm* tc = localtime(&epoch);

      if (tc->tm_yday - bl_a == 0)
	  return 0;
	
    }

  char* url_xml;
  if(r == AZEROTH)
    url_xml = "http://www.banlist.nl/files/approved_azeroth_nocompress.xml";
  else if(r == LORDAERON)
    url_xml = "http://www.banlist.nl/files/approved_lordaeron_nocompress.xml";
  else if(r == KALIMDOR)
    url_xml = "http://www.banlist.nl/files/approved_kalimdor_nocompress.xml";
  else if(r == NORTHREND)
    url_xml = "http://www.banlist.nl/files/approved_northrend_nocompress.xml";
  else
    return -1;

  char wget[500];
  char* filename;
  if(r == AZEROTH)
    filename = "snoopy_global_azeroth.bl";
  if(r == LORDAERON)
    filename = "snoopy_global_lordaeron.bl";
  if(r == KALIMDOR)
    filename = "snoopy_global_kalimdor.bl";
  if(r == NORTHREND)
    filename = "snoopy_global_northrend.bl";
  char* page = get_page(url_xml);
  sprintf(wget, "wget -q \"%s\" -O ~/.snoopy/%s", get_between_tags(page, "<data>"), filename);
  system("mkdir -p ~/.snoopy");
  system(wget);
  free(page);
  char banlist_file_fp[500];
  sprintf(banlist_file_fp, "%s/.snoopy/%s", getenv("HOME"), filename);
  brain_perm_set_file_to_user(banlist_file_fp);

  return 0;
}



int banlist_check_account(const char* bl_file_name, const char* account, char* reason, unsigned short reason_size)
{
  FILE* fd = fopen(bl_file_name, "r");
  if(!fd)
    return -1;
  while(!feof(fd))
    {
      char name[100];
      char reas[500];
      fscanf(fd, "%s", name);
      fgets(reas, 500, fd);
      if(strcmp(name, account) == 0)
	{
	  strncpy(reason, reas, reason_size);
	  fclose(fd);
	  return 1;
	}
    }
  fclose(fd);
  return -1;
}


void banlist_ban(const char* file_name, const char* account, gdouble time_of_ban, const char* banner, char* reason,  char* realm, char* output)
{

  char buf[500];
  memset(buf, '\0', 500);
  time_t epoch;
  time(&epoch);

  char* t = ctime(&epoch);
  *strstr(t, "\n") = '\0';
  sprintf(buf, "%s %s on %s on (%s) (banned by %s)\0", account, reason, 
	  /* (int)((time_of_ban/1000)/60/60),  (int)((time_of_ban/1000)/60),  (int)((time_of_ban/1000)), */ realm, t,
	  banner);
  memmove(output, buf, strlen(buf));

  FILE* fd = fopen(file_name, "a");
  fprintf(fd, "%s\n", buf);
  fclose(fd);
}
